/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.utils.common.AlphaNumericComparator;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\b\u0086\b\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0014H\u00d6\u0001J\u001f\u0010\u001f\u001a\u00020\u001c2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040!\"\u00020\u0004\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0004H\u0007J\u001a\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u0004J\t\u0010'\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/ossreviewtoolkit/model/Identifier;", "", "components", "", "", "(Ljava/util/List;)V", "identifier", "(Ljava/lang/String;)V", "type", "namespace", "name", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getNamespace", "sanitizedComponents", "getType", "getVersion", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "isFromOrg", "names", "", "([Ljava/lang/String;)Z", "toCoordinates", "toPath", "separator", "emptyValue", "toString", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nIdentifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Identifier.kt\norg/ossreviewtoolkit/model/Identifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,128:1\n1549#2:129\n1620#2,2:130\n1622#2:143\n2624#2,3:144\n483#3,11:132\n1#4:147\n12474#5,2:148\n*S KotlinDebug\n*F\n+ 1 Identifier.kt\norg/ossreviewtoolkit/model/Identifier\n*L\n85#1:129\n85#1:130,2\n85#1:143\n90#1:144,3\n86#1:132,11\n103#1:148,2\n*E\n"})
public final class Identifier
implements Comparable<Identifier> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final String namespace;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final List<String> sanitizedComponents;
    @JvmField
    @NotNull
    public static final Identifier EMPTY = new Identifier("", "", "", "");
    private static final Comparator<Identifier> COMPARATOR;

    /*
     * WARNING - void declaration
     */
    public Identifier(@NotNull String type, @NotNull String namespace, @NotNull String name, @NotNull String version) {
        boolean bl;
        block6: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.type = type;
            this.namespace = namespace;
            this.name = name;
            this.version = version;
            Object object = new String[]{this.type, this.namespace, this.name, this.version};
            object = CollectionsKt.listOf((Object[])object);
            Identifier identifier = this;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                void component;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)component))).toString();
                boolean $i$f$filterNot = false;
                CharSequence charSequence = (CharSequence)$this$filterNot$iv;
                Appendable destination$iv$iv2 = new StringBuilder();
                boolean $i$f$filterNotTo = false;
                for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                    boolean bl3 = false;
                    if (Intrinsics.compare((int)it, (int)32) < 0) continue;
                    destination$iv$iv2.append(element$iv$iv);
                }
                String string3 = ((StringBuilder)destination$iv$iv2).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                collection.add(string3);
            }
            identifier.sanitizedComponents = (List)destination$iv$iv;
            Iterable $this$none$iv = this.sanitizedComponents;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)":", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl5 = false;
            String string = "An identifier's properties must not contain ':' because that character is used as a separator in the string representation: type='" + this.type + "', namespace='" + this.namespace + "', name='" + this.name + "', version='" + this.version + "'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    private Identifier(List<String> components) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        int it;
        String string6;
        Identifier identifier;
        String string7;
        Identifier identifier2 = this;
        int n = 0;
        List<String> list = components;
        if (n <= CollectionsKt.getLastIndex(list)) {
            string7 = list.get(n);
        } else {
            int n2 = n;
            identifier = identifier2;
            boolean bl = false;
            string7 = "";
            identifier2 = identifier;
        }
        String string8 = string7;
        list = components;
        n = 1;
        if (n <= CollectionsKt.getLastIndex(list)) {
            string6 = list.get(n);
        } else {
            it = n;
            string5 = string8;
            identifier = identifier2;
            boolean bl = false;
            string4 = "";
            identifier2 = identifier;
            string8 = string5;
            string6 = string4;
        }
        String string9 = string6;
        list = components;
        n = 2;
        if (n <= CollectionsKt.getLastIndex(list)) {
            string3 = list.get(n);
        } else {
            it = n;
            string4 = string9;
            string5 = string8;
            identifier = identifier2;
            boolean bl = false;
            string2 = "";
            identifier2 = identifier;
            string8 = string5;
            string9 = string4;
            string3 = string2;
        }
        String string10 = string3;
        list = components;
        n = 3;
        if (n <= CollectionsKt.getLastIndex(list)) {
            string = list.get(n);
        } else {
            it = n;
            string2 = string10;
            string4 = string9;
            string5 = string8;
            identifier = identifier2;
            boolean bl = false;
            String string11 = "";
            identifier2 = identifier;
            string8 = string5;
            string9 = string4;
            string10 = string2;
            string = string11;
        }
        identifier2(string8, string9, string10, string);
    }

    @JsonCreator
    public Identifier(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        char[] cArray = new char[]{':'};
        this(StringsKt.split$default((CharSequence)identifier, (char[])cArray, (boolean)false, (int)4, (int)2, null));
    }

    @Override
    public int compareTo(@NotNull Identifier other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return COMPARATOR.compare(this, other);
    }

    public final boolean isFromOrg(String ... names) {
        boolean bl;
        block15: {
            Intrinsics.checkNotNullParameter((Object)names, (String)"names");
            String[] $this$any$iv = names;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                CharSequence charSequence;
                String vendorNamespace;
                String element$iv;
                String name = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)name.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                switch (this.type) {
                    case "NPM": {
                        String lowerName;
                        Object object = "@" + lowerName;
                        break;
                    }
                    case "Maven": 
                    case "SBT": 
                    case "Gradle": {
                        String lowerName;
                        Object object = "((com|io|net|org)\\.)?" + lowerName + "(\\..+)?";
                        break;
                    }
                    default: {
                        Object object = vendorNamespace = "";
                    }
                }
                boolean bl3 = ((CharSequence)vendorNamespace).length() > 0 && new Regex(vendorNamespace).matches(charSequence = (CharSequence)this.namespace);
                if (!bl3) continue;
                bl = true;
                break block15;
            }
            bl = false;
        }
        return bl;
    }

    @JsonValue
    @NotNull
    public final String toCoordinates() {
        return CollectionsKt.joinToString$default((Iterable)this.sanitizedComponents, (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String toPath(@NotNull String separator, @NotNull String emptyValue) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)emptyValue, (String)"emptyValue");
        return CollectionsKt.joinToString$default((Iterable)this.sanitizedComponents, (CharSequence)separator, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(emptyValue){
            final /* synthetic */ String $emptyValue;
            {
                this.$emptyValue = $emptyValue;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExtensionsKt.encodeOr((String)it, (String)this.$emptyValue);
            }
        }), (int)30, null);
    }

    public static /* synthetic */ String toPath$default(Identifier identifier, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        if ((n & 2) != 0) {
            string2 = "unknown";
        }
        return identifier.toPath(string, string2);
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.namespace;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.version;
    }

    @NotNull
    public final Identifier copy(@NotNull String type, @NotNull String namespace, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new Identifier(type, namespace, name, version);
    }

    public static /* synthetic */ Identifier copy$default(Identifier identifier, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = identifier.type;
        }
        if ((n & 2) != 0) {
            string2 = identifier.namespace;
        }
        if ((n & 4) != 0) {
            string3 = identifier.name;
        }
        if ((n & 8) != 0) {
            string4 = identifier.version;
        }
        return identifier.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "Identifier(type=" + this.type + ", namespace=" + this.namespace + ", name=" + this.name + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.namespace.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.version.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Identifier)) {
            return false;
        }
        Identifier identifier = (Identifier)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)identifier.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)identifier.namespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)identifier.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)identifier.version);
    }

    private static final String COMPARATOR$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.COMPARATOR.1.INSTANCE, Companion.COMPARATOR.2.INSTANCE, Companion.COMPARATOR.3.INSTANCE};
        COMPARATOR = ComparisonsKt.compareBy((Function1[])function1Array).thenComparing(arg_0 -> Identifier.COMPARATOR$lambda$9(Companion.COMPARATOR.4.INSTANCE, arg_0), (Comparator)AlphaNumericComparator.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/ossreviewtoolkit/model/Identifier$Companion;", "", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lorg/ossreviewtoolkit/model/Identifier;", "kotlin.jvm.PlatformType", "EMPTY", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

