/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.NormalizeLineBreaksSerializer;
import org.ossreviewtoolkit.model.Severity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/ossreviewtoolkit/model/Issue;", "", "timestamp", "Ljava/time/Instant;", "source", "", "message", "severity", "Lorg/ossreviewtoolkit/model/Severity;", "affectedPath", "(Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Lorg/ossreviewtoolkit/model/Severity;Ljava/lang/String;)V", "getAffectedPath", "()Ljava/lang/String;", "getMessage", "getSeverity", "()Lorg/ossreviewtoolkit/model/Severity;", "getSource", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "model"})
public final class Issue {
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final String source;
    @NotNull
    private final String message;
    @NotNull
    private final Severity severity;
    @Nullable
    private final String affectedPath;

    public Issue(@NotNull Instant timestamp, @NotNull String source, @JsonSerialize(using=NormalizeLineBreaksSerializer.class) @NotNull String message, @NotNull Severity severity, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable String affectedPath) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.timestamp = timestamp;
        this.source = source;
        this.message = message;
        this.severity = severity;
        this.affectedPath = affectedPath;
    }

    public /* synthetic */ Issue(Instant instant, String string, String string2, Severity severity, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        if ((n & 8) != 0) {
            severity = Severity.ERROR;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        this(instant, string, string2, severity, string3);
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    @Nullable
    public final String getAffectedPath() {
        return this.affectedPath;
    }

    @NotNull
    public String toString() {
        String string;
        if (Intrinsics.areEqual((Object)this.timestamp, (Object)Instant.EPOCH)) {
            string = "Unknown time";
        } else {
            String string2 = this.timestamp.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String time = string;
        return time + " [" + this.severity + "]: " + this.source + " - " + this.message;
    }

    @NotNull
    public final Instant component1() {
        return this.timestamp;
    }

    @NotNull
    public final String component2() {
        return this.source;
    }

    @NotNull
    public final String component3() {
        return this.message;
    }

    @NotNull
    public final Severity component4() {
        return this.severity;
    }

    @Nullable
    public final String component5() {
        return this.affectedPath;
    }

    @NotNull
    public final Issue copy(@NotNull Instant timestamp, @NotNull String source, @JsonSerialize(using=NormalizeLineBreaksSerializer.class) @NotNull String message, @NotNull Severity severity, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable String affectedPath) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        return new Issue(timestamp, source, message, severity, affectedPath);
    }

    public static /* synthetic */ Issue copy$default(Issue issue, Instant instant, String string, String string2, Severity severity, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            instant = issue.timestamp;
        }
        if ((n & 2) != 0) {
            string = issue.source;
        }
        if ((n & 4) != 0) {
            string2 = issue.message;
        }
        if ((n & 8) != 0) {
            severity = issue.severity;
        }
        if ((n & 0x10) != 0) {
            string3 = issue.affectedPath;
        }
        return issue.copy(instant, string, string2, severity, string3);
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = result * 31 + this.source.hashCode();
        result = result * 31 + this.message.hashCode();
        result = result * 31 + this.severity.hashCode();
        result = result * 31 + (this.affectedPath == null ? 0 : this.affectedPath.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Issue)) {
            return false;
        }
        Issue issue = (Issue)other;
        if (!Intrinsics.areEqual((Object)this.timestamp, (Object)issue.timestamp)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.source, (Object)issue.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)issue.message)) {
            return false;
        }
        if (this.severity != issue.severity) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.affectedPath, (Object)issue.affectedPath);
    }
}

