/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.AdvisorRecord;
import org.ossreviewtoolkit.model.AdvisorResult;
import org.ossreviewtoolkit.model.AdvisorRun;
import org.ossreviewtoolkit.model.AnalyzerResult;
import org.ossreviewtoolkit.model.AnalyzerRun;
import org.ossreviewtoolkit.model.CompatibilityDependencyNavigator;
import org.ossreviewtoolkit.model.CuratedPackage;
import org.ossreviewtoolkit.model.DependencyNavigator;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.EvaluatorRun;
import org.ossreviewtoolkit.model.FileList;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.OrtResultKt;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageEntry;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectEntry;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.Repository;
import org.ossreviewtoolkit.model.ResolvedConfiguration;
import org.ossreviewtoolkit.model.ResolvedPackageCurations;
import org.ossreviewtoolkit.model.RuleViolation;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.ScannerRun;
import org.ossreviewtoolkit.model.Severity;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.model.config.IssueResolution;
import org.ossreviewtoolkit.model.config.LicenseFindingCuration;
import org.ossreviewtoolkit.model.config.PackageConfiguration;
import org.ossreviewtoolkit.model.config.PackageLicenseChoice;
import org.ossreviewtoolkit.model.config.PathExclude;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.model.config.Resolutions;
import org.ossreviewtoolkit.model.config.ResolutionsKt;
import org.ossreviewtoolkit.model.config.RuleViolationResolution;
import org.ossreviewtoolkit.model.config.VulnerabilityResolution;
import org.ossreviewtoolkit.model.utils.PackageConfigurationProvider;
import org.ossreviewtoolkit.model.utils.ResolutionProvider;
import org.ossreviewtoolkit.model.vulnerabilities.Vulnerability;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.SpdxLicenseChoice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u0099\u00012\u00020\u00012\u00020\u0002:\u0002\u0099\u0001B]\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0014\b\u0003\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\t\u0010<\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010A\u001a\u00020\u000eH\u00c6\u0003J\u0015\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0003Jc\u0010C\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0014\b\u0003\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0001J\u0013\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010GH\u00d6\u0003J$\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00102\b\b\u0002\u0010I\u001a\u00020EH\u0007J\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010K\u001a\u00020\u0016J\u000e\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020NJ(\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00160P2\u0006\u0010K\u001a\u00020\u00162\b\b\u0002\u0010Q\u001a\u00020R2\b\b\u0002\u0010I\u001a\u00020EJ\b\u0010S\u001a\u00020TH\u0007J\u0010\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010K\u001a\u00020\u0016J\u0014\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020V0\u0010H\u0007J\u0016\u0010X\u001a\u00020\u00112\u0006\u0010M\u001a\u00020N2\u0006\u0010Y\u001a\u00020\u0011J\u001a\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0P0\u0010H\u0007J\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00110P2\u0006\u0010]\u001a\u00020\u0011J\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020_0\u00172\u0006\u0010K\u001a\u00020\u0016J\u0018\u0010`\u001a\b\u0012\u0004\u0012\u00020[0\u00172\b\b\u0002\u0010a\u001a\u00020bH\u0007J/\u0010c\u001a\b\u0012\u0004\u0012\u00020d0P2\u0012\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110f\"\u00020\u00112\b\b\u0002\u0010I\u001a\u00020E\u00a2\u0006\u0002\u0010gJ\u0010\u0010h\u001a\u0004\u0018\u00010i2\u0006\u0010K\u001a\u00020\u0016J\u001e\u0010j\u001a\b\u0012\u0004\u0012\u00020(0\u00172\u0006\u0010k\u001a\u00020\u00162\u0006\u0010l\u001a\u00020mH\u0016J\u0014\u0010n\u001a\b\u0012\u0004\u0012\u00020o0\u00172\u0006\u0010K\u001a\u00020\u0016J\u0010\u0010p\u001a\u0004\u0018\u00010i2\u0006\u0010K\u001a\u00020\u0016J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020i0P2\b\b\u0002\u0010I\u001a\u00020EH\u0007J\u0010\u0010q\u001a\u0004\u0018\u00010N2\u0006\u0010K\u001a\u00020\u0016J\"\u00101\u001a\b\u0012\u0004\u0012\u00020N0P2\b\b\u0002\u0010I\u001a\u00020E2\b\b\u0002\u0010r\u001a\u00020EH\u0007J\u0018\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00160P2\b\b\u0002\u0010r\u001a\u00020EH\u0007J\b\u0010t\u001a\u00020uH\u0007J\u000e\u0010v\u001a\b\u0012\u0004\u0012\u00020o0\u0017H\u0007J\b\u0010w\u001a\u00020uH\u0007J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020y0\u00172\u0006\u0010z\u001a\u00020[H\u0016J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020{0\u00172\u0006\u0010|\u001a\u00020}H\u0016J\u0017\u0010x\u001a\b\u0012\u0004\u0012\u00020~0\u00172\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0016J&\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020}0\u00172\t\b\u0002\u0010\u0082\u0001\u001a\u00020E2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010bH\u0007J\u001c\u0010\u0083\u0001\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0084\u00010\u00170\u0010H\u0007J\u0016\u0010\u0085\u0001\u001a\t\u0012\u0005\u0012\u00030\u0084\u00010\u00172\u0006\u0010K\u001a\u00020\u0016J\u0011\u0010\u0086\u0001\u001a\u0004\u0018\u00010d2\u0006\u0010K\u001a\u00020\u0016J\u0019\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020d0P2\b\b\u0002\u0010I\u001a\u00020EH\u0007J1\u0010\u0088\u0001\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0080\u00010\u00170\u00102\t\b\u0002\u0010\u0082\u0001\u001a\u00020E2\b\b\u0002\u0010I\u001a\u00020EH\u0007J(\u0010\u0089\u0001\u001a\u00020E2\u0007\u0010\u008a\u0001\u001a\u00020\u00112\u000b\b\u0002\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00112\t\b\u0002\u0010\u008c\u0001\u001a\u00020EJ\n\u0010\u008d\u0001\u001a\u00020RH\u00d6\u0001J\u000f\u0010\u008e\u0001\u001a\u00020E2\u0006\u0010K\u001a\u00020\u0016J\u000f\u0010\u008f\u0001\u001a\u00020E2\u0006\u0010K\u001a\u00020\u0016J\u000f\u0010\u0090\u0001\u001a\u00020E2\u0006\u0010K\u001a\u00020\u0016J\u000f\u0010\u0091\u0001\u001a\u00020E2\u0006\u0010K\u001a\u00020\u0016J\u000f\u0010\u0092\u0001\u001a\u00020E2\u0006\u0010K\u001a\u00020\u0016J\u0011\u0010\u0093\u0001\u001a\u00020E2\u0006\u0010|\u001a\u00020}H\u0016J\u0012\u0010\u0093\u0001\u001a\u00020E2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0016J\u0011\u0010\u0094\u0001\u001a\u00020\u00002\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001J\n\u0010\u0097\u0001\u001a\u00020\u0011H\u00d6\u0001J\u0007\u0010\u0098\u0001\u001a\u00020\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001c\u001a\u0004\b!\u0010\"R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR-\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00170\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001c\u001a\u0004\b)\u0010\u001aR'\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020,0\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001c\u001a\u0004\b-\u0010\u001aR'\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002000\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u001c\u001a\u0004\b1\u0010\u001aR)\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u001c\u001a\u0004\b4\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006\u009a\u0001"}, d2={"Lorg/ossreviewtoolkit/model/OrtResult;", "Lorg/ossreviewtoolkit/model/utils/ResolutionProvider;", "Lorg/ossreviewtoolkit/model/utils/PackageConfigurationProvider;", "repository", "Lorg/ossreviewtoolkit/model/Repository;", "analyzer", "Lorg/ossreviewtoolkit/model/AnalyzerRun;", "scanner", "Lorg/ossreviewtoolkit/model/ScannerRun;", "advisor", "Lorg/ossreviewtoolkit/model/AdvisorRun;", "evaluator", "Lorg/ossreviewtoolkit/model/EvaluatorRun;", "resolvedConfiguration", "Lorg/ossreviewtoolkit/model/ResolvedConfiguration;", "labels", "", "", "(Lorg/ossreviewtoolkit/model/Repository;Lorg/ossreviewtoolkit/model/AnalyzerRun;Lorg/ossreviewtoolkit/model/ScannerRun;Lorg/ossreviewtoolkit/model/AdvisorRun;Lorg/ossreviewtoolkit/model/EvaluatorRun;Lorg/ossreviewtoolkit/model/ResolvedConfiguration;Ljava/util/Map;)V", "getAdvisor", "()Lorg/ossreviewtoolkit/model/AdvisorRun;", "advisorResultsById", "Lorg/ossreviewtoolkit/model/Identifier;", "", "Lorg/ossreviewtoolkit/model/AdvisorResult;", "getAdvisorResultsById", "()Ljava/util/Map;", "advisorResultsById$delegate", "Lkotlin/Lazy;", "getAnalyzer", "()Lorg/ossreviewtoolkit/model/AnalyzerRun;", "dependencyNavigator", "Lorg/ossreviewtoolkit/model/DependencyNavigator;", "getDependencyNavigator", "()Lorg/ossreviewtoolkit/model/DependencyNavigator;", "dependencyNavigator$delegate", "getEvaluator", "()Lorg/ossreviewtoolkit/model/EvaluatorRun;", "getLabels", "packageConfigurationsById", "Lorg/ossreviewtoolkit/model/config/PackageConfiguration;", "getPackageConfigurationsById", "packageConfigurationsById$delegate", "packages", "Lorg/ossreviewtoolkit/model/PackageEntry;", "getPackages", "packages$delegate", "projects", "Lorg/ossreviewtoolkit/model/ProjectEntry;", "getProjects", "projects$delegate", "relativeProjectVcsPath", "getRelativeProjectVcsPath", "relativeProjectVcsPath$delegate", "getRepository", "()Lorg/ossreviewtoolkit/model/Repository;", "getResolvedConfiguration", "()Lorg/ossreviewtoolkit/model/ResolvedConfiguration;", "getScanner", "()Lorg/ossreviewtoolkit/model/ScannerRun;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "getAdvisorResults", "omitExcluded", "getAdvisorResultsForId", "id", "getDefinitionFilePathRelativeToAnalyzerRoot", "project", "Lorg/ossreviewtoolkit/model/Project;", "getDependencies", "", "maxLevel", "", "getExcludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "getFileListForId", "Lorg/ossreviewtoolkit/model/FileList;", "getFileLists", "getFilePathRelativeToAnalyzerRoot", "path", "getIssues", "Lorg/ossreviewtoolkit/model/Issue;", "getLabelValues", "key", "getLicenseFindingCurations", "Lorg/ossreviewtoolkit/model/config/LicenseFindingCuration;", "getOpenIssues", "minSeverity", "Lorg/ossreviewtoolkit/model/Severity;", "getOrgPackages", "Lorg/ossreviewtoolkit/model/Package;", "names", "", "([Ljava/lang/String;Z)Ljava/util/Set;", "getPackage", "Lorg/ossreviewtoolkit/model/CuratedPackage;", "getPackageConfigurations", "packageId", "provenance", "Lorg/ossreviewtoolkit/model/Provenance;", "getPackageLicenseChoices", "Lorg/ossreviewtoolkit/utils/spdx/SpdxLicenseChoice;", "getPackageOrProject", "getProject", "includeSubProjects", "getProjectsAndPackages", "getRepositoryConfigResolutions", "Lorg/ossreviewtoolkit/model/config/Resolutions;", "getRepositoryLicenseChoices", "getResolutions", "getResolutionsFor", "Lorg/ossreviewtoolkit/model/config/IssueResolution;", "issue", "Lorg/ossreviewtoolkit/model/config/RuleViolationResolution;", "violation", "Lorg/ossreviewtoolkit/model/RuleViolation;", "Lorg/ossreviewtoolkit/model/config/VulnerabilityResolution;", "vulnerability", "Lorg/ossreviewtoolkit/model/vulnerabilities/Vulnerability;", "getRuleViolations", "omitResolved", "getScanResults", "Lorg/ossreviewtoolkit/model/ScanResult;", "getScanResultsForId", "getUncuratedPackageOrProject", "getUncuratedPackages", "getVulnerabilities", "hasLabel", "label", "value", "splitValue", "hashCode", "isExcluded", "isPackage", "isPackageExcluded", "isProject", "isProjectExcluded", "isResolved", "replaceConfig", "config", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "toString", "withResolvedScopes", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nOrtResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrtResult.kt\norg/ossreviewtoolkit/model/OrtResult\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,655:1\n526#2:656\n511#2,6:657\n478#2,7:750\n453#2:757\n403#2:758\n494#2,7:768\n1#3:663\n1#3:679\n1#3:705\n1#3:747\n1855#4,2:664\n1620#4,3:666\n766#4:682\n857#4:683\n2624#4,3:684\n858#4:687\n766#4:688\n857#4,2:689\n766#4:691\n857#4,2:692\n1620#4,3:694\n766#4:697\n857#4,2:698\n1620#4,3:700\n857#4,2:708\n1446#4,5:710\n1620#4,3:715\n1620#4,3:718\n1747#4,3:721\n1747#4,3:724\n766#4:727\n857#4,2:728\n766#4:730\n857#4,2:731\n766#4:733\n857#4,2:734\n766#4:736\n857#4,2:737\n766#4:739\n857#4:740\n2624#4,3:741\n858#4:744\n1238#4,2:759\n766#4:761\n857#4:762\n2624#4,3:763\n858#4:766\n1241#4:767\n1549#4:775\n1620#4,3:776\n135#5,9:669\n215#5:678\n216#5:680\n144#5:681\n143#5:703\n215#5:704\n216#5:706\n144#5:707\n143#5:745\n215#5:746\n216#5:748\n144#5:749\n*S KotlinDebug\n*F\n+ 1 OrtResult.kt\norg/ossreviewtoolkit/model/OrtResult\n*L\n183#1:656\n183#1:657,6\n506#1:750,7\n511#1:757\n511#1:758\n515#1:768,7\n282#1:679\n342#1:705\n496#1:747\n211#1:664,2\n263#1:666,3\n284#1:682\n284#1:683\n285#1:684,3\n284#1:687\n292#1:688\n292#1:689,2\n303#1:691\n303#1:692,2\n305#1:694,3\n309#1:697\n309#1:698,2\n311#1:700,3\n357#1:708,2\n362#1:710,5\n381#1:715,3\n382#1:718,3\n410#1:721,3\n416#1:724,3\n422#1:727\n422#1:728,2\n428#1:730\n428#1:731,2\n434#1:733\n434#1:734,2\n446#1:736\n446#1:737,2\n452#1:739\n452#1:740\n453#1:741,3\n452#1:744\n511#1:759,2\n512#1:761\n512#1:762\n513#1:763,3\n512#1:766\n511#1:767\n596#1:775\n596#1:776,3\n282#1:669,9\n282#1:678\n282#1:680\n282#1:681\n342#1:703\n342#1:704\n342#1:706\n342#1:707\n496#1:745\n496#1:746\n496#1:748\n496#1:749\n*E\n"})
public final class OrtResult
implements ResolutionProvider,
PackageConfigurationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Repository repository;
    @Nullable
    private final AnalyzerRun analyzer;
    @Nullable
    private final ScannerRun scanner;
    @Nullable
    private final AdvisorRun advisor;
    @Nullable
    private final EvaluatorRun evaluator;
    @NotNull
    private final ResolvedConfiguration resolvedConfiguration;
    @NotNull
    private final Map<String, String> labels;
    @NotNull
    private final Lazy dependencyNavigator$delegate;
    @NotNull
    private final Lazy advisorResultsById$delegate;
    @NotNull
    private final Lazy packages$delegate;
    @NotNull
    private final Lazy packageConfigurationsById$delegate;
    @NotNull
    private final Lazy projects$delegate;
    @NotNull
    private final Lazy relativeProjectVcsPath$delegate;
    @JvmField
    @NotNull
    public static final OrtResult EMPTY = new OrtResult(Repository.EMPTY, null, null, null, null, null, MapsKt.emptyMap(), 32, null);

    public OrtResult(@NotNull Repository repository, @Nullable AnalyzerRun analyzer, @Nullable ScannerRun scanner, @Nullable AdvisorRun advisor, @Nullable EvaluatorRun evaluator, @NotNull ResolvedConfiguration resolvedConfiguration, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)resolvedConfiguration, (String)"resolvedConfiguration");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        this.repository = repository;
        this.analyzer = analyzer;
        this.scanner = scanner;
        this.advisor = advisor;
        this.evaluator = evaluator;
        this.resolvedConfiguration = resolvedConfiguration;
        this.labels = labels;
        this.dependencyNavigator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DependencyNavigator>(this){
            final /* synthetic */ OrtResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DependencyNavigator invoke() {
                return CompatibilityDependencyNavigator.Companion.create(this.this$0);
            }
        }));
        this.advisorResultsById$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends List<? extends AdvisorResult>>>(this){
            final /* synthetic */ OrtResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<Identifier, List<AdvisorResult>> invoke() {
                Map map;
                Object object = this.this$0.getAdvisor();
                if ((object != null && (object = ((AdvisorRun)object).getResults()) != null ? ((AdvisorRecord)object).getAdvisorResults() : (map = null)) == null) {
                    map = MapsKt.emptyMap();
                }
                return map;
            }
        }));
        this.packages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, PackageEntry>>(this){
            final /* synthetic */ OrtResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, PackageEntry> invoke() {
                void destination$iv;
                void $this$associateWithTo$iv;
                Object project;
                Iterable $this$forEach$iv;
                Object $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Map map;
                Object element$iv$iv2;
                void $this$associateByTo$iv$iv2;
                Set set;
                Set projects2 = OrtResult.getProjects$default(this.this$0, false, false, 3, null);
                Object object = this.this$0.getAnalyzer();
                if ((object != null && (object = ((AnalyzerRun)object).getResult()) != null ? ((AnalyzerResult)object).getPackages() : (set = null)) == null) {
                    set = SetsKt.emptySet();
                }
                Iterable $this$associateBy$iv2 = set;
                boolean $i$f$associateBy22 = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv2;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv2 : $this$associateByTo$iv$iv2) {
                    void it;
                    Package package_ = (Package)element$iv$iv2;
                    map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getId(), element$iv$iv2);
                }
                Map packages2 = destination$iv$iv;
                Iterable $i$f$associateBy22 = OrtResultKt.access$applyPackageCurations(packages2.values(), this.this$0.getResolvedConfiguration().getAllPackageCurations());
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv22);
                boolean $i$f$associateByTo2 = false;
                element$iv$iv2 = $this$associateByTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    void it;
                    E element$iv$iv3 = element$iv$iv2.next();
                    CuratedPackage bl = (CuratedPackage)element$iv$iv3;
                    map = destination$iv$iv2;
                    boolean bl2 = false;
                    map.put(it.getMetadata().getId(), element$iv$iv3);
                }
                Map curatedPackages = destination$iv$iv2;
                Set allDependencies = CollectionsKt.toMutableSet((Iterable)packages2.keySet());
                Set includedDependencies = new LinkedHashSet<E>();
                Iterable capacity$iv22 = projects2;
                $this$associateByTo$iv$iv = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    project = (Project)element$iv;
                    boolean bl = false;
                    Map $this$forEach$iv2 = DependencyNavigator.DefaultImpls.scopeDependencies$default(((OrtResult)$this$associateByTo$iv$iv).getDependencyNavigator(), (Project)project, 0, null, 6, null);
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv2;
                        Map.Entry<K, V> entry = element$iv2 = iterator.next();
                        boolean bl3 = false;
                        String scopeName = (String)entry.getKey();
                        Set dependencies2 = (Set)entry.getValue();
                        boolean isScopeExcluded = ((OrtResult)$this$associateByTo$iv$iv).getExcludes().isScopeExcluded(scopeName);
                        CollectionsKt.addAll((Collection)allDependencies, (Iterable)dependencies2);
                        if (((OrtResult)$this$associateByTo$iv$iv).isProjectExcluded(((Project)project).getId()) || isScopeExcluded) continue;
                        CollectionsKt.addAll((Collection)includedDependencies, (Iterable)dependencies2);
                    }
                }
                $this$forEach$iv = allDependencies;
                $this$associateByTo$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$associateWithTo = false;
                for (T element$iv : $this$associateWithTo$iv) {
                    void id;
                    project = (Identifier)element$iv;
                    T t = element$iv;
                    map = destination$iv;
                    boolean bl = false;
                    PackageEntry packageEntry = new PackageEntry((Package)packages2.get(id), (CuratedPackage)curatedPackages.get(id), !includedDependencies.contains(id));
                    map.put(t, packageEntry);
                }
                return destination$iv;
            }
        }));
        this.packageConfigurationsById$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends List<? extends PackageConfiguration>>>(this){
            final /* synthetic */ OrtResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, List<PackageConfiguration>> invoke() {
                void $this$groupByTo$iv$iv;
                List list = this.this$0.getResolvedConfiguration().getPackageConfigurations();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable $this$groupBy$iv = list;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    PackageConfiguration it = (PackageConfiguration)element$iv$iv;
                    boolean bl = false;
                    Identifier key$iv$iv = it.getId();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.projects$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends ProjectEntry>>(this){
            final /* synthetic */ OrtResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, ProjectEntry> invoke() {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Iterable iterable = OrtResult.getProjects$default(this.this$0, false, false, 3, null);
                OrtResult ortResult = this.this$0;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var5_5 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    Project project = (Project)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Project project2 = (Project)element$iv$iv;
                    Identifier identifier = project2.getId();
                    boolean bl2 = false;
                    List<PathExclude> pathExcludes = ortResult.getExcludes().findPathExcludes(project2, ortResult);
                    ProjectEntry projectEntry = new ProjectEntry(project2, !((Collection)pathExcludes).isEmpty());
                    map.put(identifier, projectEntry);
                }
                return destination$iv$iv;
            }
        }));
        this.relativeProjectVcsPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends String>>(this){
            final /* synthetic */ OrtResult this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, String> invoke() {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Iterable iterable = OrtResult.getProjects$default(this.this$0, false, false, 3, null);
                OrtResult ortResult = this.this$0;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var5_5 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    Project project = (Project)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Project it = (Project)element$iv$iv;
                    Identifier identifier = it.getId();
                    boolean bl2 = false;
                    String string = ortResult.getRepository().getRelativePath(it.getVcsProcessed());
                    map.put(identifier, string);
                }
                return destination$iv$iv;
            }
        }));
    }

    public /* synthetic */ OrtResult(Repository repository, AnalyzerRun analyzerRun, ScannerRun scannerRun, AdvisorRun advisorRun, EvaluatorRun evaluatorRun, ResolvedConfiguration resolvedConfiguration, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            analyzerRun = null;
        }
        if ((n & 4) != 0) {
            scannerRun = null;
        }
        if ((n & 8) != 0) {
            advisorRun = null;
        }
        if ((n & 0x10) != 0) {
            evaluatorRun = null;
        }
        if ((n & 0x20) != 0) {
            resolvedConfiguration = new ResolvedConfiguration(null, null, null, 7, null);
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        this(repository, analyzerRun, scannerRun, advisorRun, evaluatorRun, resolvedConfiguration, map);
    }

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public final AnalyzerRun getAnalyzer() {
        return this.analyzer;
    }

    @Nullable
    public final ScannerRun getScanner() {
        return this.scanner;
    }

    @Nullable
    public final AdvisorRun getAdvisor() {
        return this.advisor;
    }

    @Nullable
    public final EvaluatorRun getEvaluator() {
        return this.evaluator;
    }

    @NotNull
    public final ResolvedConfiguration getResolvedConfiguration() {
        return this.resolvedConfiguration;
    }

    @NotNull
    public final Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonIgnore
    @NotNull
    public final DependencyNavigator getDependencyNavigator() {
        Lazy lazy = this.dependencyNavigator$delegate;
        return (DependencyNavigator)lazy.getValue();
    }

    private final Map<Identifier, List<AdvisorResult>> getAdvisorResultsById() {
        Lazy lazy = this.advisorResultsById$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<Identifier, PackageEntry> getPackages() {
        Lazy lazy = this.packages$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<Identifier, List<PackageConfiguration>> getPackageConfigurationsById() {
        Lazy lazy = this.packageConfigurationsById$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<Identifier, ProjectEntry> getProjects() {
        Lazy lazy = this.projects$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<Identifier, String> getRelativeProjectVcsPath() {
        Lazy lazy = this.relativeProjectVcsPath$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Map<Identifier, List<AdvisorResult>> getAdvisorResults(boolean omitExcluded) {
        void $this$filterTo$iv$iv;
        Map<Identifier, List<AdvisorResult>> $this$filter$iv = this.getAdvisorResultsById();
        boolean $i$f$filter = false;
        Map<Identifier, List<AdvisorResult>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Identifier id = (Identifier)entry.getKey();
            if (!(!omitExcluded || !this.isExcluded(id))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public static /* synthetic */ Map getAdvisorResults$default(OrtResult ortResult, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ortResult.getAdvisorResults(bl);
    }

    @NotNull
    public final List<AdvisorResult> getAdvisorResultsForId(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List list = this.getAdvisorResultsById().get(id);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String getDefinitionFilePathRelativeToAnalyzerRoot(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getFilePathRelativeToAnalyzerRoot(project, project.getDefinitionFilePath());
    }

    @NotNull
    public final Set<Identifier> getDependencies(@NotNull Identifier id, int maxLevel, boolean omitExcluded) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Set dependencies2 = new LinkedHashSet();
        Function1 it = function1 = DependencyNavigator.Companion.getMATCH_ALL();
        boolean bl = false;
        Object object = !omitExcluded ? function1 : null;
        if (object == null) {
            object = (Function1)new Function1<DependencyNode, Boolean>(this){
                final /* synthetic */ OrtResult this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull DependencyNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !this.this$0.isExcluded(it.getId());
                }
            };
        }
        Function1 matcher2 = object;
        Iterable $this$forEach$iv = OrtResult.getProjects$default(this, false, false, 3, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)project.getId(), (Object)id)) {
                CollectionsKt.addAll((Collection)dependencies2, (Iterable)this.getDependencyNavigator().projectDependencies(project, maxLevel, (Function1<? super DependencyNode, Boolean>)matcher2));
            }
            CollectionsKt.addAll((Collection)dependencies2, (Iterable)this.getDependencyNavigator().packageDependencies(project, id, maxLevel, (Function1<? super DependencyNode, Boolean>)matcher2));
        }
        return dependencies2;
    }

    public static /* synthetic */ Set getDependencies$default(OrtResult ortResult, Identifier identifier, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return ortResult.getDependencies(identifier, n, bl);
    }

    @JsonIgnore
    @NotNull
    public final Excludes getExcludes() {
        return this.repository.getConfig().getExcludes();
    }

    @NotNull
    public final String getFilePathRelativeToAnalyzerRoot(@NotNull Project project, @NotNull String path) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String vcsPath = (String)MapsKt.getValue(this.getRelativeProjectVcsPath(), (Object)project.getId());
        if (vcsPath == null) {
            boolean bl = false;
            String string = "The " + project.getVcsProcessed() + " of project '" + project.getId().toCoordinates() + "' cannot be found in " + this.repository + ".";
            throw new IllegalArgumentException(string.toString());
        }
        StringBuilder $this$getFilePathRelativeToAnalyzerRoot_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)vcsPath).length() > 0) {
            $this$getFilePathRelativeToAnalyzerRoot_u24lambda_u244.append(vcsPath);
            $this$getFilePathRelativeToAnalyzerRoot_u24lambda_u244.append("/");
        }
        $this$getFilePathRelativeToAnalyzerRoot_u24lambda_u244.append(path);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JsonIgnore
    @NotNull
    public final Map<Identifier, Set<Issue>> getIssues() {
        Map map;
        Object object;
        Map scannerIssues;
        Map map2;
        Object object2 = this.analyzer;
        if ((object2 != null && (object2 = ((AnalyzerRun)object2).getResult()) != null ? ((AnalyzerResult)object2).getAllIssues() : (map2 = null)) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map analyzerIssues = map2;
        ScannerRun scannerRun = this.scanner;
        Map map3 = scannerRun != null ? scannerRun.getIssues() : null;
        if (map3 == null) {
            map3 = scannerIssues = MapsKt.emptyMap();
        }
        if (((object = this.advisor) != null && (object = ((AdvisorRun)object).getResults()) != null ? ((AdvisorRecord)object).getIssues() : (map = null)) == null) {
            map = MapsKt.emptyMap();
        }
        Map advisorIssues = map;
        Map analyzerAndScannerIssues = ExtensionsKt.zipWithSets((Map)analyzerIssues, (Map)scannerIssues);
        return ExtensionsKt.zipWithSets((Map)analyzerAndScannerIssues, (Map)advisorIssues);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getLabelValues(@NotNull String key) {
        void $this$mapTo$iv;
        List list;
        List list2;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.labels.get(key);
        if (string != null) {
            cArray = new char[]{','};
            list2 = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        return (Set)cArray;
    }

    @NotNull
    public final List<LicenseFindingCuration> getLicenseFindingCurations(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getProjects().containsKey(id) ? this.repository.getConfig().getCurations().getLicenseFindings() : CollectionsKt.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    @JsonIgnore
    @NotNull
    public final List<Issue> getOpenIssues(@NotNull Severity minSeverity) {
        Intrinsics.checkNotNullParameter((Object)minSeverity, (String)"minSeverity");
        $this$mapNotNull$iv = this.getIssues();
        $i$f$mapNotNull = false;
        var4_4 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var9_10 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (var9_10.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var9_10.next();
            $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = false;
            var13_15 = element$iv$iv;
            $i$a$-mapNotNull-OrtResult$getOpenIssues$1 = false;
            id = (Identifier)var13_15.getKey();
            it = var17_21 = (issues = (Set<E>)var13_15.getValue());
            $i$a$-takeUnless-OrtResult$getOpenIssues$1$1 = false;
            if ((!this.isExcluded(id) ? var17_21 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            $i$a$-let-MapsKt___MapsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block7: {
                issue = (Issue)element$iv$iv;
                $i$a$-filter-OrtResult$getOpenIssues$2 = false;
                if (issue.getSeverity().compareTo((Enum)minSeverity) < 0) ** GOTO lbl-1000
                $this$none$iv = this.getResolutions().getIssues();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (E element$iv : $this$none$iv) {
                        it = (IssueResolution)element$iv;
                        $i$a$-none-OrtResult$getOpenIssues$2$1 = false;
                        if (!it.matches(issue)) continue;
                        v0 = false;
                        break block7;
                    }
                    v0 = true;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getOpenIssues$default(OrtResult ortResult, Severity severity, int n, Object object) {
        if ((n & 1) != 0) {
            severity = Severity.WARNING;
        }
        return ortResult.getOpenIssues(severity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackageConfiguration> getPackageConfigurations(@NotNull Identifier packageId, @NotNull Provenance provenance) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        List list = this.getPackageConfigurationsById().get(packageId);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageConfiguration it = (PackageConfiguration)element$iv$iv;
            boolean bl = false;
            if (!it.matches(packageId, provenance)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Package> getOrgPackages(@NotNull String[] names, boolean omitExcluded) {
        Collection collection;
        void $this$mapTo$iv;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        Set vendorPackages = new LinkedHashSet();
        Iterable $this$filter$iv = OrtResult.getProjects$default(this, false, false, 3, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            if (!(it.getId().isFromOrg(Arrays.copyOf(names, names.length)) && (!omitExcluded || !this.isExcluded(it.getId())))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Project $i$f$filterTo2 = (Project)item$iv;
            collection = vendorPackages;
            boolean bl = false;
            collection.add(it.toPackage());
        }
        $this$filter$iv = OrtResult.getPackages$default(this, false, 1, null);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo2 = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            CuratedPackage curatedPackage = (CuratedPackage)element$iv$iv;
            boolean bl2 = false;
            Package pkg = curatedPackage.component1();
            if (!(pkg.getId().isFromOrg(Arrays.copyOf(names, names.length)) && (!omitExcluded || !this.isPackageExcluded(pkg.getId())))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CuratedPackage $i$f$filterTo3 = (CuratedPackage)item$iv;
            collection = vendorPackages;
            boolean bl3 = false;
            collection.add(it.getMetadata());
        }
        return vendorPackages;
    }

    public static /* synthetic */ Set getOrgPackages$default(OrtResult ortResult, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ortResult.getOrgPackages(stringArray, bl);
    }

    @Nullable
    public final CuratedPackage getPackage(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PackageEntry packageEntry = this.getPackages().get(id);
        return packageEntry != null ? packageEntry.getCuratedPackage() : null;
    }

    @NotNull
    public final List<SpdxLicenseChoice> getPackageLicenseChoices(@NotNull Identifier id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.repository.getConfig().getLicenseChoices().getPackageLicenseChoices();
            for (Object t : iterable) {
                PackageLicenseChoice it = (PackageLicenseChoice)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPackageId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        PackageLicenseChoice packageLicenseChoice = v0;
        List list = packageLicenseChoice != null ? packageLicenseChoice.getLicenseChoices() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final CuratedPackage getPackageOrProject(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CuratedPackage curatedPackage = this.getPackage(id);
        if (curatedPackage == null) {
            Object object = this.getProject(id);
            curatedPackage = object != null && (object = ((Project)object).toPackage()) != null ? ((Package)object).toCuratedPackage() : null;
        }
        return curatedPackage;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Set<CuratedPackage> getPackages(boolean omitExcluded) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Map<Identifier, PackageEntry> map = this.getPackages();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            CuratedPackage it$iv;
            CuratedPackage curatedPackage;
            Map.Entry element$iv$iv;
            Map.Entry element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv;
            boolean bl2 = false;
            PackageEntry entry2 = (PackageEntry)entry.getValue();
            CuratedPackage it = curatedPackage = entry2.getCuratedPackage();
            boolean bl3 = false;
            if ((!(omitExcluded && entry2.isExcluded()) ? curatedPackage : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    public static /* synthetic */ Set getPackages$default(OrtResult ortResult, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ortResult.getPackages(bl);
    }

    @Nullable
    public final Project getProject(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectEntry projectEntry = this.getProjects().get(id);
        return projectEntry != null ? projectEntry.getProject() : null;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Set<Project> getProjects(boolean omitExcluded, boolean includeSubProjects) {
        Iterable destination$iv;
        void $this$filterTo$iv;
        Set set;
        Object object = this.analyzer;
        if ((object != null && (object = ((AnalyzerRun)object).getResult()) != null ? ((AnalyzerResult)object).getProjects() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        Iterable iterable = set;
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv : $this$filterTo$iv) {
            Project project = (Project)element$iv;
            boolean bl = false;
            if (!(!omitExcluded || !this.isExcluded(project.getId()))) continue;
            destination$iv.add(element$iv);
        }
        Set projects2 = (Set)destination$iv;
        if (!includeSubProjects) {
            void destination$iv2;
            void $this$flatMapTo$iv;
            destination$iv = projects2;
            Collection $i$f$filterTo2 = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                Iterable list$iv = this.getDependencyNavigator().collectSubProjects(it);
                CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
            }
            Set subProjectIds = (Set)destination$iv2;
            CollectionsKt.removeAll((Iterable)projects2, (Function1)((Function1)new Function1<Project, Boolean>((Set<Identifier>)subProjectIds){
                final /* synthetic */ Set<Identifier> $subProjectIds;
                {
                    this.$subProjectIds = $subProjectIds;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Project it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$subProjectIds.contains(it.getId());
                }
            }));
        }
        return projects2;
    }

    public static /* synthetic */ Set getProjects$default(OrtResult ortResult, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return ortResult.getProjects(bl, bl2);
    }

    @JsonIgnore
    @NotNull
    public final Set<Identifier> getProjectsAndPackages(boolean includeSubProjects) {
        CuratedPackage it;
        Collection collection;
        Set projectsAndPackages = new LinkedHashSet();
        Set projects2 = OrtResult.getProjects$default(this, false, includeSubProjects, 1, null);
        Iterable $this$mapTo$iv = projects2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Project project = (Project)item$iv;
            collection = projectsAndPackages;
            boolean bl = false;
            collection.add(((Project)((Object)it)).getId());
        }
        $this$mapTo$iv = OrtResult.getPackages$default(this, false, 1, null);
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (CuratedPackage)item$iv;
            collection = projectsAndPackages;
            boolean bl = false;
            collection.add(it.getMetadata().getId());
        }
        return projectsAndPackages;
    }

    public static /* synthetic */ Set getProjectsAndPackages$default(OrtResult ortResult, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return ortResult.getProjectsAndPackages(bl);
    }

    @JsonIgnore
    @NotNull
    public final List<SpdxLicenseChoice> getRepositoryLicenseChoices() {
        return this.repository.getConfig().getLicenseChoices().getRepositoryLicenseChoices();
    }

    @JsonIgnore
    @NotNull
    public final Resolutions getRepositoryConfigResolutions() {
        return ResolutionsKt.orEmpty(this.repository.getConfig().getResolutions());
    }

    @JsonIgnore
    @NotNull
    public final Resolutions getResolutions() {
        return ResolutionsKt.orEmpty(this.resolvedConfiguration.getResolutions());
    }

    @Override
    public boolean isResolved(@NotNull RuleViolation violation) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)violation, (String)"violation");
            Iterable $this$any$iv = this.getResolutions().getRuleViolations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RuleViolationResolution it = (RuleViolationResolution)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(violation)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isResolved(@NotNull Vulnerability vulnerability) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)vulnerability, (String)"vulnerability");
            Iterable $this$any$iv = this.getResolutions().getVulnerabilities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VulnerabilityResolution it = (VulnerabilityResolution)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(vulnerability)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IssueResolution> getResolutionsFor(@NotNull Issue issue) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Iterable $this$filter$iv = this.getResolutions().getIssues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IssueResolution it = (IssueResolution)element$iv$iv;
            boolean bl = false;
            if (!it.matches(issue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RuleViolationResolution> getResolutionsFor(@NotNull RuleViolation violation) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)violation, (String)"violation");
        Iterable $this$filter$iv = this.getResolutions().getRuleViolations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RuleViolationResolution it = (RuleViolationResolution)element$iv$iv;
            boolean bl = false;
            if (!it.matches(violation)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VulnerabilityResolution> getResolutionsFor(@NotNull Vulnerability vulnerability) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vulnerability, (String)"vulnerability");
        Iterable $this$filter$iv = this.getResolutions().getVulnerabilities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VulnerabilityResolution it = (VulnerabilityResolution)element$iv$iv;
            boolean bl = false;
            if (!it.matches(vulnerability)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final List<RuleViolation> getRuleViolations(boolean omitResolved, @Nullable Severity minSeverity) {
        List list;
        List list2;
        EvaluatorRun evaluatorRun = this.evaluator;
        List list3 = evaluatorRun != null ? evaluatorRun.getViolations() : null;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List allViolations = list3;
        Severity severity = minSeverity;
        if ((severity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) == -1) {
            list2 = allViolations;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allViolations;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RuleViolation it = (RuleViolation)element$iv$iv;
                boolean bl = false;
                if (!(it.getSeverity().compareTo((Enum)minSeverity) >= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List severeViolations = list2;
        if (omitResolved) {
            void $this$filterTo$iv$iv;
            List<RuleViolationResolution> resolutions = this.getResolutions().getRuleViolations();
            Iterable $this$filter$iv = severeViolations;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block10: {
                    RuleViolation violation = (RuleViolation)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = resolutions;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            RuleViolationResolution resolution = (RuleViolationResolution)element$iv;
                            boolean bl3 = false;
                            if (!resolution.matches(violation)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = severeViolations;
        }
        return list;
    }

    public static /* synthetic */ List getRuleViolations$default(OrtResult ortResult, boolean bl, Severity severity, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            severity = null;
        }
        return ortResult.getRuleViolations(bl, severity);
    }

    @NotNull
    public final List<ScanResult> getScanResultsForId(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ScannerRun scannerRun = this.scanner;
        List list = scannerRun != null ? scannerRun.getScanResults(id) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JsonIgnore
    @NotNull
    public final Map<Identifier, List<ScanResult>> getScanResults() {
        ScannerRun scannerRun = this.scanner;
        Map map = scannerRun != null ? scannerRun.getAllScanResults() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    public final FileList getFileListForId(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ScannerRun scannerRun = this.scanner;
        return scannerRun != null ? scannerRun.getFileList(id) : null;
    }

    @JsonIgnore
    @NotNull
    public final Map<Identifier, FileList> getFileLists() {
        ScannerRun scannerRun = this.scanner;
        Map map = scannerRun != null ? scannerRun.getAllFileLists() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    public final Package getUncuratedPackageOrProject(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.getPackages().get(id);
        if (object == null || (object = ((PackageEntry)object).getPkg()) == null) {
            Project project = this.getProject(id);
            object = project != null ? project.toPackage() : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Set<Package> getUncuratedPackages(boolean omitExcluded) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Map<Identifier, PackageEntry> map = this.getPackages();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Package it$iv;
            Package package_;
            Map.Entry element$iv$iv;
            Map.Entry element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv;
            boolean bl2 = false;
            PackageEntry entry2 = (PackageEntry)entry.getValue();
            Package it = package_ = entry2.getPkg();
            boolean bl3 = false;
            if ((!(omitExcluded && entry2.isExcluded()) ? package_ : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    public static /* synthetic */ Set getUncuratedPackages$default(OrtResult ortResult, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ortResult.getUncuratedPackages(bl);
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Map<Identifier, List<Vulnerability>> getVulnerabilities(boolean omitResolved, boolean omitExcluded) {
        Map map;
        void $this$filterKeys$iv;
        Map map2;
        Object object = this.advisor;
        if ((object != null && (object = ((AdvisorRun)object).getResults()) != null ? ((AdvisorRecord)object).getVulnerabilities() : (map2 = null)) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map map3 = map2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            Identifier it = (Identifier)entry$iv.getKey();
            boolean bl = false;
            if (!(!omitExcluded || !this.isExcluded(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map allVulnerabilities = result$iv;
        if (omitResolved) {
            void $this$filterValues$iv;
            void $this$mapValuesTo$iv$iv;
            List<VulnerabilityResolution> resolutions = this.getResolutions().getVulnerabilities();
            Map $this$mapValues$iv = allVulnerabilities;
            boolean $i$f$mapValues = false;
            Map map4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$filterTo$iv$iv;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map6 = map5;
                boolean bl2 = false;
                List vulnerabilities = (List)entry2.getValue();
                Iterable $this$filter$iv = vulnerabilities;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl3;
                    block10: {
                        Vulnerability vulnerability = (Vulnerability)element$iv$iv;
                        boolean bl4 = false;
                        Iterable $this$none$iv = resolutions;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                VulnerabilityResolution it = (VulnerabilityResolution)element$iv;
                                boolean bl5 = false;
                                if (!it.matches(vulnerability)) continue;
                                bl3 = false;
                                break block10;
                            }
                            bl3 = true;
                        }
                    }
                    if (!bl3) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv2;
                map6.put(k, list);
            }
            $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv2 = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                List it = (List)entry$iv.getValue();
                boolean bl = false;
                boolean bl6 = !((Collection)it).isEmpty();
                if (!bl6) continue;
                result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv2;
        } else {
            map = allVulnerabilities;
        }
        return map;
    }

    public static /* synthetic */ Map getVulnerabilities$default(OrtResult ortResult, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return ortResult.getVulnerabilities(bl, bl2);
    }

    public final boolean hasLabel(@NotNull String label, @Nullable String value2, boolean splitValue) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return value2 == null ? this.labels.containsKey(label) : (splitValue ? this.getLabelValues(label).contains(value2) : Intrinsics.areEqual((Object)this.labels.get(label), (Object)value2));
    }

    public static /* synthetic */ boolean hasLabel$default(OrtResult ortResult, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return ortResult.hasLabel(string, string2, bl);
    }

    public final boolean isExcluded(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.isProject(id) ? this.isProjectExcluded(id) && (!this.getPackages().containsKey(id) || this.isPackageExcluded(id)) : this.isPackageExcluded(id);
    }

    public final boolean isPackageExcluded(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PackageEntry packageEntry = this.getPackages().get(id);
        return packageEntry != null ? packageEntry.isExcluded() : false;
    }

    public final boolean isProjectExcluded(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectEntry projectEntry = this.getProjects().get(id);
        return projectEntry != null ? projectEntry.isExcluded() : false;
    }

    public final boolean isPackage(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getPackage(id) != null;
    }

    public final boolean isProject(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getProject(id) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OrtResult replaceConfig(@NotNull RepositoryConfiguration config) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Iterable iterable = this.resolvedConfiguration.getPackageCurations();
        List list = null;
        ResolvedConfiguration resolvedConfiguration = this.resolvedConfiguration;
        EvaluatorRun evaluatorRun = null;
        AdvisorRun advisorRun = null;
        ScannerRun scannerRun = null;
        AnalyzerRun analyzerRun = null;
        Repository repository = Repository.copy$default(this.repository, null, null, null, config, 7, null);
        OrtResult ortResult = this;
        boolean $i$f$map = false;
        void var4_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedPackageCurations resolvedPackageCurations = (ResolvedPackageCurations)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((void)(!Intrinsics.areEqual((Object)it.getProvider().getId(), (Object)"RepositoryConfiguration") ? it : ResolvedPackageCurations.copy$default((ResolvedPackageCurations)it, null, config.getCurations().getPackages(), 1, null)));
        }
        collection = (List)destination$iv$iv;
        return OrtResult.copy$default(ortResult, repository, analyzerRun, scannerRun, advisorRun, evaluatorRun, ResolvedConfiguration.copy$default(resolvedConfiguration, list, (List)collection, null, 5, null), null, 94, null);
    }

    @NotNull
    public final OrtResult withResolvedScopes() {
        AnalyzerRun analyzerRun = this.analyzer;
        return OrtResult.copy$default(this, null, analyzerRun != null ? AnalyzerRun.copy$default(analyzerRun, null, null, null, null, this.analyzer.getResult().withResolvedScopes(), 15, null) : null, null, null, null, null, null, 125, null);
    }

    @Override
    public boolean isResolved(@NotNull Issue issue) {
        return ResolutionProvider.DefaultImpls.isResolved((ResolutionProvider)this, issue);
    }

    @NotNull
    public final Repository component1() {
        return this.repository;
    }

    @Nullable
    public final AnalyzerRun component2() {
        return this.analyzer;
    }

    @Nullable
    public final ScannerRun component3() {
        return this.scanner;
    }

    @Nullable
    public final AdvisorRun component4() {
        return this.advisor;
    }

    @Nullable
    public final EvaluatorRun component5() {
        return this.evaluator;
    }

    @NotNull
    public final ResolvedConfiguration component6() {
        return this.resolvedConfiguration;
    }

    @NotNull
    public final Map<String, String> component7() {
        return this.labels;
    }

    @NotNull
    public final OrtResult copy(@NotNull Repository repository, @Nullable AnalyzerRun analyzer, @Nullable ScannerRun scanner, @Nullable AdvisorRun advisor, @Nullable EvaluatorRun evaluator, @NotNull ResolvedConfiguration resolvedConfiguration, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, String> labels) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)resolvedConfiguration, (String)"resolvedConfiguration");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        return new OrtResult(repository, analyzer, scanner, advisor, evaluator, resolvedConfiguration, labels);
    }

    public static /* synthetic */ OrtResult copy$default(OrtResult ortResult, Repository repository, AnalyzerRun analyzerRun, ScannerRun scannerRun, AdvisorRun advisorRun, EvaluatorRun evaluatorRun, ResolvedConfiguration resolvedConfiguration, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            repository = ortResult.repository;
        }
        if ((n & 2) != 0) {
            analyzerRun = ortResult.analyzer;
        }
        if ((n & 4) != 0) {
            scannerRun = ortResult.scanner;
        }
        if ((n & 8) != 0) {
            advisorRun = ortResult.advisor;
        }
        if ((n & 0x10) != 0) {
            evaluatorRun = ortResult.evaluator;
        }
        if ((n & 0x20) != 0) {
            resolvedConfiguration = ortResult.resolvedConfiguration;
        }
        if ((n & 0x40) != 0) {
            map = ortResult.labels;
        }
        return ortResult.copy(repository, analyzerRun, scannerRun, advisorRun, evaluatorRun, resolvedConfiguration, map);
    }

    @NotNull
    public String toString() {
        return "OrtResult(repository=" + this.repository + ", analyzer=" + this.analyzer + ", scanner=" + this.scanner + ", advisor=" + this.advisor + ", evaluator=" + this.evaluator + ", resolvedConfiguration=" + this.resolvedConfiguration + ", labels=" + this.labels + ")";
    }

    public int hashCode() {
        int result = this.repository.hashCode();
        result = result * 31 + (this.analyzer == null ? 0 : this.analyzer.hashCode());
        result = result * 31 + (this.scanner == null ? 0 : this.scanner.hashCode());
        result = result * 31 + (this.advisor == null ? 0 : this.advisor.hashCode());
        result = result * 31 + (this.evaluator == null ? 0 : this.evaluator.hashCode());
        result = result * 31 + this.resolvedConfiguration.hashCode();
        result = result * 31 + ((Object)this.labels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrtResult)) {
            return false;
        }
        OrtResult ortResult = (OrtResult)other;
        if (!Intrinsics.areEqual((Object)this.repository, (Object)ortResult.repository)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.analyzer, (Object)ortResult.analyzer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scanner, (Object)ortResult.scanner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.advisor, (Object)ortResult.advisor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.evaluator, (Object)ortResult.evaluator)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resolvedConfiguration, (Object)ortResult.resolvedConfiguration)) {
            return false;
        }
        return Intrinsics.areEqual(this.labels, ortResult.labels);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ossreviewtoolkit/model/OrtResult$Companion;", "", "()V", "EMPTY", "Lorg/ossreviewtoolkit/model/OrtResult;", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            $EnumSwitchMapping$0 = new int[Severity.values().length];
        }
    }
}

