/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.CuratedPackage;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.PackageCurationData;
import org.ossreviewtoolkit.model.PackageCurationKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.Semver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\f\u0010\u001c\u001a\u00020\u0012*\u00020\u001bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/ossreviewtoolkit/model/PackageCuration;", "", "id", "Lorg/ossreviewtoolkit/model/Identifier;", "data", "Lorg/ossreviewtoolkit/model/PackageCurationData;", "(Lorg/ossreviewtoolkit/model/Identifier;Lorg/ossreviewtoolkit/model/PackageCurationData;)V", "getData", "()Lorg/ossreviewtoolkit/model/PackageCurationData;", "getId", "()Lorg/ossreviewtoolkit/model/Identifier;", "apply", "Lorg/ossreviewtoolkit/model/CuratedPackage;", "targetPackage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isApplicable", "pkgId", "isApplicableDisregardingVersion", "isApplicableIvyVersion", "toString", "", "isVersionRange", "model"})
@SourceDebugExtension(value={"SMAP\nPackageCuration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageCuration.kt\norg/ossreviewtoolkit/model/PackageCuration\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n38#2:120\n1747#3,3:121\n*S KotlinDebug\n*F\n+ 1 PackageCuration.kt\norg/ossreviewtoolkit/model/PackageCuration\n*L\n86#1:120\n94#1:121,3\n*E\n"})
public final class PackageCuration {
    @NotNull
    private final Identifier id;
    @NotNull
    private final PackageCurationData data;

    public PackageCuration(@NotNull Identifier id, @JsonProperty(value="curations") @NotNull PackageCurationData data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.id = id;
        this.data = data;
    }

    @NotNull
    public final Identifier getId() {
        return this.id;
    }

    @NotNull
    public final PackageCurationData getData() {
        return this.data;
    }

    private final boolean isApplicableDisregardingVersion(Identifier pkgId) {
        return StringsKt.equals((String)this.id.getType(), (String)pkgId.getType(), (boolean)true) && Intrinsics.areEqual((Object)this.id.getNamespace(), (Object)pkgId.getNamespace()) && PackageCurationKt.access$equalsOrIsBlank(this.id.getName(), pkgId.getName());
    }

    private final boolean isApplicableIvyVersion(Identifier pkgId) {
        Object object = this;
        try {
            PackageCuration $this$isApplicableIvyVersion_u24lambda_u241 = object;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)$this$isApplicableIvyVersion_u24lambda_u241.id.getVersion(), (Object)pkgId.getVersion())) {
                return true;
            }
            if ($this$isApplicableIvyVersion_u24lambda_u241.isVersionRange($this$isApplicableIvyVersion_u24lambda_u241.id.getVersion())) {
                RangesList rangesList = RangesListFactory.create((String)$this$isApplicableIvyVersion_u24lambda_u241.id.getVersion());
                Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
                RangesList range = rangesList;
                if (!(range.get().size() > 0)) {
                    boolean $i$a$-require-PackageCuration$isApplicableIvyVersion$1$22 = false;
                    String $i$a$-require-PackageCuration$isApplicableIvyVersion$1$22 = "'" + $this$isApplicableIvyVersion_u24lambda_u241.id.getVersion() + "' is not a valid version range.";
                    throw new IllegalArgumentException($i$a$-require-PackageCuration$isApplicableIvyVersion$1$22.toString());
                }
                Semver semver = Semver.coerce((String)pkgId.getVersion());
                return semver != null ? semver.satisfies(range) : false;
            }
            return false;
        }
        catch (Throwable bl) {
            Serializable serializable;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = serializable = throwable;
                boolean bl2 = false;
                PackageCuration $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(PackageCuration.class).warn((Function0)new Function0<Object>(this, pkgId){
                    final /* synthetic */ PackageCuration this$0;
                    final /* synthetic */ Identifier $pkgId;
                    {
                        this.this$0 = $receiver;
                        this.$pkgId = $pkgId;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Failed to check if package curation version '" + this.this$0.getId().getVersion() + "' is applicable to package version '" + this.$pkgId.getVersion() + "' of package '" + this.$pkgId.toCoordinates() + "'.";
                    }
                });
                ExtensionsKt.showStackTrace((Throwable)it);
            }
            serializable = Boolean.valueOf(false);
            return (Boolean)(Result.isFailure-impl((Object)object) ? serializable : object);
        }
    }

    private final boolean isVersionRange(String $this$isVersionRange) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = PackageCurationKt.access$getVersionRangeIndicators$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)$this$isVersionRange, (CharSequence)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isApplicable(@NotNull Identifier pkgId) {
        Intrinsics.checkNotNullParameter((Object)pkgId, (String)"pkgId");
        return this.isApplicableDisregardingVersion(pkgId) && (PackageCurationKt.access$equalsOrIsBlank(this.id.getVersion(), pkgId.getVersion()) || this.isApplicableIvyVersion(pkgId));
    }

    @NotNull
    public final CuratedPackage apply(@NotNull CuratedPackage targetPackage) {
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        if (!this.isApplicable(targetPackage.getMetadata().getId())) {
            boolean bl = false;
            String string = "Package curation identifier '" + this.id.toCoordinates() + "' does not match package identifier '" + targetPackage.getMetadata().getId().toCoordinates() + "'.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.data.apply(targetPackage);
    }

    @NotNull
    public final Identifier component1() {
        return this.id;
    }

    @NotNull
    public final PackageCurationData component2() {
        return this.data;
    }

    @NotNull
    public final PackageCuration copy(@NotNull Identifier id, @JsonProperty(value="curations") @NotNull PackageCurationData data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new PackageCuration(id, data);
    }

    public static /* synthetic */ PackageCuration copy$default(PackageCuration packageCuration, Identifier identifier, PackageCurationData packageCurationData, int n, Object object) {
        if ((n & 1) != 0) {
            identifier = packageCuration.id;
        }
        if ((n & 2) != 0) {
            packageCurationData = packageCuration.data;
        }
        return packageCuration.copy(identifier, packageCurationData);
    }

    @NotNull
    public String toString() {
        return "PackageCuration(id=" + this.id + ", data=" + this.data + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackageCuration)) {
            return false;
        }
        PackageCuration packageCuration = (PackageCuration)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)packageCuration.id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)packageCuration.data);
    }
}

