/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.PackageLinkage;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.utils.PackageLinkageValueFilter;
import org.ossreviewtoolkit.model.utils.PackageReferenceSortedSetConverter;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a0\u0019J\u0011\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000\bH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J=\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u00062\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0013\u0010#\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010$H\u00d6\u0003J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\u0006\u0010\u0003\u001a\u00020\u0004J\t\u0010&\u001a\u00020\u0017H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u001a\u0010)\u001a\u00020\u00002\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0019J-\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020.\u0012\u0004\u0012\u0002H,0\u0019H\u0016\u00a2\u0006\u0002\u0010/R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lorg/ossreviewtoolkit/model/PackageReference;", "", "Lorg/ossreviewtoolkit/model/DependencyNode;", "id", "Lorg/ossreviewtoolkit/model/Identifier;", "linkage", "Lorg/ossreviewtoolkit/model/PackageLinkage;", "dependencies", "", "issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "(Lorg/ossreviewtoolkit/model/Identifier;Lorg/ossreviewtoolkit/model/PackageLinkage;Ljava/util/Set;Ljava/util/List;)V", "getDependencies", "()Ljava/util/Set;", "getId", "()Lorg/ossreviewtoolkit/model/Identifier;", "getIssues", "()Ljava/util/List;", "getLinkage", "()Lorg/ossreviewtoolkit/model/PackageLinkage;", "collectDependencies", "maxDepth", "", "filterPredicate", "Lkotlin/Function1;", "", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "dependsOn", "equals", "", "findReferences", "hashCode", "toString", "", "traverse", "transform", "visitDependencies", "T", "block", "Lkotlin/sequences/Sequence;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "model"})
@SourceDebugExtension(value={"SMAP\nPackageReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageReference.kt\norg/ossreviewtoolkit/model/PackageReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1747#2,3:125\n766#2:128\n857#2,2:129\n1360#2:131\n1446#2,5:132\n1620#2,3:137\n1855#2,2:140\n*S KotlinDebug\n*F\n+ 1 PackageReference.kt\norg/ossreviewtoolkit/model/PackageReference\n*L\n103#1:125,3\n109#1:128\n109#1:129,2\n109#1:131\n109#1:132,5\n116#1:137,3\n78#1:140,2\n*E\n"})
public final class PackageReference
implements Comparable<PackageReference>,
DependencyNode {
    @NotNull
    private final Identifier id;
    @NotNull
    private final PackageLinkage linkage;
    @NotNull
    private final Set<PackageReference> dependencies;
    @NotNull
    private final List<Issue> issues;

    public PackageReference(@NotNull Identifier id, @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=PackageLinkageValueFilter.class) @NotNull PackageLinkage linkage, @JsonSerialize(converter=PackageReferenceSortedSetConverter.class) @NotNull Set<PackageReference> dependencies2, @NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)linkage), (String)"linkage");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        this.id = id;
        this.linkage = linkage;
        this.dependencies = dependencies2;
        this.issues = issues;
    }

    public /* synthetic */ PackageReference(Identifier identifier, PackageLinkage packageLinkage, Set set, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            packageLinkage = PackageLinkage.DYNAMIC;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(identifier, packageLinkage, set, list);
    }

    @Override
    @NotNull
    public Identifier getId() {
        return this.id;
    }

    @Override
    @NotNull
    public PackageLinkage getLinkage() {
        return this.linkage;
    }

    @NotNull
    public final Set<PackageReference> getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @NotNull
    public final Set<Identifier> collectDependencies(int maxDepth, @NotNull Function1<? super PackageReference, Boolean> filterPredicate) {
        Intrinsics.checkNotNullParameter(filterPredicate, (String)"filterPredicate");
        Set result = new LinkedHashSet();
        Deque queue = new LinkedList();
        PackageReference.collectDependencies$enqueue(maxDepth, queue, (Collection<PackageReference>)this.dependencies, 1);
        while (!((Collection)queue).isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            PackageReference pkg = (PackageReference)pair.component1();
            int level = ((Number)pair.component2()).intValue();
            if (((Boolean)filterPredicate.invoke((Object)pkg)).booleanValue()) {
                ((Collection)result).add(pkg.getId());
            }
            PackageReference.collectDependencies$enqueue(maxDepth, queue, (Collection<PackageReference>)pkg.dependencies, level + 1);
        }
        return result;
    }

    public static /* synthetic */ Set collectDependencies$default(PackageReference packageReference, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        if ((n2 & 2) != 0) {
            function1 = collectDependencies.1.INSTANCE;
        }
        return packageReference.collectDependencies(n, (Function1<? super PackageReference, Boolean>)function1);
    }

    @Override
    public int compareTo(@NotNull PackageReference other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getId().compareTo(other.getId());
    }

    public final boolean dependsOn(@NotNull Identifier id) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$any$iv = this.dependencies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PackageReference it = (PackageReference)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getId(), (Object)id) || it.dependsOn(id))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageReference> findReferences(@NotNull Identifier id) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PackageReference it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Iterable $this$filter$iv = this.dependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PackageReference)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = this.dependencies;
        Collection collection = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PackageReference)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findReferences(id);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PackageReference traverse(@NotNull Function1<? super PackageReference, PackageReference> transform) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable iterable = this.dependencies;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageReference packageReference = (PackageReference)item$iv;
            void var10_9 = destination$iv;
            boolean bl = false;
            var10_9.add(it.traverse(transform));
        }
        Set transformedDependencies = (Set)destination$iv;
        return (PackageReference)transform.invoke((Object)PackageReference.copy$default(this, null, null, transformedDependencies, null, 11, null));
    }

    @Override
    public <T> T visitDependencies(@NotNull Function1<? super Sequence<? extends DependencyNode>, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)block.invoke((Object)CollectionsKt.asSequence((Iterable)this.dependencies));
    }

    @Override
    @JsonIgnore
    @NotNull
    public DependencyNode getStableReference() {
        return DependencyNode.DefaultImpls.getStableReference(this);
    }

    @Override
    @JsonIgnore
    @NotNull
    public Object getInternalId() {
        return DependencyNode.DefaultImpls.getInternalId(this);
    }

    @NotNull
    public final Identifier component1() {
        return this.id;
    }

    @NotNull
    public final PackageLinkage component2() {
        return this.linkage;
    }

    @NotNull
    public final Set<PackageReference> component3() {
        return this.dependencies;
    }

    @NotNull
    public final List<Issue> component4() {
        return this.issues;
    }

    @NotNull
    public final PackageReference copy(@NotNull Identifier id, @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=PackageLinkageValueFilter.class) @NotNull PackageLinkage linkage, @JsonSerialize(converter=PackageReferenceSortedSetConverter.class) @NotNull Set<PackageReference> dependencies2, @NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)linkage), (String)"linkage");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        return new PackageReference(id, linkage, dependencies2, issues);
    }

    public static /* synthetic */ PackageReference copy$default(PackageReference packageReference, Identifier identifier, PackageLinkage packageLinkage, Set set, List list, int n, Object object) {
        if ((n & 1) != 0) {
            identifier = packageReference.id;
        }
        if ((n & 2) != 0) {
            packageLinkage = packageReference.linkage;
        }
        if ((n & 4) != 0) {
            set = packageReference.dependencies;
        }
        if ((n & 8) != 0) {
            list = packageReference.issues;
        }
        return packageReference.copy(identifier, packageLinkage, set, list);
    }

    @NotNull
    public String toString() {
        return "PackageReference(id=" + this.id + ", linkage=" + this.linkage + ", dependencies=" + this.dependencies + ", issues=" + this.issues + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.linkage.hashCode();
        result = result * 31 + ((Object)this.dependencies).hashCode();
        result = result * 31 + ((Object)this.issues).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackageReference)) {
            return false;
        }
        PackageReference packageReference = (PackageReference)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)packageReference.id)) {
            return false;
        }
        if (this.linkage != packageReference.linkage) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dependencies, packageReference.dependencies)) {
            return false;
        }
        return Intrinsics.areEqual(this.issues, packageReference.issues);
    }

    private static final void collectDependencies$enqueue(int $maxDepth, Deque<Pair<PackageReference, Integer>> queue, Collection<PackageReference> packages2, int level) {
        if ($maxDepth < 0 || level <= $maxDepth) {
            Iterable $this$forEach$iv = packages2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PackageReference it = (PackageReference)element$iv;
                boolean bl = false;
                ((Collection)queue).add(new Pair((Object)it, (Object)level));
            }
        }
    }
}

