/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.utils.PackageSortedSetConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "", "project", "Lorg/ossreviewtoolkit/model/Project;", "packages", "", "Lorg/ossreviewtoolkit/model/Package;", "issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "(Lorg/ossreviewtoolkit/model/Project;Ljava/util/Set;Ljava/util/List;)V", "getIssues", "()Ljava/util/List;", "getPackages", "()Ljava/util/Set;", "getProject", "()Lorg/ossreviewtoolkit/model/Project;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "model"})
public final class ProjectAnalyzerResult {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<Package> packages;
    @NotNull
    private final List<Issue> issues;

    public ProjectAnalyzerResult(@NotNull Project project, @JsonSerialize(converter=PackageSortedSetConverter.class) @NotNull Set<Package> packages2, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        this.project = project;
        this.packages = packages2;
        this.issues = issues;
    }

    public /* synthetic */ ProjectAnalyzerResult(Project project, Set set, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(project, set, list);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Set<Package> getPackages() {
        return this.packages;
    }

    @NotNull
    public final List<Issue> getIssues() {
        return this.issues;
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Set<Package> component2() {
        return this.packages;
    }

    @NotNull
    public final List<Issue> component3() {
        return this.issues;
    }

    @NotNull
    public final ProjectAnalyzerResult copy(@NotNull Project project, @JsonSerialize(converter=PackageSortedSetConverter.class) @NotNull Set<Package> packages2, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        return new ProjectAnalyzerResult(project, packages2, issues);
    }

    public static /* synthetic */ ProjectAnalyzerResult copy$default(ProjectAnalyzerResult projectAnalyzerResult, Project project, Set set, List list, int n, Object object) {
        if ((n & 1) != 0) {
            project = projectAnalyzerResult.project;
        }
        if ((n & 2) != 0) {
            set = projectAnalyzerResult.packages;
        }
        if ((n & 4) != 0) {
            list = projectAnalyzerResult.issues;
        }
        return projectAnalyzerResult.copy(project, set, list);
    }

    @NotNull
    public String toString() {
        return "ProjectAnalyzerResult(project=" + this.project + ", packages=" + this.packages + ", issues=" + this.issues + ")";
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = result * 31 + ((Object)this.packages).hashCode();
        result = result * 31 + ((Object)this.issues).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectAnalyzerResult)) {
            return false;
        }
        ProjectAnalyzerResult projectAnalyzerResult = (ProjectAnalyzerResult)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)projectAnalyzerResult.project)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.packages, projectAnalyzerResult.packages)) {
            return false;
        }
        return Intrinsics.areEqual(this.issues, projectAnalyzerResult.issues);
    }
}

