/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.ArtifactProvenance;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.UnknownProvenance;
import org.ossreviewtoolkit.model.VcsInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/ossreviewtoolkit/model/ProvenanceDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lorg/ossreviewtoolkit/model/Provenance;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "model"})
@SourceDebugExtension(value={"SMAP\nProvenance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Provenance.kt\norg/ossreviewtoolkit/model/ProvenanceDeserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,105:1\n61#2:106\n49#2:107\n61#2:108\n49#2:109\n*S KotlinDebug\n*F\n+ 1 Provenance.kt\norg/ossreviewtoolkit/model/ProvenanceDeserializer\n*L\n92#1:106\n92#1:107\n96#1:108\n96#1:109\n*E\n"})
final class ProvenanceDeserializer
extends StdDeserializer<Provenance> {
    public ProvenanceDeserializer() {
        super(Provenance.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Provenance deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Provenance provenance;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.has("source_artifact")) {
            void $this$treeToValue$iv;
            ObjectMapper objectMapper = (ObjectMapper)MappersKt.getJsonMapper();
            JsonNode jsonNode = node.get("source_artifact");
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"get(...)");
            TreeNode n$iv = (TreeNode)jsonNode;
            boolean $i$f$treeToValue = false;
            boolean $i$f$jacksonTypeRef = false;
            RemoteArtifact sourceArtifact = (RemoteArtifact)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens(n$iv), (TypeReference)new TypeReference<RemoteArtifact>(){});
            provenance = new ArtifactProvenance(sourceArtifact);
        } else if (node.has("vcs_info")) {
            ObjectMapper $this$treeToValue$iv = (ObjectMapper)MappersKt.getJsonMapper();
            JsonNode jsonNode = node.get("vcs_info");
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"get(...)");
            TreeNode n$iv = (TreeNode)jsonNode;
            boolean $i$f$treeToValue = false;
            boolean $i$f$jacksonTypeRef = false;
            VcsInfo vcsInfo = (VcsInfo)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens(n$iv), (TypeReference)new TypeReference<VcsInfo>(){});
            JsonNode jsonNode2 = node.get("resolved_revision");
            String string = jsonNode2 != null ? jsonNode2.textValue() : null;
            if (string == null) {
                string = vcsInfo.getRevision();
            }
            String resolvedRevision = string;
            provenance = new RepositoryProvenance(vcsInfo, resolvedRevision);
        } else {
            provenance = UnknownProvenance.INSTANCE;
        }
        return provenance;
    }
}

