/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.VcsInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0003\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JM\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0014\b\u0003\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/ossreviewtoolkit/model/ProvenanceResolutionResult;", "", "id", "Lorg/ossreviewtoolkit/model/Identifier;", "packageProvenance", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "subRepositories", "", "", "Lorg/ossreviewtoolkit/model/VcsInfo;", "packageProvenanceResolutionIssue", "Lorg/ossreviewtoolkit/model/Issue;", "nestedProvenanceResolutionIssue", "(Lorg/ossreviewtoolkit/model/Identifier;Lorg/ossreviewtoolkit/model/KnownProvenance;Ljava/util/Map;Lorg/ossreviewtoolkit/model/Issue;Lorg/ossreviewtoolkit/model/Issue;)V", "getId", "()Lorg/ossreviewtoolkit/model/Identifier;", "getNestedProvenanceResolutionIssue", "()Lorg/ossreviewtoolkit/model/Issue;", "getPackageProvenance", "()Lorg/ossreviewtoolkit/model/KnownProvenance;", "getPackageProvenanceResolutionIssue", "getSubRepositories", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "model"})
@SourceDebugExtension(value={"SMAP\nProvenanceResolutionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceResolutionResult.kt\norg/ossreviewtoolkit/model/ProvenanceResolutionResult\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,82:1\n215#2,2:83\n*S KotlinDebug\n*F\n+ 1 ProvenanceResolutionResult.kt\norg/ossreviewtoolkit/model/ProvenanceResolutionResult\n*L\n66#1:83,2\n*E\n"})
public final class ProvenanceResolutionResult {
    @NotNull
    private final Identifier id;
    @Nullable
    private final KnownProvenance packageProvenance;
    @NotNull
    private final Map<String, VcsInfo> subRepositories;
    @Nullable
    private final Issue packageProvenanceResolutionIssue;
    @Nullable
    private final Issue nestedProvenanceResolutionIssue;

    public ProvenanceResolutionResult(@NotNull Identifier id, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable KnownProvenance packageProvenance, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, VcsInfo> subRepositories, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable Issue packageProvenanceResolutionIssue, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable Issue nestedProvenanceResolutionIssue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(subRepositories, (String)"subRepositories");
        this.id = id;
        this.packageProvenance = packageProvenance;
        this.subRepositories = subRepositories;
        this.packageProvenanceResolutionIssue = packageProvenanceResolutionIssue;
        this.nestedProvenanceResolutionIssue = nestedProvenanceResolutionIssue;
        if (!(this.packageProvenance != null ^ this.packageProvenanceResolutionIssue != null)) {
            boolean $i$a$-require-ProvenanceResolutionResult$22 = false;
            String $i$a$-require-ProvenanceResolutionResult$22 = "Either the package provenance must be known, or a resolution issue must have occurred.";
            throw new IllegalArgumentException($i$a$-require-ProvenanceResolutionResult$22.toString());
        }
        Map<String, VcsInfo> $this$forEach$iv = this.subRepositories;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, VcsInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VcsInfo> element$iv;
            Map.Entry<String, VcsInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            String path = entry.getKey();
            VcsInfo vcsInfo = entry.getValue();
            if (((CharSequence)vcsInfo.getPath()).length() == 0) continue;
            boolean bl2 = false;
            String string = "The resolved sub-repository for package '" + this.id.toCoordinates() + "' at '" + path + "' has a non-empty VCS path which is not allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.packageProvenanceResolutionIssue != null && !(this.nestedProvenanceResolutionIssue == null)) {
            boolean bl = false;
            String string = "Nested provenance resolution was not executed as already the (root) provenance resolution had an issue, but still the nested provenance resolution also has an issue.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ProvenanceResolutionResult(Identifier identifier, KnownProvenance knownProvenance, Map map, Issue issue, Issue issue2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            knownProvenance = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            issue = null;
        }
        if ((n & 0x10) != 0) {
            issue2 = null;
        }
        this(identifier, knownProvenance, map, issue, issue2);
    }

    @NotNull
    public final Identifier getId() {
        return this.id;
    }

    @Nullable
    public final KnownProvenance getPackageProvenance() {
        return this.packageProvenance;
    }

    @NotNull
    public final Map<String, VcsInfo> getSubRepositories() {
        return this.subRepositories;
    }

    @Nullable
    public final Issue getPackageProvenanceResolutionIssue() {
        return this.packageProvenanceResolutionIssue;
    }

    @Nullable
    public final Issue getNestedProvenanceResolutionIssue() {
        return this.nestedProvenanceResolutionIssue;
    }

    @NotNull
    public final Identifier component1() {
        return this.id;
    }

    @Nullable
    public final KnownProvenance component2() {
        return this.packageProvenance;
    }

    @NotNull
    public final Map<String, VcsInfo> component3() {
        return this.subRepositories;
    }

    @Nullable
    public final Issue component4() {
        return this.packageProvenanceResolutionIssue;
    }

    @Nullable
    public final Issue component5() {
        return this.nestedProvenanceResolutionIssue;
    }

    @NotNull
    public final ProvenanceResolutionResult copy(@NotNull Identifier id, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable KnownProvenance packageProvenance, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, VcsInfo> subRepositories, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable Issue packageProvenanceResolutionIssue, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable Issue nestedProvenanceResolutionIssue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(subRepositories, (String)"subRepositories");
        return new ProvenanceResolutionResult(id, packageProvenance, subRepositories, packageProvenanceResolutionIssue, nestedProvenanceResolutionIssue);
    }

    public static /* synthetic */ ProvenanceResolutionResult copy$default(ProvenanceResolutionResult provenanceResolutionResult, Identifier identifier, KnownProvenance knownProvenance, Map map, Issue issue, Issue issue2, int n, Object object) {
        if ((n & 1) != 0) {
            identifier = provenanceResolutionResult.id;
        }
        if ((n & 2) != 0) {
            knownProvenance = provenanceResolutionResult.packageProvenance;
        }
        if ((n & 4) != 0) {
            map = provenanceResolutionResult.subRepositories;
        }
        if ((n & 8) != 0) {
            issue = provenanceResolutionResult.packageProvenanceResolutionIssue;
        }
        if ((n & 0x10) != 0) {
            issue2 = provenanceResolutionResult.nestedProvenanceResolutionIssue;
        }
        return provenanceResolutionResult.copy(identifier, knownProvenance, map, issue, issue2);
    }

    @NotNull
    public String toString() {
        return "ProvenanceResolutionResult(id=" + this.id + ", packageProvenance=" + this.packageProvenance + ", subRepositories=" + this.subRepositories + ", packageProvenanceResolutionIssue=" + this.packageProvenanceResolutionIssue + ", nestedProvenanceResolutionIssue=" + this.nestedProvenanceResolutionIssue + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + (this.packageProvenance == null ? 0 : this.packageProvenance.hashCode());
        result = result * 31 + ((Object)this.subRepositories).hashCode();
        result = result * 31 + (this.packageProvenanceResolutionIssue == null ? 0 : this.packageProvenanceResolutionIssue.hashCode());
        result = result * 31 + (this.nestedProvenanceResolutionIssue == null ? 0 : this.nestedProvenanceResolutionIssue.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProvenanceResolutionResult)) {
            return false;
        }
        ProvenanceResolutionResult provenanceResolutionResult = (ProvenanceResolutionResult)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)provenanceResolutionResult.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packageProvenance, (Object)provenanceResolutionResult.packageProvenance)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subRepositories, provenanceResolutionResult.subRepositories)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packageProvenanceResolutionIssue, (Object)provenanceResolutionResult.packageProvenanceResolutionIssue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.nestedProvenanceResolutionIssue, (Object)provenanceResolutionResult.nestedProvenanceResolutionIssue);
    }
}

