/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0003\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0003\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/ossreviewtoolkit/model/Repository;", "", "vcs", "Lorg/ossreviewtoolkit/model/VcsInfo;", "vcsProcessed", "nestedRepositories", "", "", "config", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Lorg/ossreviewtoolkit/model/VcsInfo;Lorg/ossreviewtoolkit/model/VcsInfo;Ljava/util/Map;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "getConfig", "()Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "getNestedRepositories", "()Ljava/util/Map;", "getVcs", "()Lorg/ossreviewtoolkit/model/VcsInfo;", "getVcsProcessed", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getRelativePath", "hashCode", "", "toString", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Repository.kt\norg/ossreviewtoolkit/model/Repository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class Repository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsInfo vcs;
    @NotNull
    private final VcsInfo vcsProcessed;
    @NotNull
    private final Map<String, VcsInfo> nestedRepositories;
    @NotNull
    private final RepositoryConfiguration config;
    @JvmField
    @NotNull
    public static final Repository EMPTY = new Repository(VcsInfo.EMPTY, VcsInfo.EMPTY, MapsKt.emptyMap(), new RepositoryConfiguration(null, null, null, null, null, null, null, 127, null));

    public Repository(@NotNull VcsInfo vcs, @NotNull VcsInfo vcsProcessed, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, VcsInfo> nestedRepositories, @NotNull RepositoryConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)vcsProcessed, (String)"vcsProcessed");
        Intrinsics.checkNotNullParameter(nestedRepositories, (String)"nestedRepositories");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.vcs = vcs;
        this.vcsProcessed = vcsProcessed;
        this.nestedRepositories = nestedRepositories;
        this.config = config;
    }

    public /* synthetic */ Repository(VcsInfo vcsInfo, VcsInfo vcsInfo2, Map map, RepositoryConfiguration repositoryConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vcsInfo2 = vcsInfo.normalize();
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            repositoryConfiguration = new RepositoryConfiguration(null, null, null, null, null, null, null, 127, null);
        }
        this(vcsInfo, vcsInfo2, map, repositoryConfiguration);
    }

    @NotNull
    public final VcsInfo getVcs() {
        return this.vcs;
    }

    @NotNull
    public final VcsInfo getVcsProcessed() {
        return this.vcsProcessed;
    }

    @NotNull
    public final Map<String, VcsInfo> getNestedRepositories() {
        return this.nestedRepositories;
    }

    @NotNull
    public final RepositoryConfiguration getConfig() {
        return this.config;
    }

    @Nullable
    public final String getRelativePath(@NotNull VcsInfo vcs) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
            VcsInfo normalizedVcs = vcs.normalize();
            if (Repository.getRelativePath$matches(this.vcsProcessed, normalizedVcs)) {
                return "";
            }
            Iterable iterable = this.nestedRepositories.entrySet();
            for (Object t : iterable) {
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                VcsInfo nestedVcs = (VcsInfo)entry.getValue();
                if (!Repository.getRelativePath$matches(nestedVcs.normalize(), normalizedVcs)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (String)entry.getKey() : null;
    }

    @NotNull
    public final VcsInfo component1() {
        return this.vcs;
    }

    @NotNull
    public final VcsInfo component2() {
        return this.vcsProcessed;
    }

    @NotNull
    public final Map<String, VcsInfo> component3() {
        return this.nestedRepositories;
    }

    @NotNull
    public final RepositoryConfiguration component4() {
        return this.config;
    }

    @NotNull
    public final Repository copy(@NotNull VcsInfo vcs, @NotNull VcsInfo vcsProcessed, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, VcsInfo> nestedRepositories, @NotNull RepositoryConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)vcsProcessed, (String)"vcsProcessed");
        Intrinsics.checkNotNullParameter(nestedRepositories, (String)"nestedRepositories");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new Repository(vcs, vcsProcessed, nestedRepositories, config);
    }

    public static /* synthetic */ Repository copy$default(Repository repository, VcsInfo vcsInfo, VcsInfo vcsInfo2, Map map, RepositoryConfiguration repositoryConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            vcsInfo = repository.vcs;
        }
        if ((n & 2) != 0) {
            vcsInfo2 = repository.vcsProcessed;
        }
        if ((n & 4) != 0) {
            map = repository.nestedRepositories;
        }
        if ((n & 8) != 0) {
            repositoryConfiguration = repository.config;
        }
        return repository.copy(vcsInfo, vcsInfo2, map, repositoryConfiguration);
    }

    @NotNull
    public String toString() {
        return "Repository(vcs=" + this.vcs + ", vcsProcessed=" + this.vcsProcessed + ", nestedRepositories=" + this.nestedRepositories + ", config=" + this.config + ")";
    }

    public int hashCode() {
        int result = this.vcs.hashCode();
        result = result * 31 + this.vcsProcessed.hashCode();
        result = result * 31 + ((Object)this.nestedRepositories).hashCode();
        result = result * 31 + this.config.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Repository)) {
            return false;
        }
        Repository repository = (Repository)other;
        if (!Intrinsics.areEqual((Object)this.vcs, (Object)repository.vcs)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vcsProcessed, (Object)repository.vcsProcessed)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.nestedRepositories, repository.nestedRepositories)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.config, (Object)repository.config);
    }

    private static final boolean getRelativePath$matches(VcsInfo $this$getRelativePath_u24matches, VcsInfo other) {
        return Intrinsics.areEqual((Object)$this$getRelativePath_u24matches.getType(), (Object)other.getType()) && Intrinsics.areEqual((Object)$this$getRelativePath_u24matches.getUrl(), (Object)other.getUrl()) && Intrinsics.areEqual((Object)$this$getRelativePath_u24matches.getRevision(), (Object)other.getRevision());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ossreviewtoolkit/model/Repository$Companion;", "", "()V", "EMPTY", "Lorg/ossreviewtoolkit/model/Repository;", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

