/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.VcsInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/ossreviewtoolkit/model/RepositoryProvenance;", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "vcsInfo", "Lorg/ossreviewtoolkit/model/VcsInfo;", "resolvedRevision", "", "(Lorg/ossreviewtoolkit/model/VcsInfo;Ljava/lang/String;)V", "getResolvedRevision", "()Ljava/lang/String;", "getVcsInfo", "()Lorg/ossreviewtoolkit/model/VcsInfo;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "matches", "pkg", "Lorg/ossreviewtoolkit/model/Package;", "toString", "model"})
@SourceDebugExtension(value={"SMAP\nProvenance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Provenance.kt\norg/ossreviewtoolkit/model/RepositoryProvenance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class RepositoryProvenance
implements KnownProvenance {
    @NotNull
    private final VcsInfo vcsInfo;
    @NotNull
    private final String resolvedRevision;

    public RepositoryProvenance(@NotNull VcsInfo vcsInfo, @NotNull String resolvedRevision) {
        Intrinsics.checkNotNullParameter((Object)vcsInfo, (String)"vcsInfo");
        Intrinsics.checkNotNullParameter((Object)resolvedRevision, (String)"resolvedRevision");
        this.vcsInfo = vcsInfo;
        this.resolvedRevision = resolvedRevision;
        if (!(!StringsKt.isBlank((CharSequence)this.resolvedRevision))) {
            boolean bl = false;
            String string = "The resolved revision must not be blank.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final VcsInfo getVcsInfo() {
        return this.vcsInfo;
    }

    @NotNull
    public final String getResolvedRevision() {
        return this.resolvedRevision;
    }

    @Override
    public boolean matches(@NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        return Intrinsics.areEqual((Object)this.vcsInfo, (Object)pkg.getVcsProcessed());
    }

    @NotNull
    public final VcsInfo component1() {
        return this.vcsInfo;
    }

    @NotNull
    public final String component2() {
        return this.resolvedRevision;
    }

    @NotNull
    public final RepositoryProvenance copy(@NotNull VcsInfo vcsInfo, @NotNull String resolvedRevision) {
        Intrinsics.checkNotNullParameter((Object)vcsInfo, (String)"vcsInfo");
        Intrinsics.checkNotNullParameter((Object)resolvedRevision, (String)"resolvedRevision");
        return new RepositoryProvenance(vcsInfo, resolvedRevision);
    }

    public static /* synthetic */ RepositoryProvenance copy$default(RepositoryProvenance repositoryProvenance, VcsInfo vcsInfo, String string, int n, Object object) {
        if ((n & 1) != 0) {
            vcsInfo = repositoryProvenance.vcsInfo;
        }
        if ((n & 2) != 0) {
            string = repositoryProvenance.resolvedRevision;
        }
        return repositoryProvenance.copy(vcsInfo, string);
    }

    @NotNull
    public String toString() {
        return "RepositoryProvenance(vcsInfo=" + this.vcsInfo + ", resolvedRevision=" + this.resolvedRevision + ")";
    }

    public int hashCode() {
        int result = this.vcsInfo.hashCode();
        result = result * 31 + this.resolvedRevision.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryProvenance)) {
            return false;
        }
        RepositoryProvenance repositoryProvenance = (RepositoryProvenance)other;
        if (!Intrinsics.areEqual((Object)this.vcsInfo, (Object)repositoryProvenance.vcsInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resolvedRevision, (Object)repositoryProvenance.resolvedRevision);
    }
}

