/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.ScanSummary;
import org.ossreviewtoolkit.model.ScannerDetails;
import org.ossreviewtoolkit.model.VcsInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0003\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0003\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nJ\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\nH\u00d6\u0001R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/ossreviewtoolkit/model/ScanResult;", "", "provenance", "Lorg/ossreviewtoolkit/model/Provenance;", "scanner", "Lorg/ossreviewtoolkit/model/ScannerDetails;", "summary", "Lorg/ossreviewtoolkit/model/ScanSummary;", "additionalData", "", "", "(Lorg/ossreviewtoolkit/model/Provenance;Lorg/ossreviewtoolkit/model/ScannerDetails;Lorg/ossreviewtoolkit/model/ScanSummary;Ljava/util/Map;)V", "getAdditionalData", "()Ljava/util/Map;", "getProvenance", "()Lorg/ossreviewtoolkit/model/Provenance;", "getScanner", "()Lorg/ossreviewtoolkit/model/ScannerDetails;", "getSummary", "()Lorg/ossreviewtoolkit/model/ScanSummary;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "filterByIgnorePatterns", "ignorePatterns", "", "filterByPath", "path", "hashCode", "", "toString", "model"})
public final class ScanResult {
    @NotNull
    private final Provenance provenance;
    @NotNull
    private final ScannerDetails scanner;
    @NotNull
    private final ScanSummary summary;
    @NotNull
    private final Map<String, String> additionalData;

    public ScanResult(@NotNull Provenance provenance, @NotNull ScannerDetails scanner, @NotNull ScanSummary summary, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, String> additionalData) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
        this.provenance = provenance;
        this.scanner = scanner;
        this.summary = summary;
        this.additionalData = additionalData;
    }

    public /* synthetic */ ScanResult(Provenance provenance, ScannerDetails scannerDetails, ScanSummary scanSummary, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        this(provenance, scannerDetails, scanSummary, map);
    }

    @NotNull
    public final Provenance getProvenance() {
        return this.provenance;
    }

    @NotNull
    public final ScannerDetails getScanner() {
        return this.scanner;
    }

    @NotNull
    public final ScanSummary getSummary() {
        return this.summary;
    }

    @NotNull
    public final Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @NotNull
    public final ScanResult filterByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.isBlank((CharSequence)path) ? this : (this.provenance instanceof RepositoryProvenance ? ScanResult.copy$default(this, RepositoryProvenance.copy$default((RepositoryProvenance)this.provenance, VcsInfo.copy$default(((RepositoryProvenance)this.provenance).getVcsInfo(), null, null, null, path, 7, null), null, 2, null), null, this.summary.filterByPath(path), null, 10, null) : ScanResult.copy$default(this, null, null, this.summary.filterByPath(path), null, 11, null));
    }

    @NotNull
    public final ScanResult filterByIgnorePatterns(@NotNull Collection<String> ignorePatterns) {
        Intrinsics.checkNotNullParameter(ignorePatterns, (String)"ignorePatterns");
        return ScanResult.copy$default(this, null, null, this.summary.filterByIgnorePatterns(ignorePatterns), null, 11, null);
    }

    @NotNull
    public final Provenance component1() {
        return this.provenance;
    }

    @NotNull
    public final ScannerDetails component2() {
        return this.scanner;
    }

    @NotNull
    public final ScanSummary component3() {
        return this.summary;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.additionalData;
    }

    @NotNull
    public final ScanResult copy(@NotNull Provenance provenance, @NotNull ScannerDetails scanner, @NotNull ScanSummary summary, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, String> additionalData) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
        return new ScanResult(provenance, scanner, summary, additionalData);
    }

    public static /* synthetic */ ScanResult copy$default(ScanResult scanResult, Provenance provenance, ScannerDetails scannerDetails, ScanSummary scanSummary, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            provenance = scanResult.provenance;
        }
        if ((n & 2) != 0) {
            scannerDetails = scanResult.scanner;
        }
        if ((n & 4) != 0) {
            scanSummary = scanResult.summary;
        }
        if ((n & 8) != 0) {
            map = scanResult.additionalData;
        }
        return scanResult.copy(provenance, scannerDetails, scanSummary, map);
    }

    @NotNull
    public String toString() {
        return "ScanResult(provenance=" + this.provenance + ", scanner=" + this.scanner + ", summary=" + this.summary + ", additionalData=" + this.additionalData + ")";
    }

    public int hashCode() {
        int result = this.provenance.hashCode();
        result = result * 31 + this.scanner.hashCode();
        result = result * 31 + this.summary.hashCode();
        result = result * 31 + ((Object)this.additionalData).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScanResult)) {
            return false;
        }
        ScanResult scanResult = (ScanResult)other;
        if (!Intrinsics.areEqual((Object)this.provenance, (Object)scanResult.provenance)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scanner, (Object)scanResult.scanner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.summary, (Object)scanResult.summary)) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalData, scanResult.additionalData);
    }
}

