/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.CopyrightFinding;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.IssueListConverter;
import org.ossreviewtoolkit.model.LicenseFinding;
import org.ossreviewtoolkit.model.SnippetFinding;
import org.ossreviewtoolkit.model.TextLocation;
import org.ossreviewtoolkit.model.config.LicenseFilePatterns;
import org.ossreviewtoolkit.model.utils.CopyrightFindingSortedSetConverter;
import org.ossreviewtoolkit.model.utils.LicenseFindingSortedSetConverter;
import org.ossreviewtoolkit.model.utils.RootLicenseMatcher;
import org.ossreviewtoolkit.model.utils.SnippetFindingSortedSetConverter;
import org.ossreviewtoolkit.utils.common.FileMatcher;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;

@JsonIgnoreProperties(value={"file_count", "package_verification_code"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 32\u00020\u0001:\u00013BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0003\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u000e\b\u0003\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u000e\b\u0003\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J]\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0003\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u000e\b\u0003\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u000e\b\u0003\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010(\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020+J\u0014\u0010.\u001a\u00020\u00002\f\u0010/\u001a\b\u0012\u0004\u0012\u00020+0*J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020+H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00068GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013\u00a8\u00064"}, d2={"Lorg/ossreviewtoolkit/model/ScanSummary;", "", "startTime", "Ljava/time/Instant;", "endTime", "licenseFindings", "", "Lorg/ossreviewtoolkit/model/LicenseFinding;", "copyrightFindings", "Lorg/ossreviewtoolkit/model/CopyrightFinding;", "snippetFindings", "Lorg/ossreviewtoolkit/model/SnippetFinding;", "issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/List;)V", "getCopyrightFindings", "()Ljava/util/Set;", "getEndTime", "()Ljava/time/Instant;", "getIssues", "()Ljava/util/List;", "getLicenseFindings", "licenses", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;", "getLicenses", "licenses$delegate", "Lkotlin/Lazy;", "getSnippetFindings", "getStartTime", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "filterByIgnorePatterns", "ignorePatterns", "", "", "filterByPath", "path", "filterByPaths", "paths", "hashCode", "", "toString", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nScanSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanSummary.kt\norg/ossreviewtoolkit/model/ScanSummary\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1747#2,3:168\n1620#2,3:171\n857#2,2:174\n857#2,2:176\n857#2,2:178\n766#2:180\n857#2,2:181\n857#2,2:183\n857#2,2:185\n857#2,2:187\n766#2:189\n857#2,2:190\n1747#2,3:192\n*S KotlinDebug\n*F\n+ 1 ScanSummary.kt\norg/ossreviewtoolkit/model/ScanSummary\n*L\n112#1:168,3\n118#1:171,3\n128#1:174,2\n129#1:176,2\n130#1:178,2\n131#1:180\n131#1:181,2\n143#1:183,2\n144#1:185,2\n145#1:187,2\n146#1:189\n146#1:190,2\n121#1:192,3\n*E\n"})
public final class ScanSummary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant startTime;
    @NotNull
    private final Instant endTime;
    @NotNull
    private final Set<LicenseFinding> licenseFindings;
    @NotNull
    private final Set<CopyrightFinding> copyrightFindings;
    @NotNull
    private final Set<SnippetFinding> snippetFindings;
    @NotNull
    private final List<Issue> issues;
    @NotNull
    private final Lazy licenses$delegate;
    @JvmField
    @NotNull
    public static final ScanSummary EMPTY;

    public ScanSummary(@NotNull Instant startTime, @NotNull Instant endTime, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="licenses") @JsonSerialize(converter=LicenseFindingSortedSetConverter.class) @NotNull Set<LicenseFinding> licenseFindings, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="copyrights") @JsonSerialize(converter=CopyrightFindingSortedSetConverter.class) @NotNull Set<CopyrightFinding> copyrightFindings, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="snippets") @JsonSerialize(converter=SnippetFindingSortedSetConverter.class) @NotNull Set<SnippetFinding> snippetFindings, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonDeserialize(converter=IssueListConverter.class) @NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter(licenseFindings, (String)"licenseFindings");
        Intrinsics.checkNotNullParameter(copyrightFindings, (String)"copyrightFindings");
        Intrinsics.checkNotNullParameter(snippetFindings, (String)"snippetFindings");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        this.startTime = startTime;
        this.endTime = endTime;
        this.licenseFindings = licenseFindings;
        this.copyrightFindings = copyrightFindings;
        this.snippetFindings = snippetFindings;
        this.issues = issues;
        this.licenses$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<SpdxExpression>>(this){
            final /* synthetic */ ScanSummary this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<SpdxExpression> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getLicenseFindings();
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    LicenseFinding licenseFinding = (LicenseFinding)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getLicense());
                }
                return (Set)var2_2;
            }
        }));
    }

    public /* synthetic */ ScanSummary(Instant instant, Instant instant2, Set set, Set set2, Set set3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(instant, instant2, set, set2, set3, list);
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final Set<LicenseFinding> getLicenseFindings() {
        return this.licenseFindings;
    }

    @NotNull
    public final Set<CopyrightFinding> getCopyrightFindings() {
        return this.copyrightFindings;
    }

    @NotNull
    public final Set<SnippetFinding> getSnippetFindings() {
        return this.snippetFindings;
    }

    @NotNull
    public final List<Issue> getIssues() {
        return this.issues;
    }

    @JsonIgnore
    @NotNull
    public final Set<SpdxExpression> getLicenses() {
        Lazy lazy = this.licenses$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ScanSummary filterByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.filterByPaths(CollectionsKt.listOf((Object)path));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanSummary filterByPaths(@NotNull Collection<String> paths) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$filterTo$iv;
        Object it;
        ScanSummary scanSummary;
        Collection destination$iv;
        Iterable $this$mapTo$iv;
        Object element$iv2;
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable $this$any$iv = paths;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    String it2 = (String)element$iv2;
                    boolean bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)it2)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return this;
        }
        RootLicenseMatcher rootLicenseMatcher = new RootLicenseMatcher(LicenseFilePatterns.Companion.getInstance());
        Iterable iterable = CollectionsKt.flatten((Iterable)rootLicenseMatcher.getApplicableRootLicenseFindingsForDirectories((Collection<LicenseFinding>)this.licenseFindings, paths).values());
        element$iv2 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            LicenseFinding licenseFinding = (LicenseFinding)item$iv;
            scanSummary = destination$iv;
            boolean bl3 = false;
            scanSummary.add(((LicenseFinding)it).getLocation().getPath());
        }
        Set applicableLicenseFiles = (Set)destination$iv;
        $this$mapTo$iv = this.licenseFindings;
        destination$iv = new LinkedHashSet();
        Instant instant = null;
        Instant instant2 = null;
        scanSummary = this;
        boolean $i$f$filterTo = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            it = (LicenseFinding)element$iv3;
            boolean bl4 = false;
            if (!ScanSummary.filterByPaths$matchesPaths$3(((LicenseFinding)it).getLocation(), paths, applicableLicenseFiles)) continue;
            destination$iv.add(element$iv3);
        }
        Collection collection = destination$iv;
        $this$filterTo$iv = this.copyrightFindings;
        destination$iv = new LinkedHashSet();
        collection = (Set)collection;
        $i$f$filterTo = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            it = (CopyrightFinding)element$iv3;
            boolean bl5 = false;
            if (!ScanSummary.filterByPaths$matchesPaths$3(((CopyrightFinding)it).getLocation(), paths, applicableLicenseFiles)) continue;
            destination$iv.add(element$iv3);
        }
        Collection collection2 = destination$iv;
        $this$filterTo$iv = this.snippetFindings;
        destination$iv = new LinkedHashSet();
        collection2 = (Set)collection2;
        $i$f$filterTo = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            it = (SnippetFinding)element$iv3;
            boolean bl6 = false;
            if (!ScanSummary.filterByPaths$matchesPaths$3(((SnippetFinding)it).getSourceLocation(), paths, applicableLicenseFiles)) continue;
            destination$iv.add(element$iv3);
        }
        Collection collection3 = destination$iv;
        $this$filterTo$iv = this.issues;
        collection3 = (Set)collection3;
        boolean $i$f$filter = false;
        void $i$f$filterTo2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Issue it3 = (Issue)element$iv$iv;
            boolean bl7 = false;
            String string = it3.getAffectedPath();
            if (!(string != null ? ScanSummary.filterByPaths$matchesPaths(string, paths, applicableLicenseFiles) : true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return ScanSummary.copy$default(scanSummary, instant2, instant, (Set)collection, (Set)collection2, (Set)collection3, list, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanSummary filterByIgnorePatterns(@NotNull Collection<String> ignorePatterns) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection destination$iv;
        Object it;
        Iterable $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(ignorePatterns, (String)"ignorePatterns");
        FileMatcher matcher2 = new FileMatcher(ignorePatterns, false, 2, null);
        Iterable iterable = this.licenseFindings;
        Collection collection = new LinkedHashSet();
        Instant instant = null;
        Instant instant2 = null;
        ScanSummary scanSummary = this;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (LicenseFinding)element$iv;
            boolean bl = false;
            if (!(!matcher2.matches(((LicenseFinding)it).getLocation().getPath()))) continue;
            destination$iv.add(element$iv);
        }
        Set set = destination$iv;
        $this$filterTo$iv = this.copyrightFindings;
        destination$iv = new LinkedHashSet();
        set = set;
        $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (CopyrightFinding)element$iv;
            boolean bl = false;
            if (!(!matcher2.matches(((CopyrightFinding)it).getLocation().getPath()))) continue;
            destination$iv.add(element$iv);
        }
        Collection collection2 = destination$iv;
        $this$filterTo$iv = this.snippetFindings;
        destination$iv = new LinkedHashSet();
        collection2 = (Set)collection2;
        $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (SnippetFinding)element$iv;
            boolean bl = false;
            if (!(!matcher2.matches(((SnippetFinding)it).getSourceLocation().getPath()))) continue;
            destination$iv.add(element$iv);
        }
        Collection collection3 = destination$iv;
        $this$filterTo$iv = this.issues;
        collection3 = (Set)collection3;
        boolean $i$f$filter = false;
        void $i$f$filterTo2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Issue it2 = (Issue)element$iv$iv;
            boolean bl = false;
            if (!(it2.getAffectedPath() == null || !matcher2.matches(it2.getAffectedPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return ScanSummary.copy$default(scanSummary, instant2, instant, set, (Set)collection2, (Set)collection3, list, 3, null);
    }

    @NotNull
    public final Instant component1() {
        return this.startTime;
    }

    @NotNull
    public final Instant component2() {
        return this.endTime;
    }

    @NotNull
    public final Set<LicenseFinding> component3() {
        return this.licenseFindings;
    }

    @NotNull
    public final Set<CopyrightFinding> component4() {
        return this.copyrightFindings;
    }

    @NotNull
    public final Set<SnippetFinding> component5() {
        return this.snippetFindings;
    }

    @NotNull
    public final List<Issue> component6() {
        return this.issues;
    }

    @NotNull
    public final ScanSummary copy(@NotNull Instant startTime, @NotNull Instant endTime, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="licenses") @JsonSerialize(converter=LicenseFindingSortedSetConverter.class) @NotNull Set<LicenseFinding> licenseFindings, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="copyrights") @JsonSerialize(converter=CopyrightFindingSortedSetConverter.class) @NotNull Set<CopyrightFinding> copyrightFindings, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonProperty(value="snippets") @JsonSerialize(converter=SnippetFindingSortedSetConverter.class) @NotNull Set<SnippetFinding> snippetFindings, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @JsonDeserialize(converter=IssueListConverter.class) @NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter(licenseFindings, (String)"licenseFindings");
        Intrinsics.checkNotNullParameter(copyrightFindings, (String)"copyrightFindings");
        Intrinsics.checkNotNullParameter(snippetFindings, (String)"snippetFindings");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        return new ScanSummary(startTime, endTime, licenseFindings, copyrightFindings, snippetFindings, issues);
    }

    public static /* synthetic */ ScanSummary copy$default(ScanSummary scanSummary, Instant instant, Instant instant2, Set set, Set set2, Set set3, List list, int n, Object object) {
        if ((n & 1) != 0) {
            instant = scanSummary.startTime;
        }
        if ((n & 2) != 0) {
            instant2 = scanSummary.endTime;
        }
        if ((n & 4) != 0) {
            set = scanSummary.licenseFindings;
        }
        if ((n & 8) != 0) {
            set2 = scanSummary.copyrightFindings;
        }
        if ((n & 0x10) != 0) {
            set3 = scanSummary.snippetFindings;
        }
        if ((n & 0x20) != 0) {
            list = scanSummary.issues;
        }
        return scanSummary.copy(instant, instant2, set, set2, set3, list);
    }

    @NotNull
    public String toString() {
        return "ScanSummary(startTime=" + this.startTime + ", endTime=" + this.endTime + ", licenseFindings=" + this.licenseFindings + ", copyrightFindings=" + this.copyrightFindings + ", snippetFindings=" + this.snippetFindings + ", issues=" + this.issues + ")";
    }

    public int hashCode() {
        int result = this.startTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        result = result * 31 + ((Object)this.licenseFindings).hashCode();
        result = result * 31 + ((Object)this.copyrightFindings).hashCode();
        result = result * 31 + ((Object)this.snippetFindings).hashCode();
        result = result * 31 + ((Object)this.issues).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScanSummary)) {
            return false;
        }
        ScanSummary scanSummary = (ScanSummary)other;
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)scanSummary.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTime, (Object)scanSummary.endTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.licenseFindings, scanSummary.licenseFindings)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.copyrightFindings, scanSummary.copyrightFindings)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.snippetFindings, scanSummary.snippetFindings)) {
            return false;
        }
        return Intrinsics.areEqual(this.issues, scanSummary.issues);
    }

    private static final boolean filterByPaths$matchesPaths(String $this$filterByPaths_u24matchesPaths, Collection<String> $paths, Set<String> applicableLicenseFiles) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $paths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String filterPath = (String)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.startsWith$default((String)$this$filterByPaths_u24matchesPaths, (String)(filterPath + "/"), (boolean)false, (int)2, null) || applicableLicenseFiles.contains($this$filterByPaths_u24matchesPaths))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean filterByPaths$matchesPaths$3(TextLocation $this$filterByPaths_u24matchesPaths_u243, Collection<String> $paths, Set<String> applicableLicenseFiles) {
        return ScanSummary.filterByPaths$matchesPaths($this$filterByPaths_u24matchesPaths_u243.getPath(), $paths, applicableLicenseFiles);
    }

    static {
        Instant instant = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
        Instant instant2 = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"EPOCH");
        EMPTY = new ScanSummary(instant, instant2, null, null, null, null, 60, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ossreviewtoolkit/model/ScanSummary$Companion;", "", "()V", "EMPTY", "Lorg/ossreviewtoolkit/model/ScanSummary;", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

