/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.FileList;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.ProvenanceResolutionResult;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.ScannerRun;
import org.ossreviewtoolkit.model.ScannerRunKt;
import org.ossreviewtoolkit.model.config.ScannerConfiguration;
import org.ossreviewtoolkit.model.utils.ExtensionsKt;
import org.ossreviewtoolkit.model.utils.FileListSortedSetConverter;
import org.ossreviewtoolkit.model.utils.ProvenanceResolutionResultSortedSetConverter;
import org.ossreviewtoolkit.model.utils.ScanResultSortedSetConverter;
import org.ossreviewtoolkit.model.utils.ScanResultUtilsKt;
import org.ossreviewtoolkit.model.utils.ScannersMapConverter;
import org.ossreviewtoolkit.utils.ort.Environment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 K2\u00020\u0001:\u0001KBq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u001a\b\u0001\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u000f\u0012\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n\u00a2\u0006\u0002\u0010\u0014J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u00c6\u0003J\u001b\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u000fH\u00c6\u0003J\u000f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00130\nH\u00c6\u0003J}\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0003\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0003\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u001a\b\u0003\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u000f2\u000e\b\u0003\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nH\u00c6\u0001J\u0013\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fH\u0007J\u001a\u0010A\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0,0\u000fH\u0007J\u0010\u0010B\u001a\u0004\u0018\u00010\u00132\u0006\u0010C\u001a\u00020\u0010J\u001a\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0\n0\u000fH\u0007J\u0012\u0010F\u001a\u0004\u0018\u00010\u00132\u0006\u0010C\u001a\u00020\u0010H\u0002J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\r0,2\u0006\u0010C\u001a\u00020\u0010H\u0002J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0,2\u0006\u0010C\u001a\u00020\u0010J\t\u0010H\u001a\u00020IH\u00d6\u0001J\t\u0010J\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR'\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00130\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b\"\u0010\u001dR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R'\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001f\u001a\u0004\b(\u0010\u001dR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R-\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0,0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001f\u001a\u0004\b-\u0010\u001dR-\u0010/\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0,0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001f\u001a\u0004\b0\u0010\u001dR#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0018\u00a8\u0006L"}, d2={"Lorg/ossreviewtoolkit/model/ScannerRun;", "", "startTime", "Ljava/time/Instant;", "endTime", "environment", "Lorg/ossreviewtoolkit/utils/ort/Environment;", "config", "Lorg/ossreviewtoolkit/model/config/ScannerConfiguration;", "provenances", "", "Lorg/ossreviewtoolkit/model/ProvenanceResolutionResult;", "scanResults", "Lorg/ossreviewtoolkit/model/ScanResult;", "scanners", "", "Lorg/ossreviewtoolkit/model/Identifier;", "", "files", "Lorg/ossreviewtoolkit/model/FileList;", "(Ljava/time/Instant;Ljava/time/Instant;Lorg/ossreviewtoolkit/utils/ort/Environment;Lorg/ossreviewtoolkit/model/config/ScannerConfiguration;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Ljava/util/Set;)V", "getConfig", "()Lorg/ossreviewtoolkit/model/config/ScannerConfiguration;", "getEndTime", "()Ljava/time/Instant;", "getEnvironment", "()Lorg/ossreviewtoolkit/utils/ort/Environment;", "fileListById", "getFileListById", "()Ljava/util/Map;", "fileListById$delegate", "Lkotlin/Lazy;", "fileListByProvenance", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "getFileListByProvenance", "fileListByProvenance$delegate", "getFiles", "()Ljava/util/Set;", "getProvenances", "provenancesById", "getProvenancesById", "provenancesById$delegate", "getScanResults", "scanResultsById", "", "getScanResultsById", "scanResultsById$delegate", "scanResultsByProvenance", "getScanResultsByProvenance", "scanResultsByProvenance$delegate", "getScanners", "getStartTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "getAllFileLists", "getAllScanResults", "getFileList", "id", "getIssues", "Lorg/ossreviewtoolkit/model/Issue;", "getMergedFileListForId", "getMergedResultsForId", "hashCode", "", "toString", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nScannerRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScannerRun.kt\norg/ossreviewtoolkit/model/ScannerRun\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,309:1\n1855#2,2:310\n1620#2,3:312\n1446#2,5:315\n1620#2,3:320\n1855#2,2:323\n1238#2,4:327\n1238#2,2:333\n766#2:335\n857#2,2:336\n1241#2:338\n1549#2:339\n1620#2,3:340\n1549#2:343\n1620#2,3:344\n1238#2,4:349\n1238#2,2:355\n1446#2,5:357\n1241#2:362\n453#3:325\n403#3:326\n453#3:331\n403#3:332\n453#3:347\n403#3:348\n453#3:353\n403#3:354\n*S KotlinDebug\n*F\n+ 1 ScannerRun.kt\norg/ossreviewtoolkit/model/ScannerRun\n*L\n110#1:310,2\n133#1:312,3\n134#1:315,5\n145#1:320,3\n153#1:323,2\n214#1:327,4\n216#1:333,2\n217#1:335\n217#1:336,2\n216#1:338\n221#1:339\n221#1:340,3\n223#1:343\n223#1:344,3\n238#1:349,4\n261#1:355,2\n262#1:357,5\n261#1:362\n214#1:325\n214#1:326\n216#1:331\n216#1:332\n238#1:347\n238#1:348\n261#1:353\n261#1:354\n*E\n"})
public final class ScannerRun {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant startTime;
    @NotNull
    private final Instant endTime;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ScannerConfiguration config;
    @NotNull
    private final Set<ProvenanceResolutionResult> provenances;
    @NotNull
    private final Set<ScanResult> scanResults;
    @NotNull
    private final Map<Identifier, Set<String>> scanners;
    @NotNull
    private final Set<FileList> files;
    @NotNull
    private final Lazy provenancesById$delegate;
    @NotNull
    private final Lazy scanResultsByProvenance$delegate;
    @NotNull
    private final Lazy scanResultsById$delegate;
    @NotNull
    private final Lazy fileListByProvenance$delegate;
    @NotNull
    private final Lazy fileListById$delegate;
    @JvmField
    @NotNull
    public static final ScannerRun EMPTY;

    /*
     * WARNING - void declaration
     */
    public ScannerRun(@NotNull Instant startTime, @NotNull Instant endTime, @NotNull Environment environment, @NotNull ScannerConfiguration config, @JsonSerialize(converter=ProvenanceResolutionResultSortedSetConverter.class) @NotNull Set<ProvenanceResolutionResult> provenances, @JsonSerialize(converter=ScanResultSortedSetConverter.class) @NotNull Set<ScanResult> scanResults, @JsonSerialize(converter=ScannersMapConverter.class) @NotNull Map<Identifier, ? extends Set<String>> scanners, @JsonSerialize(converter=FileListSortedSetConverter.class) @NotNull Set<FileList> files) {
        void destination$iv;
        void $this$mapTo$iv;
        void destination$iv2;
        void $this$flatMapTo$iv;
        void var22_50;
        Iterable destination$iv3;
        void $this$mapTo$iv2;
        Object $i$a$-require-ScannerRun$1$222;
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(provenances, (String)"provenances");
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        Intrinsics.checkNotNullParameter(scanners, (String)"scanners");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.startTime = startTime;
        this.endTime = endTime;
        this.environment = environment;
        this.config = config;
        this.provenances = provenances;
        this.scanResults = scanResults;
        this.scanners = scanners;
        this.files = files;
        Iterable $this$forEach$iv = this.scanResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RepositoryProvenance repositoryProvenance;
            ScanResult scanResult = (ScanResult)element$iv;
            boolean bl = false;
            if (!(scanResult.getProvenance() instanceof KnownProvenance)) {
                boolean $i$a$-require-ScannerRun$1$222 = false;
                String $i$a$-require-ScannerRun$1$222 = "Found a scan result with an unknown provenance, which is not allowed.";
                throw new IllegalArgumentException($i$a$-require-ScannerRun$1$222.toString());
            }
            $i$a$-require-ScannerRun$1$222 = scanResult.getProvenance();
            if (($i$a$-require-ScannerRun$1$222 instanceof RepositoryProvenance ? (RepositoryProvenance)$i$a$-require-ScannerRun$1$222 : null) == null) continue;
            repositoryProvenance = repositoryProvenance;
            boolean bl2 = false;
            if (!(((CharSequence)repositoryProvenance.getVcsInfo().getPath()).length() == 0)) {
                boolean $i$a$-require-ScannerRun$1$2$32 = false;
                String $i$a$-require-ScannerRun$1$2$32 = "Found a scan result with a non-empty VCS path, which is not allowed.";
                throw new IllegalArgumentException($i$a$-require-ScannerRun$1$2$32.toString());
            }
            if (Intrinsics.areEqual((Object)repositoryProvenance.getVcsInfo().getRevision(), (Object)repositoryProvenance.getResolvedRevision())) continue;
            boolean $i$a$-require-ScannerRun$1$2$42 = false;
            String $i$a$-require-ScannerRun$1$2$42 = "The revision and resolved revision of a scan result are not equal, which is not allowed.";
            throw new IllegalArgumentException($i$a$-require-ScannerRun$1$2$42.toString());
        }
        Iterable<Object> idsForDuplicateProvenanceResolutionResults = org.ossreviewtoolkit.utils.common.ExtensionsKt.getDuplicates((Collection)this.provenances, (Function1)2.INSTANCE).keySet();
        boolean $i$a$-let-ScannerRun$62 = false;
        if (!idsForDuplicateProvenanceResolutionResults.isEmpty()) {
            boolean $i$a$-require-ScannerRun$3$22 = false;
            String $i$a$-require-ScannerRun$3$22 = "Found multiple provenance resolution results for the following ids: " + CollectionsKt.joinToString$default((Iterable)idsForDuplicateProvenanceResolutionResults, null, null, null, (int)0, null, (Function1)3.1.1.INSTANCE, (int)31, null) + ".";
            throw new IllegalArgumentException($i$a$-require-ScannerRun$3$22.toString());
        }
        idsForDuplicateProvenanceResolutionResults = this.scanResults;
        Collection $i$a$-let-ScannerRun$62 = new LinkedHashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            $i$a$-require-ScannerRun$1$222 = (ScanResult)item$iv;
            var22_50 = destination$iv3;
            boolean bl = false;
            var22_50.add(it.getProvenance());
        }
        Set scannedProvenances = (Set)destination$iv3;
        destination$iv3 = this.provenances;
        Collection $i$f$mapTo22 = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            ProvenanceResolutionResult it = (ProvenanceResolutionResult)element$iv;
            boolean bl = false;
            Iterable list$iv = ExtensionsKt.getKnownProvenancesWithoutVcsPath(it).values();
            CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
        }
        Set resolvedProvenances = (Set)destination$iv2;
        Iterable it = SetsKt.minus((Set)scannedProvenances, (Iterable)resolvedProvenances);
        boolean $i$a$-let-ScannerRun$72 = false;
        if (!it.isEmpty()) {
            boolean $i$a$-require-ScannerRun$4$22 = false;
            String $i$a$-require-ScannerRun$4$22 = "Found scan results which do not correspond to any resolved provenances, which is not allowed: \n" + MappersKt.toYaml(it);
            throw new IllegalArgumentException($i$a$-require-ScannerRun$4$22.toString());
        }
        it = this.files;
        Collection $i$a$-let-ScannerRun$72 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            FileList bl = (FileList)item$iv;
            var22_50 = destination$iv;
            boolean bl3 = false;
            var22_50.add(it2.getProvenance());
        }
        Set fileListProvenances = (Set)destination$iv;
        Set it3 = SetsKt.minus((Set)fileListProvenances, (Iterable)resolvedProvenances);
        boolean bl = false;
        if (!it3.isEmpty()) {
            boolean $i$a$-require-ScannerRun$5$22 = false;
            String $i$a$-require-ScannerRun$5$22 = "Found a file lists which do not correspond to any resolved provenances, which is not allowed: \n" + MappersKt.toYaml(it3);
            throw new IllegalArgumentException($i$a$-require-ScannerRun$5$22.toString());
        }
        Iterable $this$forEach$iv2 = this.files;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            RepositoryProvenance it4;
            FileList fileList = (FileList)element$iv;
            boolean bl4 = false;
            KnownProvenance knownProvenance = fileList.getProvenance();
            if ((knownProvenance instanceof RepositoryProvenance ? (RepositoryProvenance)knownProvenance : null) == null) continue;
            it4 = it4;
            boolean bl5 = false;
            if (!(((CharSequence)it4.getVcsInfo().getPath()).length() == 0)) {
                boolean $i$a$-require-ScannerRun$6$1$32 = false;
                String $i$a$-require-ScannerRun$6$1$32 = "Found a file list with a non-empty VCS path, which is not allowed.";
                throw new IllegalArgumentException($i$a$-require-ScannerRun$6$1$32.toString());
            }
            if (Intrinsics.areEqual((Object)it4.getVcsInfo().getRevision(), (Object)it4.getResolvedRevision())) continue;
            boolean bl6 = false;
            String string = "The revision and resolved revision of a file list are not equal, which is not allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        this.provenancesById$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends ProvenanceResolutionResult>>(this){
            final /* synthetic */ ScannerRun this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, ProvenanceResolutionResult> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getProvenances();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ProvenanceResolutionResult provenanceResolutionResult = (ProvenanceResolutionResult)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getId(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.scanResultsByProvenance$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<KnownProvenance, ? extends List<? extends ScanResult>>>(this){
            final /* synthetic */ ScannerRun this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<KnownProvenance, List<ScanResult>> invoke() {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = this.this$0.getScanResults();
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    ScanResult it = (ScanResult)element$iv$iv;
                    boolean bl = false;
                    Provenance provenance = it.getProvenance();
                    Intrinsics.checkNotNull((Object)provenance, (String)"null cannot be cast to non-null type org.ossreviewtoolkit.model.KnownProvenance");
                    KnownProvenance key$iv$iv = (KnownProvenance)provenance;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.scanResultsById$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends List<? extends ScanResult>>>(this){
            final /* synthetic */ ScannerRun this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, List<ScanResult>> invoke() {
                void $this$associateWith$iv;
                Identifier it;
                Object object;
                void $this$mapTo$iv$iv;
                ScannerRun $this$logger$iv = this.this$0;
                boolean $i$f$getLogger22 = false;
                LoggingFactoryKt.cachedLoggerOf(ScannerRun.class).debug((Function0)scanResultsById.1.INSTANCE);
                ScannerRun $i$f$getLogger22 = this.this$0;
                boolean $i$f$measureTimedValue = false;
                TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTimedValue2 = false;
                long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
                boolean bl = false;
                Iterable $this$map$iv = $i$f$getLogger22.getProvenances();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    ProvenanceResolutionResult provenanceResolutionResult = (ProvenanceResolutionResult)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    object.add(((ProvenanceResolutionResult)((Object)it)).getId());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$associateWith = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    void id;
                    it = (Identifier)element$iv$iv;
                    T t = element$iv$iv;
                    object = result$iv;
                    boolean bl3 = false;
                    List list = ScannerRun.access$getMergedResultsForId($i$f$getLogger22, (Identifier)id);
                    object.put(t, list);
                }
                Map result$iv$iv = result$iv;
                TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
                Map result = (Map)timedValue.component1();
                long duration = timedValue.component2-UwyO8pc();
                ScannerRun $this$logger$iv2 = this.this$0;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(ScannerRun.class).debug((Function0)new Function0<Object>(duration){
                    final /* synthetic */ long $duration;
                    {
                        this.$duration = $duration;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Merging scan results took " + Duration.toString-impl((long)this.$duration) + ".";
                    }
                });
                return result;
            }
        }));
        this.fileListByProvenance$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<KnownProvenance, ? extends FileList>>(this){
            final /* synthetic */ ScannerRun this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<KnownProvenance, FileList> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getFiles();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    FileList fileList = (FileList)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getProvenance(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.fileListById$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Identifier, ? extends FileList>>(this){
            final /* synthetic */ ScannerRun this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Identifier, FileList> invoke() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = this.this$0.getProvenances();
                ScannerRun scannerRun = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var4_4 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ProvenanceResolutionResult it = (ProvenanceResolutionResult)element$iv$iv;
                    boolean bl2 = false;
                    if (ScannerRun.access$getMergedFileListForId(scannerRun, it.getId()) != null) {
                        FileList fileList;
                        boolean bl3 = false;
                        pair = TuplesKt.to((Object)it.getId(), (Object)fileList);
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final ScannerConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final Set<ProvenanceResolutionResult> getProvenances() {
        return this.provenances;
    }

    @NotNull
    public final Set<ScanResult> getScanResults() {
        return this.scanResults;
    }

    @NotNull
    public final Map<Identifier, Set<String>> getScanners() {
        return this.scanners;
    }

    @NotNull
    public final Set<FileList> getFiles() {
        return this.files;
    }

    private final Map<Identifier, ProvenanceResolutionResult> getProvenancesById() {
        Lazy lazy = this.provenancesById$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<KnownProvenance, List<ScanResult>> getScanResultsByProvenance() {
        Lazy lazy = this.scanResultsByProvenance$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<Identifier, List<ScanResult>> getScanResultsById() {
        Lazy lazy = this.scanResultsById$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<KnownProvenance, FileList> getFileListByProvenance() {
        Lazy lazy = this.fileListByProvenance$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<Identifier, FileList> getFileListById() {
        Lazy lazy = this.fileListById$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScanResult> getMergedResultsForId(Identifier id) {
        ScanResult scanResult;
        Iterable $this$mapTo$iv$iv;
        List list;
        Object object;
        Object k;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        boolean bl;
        Map map;
        Object $this$mapValuesTo$iv$iv;
        Object object2 = MapsKt.getValue(this.getProvenancesById(), (Object)id);
        ProvenanceResolutionResult $this$getMergedResultsForId_u24lambda_u2418 = (ProvenanceResolutionResult)object2;
        boolean bl2 = false;
        if (!((Collection)ScannerRunKt.getIssues($this$getMergedResultsForId_u24lambda_u2418)).isEmpty()) {
            return CollectionsKt.listOf((Object)ScannerRunKt.access$scanResultForProvenanceResolutionIssues($this$getMergedResultsForId_u24lambda_u2418.getPackageProvenance(), ScannerRunKt.getIssues($this$getMergedResultsForId_u24lambda_u2418)));
        }
        ProvenanceResolutionResult resolutionResult = (ProvenanceResolutionResult)object2;
        KnownProvenance knownProvenance = resolutionResult.getPackageProvenance();
        Intrinsics.checkNotNull((Object)knownProvenance);
        KnownProvenance packageProvenance = knownProvenance;
        Map $this$mapValues$iv = ExtensionsKt.getKnownProvenancesWithoutVcsPath(resolutionResult);
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = map;
            boolean bl3 = false;
            KnownProvenance provenance = (KnownProvenance)entry.getValue();
            List list2 = this.getScanResultsByProvenance().get(provenance);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
            object.put(k, list);
        }
        $this$mapValues$iv = destination$iv$iv;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object = map;
            boolean bl4 = false;
            List scanResults = (List)entry.getValue();
            Iterable $this$filter$iv = scanResults;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ScanResult it = (ScanResult)element$iv$iv;
                boolean bl5 = false;
                Set set = this.scanners.get(id);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                if (!set.contains(it.getScanner().getName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
            object.put(k, list);
        }
        Map scanResultsByPath = destination$iv$iv;
        Iterable $this$map$iv = ScanResultUtilsKt.mergeScanResultsByScanner(scanResultsByPath, packageProvenance);
        boolean $i$f$map = false;
        $this$mapValuesTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScanResult scanResult2 = (ScanResult)item$iv$iv;
            object = destination$iv$iv;
            boolean bl6 = false;
            object.add(scanResult.filterByPath(ExtensionsKt.getVcsPath(packageProvenance)).filterByIgnorePatterns((Collection<String>)this.config.getIgnorePatterns()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            scanResult = (ScanResult)item$iv$iv;
            object = destination$iv$iv;
            boolean bl7 = false;
            object.add(ScanResult.copy$default(scanResult, null, null, ScannerRunKt.access$addIssue(scanResult.getSummary(), resolutionResult.getNestedProvenanceResolutionIssue()), null, 11, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FileList getMergedFileListForId(Identifier id) {
        void $this$mapValuesTo$iv$iv;
        ProvenanceResolutionResult provenanceResolutionResult;
        block6: {
            block5: {
                ProvenanceResolutionResult provenanceResolutionResult2;
                provenanceResolutionResult = this.getProvenancesById().get(id);
                if (provenanceResolutionResult == null) break block5;
                ProvenanceResolutionResult it = provenanceResolutionResult2 = provenanceResolutionResult;
                boolean bl = false;
                provenanceResolutionResult = it.getPackageProvenanceResolutionIssue() == null && it.getNestedProvenanceResolutionIssue() == null ? provenanceResolutionResult2 : null;
                if (provenanceResolutionResult != null) break block6;
            }
            return null;
        }
        ProvenanceResolutionResult resolutionResult = provenanceResolutionResult;
        KnownProvenance knownProvenance = resolutionResult.getPackageProvenance();
        Intrinsics.checkNotNull((Object)knownProvenance);
        KnownProvenance packageProvenance = knownProvenance;
        Map<String, KnownProvenance> $this$mapValues$iv = ExtensionsKt.getKnownProvenancesWithoutVcsPath(resolutionResult);
        boolean $i$f$mapValues = false;
        Map<String, KnownProvenance> bl = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            FileList fileList;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            KnownProvenance provenance = (KnownProvenance)entry2.getValue();
            if (this.getFileListByProvenance().get(provenance) == null) {
                return null;
            }
            map2.put(k, fileList);
        }
        Map fileListsByPath = destination$iv$iv;
        return FileList.copy$default(ScannerRunKt.access$filterByVcsPath(ScannerRunKt.access$mergeFileLists(fileListsByPath), ExtensionsKt.getVcsPath(packageProvenance)), packageProvenance, null, 2, null);
    }

    @JsonIgnore
    @NotNull
    public final Map<Identifier, List<ScanResult>> getAllScanResults() {
        return this.getScanResultsById();
    }

    @NotNull
    public final List<ScanResult> getScanResults(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List list = this.getScanResultsById().get(id);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JsonIgnore
    @NotNull
    public final Map<Identifier, FileList> getAllFileLists() {
        return this.getFileListById();
    }

    @Nullable
    public final FileList getFileList(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getFileListById().get(id);
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Map<Identifier, Set<Issue>> getIssues() {
        void $this$mapValuesTo$iv$iv;
        Map<Identifier, List<ScanResult>> $this$mapValues$iv = this.getScanResultsById();
        boolean $i$f$mapValues = false;
        Map<Identifier, List<ScanResult>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void destination$iv;
            void $this$flatMapTo$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List scanResults = (List)entry2.getValue();
            Iterable iterable = scanResults;
            Collection collection = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ScanResult it = (ScanResult)element$iv;
                boolean bl3 = false;
                Iterable list$iv = it.getSummary().getIssues();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Set set = (Set)destination$iv;
            map3.put(k, set);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Instant component1() {
        return this.startTime;
    }

    @NotNull
    public final Instant component2() {
        return this.endTime;
    }

    @NotNull
    public final Environment component3() {
        return this.environment;
    }

    @NotNull
    public final ScannerConfiguration component4() {
        return this.config;
    }

    @NotNull
    public final Set<ProvenanceResolutionResult> component5() {
        return this.provenances;
    }

    @NotNull
    public final Set<ScanResult> component6() {
        return this.scanResults;
    }

    @NotNull
    public final Map<Identifier, Set<String>> component7() {
        return this.scanners;
    }

    @NotNull
    public final Set<FileList> component8() {
        return this.files;
    }

    @NotNull
    public final ScannerRun copy(@NotNull Instant startTime, @NotNull Instant endTime, @NotNull Environment environment, @NotNull ScannerConfiguration config, @JsonSerialize(converter=ProvenanceResolutionResultSortedSetConverter.class) @NotNull Set<ProvenanceResolutionResult> provenances, @JsonSerialize(converter=ScanResultSortedSetConverter.class) @NotNull Set<ScanResult> scanResults, @JsonSerialize(converter=ScannersMapConverter.class) @NotNull Map<Identifier, ? extends Set<String>> scanners, @JsonSerialize(converter=FileListSortedSetConverter.class) @NotNull Set<FileList> files) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(provenances, (String)"provenances");
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        Intrinsics.checkNotNullParameter(scanners, (String)"scanners");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return new ScannerRun(startTime, endTime, environment, config, provenances, scanResults, scanners, files);
    }

    public static /* synthetic */ ScannerRun copy$default(ScannerRun scannerRun, Instant instant, Instant instant2, Environment environment, ScannerConfiguration scannerConfiguration, Set set, Set set2, Map map, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            instant = scannerRun.startTime;
        }
        if ((n & 2) != 0) {
            instant2 = scannerRun.endTime;
        }
        if ((n & 4) != 0) {
            environment = scannerRun.environment;
        }
        if ((n & 8) != 0) {
            scannerConfiguration = scannerRun.config;
        }
        if ((n & 0x10) != 0) {
            set = scannerRun.provenances;
        }
        if ((n & 0x20) != 0) {
            set2 = scannerRun.scanResults;
        }
        if ((n & 0x40) != 0) {
            map = scannerRun.scanners;
        }
        if ((n & 0x80) != 0) {
            set3 = scannerRun.files;
        }
        return scannerRun.copy(instant, instant2, environment, scannerConfiguration, set, set2, map, set3);
    }

    @NotNull
    public String toString() {
        return "ScannerRun(startTime=" + this.startTime + ", endTime=" + this.endTime + ", environment=" + this.environment + ", config=" + this.config + ", provenances=" + this.provenances + ", scanResults=" + this.scanResults + ", scanners=" + this.scanners + ", files=" + this.files + ")";
    }

    public int hashCode() {
        int result = this.startTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        result = result * 31 + this.environment.hashCode();
        result = result * 31 + this.config.hashCode();
        result = result * 31 + ((Object)this.provenances).hashCode();
        result = result * 31 + ((Object)this.scanResults).hashCode();
        result = result * 31 + ((Object)this.scanners).hashCode();
        result = result * 31 + ((Object)this.files).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScannerRun)) {
            return false;
        }
        ScannerRun scannerRun = (ScannerRun)other;
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)scannerRun.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTime, (Object)scannerRun.endTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.environment, (Object)scannerRun.environment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.config, (Object)scannerRun.config)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.provenances, scannerRun.provenances)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scanResults, scannerRun.scanResults)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scanners, scannerRun.scanners)) {
            return false;
        }
        return Intrinsics.areEqual(this.files, scannerRun.files);
    }

    public static final /* synthetic */ List access$getMergedResultsForId(ScannerRun $this, Identifier id) {
        return $this.getMergedResultsForId(id);
    }

    public static final /* synthetic */ FileList access$getMergedFileListForId(ScannerRun $this, Identifier id) {
        return $this.getMergedFileListForId(id);
    }

    static {
        Instant instant = Instant.EPOCH;
        Instant instant2 = Instant.EPOCH;
        Environment environment = new Environment(null, null, null, null, 0, 0L, null, null, 255, null);
        ScannerConfiguration scannerConfiguration = new ScannerConfiguration(false, false, null, false, null, null, null, null, null, null, null, null, 4095, null);
        Set set = SetsKt.emptySet();
        Set set2 = SetsKt.emptySet();
        Set set3 = SetsKt.emptySet();
        Map map = MapsKt.emptyMap();
        Intrinsics.checkNotNull((Object)instant);
        Intrinsics.checkNotNull((Object)instant2);
        EMPTY = new ScannerRun(instant, instant2, environment, scannerConfiguration, set, set2, map, set3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ossreviewtoolkit/model/ScannerRun$Companion;", "", "()V", "EMPTY", "Lorg/ossreviewtoolkit/model/ScannerRun;", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

