/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.FileList;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.ProvenanceResolutionResult;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.ScanSummary;
import org.ossreviewtoolkit.model.ScannerDetails;
import org.ossreviewtoolkit.model.UnknownProvenance;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.utils.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a \u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0013\u001a\u00020\nH\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0014"}, d2={"issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "Lorg/ossreviewtoolkit/model/ProvenanceResolutionResult;", "getIssues", "(Lorg/ossreviewtoolkit/model/ProvenanceResolutionResult;)Ljava/util/List;", "mergeFileLists", "Lorg/ossreviewtoolkit/model/FileList;", "fileListByPath", "", "", "scanResultForProvenanceResolutionIssues", "Lorg/ossreviewtoolkit/model/ScanResult;", "packageProvenance", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "addIssue", "Lorg/ossreviewtoolkit/model/ScanSummary;", "issue", "filterByVcsPath", "path", "model"})
@SourceDebugExtension(value={"SMAP\nScannerRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScannerRun.kt\norg/ossreviewtoolkit/model/ScannerRunKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n96#2,2:310\n98#2,3:316\n1549#3:312\n1620#3,3:313\n857#3,2:319\n*S KotlinDebug\n*F\n+ 1 ScannerRun.kt\norg/ossreviewtoolkit/model/ScannerRunKt\n*L\n281#1:310,2\n281#1:316,3\n282#1:312\n282#1:313,3\n300#1:319,2\n*E\n"})
public final class ScannerRunKt {
    private static final ScanResult scanResultForProvenanceResolutionIssues(KnownProvenance packageProvenance, List<Issue> issues) {
        KnownProvenance knownProvenance = packageProvenance;
        return new ScanResult(knownProvenance != null ? (Provenance)knownProvenance : (Provenance)UnknownProvenance.INSTANCE, new ScannerDetails("ProvenanceResolver", "", ""), ScanSummary.copy$default(ScanSummary.EMPTY, null, null, null, null, null, issues, 31, null), null, 8, null);
    }

    private static final ScanSummary addIssue(ScanSummary $this$addIssue, Issue issue) {
        return issue == null ? $this$addIssue : ScanSummary.copy$default($this$addIssue, null, null, null, null, null, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)$this$addIssue.getIssues(), (Object)issue)), 31, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final FileList mergeFileLists(Map<String, FileList> fileListByPath) {
        void destination$iv;
        void $this$flatMapTo$iv;
        FileList fileList = fileListByPath.get("");
        if (fileList == null) {
            boolean $i$a$-requireNotNull-ScannerRunKt$mergeFileLists$provenance$22 = false;
            String $i$a$-requireNotNull-ScannerRunKt$mergeFileLists$provenance$22 = "There must be a file list associated with the root path.";
            throw new IllegalArgumentException($i$a$-requireNotNull-ScannerRunKt$mergeFileLists$provenance$22.toString());
        }
        KnownProvenance provenance = fileList.getProvenance();
        Map<String, FileList> $i$a$-requireNotNull-ScannerRunKt$mergeFileLists$provenance$22 = fileListByPath;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String path = (String)entry.getKey();
            FileList fileList2 = (FileList)entry.getValue();
            Iterable $this$map$iv = fileList2.getFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fileEntry;
                FileList.Entry entry2 = (FileList.Entry)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(FileList.Entry.copy$default((FileList.Entry)fileEntry, ExtensionsKt.prependPath(fileEntry.getPath(), path), null, 2, null));
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set files = (Set)destination$iv;
        return new FileList(provenance, files);
    }

    /*
     * WARNING - void declaration
     */
    private static final FileList filterByVcsPath(FileList $this$filterByVcsPath, String path) {
        void destination$iv;
        void $this$filterTo$iv;
        if (StringsKt.isBlank((CharSequence)path)) {
            return $this$filterByVcsPath;
        }
        if (!($this$filterByVcsPath.getProvenance() instanceof RepositoryProvenance)) {
            boolean $i$a$-require-ScannerRunKt$filterByVcsPath$22 = false;
            String $i$a$-require-ScannerRunKt$filterByVcsPath$22 = "Expected a repository provenance but got a " + $this$filterByVcsPath.getProvenance().getClass().getSimpleName() + ".";
            throw new IllegalArgumentException($i$a$-require-ScannerRunKt$filterByVcsPath$22.toString());
        }
        RepositoryProvenance provenance = RepositoryProvenance.copy$default((RepositoryProvenance)$this$filterByVcsPath.getProvenance(), VcsInfo.copy$default(((RepositoryProvenance)$this$filterByVcsPath.getProvenance()).getVcsInfo(), null, null, null, path, 7, null), null, 2, null);
        Iterable iterable = $this$filterByVcsPath.getFiles();
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            FileList.Entry fileEntry = (FileList.Entry)element$iv;
            boolean bl = false;
            if (!FilesKt.startsWith((File)new File(fileEntry.getPath()), (String)path)) continue;
            destination$iv.add(element$iv);
        }
        Set files = (Set)destination$iv;
        return new FileList(provenance, files);
    }

    @NotNull
    public static final List<Issue> getIssues(@NotNull ProvenanceResolutionResult $this$issues) {
        Intrinsics.checkNotNullParameter((Object)$this$issues, (String)"<this>");
        Object[] objectArray = new Issue[]{$this$issues.getPackageProvenanceResolutionIssue(), $this$issues.getNestedProvenanceResolutionIssue()};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public static final /* synthetic */ FileList access$filterByVcsPath(FileList $receiver, String path) {
        return ScannerRunKt.filterByVcsPath($receiver, path);
    }

    public static final /* synthetic */ FileList access$mergeFileLists(Map fileListByPath) {
        return ScannerRunKt.mergeFileLists(fileListByPath);
    }

    public static final /* synthetic */ ScanResult access$scanResultForProvenanceResolutionIssues(KnownProvenance packageProvenance, List issues) {
        return ScannerRunKt.scanResultForProvenanceResolutionIssues(packageProvenance, issues);
    }

    public static final /* synthetic */ ScanSummary access$addIssue(ScanSummary $receiver, Issue issue) {
        return ScannerRunKt.addIssue($receiver, issue);
    }
}

