/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.utils.PackageReferenceSortedSetConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0011\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\rH\u0086\u0002J#\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0016\u001a\u00020\rJ\t\u0010\u001c\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/ossreviewtoolkit/model/Scope;", "", "name", "", "dependencies", "", "Lorg/ossreviewtoolkit/model/PackageReference;", "(Ljava/lang/String;Ljava/util/Set;)V", "getDependencies", "()Ljava/util/Set;", "getName", "()Ljava/lang/String;", "collectDependencies", "Lorg/ossreviewtoolkit/model/Identifier;", "maxDepth", "", "filterPredicate", "Lkotlin/Function1;", "", "component1", "component2", "contains", "id", "copy", "equals", "other", "findReferences", "", "hashCode", "toString", "model"})
@SourceDebugExtension(value={"SMAP\nScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scope.kt\norg/ossreviewtoolkit/model/Scope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1789#2,3:78\n1747#2,3:81\n766#2:84\n857#2,2:85\n1360#2:87\n1446#2,5:88\n*S KotlinDebug\n*F\n+ 1 Scope.kt\norg/ossreviewtoolkit/model/Scope\n*L\n57#1:78,3\n69#1:81,3\n75#1:84\n75#1:85,2\n75#1:87\n75#1:88,5\n*E\n"})
public final class Scope {
    @NotNull
    private final String name;
    @NotNull
    private final Set<PackageReference> dependencies;

    public Scope(@NotNull String name, @JsonSerialize(converter=PackageReferenceSortedSetConverter.class) @NotNull Set<PackageReference> dependencies2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        this.name = name;
        this.dependencies = dependencies2;
    }

    public /* synthetic */ Scope(String string, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, set);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Set<PackageReference> getDependencies() {
        return this.dependencies;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Identifier> collectDependencies(int maxDepth, @NotNull Function1<? super PackageReference, Boolean> filterPredicate) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(filterPredicate, (String)"filterPredicate");
        Iterable iterable = this.dependencies;
        Set set = new LinkedHashSet();
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void var12_12;
            PackageReference packageReference = (PackageReference)element$iv;
            void refs = accumulator$iv;
            boolean bl = false;
            void it = var12_12 = refs;
            boolean bl2 = false;
            if (maxDepth != 0) {
                void ref;
                if (((Boolean)filterPredicate.invoke((Object)ref)).booleanValue()) {
                    ((Collection)it).add(ref.getId());
                }
                CollectionsKt.addAll((Collection)((Collection)it), (Iterable)ref.collectDependencies(maxDepth - 1, filterPredicate));
            }
            accumulator$iv = var12_12;
        }
        return accumulator$iv;
    }

    public static /* synthetic */ Set collectDependencies$default(Scope scope, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        if ((n2 & 2) != 0) {
            function1 = collectDependencies.1.INSTANCE;
        }
        return scope.collectDependencies(n, (Function1<? super PackageReference, Boolean>)function1);
    }

    public final boolean contains(@NotNull Identifier id) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$any$iv = this.dependencies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PackageReference it = (PackageReference)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getId(), (Object)id) || it.dependsOn(id))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageReference> findReferences(@NotNull Identifier id) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PackageReference it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Iterable $this$filter$iv = this.dependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PackageReference)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = this.dependencies;
        Collection collection = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PackageReference)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findReferences(id);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Set<PackageReference> component2() {
        return this.dependencies;
    }

    @NotNull
    public final Scope copy(@NotNull String name, @JsonSerialize(converter=PackageReferenceSortedSetConverter.class) @NotNull Set<PackageReference> dependencies2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        return new Scope(name, dependencies2);
    }

    public static /* synthetic */ Scope copy$default(Scope scope, String string, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = scope.name;
        }
        if ((n & 2) != 0) {
            set = scope.dependencies;
        }
        return scope.copy(string, set);
    }

    @NotNull
    public String toString() {
        return "Scope(name=" + this.name + ", dependencies=" + this.dependencies + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.dependencies).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Scope)) {
            return false;
        }
        Scope scope = (Scope)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)scope.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.dependencies, scope.dependencies);
    }
}

