/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import java.io.File;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.TextLocation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000J\u0013\u0010\u0018\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0000J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/ossreviewtoolkit/model/TextLocation;", "", "path", "", "line", "", "(Ljava/lang/String;I)V", "startLine", "endLine", "(Ljava/lang/String;II)V", "getEndLine", "()I", "getPath", "()Ljava/lang/String;", "getStartLine", "compareTo", "other", "component1", "component2", "component3", "contains", "", "copy", "distanceTo", "equals", "", "hashCode", "linesOverlapWith", "toString", "withRelativePath", "basePath", "Ljava/io/File;", "Companion", "model"})
public final class TextLocation
implements Comparable<TextLocation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private final int startLine;
    private final int endLine;
    public static final int UNKNOWN_LINE = -1;
    @NotNull
    private static final Comparator<TextLocation> COMPARATOR;

    public TextLocation(@NotNull String path, int startLine, int endLine) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.startLine = startLine;
        this.endLine = endLine;
        if (!(((CharSequence)this.path).length() > 0)) {
            boolean $i$a$-require-TextLocation$32 = false;
            String $i$a$-require-TextLocation$32 = "The path must not be empty.";
            throw new IllegalArgumentException($i$a$-require-TextLocation$32.toString());
        }
        int n = this.endLine;
        int $i$a$-require-TextLocation$32 = this.startLine;
        if (!((1 <= $i$a$-require-TextLocation$32 ? $i$a$-require-TextLocation$32 <= n : false) || this.startLine == -1 && this.endLine == -1)) {
            boolean bl = false;
            String string = "Invalid start or end line values.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    public TextLocation(@NotNull String path, int line) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, line, line);
    }

    @Override
    public int compareTo(@NotNull TextLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return COMPARATOR.compare(this, other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(int line) {
        if (line == -1) return false;
        int n = this.startLine;
        if (line > this.endLine) return false;
        if (n > line) return false;
        return true;
    }

    public final boolean contains(@NotNull TextLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)other.path, (Object)this.path) && this.contains(other.startLine) && this.contains(other.endLine);
    }

    public final boolean linesOverlapWith(@NotNull TextLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.contains(this.startLine) || this.contains(other.startLine);
    }

    public final int distanceTo(@NotNull TextLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.linesOverlapWith(other) ? 0 : Math.min(Math.abs(other.startLine - this.endLine), Math.abs(this.startLine - other.endLine));
    }

    @NotNull
    public final TextLocation withRelativePath(@NotNull File basePath) {
        File file;
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        File pathAsFile = new File(this.path);
        if (!pathAsFile.isAbsolute()) {
            file = pathAsFile;
        } else if (basePath.isFile()) {
            File file2 = basePath.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            file = FilesKt.relativeTo((File)pathAsFile, (File)file2);
        } else {
            file = FilesKt.relativeTo((File)pathAsFile, (File)basePath);
        }
        File relativePath = file;
        return TextLocation.copy$default(this, FilesKt.getInvariantSeparatorsPath((File)relativePath), 0, 0, 6, null);
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    public final int component2() {
        return this.startLine;
    }

    public final int component3() {
        return this.endLine;
    }

    @NotNull
    public final TextLocation copy(@NotNull String path, int startLine, int endLine) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new TextLocation(path, startLine, endLine);
    }

    public static /* synthetic */ TextLocation copy$default(TextLocation textLocation, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = textLocation.path;
        }
        if ((n3 & 2) != 0) {
            n = textLocation.startLine;
        }
        if ((n3 & 4) != 0) {
            n2 = textLocation.endLine;
        }
        return textLocation.copy(string, n, n2);
    }

    @NotNull
    public String toString() {
        return "TextLocation(path=" + this.path + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + Integer.hashCode(this.startLine);
        result = result * 31 + Integer.hashCode(this.endLine);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextLocation)) {
            return false;
        }
        TextLocation textLocation = (TextLocation)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)textLocation.path)) {
            return false;
        }
        if (this.startLine != textLocation.startLine) {
            return false;
        }
        return this.endLine == textLocation.endLine;
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.COMPARATOR.1.INSTANCE, Companion.COMPARATOR.2.INSTANCE, Companion.COMPARATOR.3.INSTANCE};
        COMPARATOR = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/ossreviewtoolkit/model/TextLocation$Companion;", "", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lorg/ossreviewtoolkit/model/TextLocation;", "Lkotlin/Comparator;", "UNKNOWN_LINE", "", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

