/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.config.PackageManagerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryAnalyzerConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u00002\u00020\u0001BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003JY\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u0006J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020#J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\u001e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001f\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "", "allowDynamicVersions", "", "enabledPackageManagers", "", "", "disabledPackageManagers", "packageManagers", "", "Lorg/ossreviewtoolkit/model/config/PackageManagerConfiguration;", "skipExcluded", "(ZLjava/util/List;Ljava/util/List;Ljava/util/Map;Z)V", "getAllowDynamicVersions", "()Z", "getDisabledPackageManagers", "()Ljava/util/List;", "getEnabledPackageManagers", "getPackageManagers", "()Ljava/util/Map;", "packageManagersCaseInsensitive", "getSkipExcluded", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "getPackageManagerConfiguration", "packageManager", "hashCode", "", "merge", "Lorg/ossreviewtoolkit/model/config/RepositoryAnalyzerConfiguration;", "toString", "withPackageManagerOption", "name", "key", "value", "model"})
@SourceDebugExtension(value={"SMAP\nAnalyzerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzerConfiguration.kt\norg/ossreviewtoolkit/model/config/AnalyzerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1855#2,2:134\n*S KotlinDebug\n*F\n+ 1 AnalyzerConfiguration.kt\norg/ossreviewtoolkit/model/config/AnalyzerConfiguration\n*L\n94#1:134,2\n*E\n"})
public final class AnalyzerConfiguration {
    private final boolean allowDynamicVersions;
    @Nullable
    private final List<String> enabledPackageManagers;
    @Nullable
    private final List<String> disabledPackageManagers;
    @Nullable
    private final Map<String, PackageManagerConfiguration> packageManagers;
    private final boolean skipExcluded;
    @Nullable
    private final Map<String, PackageManagerConfiguration> packageManagersCaseInsensitive;

    public AnalyzerConfiguration(boolean allowDynamicVersions, @Nullable List<String> enabledPackageManagers, @Nullable List<String> disabledPackageManagers, @Nullable Map<String, PackageManagerConfiguration> packageManagers, boolean skipExcluded) {
        Set duplicatePackageManagers;
        Set set;
        Object object;
        this.allowDynamicVersions = allowDynamicVersions;
        this.enabledPackageManagers = enabledPackageManagers;
        this.disabledPackageManagers = disabledPackageManagers;
        this.packageManagers = packageManagers;
        this.skipExcluded = skipExcluded;
        Map<String, PackageManagerConfiguration> map = this.packageManagers;
        this.packageManagersCaseInsensitive = map != null ? MapsKt.toSortedMap(map, (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE)) : null;
        Map<String, PackageManagerConfiguration> map2 = this.packageManagers;
        Set set2 = map2 != null ? map2.keySet() : null;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        if (((object = this.packageManagersCaseInsensitive) != null && (object = object.keySet()) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        if (!(duplicatePackageManagers = SetsKt.minus((Set)set2, (Iterable)set)).isEmpty()) {
            boolean bl = false;
            String string = "The following package managers have duplicate configuration: " + CollectionsKt.joinToString$default((Iterable)duplicatePackageManagers, null, null, null, (int)0, null, null, (int)63, null) + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AnalyzerConfiguration(boolean bl, List list, List list2, Map map, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(bl, list, list2, map, bl2);
    }

    public final boolean getAllowDynamicVersions() {
        return this.allowDynamicVersions;
    }

    @Nullable
    public final List<String> getEnabledPackageManagers() {
        return this.enabledPackageManagers;
    }

    @Nullable
    public final List<String> getDisabledPackageManagers() {
        return this.disabledPackageManagers;
    }

    @Nullable
    public final Map<String, PackageManagerConfiguration> getPackageManagers() {
        return this.packageManagers;
    }

    public final boolean getSkipExcluded() {
        return this.skipExcluded;
    }

    @Nullable
    public final PackageManagerConfiguration getPackageManagerConfiguration(@NotNull String packageManager) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        Map<String, PackageManagerConfiguration> map = this.packageManagersCaseInsensitive;
        return map != null ? map.get(packageManager) : null;
    }

    @NotNull
    public final AnalyzerConfiguration merge(@NotNull RepositoryAnalyzerConfiguration other) {
        List<String> list;
        Map map;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.packageManagers == null) {
            map = other.getPackageManagers();
        } else if (other.getPackageManagers() == null) {
            map = this.packageManagers;
        } else {
            TreeSet treeSet;
            TreeSet $this$merge_u24lambda_u241 = treeSet = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[0]);
            boolean bl = false;
            $this$merge_u24lambda_u241.addAll((Collection)this.packageManagers.keySet());
            $this$merge_u24lambda_u241.addAll((Collection)other.getPackageManagers().keySet());
            TreeSet keys = treeSet;
            SortedMap result = MapsKt.sortedMapOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Pair[])new Pair[0]);
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl2 = false;
                PackageManagerConfiguration configSelf = this.getPackageManagerConfiguration(key);
                PackageManagerConfiguration configOther = other.getPackageManagerConfiguration(key);
                ((Map)result).put(key, configSelf == null ? configOther : (configOther == null ? configSelf : configSelf.merge(configOther)));
            }
            map = result;
        }
        Map mergedPackageManagers = map;
        Boolean bl = other.getAllowDynamicVersions();
        boolean bl3 = bl != null ? bl : this.allowDynamicVersions;
        List<String> list2 = other.getEnabledPackageManagers();
        if (list2 == null) {
            list2 = this.enabledPackageManagers;
        }
        if ((list = other.getDisabledPackageManagers()) == null) {
            list = this.disabledPackageManagers;
        }
        Boolean bl4 = other.getSkipExcluded();
        return new AnalyzerConfiguration(bl3, list2, list, mergedPackageManagers, bl4 != null ? bl4 : this.skipExcluded);
    }

    @NotNull
    public final AnalyzerConfiguration withPackageManagerOption(@NotNull String name, @NotNull String key, @NotNull String value2) {
        PackageManagerConfiguration configuration;
        Map map;
        Map managers;
        PackageManagerConfiguration packageManagerConfiguration;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Map map2 = this.packageManagers;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        if ((packageManagerConfiguration = (PackageManagerConfiguration)(managers = MapsKt.toMutableMap(map2)).get(name)) == null) {
            packageManagerConfiguration = new PackageManagerConfiguration(null, null, 3, null);
        }
        if ((map = (configuration = packageManagerConfiguration).getOptions()) == null) {
            map = MapsKt.emptyMap();
        }
        Map options = MapsKt.toMutableMap(map);
        options.put(key, value2);
        managers.put(name, PackageManagerConfiguration.copy$default(configuration, null, options, 1, null));
        return AnalyzerConfiguration.copy$default(this, false, null, null, managers, false, 23, null);
    }

    public final boolean component1() {
        return this.allowDynamicVersions;
    }

    @Nullable
    public final List<String> component2() {
        return this.enabledPackageManagers;
    }

    @Nullable
    public final List<String> component3() {
        return this.disabledPackageManagers;
    }

    @Nullable
    public final Map<String, PackageManagerConfiguration> component4() {
        return this.packageManagers;
    }

    public final boolean component5() {
        return this.skipExcluded;
    }

    @NotNull
    public final AnalyzerConfiguration copy(boolean allowDynamicVersions, @Nullable List<String> enabledPackageManagers, @Nullable List<String> disabledPackageManagers, @Nullable Map<String, PackageManagerConfiguration> packageManagers, boolean skipExcluded) {
        return new AnalyzerConfiguration(allowDynamicVersions, enabledPackageManagers, disabledPackageManagers, packageManagers, skipExcluded);
    }

    public static /* synthetic */ AnalyzerConfiguration copy$default(AnalyzerConfiguration analyzerConfiguration, boolean bl, List list, List list2, Map map, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = analyzerConfiguration.allowDynamicVersions;
        }
        if ((n & 2) != 0) {
            list = analyzerConfiguration.enabledPackageManagers;
        }
        if ((n & 4) != 0) {
            list2 = analyzerConfiguration.disabledPackageManagers;
        }
        if ((n & 8) != 0) {
            map = analyzerConfiguration.packageManagers;
        }
        if ((n & 0x10) != 0) {
            bl2 = analyzerConfiguration.skipExcluded;
        }
        return analyzerConfiguration.copy(bl, list, list2, map, bl2);
    }

    @NotNull
    public String toString() {
        return "AnalyzerConfiguration(allowDynamicVersions=" + this.allowDynamicVersions + ", enabledPackageManagers=" + this.enabledPackageManagers + ", disabledPackageManagers=" + this.disabledPackageManagers + ", packageManagers=" + this.packageManagers + ", skipExcluded=" + this.skipExcluded + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.allowDynamicVersions);
        result = result * 31 + (this.enabledPackageManagers == null ? 0 : ((Object)this.enabledPackageManagers).hashCode());
        result = result * 31 + (this.disabledPackageManagers == null ? 0 : ((Object)this.disabledPackageManagers).hashCode());
        result = result * 31 + (this.packageManagers == null ? 0 : ((Object)this.packageManagers).hashCode());
        result = result * 31 + Boolean.hashCode(this.skipExcluded);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalyzerConfiguration)) {
            return false;
        }
        AnalyzerConfiguration analyzerConfiguration = (AnalyzerConfiguration)other;
        if (this.allowDynamicVersions != analyzerConfiguration.allowDynamicVersions) {
            return false;
        }
        if (!Intrinsics.areEqual(this.enabledPackageManagers, analyzerConfiguration.enabledPackageManagers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.disabledPackageManagers, analyzerConfiguration.disabledPackageManagers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.packageManagers, analyzerConfiguration.packageManagers)) {
            return false;
        }
        return this.skipExcluded == analyzerConfiguration.skipExcluded;
    }

    public AnalyzerConfiguration() {
        this(false, null, null, null, false, 31, null);
    }
}

