/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.config.HttpFileStorageConfiguration;
import org.ossreviewtoolkit.model.config.LocalFileStorageConfiguration;
import org.ossreviewtoolkit.model.config.S3FileStorageConfiguration;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;
import org.ossreviewtoolkit.utils.ort.storage.HttpFileStorage;
import org.ossreviewtoolkit.utils.ort.storage.LocalFileStorage;
import org.ossreviewtoolkit.utils.ort.storage.S3FileStorage;
import org.ossreviewtoolkit.utils.ort.storage.XZCompressedLocalFileStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0006\u0010\u0013\u001a\u00020\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/model/config/FileStorageConfiguration;", "", "httpFileStorage", "Lorg/ossreviewtoolkit/model/config/HttpFileStorageConfiguration;", "localFileStorage", "Lorg/ossreviewtoolkit/model/config/LocalFileStorageConfiguration;", "s3FileStorage", "Lorg/ossreviewtoolkit/model/config/S3FileStorageConfiguration;", "(Lorg/ossreviewtoolkit/model/config/HttpFileStorageConfiguration;Lorg/ossreviewtoolkit/model/config/LocalFileStorageConfiguration;Lorg/ossreviewtoolkit/model/config/S3FileStorageConfiguration;)V", "getHttpFileStorage", "()Lorg/ossreviewtoolkit/model/config/HttpFileStorageConfiguration;", "getLocalFileStorage", "()Lorg/ossreviewtoolkit/model/config/LocalFileStorageConfiguration;", "getS3FileStorage", "()Lorg/ossreviewtoolkit/model/config/S3FileStorageConfiguration;", "component1", "component2", "component3", "copy", "createFileStorage", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "equals", "", "other", "hashCode", "", "toString", "", "model"})
public final class FileStorageConfiguration {
    @Nullable
    private final HttpFileStorageConfiguration httpFileStorage;
    @Nullable
    private final LocalFileStorageConfiguration localFileStorage;
    @Nullable
    private final S3FileStorageConfiguration s3FileStorage;

    public FileStorageConfiguration(@Nullable HttpFileStorageConfiguration httpFileStorage, @Nullable LocalFileStorageConfiguration localFileStorage, @Nullable S3FileStorageConfiguration s3FileStorage) {
        this.httpFileStorage = httpFileStorage;
        this.localFileStorage = localFileStorage;
        this.s3FileStorage = s3FileStorage;
    }

    public /* synthetic */ FileStorageConfiguration(HttpFileStorageConfiguration httpFileStorageConfiguration, LocalFileStorageConfiguration localFileStorageConfiguration, S3FileStorageConfiguration s3FileStorageConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpFileStorageConfiguration = null;
        }
        if ((n & 2) != 0) {
            localFileStorageConfiguration = null;
        }
        if ((n & 4) != 0) {
            s3FileStorageConfiguration = null;
        }
        this(httpFileStorageConfiguration, localFileStorageConfiguration, s3FileStorageConfiguration);
    }

    @Nullable
    public final HttpFileStorageConfiguration getHttpFileStorage() {
        return this.httpFileStorage;
    }

    @Nullable
    public final LocalFileStorageConfiguration getLocalFileStorage() {
        return this.localFileStorage;
    }

    @Nullable
    public final S3FileStorageConfiguration getS3FileStorage() {
        return this.s3FileStorage;
    }

    @NotNull
    public final FileStorage createFileStorage() {
        Object[] objectArray = new Object[]{this.httpFileStorage, this.localFileStorage, this.s3FileStorage};
        Object object = CollectionsKt.singleOrNull((List)CollectionsKt.listOfNotNull((Object[])objectArray));
        if (object == null) {
            boolean bl = false;
            String string = "Exactly one implementation must be configured for a FileStorage.";
            throw new IllegalArgumentException(string.toString());
        }
        Object storage = object;
        if (storage instanceof HttpFileStorageConfiguration) {
            return (FileStorage)new HttpFileStorage(((HttpFileStorageConfiguration)storage).getUrl(), ((HttpFileStorageConfiguration)storage).getQuery(), ((HttpFileStorageConfiguration)storage).getHeaders(), 0, 8, null);
        }
        if (storage instanceof S3FileStorageConfiguration) {
            return (FileStorage)new S3FileStorage(((S3FileStorageConfiguration)storage).getAccessKeyId(), ((S3FileStorageConfiguration)storage).getAwsRegion(), ((S3FileStorageConfiguration)storage).getBucketName(), ((S3FileStorageConfiguration)storage).getCompression(), ((S3FileStorageConfiguration)storage).getCustomEndpoint(), ((S3FileStorageConfiguration)storage).getSecretAccessKey());
        }
        if (!(storage instanceof LocalFileStorageConfiguration)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        File directory = ExtensionsKt.expandTilde((File)((LocalFileStorageConfiguration)storage).getDirectory());
        return ((LocalFileStorageConfiguration)storage).getCompression() ? (FileStorage)new XZCompressedLocalFileStorage(directory) : (FileStorage)new LocalFileStorage(directory);
    }

    @Nullable
    public final HttpFileStorageConfiguration component1() {
        return this.httpFileStorage;
    }

    @Nullable
    public final LocalFileStorageConfiguration component2() {
        return this.localFileStorage;
    }

    @Nullable
    public final S3FileStorageConfiguration component3() {
        return this.s3FileStorage;
    }

    @NotNull
    public final FileStorageConfiguration copy(@Nullable HttpFileStorageConfiguration httpFileStorage, @Nullable LocalFileStorageConfiguration localFileStorage, @Nullable S3FileStorageConfiguration s3FileStorage) {
        return new FileStorageConfiguration(httpFileStorage, localFileStorage, s3FileStorage);
    }

    public static /* synthetic */ FileStorageConfiguration copy$default(FileStorageConfiguration fileStorageConfiguration, HttpFileStorageConfiguration httpFileStorageConfiguration, LocalFileStorageConfiguration localFileStorageConfiguration, S3FileStorageConfiguration s3FileStorageConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            httpFileStorageConfiguration = fileStorageConfiguration.httpFileStorage;
        }
        if ((n & 2) != 0) {
            localFileStorageConfiguration = fileStorageConfiguration.localFileStorage;
        }
        if ((n & 4) != 0) {
            s3FileStorageConfiguration = fileStorageConfiguration.s3FileStorage;
        }
        return fileStorageConfiguration.copy(httpFileStorageConfiguration, localFileStorageConfiguration, s3FileStorageConfiguration);
    }

    @NotNull
    public String toString() {
        return "FileStorageConfiguration(httpFileStorage=" + this.httpFileStorage + ", localFileStorage=" + this.localFileStorage + ", s3FileStorage=" + this.s3FileStorage + ")";
    }

    public int hashCode() {
        int result = this.httpFileStorage == null ? 0 : this.httpFileStorage.hashCode();
        result = result * 31 + (this.localFileStorage == null ? 0 : this.localFileStorage.hashCode());
        result = result * 31 + (this.s3FileStorage == null ? 0 : this.s3FileStorage.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileStorageConfiguration)) {
            return false;
        }
        FileStorageConfiguration fileStorageConfiguration = (FileStorageConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.httpFileStorage, (Object)fileStorageConfiguration.httpFileStorage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.localFileStorage, (Object)fileStorageConfiguration.localFileStorage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.s3FileStorage, (Object)fileStorageConfiguration.s3FileStorage);
    }

    public FileStorageConfiguration() {
        this(null, null, null, 7, null);
    }
}

