/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.config.IssueResolutionReason;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/model/config/IssueResolution;", "", "message", "", "reason", "Lorg/ossreviewtoolkit/model/config/IssueResolutionReason;", "comment", "(Ljava/lang/String;Lorg/ossreviewtoolkit/model/config/IssueResolutionReason;Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "getMessage", "getReason", "()Lorg/ossreviewtoolkit/model/config/IssueResolutionReason;", "regex", "Lkotlin/text/Regex;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "matches", "issue", "Lorg/ossreviewtoolkit/model/Issue;", "toString", "model"})
public final class IssueResolution {
    @NotNull
    private final String message;
    @NotNull
    private final IssueResolutionReason reason;
    @NotNull
    private final String comment;
    @NotNull
    private final Regex regex;

    public IssueResolution(@NotNull String message, @NotNull IssueResolutionReason reason, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.message = message;
        this.reason = reason;
        this.comment = comment;
        this.regex = new Regex(ExtensionsKt.collapseWhitespace((String)this.message), RegexOption.DOT_MATCHES_ALL);
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final IssueResolutionReason getReason() {
        return this.reason;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    public final boolean matches(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.regex.matches((CharSequence)ExtensionsKt.collapseWhitespace((String)issue.getMessage()));
    }

    @NotNull
    public final String component1() {
        return this.message;
    }

    @NotNull
    public final IssueResolutionReason component2() {
        return this.reason;
    }

    @NotNull
    public final String component3() {
        return this.comment;
    }

    @NotNull
    public final IssueResolution copy(@NotNull String message, @NotNull IssueResolutionReason reason, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        return new IssueResolution(message, reason, comment);
    }

    public static /* synthetic */ IssueResolution copy$default(IssueResolution issueResolution, String string, IssueResolutionReason issueResolutionReason, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = issueResolution.message;
        }
        if ((n & 2) != 0) {
            issueResolutionReason = issueResolution.reason;
        }
        if ((n & 4) != 0) {
            string2 = issueResolution.comment;
        }
        return issueResolution.copy(string, issueResolutionReason, string2);
    }

    @NotNull
    public String toString() {
        return "IssueResolution(message=" + this.message + ", reason=" + this.reason + ", comment=" + this.comment + ")";
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = result * 31 + this.reason.hashCode();
        result = result * 31 + this.comment.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IssueResolution)) {
            return false;
        }
        IssueResolution issueResolution = (IssueResolution)other;
        if (!Intrinsics.areEqual((Object)this.message, (Object)issueResolution.message)) {
            return false;
        }
        if (this.reason != issueResolution.reason) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.comment, (Object)issueResolution.comment);
    }
}

