/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.ArtifactProvenance;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.UnknownProvenance;
import org.ossreviewtoolkit.model.config.LicenseFindingCuration;
import org.ossreviewtoolkit.model.config.PathExclude;
import org.ossreviewtoolkit.model.config.VcsMatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0003\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003JK\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0003\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0003\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lorg/ossreviewtoolkit/model/config/PackageConfiguration;", "", "id", "Lorg/ossreviewtoolkit/model/Identifier;", "sourceArtifactUrl", "", "vcs", "Lorg/ossreviewtoolkit/model/config/VcsMatcher;", "pathExcludes", "", "Lorg/ossreviewtoolkit/model/config/PathExclude;", "licenseFindingCurations", "Lorg/ossreviewtoolkit/model/config/LicenseFindingCuration;", "(Lorg/ossreviewtoolkit/model/Identifier;Ljava/lang/String;Lorg/ossreviewtoolkit/model/config/VcsMatcher;Ljava/util/List;Ljava/util/List;)V", "getId", "()Lorg/ossreviewtoolkit/model/Identifier;", "getLicenseFindingCurations", "()Ljava/util/List;", "getPathExcludes", "getSourceArtifactUrl", "()Ljava/lang/String;", "getVcs", "()Lorg/ossreviewtoolkit/model/config/VcsMatcher;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "matches", "otherId", "provenance", "Lorg/ossreviewtoolkit/model/Provenance;", "toString", "model"})
public final class PackageConfiguration {
    @NotNull
    private final Identifier id;
    @Nullable
    private final String sourceArtifactUrl;
    @Nullable
    private final VcsMatcher vcs;
    @NotNull
    private final List<PathExclude> pathExcludes;
    @NotNull
    private final List<LicenseFindingCuration> licenseFindingCurations;

    public PackageConfiguration(@NotNull Identifier id, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable String sourceArtifactUrl, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable VcsMatcher vcs, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<PathExclude> pathExcludes, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<LicenseFindingCuration> licenseFindingCurations) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(pathExcludes, (String)"pathExcludes");
        Intrinsics.checkNotNullParameter(licenseFindingCurations, (String)"licenseFindingCurations");
        this.id = id;
        this.sourceArtifactUrl = sourceArtifactUrl;
        this.vcs = vcs;
        this.pathExcludes = pathExcludes;
        this.licenseFindingCurations = licenseFindingCurations;
        if (!(this.sourceArtifactUrl == null ^ this.vcs == null)) {
            boolean bl = false;
            String string = "A package configuration can either apply to a source artifact or to a VCS, not to neither or both.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PackageConfiguration(Identifier identifier, String string, VcsMatcher vcsMatcher, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            vcsMatcher = null;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(identifier, string, vcsMatcher, list, list2);
    }

    @NotNull
    public final Identifier getId() {
        return this.id;
    }

    @Nullable
    public final String getSourceArtifactUrl() {
        return this.sourceArtifactUrl;
    }

    @Nullable
    public final VcsMatcher getVcs() {
        return this.vcs;
    }

    @NotNull
    public final List<PathExclude> getPathExcludes() {
        return this.pathExcludes;
    }

    @NotNull
    public final List<LicenseFindingCuration> getLicenseFindingCurations() {
        return this.licenseFindingCurations;
    }

    public final boolean matches(@NotNull Identifier otherId, @NotNull Provenance provenance) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)otherId, (String)"otherId");
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        if (!Intrinsics.areEqual((Object)this.id, (Object)otherId)) {
            return false;
        }
        Provenance provenance2 = provenance;
        if (provenance2 instanceof UnknownProvenance) {
            bl = false;
        } else if (provenance2 instanceof ArtifactProvenance) {
            bl = this.sourceArtifactUrl != null && Intrinsics.areEqual((Object)this.sourceArtifactUrl, (Object)((ArtifactProvenance)provenance).getSourceArtifact().getUrl());
        } else if (provenance2 instanceof RepositoryProvenance) {
            bl = this.vcs != null && this.vcs.matches((RepositoryProvenance)provenance);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Identifier component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.sourceArtifactUrl;
    }

    @Nullable
    public final VcsMatcher component3() {
        return this.vcs;
    }

    @NotNull
    public final List<PathExclude> component4() {
        return this.pathExcludes;
    }

    @NotNull
    public final List<LicenseFindingCuration> component5() {
        return this.licenseFindingCurations;
    }

    @NotNull
    public final PackageConfiguration copy(@NotNull Identifier id, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable String sourceArtifactUrl, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable VcsMatcher vcs, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<PathExclude> pathExcludes, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<LicenseFindingCuration> licenseFindingCurations) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(pathExcludes, (String)"pathExcludes");
        Intrinsics.checkNotNullParameter(licenseFindingCurations, (String)"licenseFindingCurations");
        return new PackageConfiguration(id, sourceArtifactUrl, vcs, pathExcludes, licenseFindingCurations);
    }

    public static /* synthetic */ PackageConfiguration copy$default(PackageConfiguration packageConfiguration, Identifier identifier, String string, VcsMatcher vcsMatcher, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            identifier = packageConfiguration.id;
        }
        if ((n & 2) != 0) {
            string = packageConfiguration.sourceArtifactUrl;
        }
        if ((n & 4) != 0) {
            vcsMatcher = packageConfiguration.vcs;
        }
        if ((n & 8) != 0) {
            list = packageConfiguration.pathExcludes;
        }
        if ((n & 0x10) != 0) {
            list2 = packageConfiguration.licenseFindingCurations;
        }
        return packageConfiguration.copy(identifier, string, vcsMatcher, list, list2);
    }

    @NotNull
    public String toString() {
        return "PackageConfiguration(id=" + this.id + ", sourceArtifactUrl=" + this.sourceArtifactUrl + ", vcs=" + this.vcs + ", pathExcludes=" + this.pathExcludes + ", licenseFindingCurations=" + this.licenseFindingCurations + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + (this.sourceArtifactUrl == null ? 0 : this.sourceArtifactUrl.hashCode());
        result = result * 31 + (this.vcs == null ? 0 : this.vcs.hashCode());
        result = result * 31 + ((Object)this.pathExcludes).hashCode();
        result = result * 31 + ((Object)this.licenseFindingCurations).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackageConfiguration)) {
            return false;
        }
        PackageConfiguration packageConfiguration = (PackageConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)packageConfiguration.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceArtifactUrl, (Object)packageConfiguration.sourceArtifactUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vcs, (Object)packageConfiguration.vcs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pathExcludes, packageConfiguration.pathExcludes)) {
            return false;
        }
        return Intrinsics.areEqual(this.licenseFindingCurations, packageConfiguration.licenseFindingCurations);
    }
}

