/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.config.IssueResolution;
import org.ossreviewtoolkit.model.config.RuleViolationResolution;
import org.ossreviewtoolkit.model.config.VulnerabilityResolution;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J9\u0010\u0011\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/model/config/Resolutions;", "", "issues", "", "Lorg/ossreviewtoolkit/model/config/IssueResolution;", "ruleViolations", "Lorg/ossreviewtoolkit/model/config/RuleViolationResolution;", "vulnerabilities", "Lorg/ossreviewtoolkit/model/config/VulnerabilityResolution;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getIssues", "()Ljava/util/List;", "getRuleViolations", "getVulnerabilities", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "merge", "toString", "", "model"})
public final class Resolutions {
    @NotNull
    private final List<IssueResolution> issues;
    @NotNull
    private final List<RuleViolationResolution> ruleViolations;
    @NotNull
    private final List<VulnerabilityResolution> vulnerabilities;

    public Resolutions(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<IssueResolution> issues, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<RuleViolationResolution> ruleViolations, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<VulnerabilityResolution> vulnerabilities) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(ruleViolations, (String)"ruleViolations");
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        this.issues = issues;
        this.ruleViolations = ruleViolations;
        this.vulnerabilities = vulnerabilities;
    }

    public /* synthetic */ Resolutions(List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(list, list2, list3);
    }

    @NotNull
    public final List<IssueResolution> getIssues() {
        return this.issues;
    }

    @NotNull
    public final List<RuleViolationResolution> getRuleViolations() {
        return this.ruleViolations;
    }

    @NotNull
    public final List<VulnerabilityResolution> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @NotNull
    public final Resolutions merge(@NotNull Resolutions other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Resolutions(CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.issues, (Iterable)other.issues)), CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.ruleViolations, (Iterable)other.ruleViolations)), CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.vulnerabilities, (Iterable)other.vulnerabilities)));
    }

    @NotNull
    public final List<IssueResolution> component1() {
        return this.issues;
    }

    @NotNull
    public final List<RuleViolationResolution> component2() {
        return this.ruleViolations;
    }

    @NotNull
    public final List<VulnerabilityResolution> component3() {
        return this.vulnerabilities;
    }

    @NotNull
    public final Resolutions copy(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<IssueResolution> issues, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<RuleViolationResolution> ruleViolations, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<VulnerabilityResolution> vulnerabilities) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(ruleViolations, (String)"ruleViolations");
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        return new Resolutions(issues, ruleViolations, vulnerabilities);
    }

    public static /* synthetic */ Resolutions copy$default(Resolutions resolutions, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = resolutions.issues;
        }
        if ((n & 2) != 0) {
            list2 = resolutions.ruleViolations;
        }
        if ((n & 4) != 0) {
            list3 = resolutions.vulnerabilities;
        }
        return resolutions.copy(list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "Resolutions(issues=" + this.issues + ", ruleViolations=" + this.ruleViolations + ", vulnerabilities=" + this.vulnerabilities + ")";
    }

    public int hashCode() {
        int result = ((Object)this.issues).hashCode();
        result = result * 31 + ((Object)this.ruleViolations).hashCode();
        result = result * 31 + ((Object)this.vulnerabilities).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resolutions)) {
            return false;
        }
        Resolutions resolutions = (Resolutions)other;
        if (!Intrinsics.areEqual(this.issues, resolutions.issues)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ruleViolations, resolutions.ruleViolations)) {
            return false;
        }
        return Intrinsics.areEqual(this.vulnerabilities, resolutions.vulnerabilities);
    }

    public Resolutions() {
        this(null, null, null, 7, null);
    }
}

