/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/model/config/VcsMatcher;", "", "type", "Lorg/ossreviewtoolkit/model/VcsType;", "url", "", "revision", "(Lorg/ossreviewtoolkit/model/VcsType;Ljava/lang/String;Ljava/lang/String;)V", "getRevision", "()Ljava/lang/String;", "getType", "()Lorg/ossreviewtoolkit/model/VcsType;", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "matches", "provenance", "Lorg/ossreviewtoolkit/model/RepositoryProvenance;", "toString", "model"})
public final class VcsMatcher {
    @NotNull
    private final VcsType type;
    @NotNull
    private final String url;
    @Nullable
    private final String revision;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VcsMatcher(@NotNull VcsType type, @NotNull String url, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable String revision) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.type = type;
        this.url = url;
        this.revision = revision;
        if (!StringsKt.isBlank((CharSequence)this.url)) {
            String string = this.revision;
            if (string == null) return;
            if (!StringsKt.isBlank((CharSequence)string)) return;
            boolean bl = true;
            if (!bl) {
                return;
            }
        }
        boolean bl = false;
        if (bl) return;
        String string = "Failed requirement.";
        throw new IllegalArgumentException(string.toString());
    }

    public /* synthetic */ VcsMatcher(VcsType vcsType, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(vcsType, string, string2);
    }

    @NotNull
    public final VcsType getType() {
        return this.type;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Nullable
    public final String getRevision() {
        return this.revision;
    }

    public final boolean matches(@NotNull RepositoryProvenance provenance) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        return Intrinsics.areEqual((Object)this.type, (Object)provenance.getVcsInfo().getType()) && Intrinsics.areEqual((Object)ExtensionsKt.replaceCredentialsInUri$default((String)this.url, null, (int)1, null), (Object)ExtensionsKt.replaceCredentialsInUri$default((String)provenance.getVcsInfo().getUrl(), null, (int)1, null)) && (this.revision == null || Intrinsics.areEqual((Object)this.revision, (Object)provenance.getResolvedRevision()));
    }

    @NotNull
    public final VcsType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.url;
    }

    @Nullable
    public final String component3() {
        return this.revision;
    }

    @NotNull
    public final VcsMatcher copy(@NotNull VcsType type, @NotNull String url, @JsonInclude(value=JsonInclude.Include.NON_NULL) @Nullable String revision) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new VcsMatcher(type, url, revision);
    }

    public static /* synthetic */ VcsMatcher copy$default(VcsMatcher vcsMatcher, VcsType vcsType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            vcsType = vcsMatcher.type;
        }
        if ((n & 2) != 0) {
            string = vcsMatcher.url;
        }
        if ((n & 4) != 0) {
            string2 = vcsMatcher.revision;
        }
        return vcsMatcher.copy(vcsType, string, string2);
    }

    @NotNull
    public String toString() {
        return "VcsMatcher(type=" + this.type + ", url=" + this.url + ", revision=" + this.revision + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VcsMatcher)) {
            return false;
        }
        VcsMatcher vcsMatcher = (VcsMatcher)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)vcsMatcher.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)vcsMatcher.url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.revision, (Object)vcsMatcher.revision);
    }
}

