/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.config.VulnerabilityResolutionReason;
import org.ossreviewtoolkit.model.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/model/config/VulnerabilityResolution;", "", "id", "", "reason", "Lorg/ossreviewtoolkit/model/config/VulnerabilityResolutionReason;", "comment", "(Ljava/lang/String;Lorg/ossreviewtoolkit/model/config/VulnerabilityResolutionReason;Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "getId", "getReason", "()Lorg/ossreviewtoolkit/model/config/VulnerabilityResolutionReason;", "regex", "Lkotlin/text/Regex;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "matches", "vulnerability", "Lorg/ossreviewtoolkit/model/vulnerabilities/Vulnerability;", "toString", "model"})
public final class VulnerabilityResolution {
    @NotNull
    private final String id;
    @NotNull
    private final VulnerabilityResolutionReason reason;
    @NotNull
    private final String comment;
    @NotNull
    private final Regex regex;

    public VulnerabilityResolution(@NotNull String id, @NotNull VulnerabilityResolutionReason reason, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.id = id;
        this.reason = reason;
        this.comment = comment;
        this.regex = new Regex(this.id, RegexOption.DOT_MATCHES_ALL);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final VulnerabilityResolutionReason getReason() {
        return this.reason;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    public final boolean matches(@NotNull Vulnerability vulnerability) {
        Intrinsics.checkNotNullParameter((Object)vulnerability, (String)"vulnerability");
        return this.regex.matches((CharSequence)vulnerability.getId());
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final VulnerabilityResolutionReason component2() {
        return this.reason;
    }

    @NotNull
    public final String component3() {
        return this.comment;
    }

    @NotNull
    public final VulnerabilityResolution copy(@NotNull String id, @NotNull VulnerabilityResolutionReason reason, @NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        return new VulnerabilityResolution(id, reason, comment);
    }

    public static /* synthetic */ VulnerabilityResolution copy$default(VulnerabilityResolution vulnerabilityResolution, String string, VulnerabilityResolutionReason vulnerabilityResolutionReason, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = vulnerabilityResolution.id;
        }
        if ((n & 2) != 0) {
            vulnerabilityResolutionReason = vulnerabilityResolution.reason;
        }
        if ((n & 4) != 0) {
            string2 = vulnerabilityResolution.comment;
        }
        return vulnerabilityResolution.copy(string, vulnerabilityResolutionReason, string2);
    }

    @NotNull
    public String toString() {
        return "VulnerabilityResolution(id=" + this.id + ", reason=" + this.reason + ", comment=" + this.comment + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.reason.hashCode();
        result = result * 31 + this.comment.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VulnerabilityResolution)) {
            return false;
        }
        VulnerabilityResolution vulnerabilityResolution = (VulnerabilityResolution)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)vulnerabilityResolution.id)) {
            return false;
        }
        if (this.reason != vulnerabilityResolution.reason) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.comment, (Object)vulnerabilityResolution.comment);
    }
}

