/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.licenses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.CuratedPackage;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageCurationResult;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.ScanSummary;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.LicenseFindingCuration;
import org.ossreviewtoolkit.model.config.PackageConfiguration;
import org.ossreviewtoolkit.model.config.PathExclude;
import org.ossreviewtoolkit.model.licenses.ConcludedLicenseInfo;
import org.ossreviewtoolkit.model.licenses.Configuration;
import org.ossreviewtoolkit.model.licenses.DeclaredLicenseInfo;
import org.ossreviewtoolkit.model.licenses.DetectedLicenseInfo;
import org.ossreviewtoolkit.model.licenses.Findings;
import org.ossreviewtoolkit.model.licenses.LicenseInfo;
import org.ossreviewtoolkit.model.licenses.LicenseInfoProvider;
import org.ossreviewtoolkit.model.utils.ScanResultUtilsKt;
import org.ossreviewtoolkit.utils.ort.ProcessedDeclaredLicense;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/ossreviewtoolkit/model/licenses/DefaultLicenseInfoProvider;", "Lorg/ossreviewtoolkit/model/licenses/LicenseInfoProvider;", "ortResult", "Lorg/ossreviewtoolkit/model/OrtResult;", "(Lorg/ossreviewtoolkit/model/OrtResult;)V", "licenseInfo", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/ossreviewtoolkit/model/Identifier;", "Lorg/ossreviewtoolkit/model/licenses/LicenseInfo;", "getOrtResult", "()Lorg/ossreviewtoolkit/model/OrtResult;", "createConcludedLicenseInfo", "Lorg/ossreviewtoolkit/model/licenses/ConcludedLicenseInfo;", "id", "createDeclaredLicenseInfo", "Lorg/ossreviewtoolkit/model/licenses/DeclaredLicenseInfo;", "createDetectedLicenseInfo", "Lorg/ossreviewtoolkit/model/licenses/DetectedLicenseInfo;", "createLicenseInfo", "get", "getConfiguration", "Lorg/ossreviewtoolkit/model/licenses/Configuration;", "provenance", "Lorg/ossreviewtoolkit/model/Provenance;", "model"})
@SourceDebugExtension(value={"SMAP\nDefaultLicenseInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLicenseInfoProvider.kt\norg/ossreviewtoolkit/model/licenses/DefaultLicenseInfoProvider\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n72#2,2:126\n1#3:128\n1#3:129\n766#4:130\n857#4,2:131\n766#4:133\n857#4,2:134\n1549#4:136\n1620#4,3:137\n1855#4,2:140\n1360#4:142\n1446#4,5:143\n1360#4:148\n1446#4,5:149\n*S KotlinDebug\n*F\n+ 1 DefaultLicenseInfoProvider.kt\norg/ossreviewtoolkit/model/licenses/DefaultLicenseInfoProvider\n*L\n39#1:126,2\n39#1:128\n53#1:130\n53#1:131,2\n70#1:133\n70#1:134,2\n82#1:136\n82#1:137,3\n88#1:140,2\n113#1:142\n113#1:143,5\n114#1:148\n114#1:149,5\n*E\n"})
public final class DefaultLicenseInfoProvider
implements LicenseInfoProvider {
    @NotNull
    private final OrtResult ortResult;
    @NotNull
    private final ConcurrentMap<Identifier, LicenseInfo> licenseInfo;

    public DefaultLicenseInfoProvider(@NotNull OrtResult ortResult) {
        Intrinsics.checkNotNullParameter((Object)ortResult, (String)"ortResult");
        this.ortResult = ortResult;
        this.licenseInfo = new ConcurrentHashMap();
    }

    @NotNull
    public final OrtResult getOrtResult() {
        return this.ortResult;
    }

    @Override
    @NotNull
    public LicenseInfo get(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ConcurrentMap<Identifier, LicenseInfo> $this$getOrPut$iv = this.licenseInfo;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(id);
        if (object == null) {
            boolean bl = false;
            LicenseInfo default$iv = this.createLicenseInfo(id);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(id, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (LicenseInfo)object;
    }

    private final LicenseInfo createLicenseInfo(Identifier id) {
        ConcludedLicenseInfo concludedLicenseInfo = this.createConcludedLicenseInfo(id);
        DeclaredLicenseInfo declaredLicenseInfo = this.createDeclaredLicenseInfo(id);
        DetectedLicenseInfo detectedLicenseInfo = this.createDetectedLicenseInfo(id);
        return new LicenseInfo(id, declaredLicenseInfo, detectedLicenseInfo, concludedLicenseInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final ConcludedLicenseInfo createConcludedLicenseInfo(Identifier id) {
        ConcludedLicenseInfo concludedLicenseInfo;
        CuratedPackage curatedPackage = this.ortResult.getPackage(id);
        if (curatedPackage != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            CuratedPackage curatedPackage2 = curatedPackage;
            boolean bl = false;
            Package pkg = curatedPackage2.component1();
            List<PackageCurationResult> curations = curatedPackage2.component2();
            Iterable iterable = curations;
            SpdxExpression spdxExpression = pkg.getConcludedLicense();
            boolean $i$f$filter = false;
            void var9_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PackageCurationResult it = (PackageCurationResult)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getCuration().getConcludedLicense() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            SpdxExpression spdxExpression2 = spdxExpression;
            concludedLicenseInfo = new ConcludedLicenseInfo(spdxExpression2, list);
        } else {
            concludedLicenseInfo = new ConcludedLicenseInfo(null, CollectionsKt.emptyList());
        }
        return concludedLicenseInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final DeclaredLicenseInfo createDeclaredLicenseInfo(Identifier id) {
        DeclaredLicenseInfo declaredLicenseInfo;
        Project project = this.ortResult.getProject(id);
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            declaredLicenseInfo = new DeclaredLicenseInfo(project2.getAuthors(), project2.getDeclaredLicenses(), project2.getDeclaredLicensesProcessed(), CollectionsKt.emptyList());
        } else {
            CuratedPackage curatedPackage = this.ortResult.getPackage(id);
            if (curatedPackage != null) {
                List list;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                CuratedPackage curatedPackage2 = curatedPackage;
                boolean bl = false;
                Package pkg = curatedPackage2.component1();
                List<PackageCurationResult> curations = curatedPackage2.component2();
                Iterable iterable = curations;
                ProcessedDeclaredLicense processedDeclaredLicense = pkg.getDeclaredLicensesProcessed();
                Set<String> set = pkg.getDeclaredLicenses();
                Set<String> set2 = pkg.getAuthors();
                boolean $i$f$filter = false;
                void var12_13 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PackageCurationResult it = (PackageCurationResult)element$iv$iv;
                    boolean bl2 = false;
                    boolean bl3 = !it.getCuration().getDeclaredLicenseMapping().isEmpty();
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = list = (List)destination$iv$iv;
                ProcessedDeclaredLicense processedDeclaredLicense2 = processedDeclaredLicense;
                Set<String> set3 = set;
                Set<String> set4 = set2;
                declaredLicenseInfo = new DeclaredLicenseInfo(set4, set3, processedDeclaredLicense2, list2);
            } else {
                declaredLicenseInfo = new DeclaredLicenseInfo(SetsKt.emptySet(), SetsKt.emptySet(), new ProcessedDeclaredLicense(null, null, null, 6, null), CollectionsKt.emptyList());
            }
        }
        return declaredLicenseInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final DetectedLicenseInfo createDetectedLicenseInfo(Identifier id) {
        void $this$mapTo$iv$iv;
        List findings = new ArrayList();
        Iterable $this$map$iv = this.ortResult.getScanResultsForId(id);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string;
            ScanResult scanResult = (ScanResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.ortResult.getPackage(id);
            if ((object != null && (object = ((CuratedPackage)object).getMetadata()) != null && (object = ((Package)object).getVcsProcessed()) != null ? ((VcsInfo)object).getPath() : (string = null)) == null) {
                string = "";
            }
            collection.add(ScanResultUtilsKt.filterByVcsPath((ScanResult)it, string));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScanResult scanResult = (ScanResult)element$iv;
            boolean bl = false;
            Provenance provenance = scanResult.component1();
            ScanSummary summary = scanResult.component3();
            Configuration config = this.getConfiguration(id, provenance);
            ((Collection)findings).add(new Findings(provenance, summary.getLicenseFindings(), summary.getCopyrightFindings(), config.getLicenseFindingCurations(), config.getPathExcludes(), config.getRelativeFindingsPath()));
        }
        return new DetectedLicenseInfo(findings);
    }

    private final Configuration getConfiguration(Identifier id, Provenance provenance) {
        Configuration configuration;
        Project project = this.ortResult.getProject(id);
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            List<LicenseFindingCuration> list = this.ortResult.getRepository().getConfig().getCurations().getLicenseFindings();
            List<PathExclude> list2 = this.ortResult.getRepository().getConfig().getExcludes().getPaths();
            String string = this.ortResult.getRepository().getRelativePath(project2.getVcsProcessed());
            if (string == null) {
                string = "";
            }
            configuration = new Configuration(list, list2, string);
        } else {
            Iterable list$iv$iv;
            PackageConfiguration it;
            Iterable $this$flatMapTo$iv$iv;
            List<PackageConfiguration> packageConfigurations2 = this.ortResult.getPackageConfigurations(id, provenance);
            boolean bl = false;
            Iterable $this$flatMap$iv = packageConfigurations2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (PackageConfiguration)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.getLicenseFindingCurations();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = packageConfigurations2;
            List list = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (PackageConfiguration)element$iv$iv;
                boolean bl3 = false;
                list$iv$iv = it.getPathExcludes();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            String string = "";
            List list3 = (List)destination$iv$iv;
            List list4 = list;
            configuration = new Configuration(list4, list3, string);
        }
        return configuration;
    }
}

