/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.licenses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.licenses.LicenseCategorization;
import org.ossreviewtoolkit.model.licenses.LicenseCategory;
import org.ossreviewtoolkit.model.licenses.LicenseClassifications;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u001d\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0019\u0010!\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\"\u001a\u00020#H\u0086\u0002J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\t\u0010(\u001a\u00020\u000eH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR-\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R-\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000b8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/ossreviewtoolkit/model/licenses/LicenseClassifications;", "", "categories", "", "Lorg/ossreviewtoolkit/model/licenses/LicenseCategory;", "categorizations", "Lorg/ossreviewtoolkit/model/licenses/LicenseCategorization;", "(Ljava/util/List;Ljava/util/List;)V", "getCategories", "()Ljava/util/List;", "categoriesByLicense", "", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "", "", "getCategoriesByLicense", "()Ljava/util/Map;", "categoriesByLicense$delegate", "Lkotlin/Lazy;", "getCategorizations", "categoryNames", "getCategoryNames", "()Ljava/util/Set;", "categoryNames$delegate", "licensesByCategory", "getLicensesByCategory", "licensesByCategory$delegate", "component1", "component2", "copy", "equals", "", "other", "get", "id", "Lorg/ossreviewtoolkit/utils/spdx/SpdxExpression;", "hashCode", "", "isCategorized", "merge", "toString", "model"})
@SourceDebugExtension(value={"SMAP\nLicenseClassifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseClassifications.kt\norg/ossreviewtoolkit/model/licenses/LicenseClassifications\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,143:1\n1271#2,2:144\n1285#2,2:146\n819#2:148\n847#2,2:149\n1288#2:151\n1855#2:159\n857#2,2:160\n1856#2:162\n1855#2:163\n1856#2:171\n766#2:172\n857#2,2:173\n551#3:152\n536#3,6:153\n372#3,7:164\n125#4:175\n152#4,3:176\n*S KotlinDebug\n*F\n+ 1 LicenseClassifications.kt\norg/ossreviewtoolkit/model/licenses/LicenseClassifications\n*L\n89#1:144,2\n89#1:146,2\n89#1:148\n89#1:149,2\n89#1:151\n118#1:159\n119#1:160,2\n118#1:162\n124#1:163\n124#1:171\n131#1:172\n131#1:173,2\n90#1:152\n90#1:153,6\n125#1:164,7\n132#1:175\n132#1:176,3\n*E\n"})
public final class LicenseClassifications {
    @NotNull
    private final List<LicenseCategory> categories;
    @NotNull
    private final List<LicenseCategorization> categorizations;
    @NotNull
    private final Lazy licensesByCategory$delegate;
    @NotNull
    private final Lazy categoriesByLicense$delegate;
    @NotNull
    private final Lazy categoryNames$delegate;

    /*
     * WARNING - void declaration
     */
    public LicenseClassifications(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<LicenseCategory> categories, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<LicenseCategorization> categorizations) {
        void $this$filterNotTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter(categorizations, (String)"categorizations");
        this.categories = categories;
        this.categorizations = categorizations;
        this.licensesByCategory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends Set<SpdxSingleLicenseExpression>>>(this){
            final /* synthetic */ LicenseClassifications this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, Set<SpdxSingleLicenseExpression>> invoke() {
                Map map;
                LicenseClassifications licenseClassifications = this.this$0;
                Map $this$invoke_u24lambda_u244 = map = MapsKt.createMapBuilder();
                boolean bl = false;
                Iterable $this$forEach$iv = licenseClassifications.getCategorizations();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LicenseCategorization license = (LicenseCategorization)element$iv;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv2 = license.getCategories();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Object object;
                        String category = (String)element$iv2;
                        boolean bl3 = false;
                        Map $this$getOrPut$iv = $this$invoke_u24lambda_u244;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(category);
                        if (value$iv == null) {
                            boolean bl4 = false;
                            Set answer$iv = new LinkedHashSet<E>();
                            $this$getOrPut$iv.put(category, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        Collection collection = (Collection)object;
                        collection.add(license.getId());
                    }
                }
                $this$forEach$iv = licenseClassifications.getCategories();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LicenseCategory category = (LicenseCategory)element$iv;
                    boolean bl5 = false;
                    $this$invoke_u24lambda_u244.putIfAbsent(category.getName(), (Set)new LinkedHashSet<E>());
                }
                return MapsKt.build((Map)map);
            }
        }));
        this.categoriesByLicense$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<SpdxSingleLicenseExpression, ? extends Set<? extends String>>>(this){
            final /* synthetic */ LicenseClassifications this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<SpdxSingleLicenseExpression, Set<String>> invoke() {
                void $this$associateTo$iv$iv;
                Iterable $this$associate$iv = this.this$0.getCategorizations();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    LicenseCategorization it = (LicenseCategorization)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getId(), it.getCategories());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                return destination$iv$iv;
            }
        }));
        this.categoryNames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TreeSet<String>>(this){
            final /* synthetic */ LicenseClassifications this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TreeSet<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getCategories();
                Collection destination$iv = SetsKt.sortedSetOf((Object[])new String[0]);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    LicenseCategory licenseCategory = (LicenseCategory)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                return (TreeSet)var2_2;
            }
        }));
        Map duplicates = ExtensionsKt.getDuplicates((Collection)this.categories, (Function1)1.INSTANCE);
        boolean bl = false;
        if (!duplicates.isEmpty()) {
            boolean $i$a$-require-LicenseClassifications$2$22 = false;
            String $i$a$-require-LicenseClassifications$2$22 = "Found multiple license categories with the same name: " + duplicates.keySet();
            throw new IllegalArgumentException($i$a$-require-LicenseClassifications$2$22.toString());
        }
        duplicates = ExtensionsKt.getDuplicates((Collection)this.categorizations, (Function1)3.INSTANCE);
        boolean bl2 = false;
        if (!duplicates.isEmpty()) {
            boolean $i$a$-require-LicenseClassifications$4$22 = false;
            String $i$a$-require-LicenseClassifications$4$22 = "Found multiple license categorizations with the same id: " + duplicates.keySet();
            throw new IllegalArgumentException($i$a$-require-LicenseClassifications$4$22.toString());
        }
        Iterable $this$associateWith$iv = this.categorizations;
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterNotTo$iv$iv2;
            void $this$filterNot$iv;
            LicenseCategorization licenseCategorization = (LicenseCategorization)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl3 = false;
            Iterable iterable = ((LicenseCategorization)it).getCategories();
            Set<String> set = this.getCategoryNames();
            boolean $i$f$filterNot = false;
            void var15_26 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv2) {
                String p0 = (String)element$iv$iv2;
                boolean bl4 = false;
                if (set.contains(p0)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        Map $this$filterNot$iv = result$iv;
        boolean $i$f$filterNot = false;
        result$iv = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator<Object> iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl5 = false;
            if (((List)it.getValue()).isEmpty()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map invalidCategorizations = destination$iv$iv;
        boolean bl6 = false;
        if (!invalidCategorizations.isEmpty()) {
            boolean bl7 = false;
            String licenseIds2 = CollectionsKt.joinToString$default((Iterable)invalidCategorizations.keySet(), null, null, null, (int)0, null, (Function1)7.1.licenseIds.1.INSTANCE, (int)31, null);
            Set categories2 = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)invalidCategorizations.values()));
            String string = "Found licenses that reference non-existing categories: " + licenseIds2 + "; unknown categories are " + categories2 + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ LicenseClassifications(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list, list2);
    }

    @NotNull
    public final List<LicenseCategory> getCategories() {
        return this.categories;
    }

    @NotNull
    public final List<LicenseCategorization> getCategorizations() {
        return this.categorizations;
    }

    @JsonIgnore
    @NotNull
    public final Map<String, Set<SpdxSingleLicenseExpression>> getLicensesByCategory() {
        Lazy lazy = this.licensesByCategory$delegate;
        return (Map)lazy.getValue();
    }

    @JsonIgnore
    @NotNull
    public final Map<SpdxSingleLicenseExpression, Set<String>> getCategoriesByLicense() {
        Lazy lazy = this.categoriesByLicense$delegate;
        return (Map)lazy.getValue();
    }

    @JsonIgnore
    @NotNull
    public final Set<String> getCategoryNames() {
        Lazy lazy = this.categoryNames$delegate;
        return (Set)lazy.getValue();
    }

    @Nullable
    public final Set<String> get(@NotNull SpdxExpression id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getCategoriesByLicense().get(id);
    }

    public final boolean isCategorized(@NotNull SpdxExpression id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getCategoriesByLicense().containsKey(id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LicenseClassifications merge(@NotNull LicenseClassifications other) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Object object;
        SpdxSingleLicenseExpression id;
        boolean bl;
        LicenseCategorization licenseCategorization;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Map filteredCategoriesByLicense = new LinkedHashMap();
        Iterable $this$forEach$iv = this.categorizations;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            void destination$iv;
            void $this$filterTo$iv;
            licenseCategorization = (LicenseCategorization)element$iv2;
            bl = false;
            id = licenseCategorization.component1();
            Set<String> set = licenseCategorization.component2();
            object = set;
            Collection collection = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv3 : $this$filterTo$iv) {
                String it = (String)element$iv3;
                boolean bl2 = false;
                if (!(!other.getCategoryNames().contains(it))) continue;
                destination$iv.add(element$iv3);
            }
            Set filteredCategories = (Set)destination$iv;
            if (!(!((Collection)filteredCategories).isEmpty())) continue;
            filteredCategoriesByLicense.put(id, filteredCategories);
        }
        $this$forEach$iv = other.categorizations;
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Object object2;
            licenseCategorization = (LicenseCategorization)element$iv2;
            bl = false;
            id = licenseCategorization.component1();
            Set<String> set = licenseCategorization.component2();
            Map $this$getOrPut$iv = filteredCategoriesByLicense;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(id);
            if (value$iv == null) {
                boolean bl3 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(id, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            CollectionsKt.addAll((Collection)((Collection)object2), (Iterable)set);
        }
        Set usedCategories = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)filteredCategoriesByLicense.values()));
        Object $this$filter$iv = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)this.categories, (Iterable)other.categories));
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            LicenseCategory it = (LicenseCategory)t;
            boolean bl2 = false;
            if (!usedCategories.contains(it.getName())) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = filteredCategoriesByLicense;
        List list = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            object = entry;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            SpdxSingleLicenseExpression id2 = (SpdxSingleLicenseExpression)object.getKey();
            Set categories2 = (Set)object.getValue();
            collection.add(new LicenseCategorization(id2, categories2));
        }
        List list2 = (List)destination$iv$iv;
        List list3 = list;
        return new LicenseClassifications(list3, list2);
    }

    @NotNull
    public final List<LicenseCategory> component1() {
        return this.categories;
    }

    @NotNull
    public final List<LicenseCategorization> component2() {
        return this.categorizations;
    }

    @NotNull
    public final LicenseClassifications copy(@JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<LicenseCategory> categories, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull List<LicenseCategorization> categorizations) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter(categorizations, (String)"categorizations");
        return new LicenseClassifications(categories, categorizations);
    }

    public static /* synthetic */ LicenseClassifications copy$default(LicenseClassifications licenseClassifications, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = licenseClassifications.categories;
        }
        if ((n & 2) != 0) {
            list2 = licenseClassifications.categorizations;
        }
        return licenseClassifications.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "LicenseClassifications(categories=" + this.categories + ", categorizations=" + this.categorizations + ")";
    }

    public int hashCode() {
        int result = ((Object)this.categories).hashCode();
        result = result * 31 + ((Object)this.categorizations).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LicenseClassifications)) {
            return false;
        }
        LicenseClassifications licenseClassifications = (LicenseClassifications)other;
        if (!Intrinsics.areEqual(this.categories, licenseClassifications.categories)) {
            return false;
        }
        return Intrinsics.areEqual(this.categorizations, licenseClassifications.categorizations);
    }

    public LicenseClassifications() {
        this(null, null, 3, null);
    }
}

