/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.licenses;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.CopyrightFinding;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.LicenseFinding;
import org.ossreviewtoolkit.model.LicenseSource;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.TextLocation;
import org.ossreviewtoolkit.model.UnknownProvenance;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.CopyrightGarbage;
import org.ossreviewtoolkit.model.config.LicenseFilePatterns;
import org.ossreviewtoolkit.model.config.LicenseFindingCuration;
import org.ossreviewtoolkit.model.config.PathExclude;
import org.ossreviewtoolkit.model.licenses.DetectedLicenseInfo;
import org.ossreviewtoolkit.model.licenses.Findings;
import org.ossreviewtoolkit.model.licenses.LicenseFindingCurationResult;
import org.ossreviewtoolkit.model.licenses.LicenseInfo;
import org.ossreviewtoolkit.model.licenses.LicenseInfoProvider;
import org.ossreviewtoolkit.model.licenses.LicenseInfoResolver;
import org.ossreviewtoolkit.model.licenses.LicenseInfoResolverKt;
import org.ossreviewtoolkit.model.licenses.ResolvedCopyrightFinding;
import org.ossreviewtoolkit.model.licenses.ResolvedLicense;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseBuilder;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseFile;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseFileInfo;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseInfo;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseLocation;
import org.ossreviewtoolkit.model.licenses.ResolvedOriginalExpression;
import org.ossreviewtoolkit.model.utils.FileArchiver;
import org.ossreviewtoolkit.model.utils.FindingCurationMatcher;
import org.ossreviewtoolkit.model.utils.FindingsMatcher;
import org.ossreviewtoolkit.model.utils.FindingsMatcherResult;
import org.ossreviewtoolkit.model.utils.RootLicenseMatcher;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;
import org.ossreviewtoolkit.utils.spdx.SpdxExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J2\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0017J<\u0010,\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0!0-2\u0006\u00100\u001a\u0002012\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u000204\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0503H\u0002J&\u00106\u001a\u000201*\u0002012\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u000204\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0!03H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/ossreviewtoolkit/model/licenses/LicenseInfoResolver;", "", "provider", "Lorg/ossreviewtoolkit/model/licenses/LicenseInfoProvider;", "copyrightGarbage", "Lorg/ossreviewtoolkit/model/config/CopyrightGarbage;", "addAuthorsToCopyrights", "", "archiver", "Lorg/ossreviewtoolkit/model/utils/FileArchiver;", "licenseFilePatterns", "Lorg/ossreviewtoolkit/model/config/LicenseFilePatterns;", "(Lorg/ossreviewtoolkit/model/licenses/LicenseInfoProvider;Lorg/ossreviewtoolkit/model/config/CopyrightGarbage;ZLorg/ossreviewtoolkit/model/utils/FileArchiver;Lorg/ossreviewtoolkit/model/config/LicenseFilePatterns;)V", "getAddAuthorsToCopyrights", "()Z", "getArchiver", "()Lorg/ossreviewtoolkit/model/utils/FileArchiver;", "findingsMatcher", "Lorg/ossreviewtoolkit/model/utils/FindingsMatcher;", "getLicenseFilePatterns", "()Lorg/ossreviewtoolkit/model/config/LicenseFilePatterns;", "resolvedLicenseFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/ossreviewtoolkit/model/Identifier;", "Lorg/ossreviewtoolkit/model/licenses/ResolvedLicenseFileInfo;", "resolvedLicenseInfo", "Lorg/ossreviewtoolkit/model/licenses/ResolvedLicenseInfo;", "rootLicenseMatcher", "Lorg/ossreviewtoolkit/model/utils/RootLicenseMatcher;", "createLicenseFileInfo", "id", "createLicenseInfo", "resolveCopyrights", "", "Lorg/ossreviewtoolkit/model/licenses/ResolvedCopyrightFinding;", "copyrightFindings", "Lorg/ossreviewtoolkit/model/CopyrightFinding;", "pathExcludes", "", "Lorg/ossreviewtoolkit/model/config/PathExclude;", "relativeFindingsPath", "", "resolveLicenseFiles", "resolveLicenseInfo", "resolveLocations", "", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "Lorg/ossreviewtoolkit/model/licenses/ResolvedLicenseLocation;", "detectedLicenseInfo", "Lorg/ossreviewtoolkit/model/licenses/DetectedLicenseInfo;", "unmatchedCopyrights", "", "Lorg/ossreviewtoolkit/model/Provenance;", "", "filterCopyrightGarbage", "copyrightGarbageFindings", "model"})
@SourceDebugExtension(value={"SMAP\nLicenseInfoResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseInfoResolver.kt\norg/ossreviewtoolkit/model/licenses/LicenseInfoResolver\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,299:1\n72#2,2:300\n72#2,2:303\n1#3:302\n1#3:305\n1#3:316\n1#3:336\n1#3:436\n1855#4,2:306\n1855#4:308\n1620#4,3:317\n1856#4:320\n1446#4,2:321\n1603#4,9:323\n1855#4:332\n1747#4,3:333\n1856#4:337\n1612#4:338\n1448#4,3:339\n1490#4:342\n1520#4,3:343\n1523#4,3:353\n1238#4,2:358\n1726#4,3:360\n1241#4:363\n1855#4:364\n766#4:365\n857#4,2:366\n1549#4:368\n1620#4,3:369\n1856#4:372\n1549#4:373\n1620#4,3:374\n1549#4:377\n1620#4,2:378\n3190#4,10:380\n1622#4:390\n1855#4:391\n1194#4,2:392\n1222#4,4:394\n766#4:399\n857#4,2:400\n1855#4:402\n1856#4:410\n1856#4:419\n1620#4,2:420\n766#4:422\n857#4,2:423\n1622#4:425\n1446#4,2:426\n1549#4:428\n1620#4,3:429\n1448#4,3:432\n1855#4:435\n1549#4:440\n1620#4,3:441\n1856#4:444\n494#5,7:309\n372#5,7:346\n453#5:356\n403#5:357\n372#5,7:403\n372#5,7:412\n372#5,7:445\n215#6:398\n216#6:411\n1155#7,3:437\n*S KotlinDebug\n*F\n+ 1 LicenseInfoResolver.kt\norg/ossreviewtoolkit/model/licenses/LicenseInfoResolver\n*L\n61#1:300,2\n68#1:303,2\n61#1:302\n68#1:305\n134#1:336\n81#1:306,2\n90#1:308\n106#1:317,3\n90#1:320\n129#1:321,2\n134#1:323,9\n134#1:332\n137#1:333,3\n134#1:337\n134#1:338\n129#1:339,3\n141#1:342\n141#1:343,3\n141#1:353,3\n141#1:358,2\n142#1:360,3\n141#1:363\n145#1:364\n149#1:365\n149#1:366,2\n151#1:368\n151#1:369,3\n145#1:372\n160#1:373\n160#1:374,3\n169#1:377\n169#1:378,2\n170#1:380,10\n169#1:390\n186#1:391\n190#1:392,2\n190#1:394,4\n212#1:399\n212#1:400,2\n216#1:402\n216#1:410\n186#1:419\n242#1:420,2\n243#1:422\n243#1:423,2\n242#1:425\n258#1:426,2\n259#1:428\n259#1:429,3\n258#1:432,3\n260#1:435\n276#1:440\n276#1:441,3\n260#1:444\n96#1:309,7\n141#1:346,7\n141#1:356\n141#1:357\n217#1:403,7\n227#1:412,7\n78#1:445,7\n198#1:398\n198#1:411\n270#1:437,3\n*E\n"})
public final class LicenseInfoResolver {
    @NotNull
    private final LicenseInfoProvider provider;
    @NotNull
    private final CopyrightGarbage copyrightGarbage;
    private final boolean addAuthorsToCopyrights;
    @Nullable
    private final FileArchiver archiver;
    @NotNull
    private final LicenseFilePatterns licenseFilePatterns;
    @NotNull
    private final ConcurrentHashMap<Identifier, ResolvedLicenseInfo> resolvedLicenseInfo;
    @NotNull
    private final ConcurrentHashMap<Identifier, ResolvedLicenseFileInfo> resolvedLicenseFiles;
    @NotNull
    private final RootLicenseMatcher rootLicenseMatcher;
    @NotNull
    private final FindingsMatcher findingsMatcher;

    public LicenseInfoResolver(@NotNull LicenseInfoProvider provider, @NotNull CopyrightGarbage copyrightGarbage, boolean addAuthorsToCopyrights, @Nullable FileArchiver archiver, @NotNull LicenseFilePatterns licenseFilePatterns) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)copyrightGarbage, (String)"copyrightGarbage");
        Intrinsics.checkNotNullParameter((Object)licenseFilePatterns, (String)"licenseFilePatterns");
        this.provider = provider;
        this.copyrightGarbage = copyrightGarbage;
        this.addAuthorsToCopyrights = addAuthorsToCopyrights;
        this.archiver = archiver;
        this.licenseFilePatterns = licenseFilePatterns;
        this.resolvedLicenseInfo = new ConcurrentHashMap();
        this.resolvedLicenseFiles = new ConcurrentHashMap();
        this.rootLicenseMatcher = new RootLicenseMatcher(LicenseFilePatterns.copy$default(this.licenseFilePatterns, null, null, CollectionsKt.emptyList(), 3, null));
        this.findingsMatcher = new FindingsMatcher(new RootLicenseMatcher(this.licenseFilePatterns), 0, 0, 6, null);
    }

    public /* synthetic */ LicenseInfoResolver(LicenseInfoProvider licenseInfoProvider, CopyrightGarbage copyrightGarbage, boolean bl, FileArchiver fileArchiver, LicenseFilePatterns licenseFilePatterns, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            licenseFilePatterns = LicenseFilePatterns.Companion.getDEFAULT();
        }
        this(licenseInfoProvider, copyrightGarbage, bl, fileArchiver, licenseFilePatterns);
    }

    public final boolean getAddAuthorsToCopyrights() {
        return this.addAuthorsToCopyrights;
    }

    @Nullable
    public final FileArchiver getArchiver() {
        return this.archiver;
    }

    @NotNull
    public final LicenseFilePatterns getLicenseFilePatterns() {
        return this.licenseFilePatterns;
    }

    @NotNull
    public final ResolvedLicenseInfo resolveLicenseInfo(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ConcurrentMap $this$getOrPut$iv = this.resolvedLicenseInfo;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(id);
        if (object == null) {
            boolean bl = false;
            ResolvedLicenseInfo default$iv = this.createLicenseInfo(id);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(id, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (ResolvedLicenseInfo)object;
    }

    @NotNull
    public final ResolvedLicenseFileInfo resolveLicenseFiles(@NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ConcurrentMap $this$getOrPut$iv = this.resolvedLicenseFiles;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(id);
        if (object == null) {
            boolean bl = false;
            ResolvedLicenseFileInfo default$iv = this.createLicenseFileInfo(id);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(id, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (ResolvedLicenseFileInfo)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolvedLicenseInfo createLicenseInfo(Identifier id) {
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ResolvedLicenseBuilder $this$createLicenseInfo_u24lambda_u2425_u24lambda_u2424;
        Comparable<Identifier> comparable;
        Iterator $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object2;
        Map $this$getOrPut$iv$iv$iv;
        Pair it;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable iterable;
        Object object3;
        Object object4;
        Iterable iterable2;
        SpdxExpression spdxExpression;
        Object object5;
        boolean bl;
        SpdxSingleLicenseExpression license;
        LicenseInfo licenseInfo = this.provider.get(id);
        SpdxExpression spdxExpression2 = licenseInfo.getConcludedLicenseInfo().getConcludedLicense();
        Set set = spdxExpression2 != null ? spdxExpression2.decompose() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set concludedLicenses = set;
        Set declaredLicenses = licenseInfo.getDeclaredLicenseInfo().getProcessed().decompose();
        Map resolvedLicenses = new LinkedHashMap();
        Iterable $this$forEach$iv = concludedLicenses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpdxExpression spdxExpression3;
            license = (SpdxSingleLicenseExpression)element$iv;
            bl = false;
            object5 = LicenseInfoResolver.createLicenseInfo$builder(license, resolvedLicenses);
            ResolvedLicenseBuilder $this$createLicenseInfo_u24lambda_u245_u24lambda_u244 = object5;
            boolean bl2 = false;
            if (licenseInfo.getConcludedLicenseInfo().getConcludedLicense() != null) {
                SpdxExpression it2 = spdxExpression;
                boolean bl3 = false;
                ((Collection)$this$createLicenseInfo_u24lambda_u245_u24lambda_u244.getOriginalExpressions()).add(new ResolvedOriginalExpression(it2, LicenseSource.CONCLUDED, false, 4, null));
                spdxExpression3 = spdxExpression;
                continue;
            }
            spdxExpression3 = null;
        }
        $this$forEach$iv = declaredLicenses;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set<String> set2;
            Object it3;
            SpdxExpression spdxExpression4;
            Object it2;
            license = (SpdxSingleLicenseExpression)element$iv;
            bl = false;
            object5 = LicenseInfoResolver.createLicenseInfo$builder(license, resolvedLicenses);
            ResolvedLicenseBuilder $this$createLicenseInfo_u24lambda_u2413_u24lambda_u2412 = object5;
            boolean bl4 = false;
            if (licenseInfo.getDeclaredLicenseInfo().getProcessed().getSpdxExpression() != null) {
                it2 = spdxExpression;
                boolean bl5 = false;
                ((Collection)$this$createLicenseInfo_u24lambda_u2413_u24lambda_u2412.getOriginalExpressions()).add(new ResolvedOriginalExpression((SpdxExpression)it2, LicenseSource.DECLARED, false, 4, null));
                spdxExpression4 = spdxExpression;
            } else {
                spdxExpression4 = null;
            }
            iterable2 = $this$createLicenseInfo_u24lambda_u2413_u24lambda_u2412.getOriginalDeclaredLicenses();
            Set<String> $this$filterValues$iv = licenseInfo.getDeclaredLicenseInfo().getProcessed().getMapped();
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                it3 = (SpdxExpression)entry.getValue();
                boolean bl6 = false;
                if (!Intrinsics.areEqual((Object)it3, (Object)license)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            $this$filterValues$iv = ((Map)result$iv).keySet();
            CollectionsKt.addAll((Collection)iterable2, (Iterable)$this$filterValues$iv);
            $this$filterValues$iv = licenseInfo.getDeclaredLicenseInfo().getAuthors();
            it2 = $this$filterValues$iv;
            boolean bl7 = false;
            Set<String> set3 = !((Collection)it2).isEmpty() && this.addAuthorsToCopyrights ? $this$filterValues$iv : null;
            if (set3 != null) {
                void destination$iv2;
                $this$filterValues$iv = set3;
                it2 = $this$filterValues$iv;
                boolean bl8 = false;
                Collection collection = $this$createLicenseInfo_u24lambda_u2413_u24lambda_u2412.getLocations();
                Iterable iterable3 = (Iterable)it2;
                it3 = new LinkedHashSet();
                List bl6 = CollectionsKt.emptyList();
                object4 = null;
                TextLocation textLocation = LicenseInfoResolverKt.access$getUNDEFINED_TEXT_LOCATION$p();
                object3 = UnknownProvenance.INSTANCE;
                boolean $i$f$mapTo = false;
                for (Object item$iv : iterable3) {
                    void author;
                    String string;
                    String string2 = (String)item$iv;
                    iterable = destination$iv2;
                    boolean bl9 = false;
                    String it4 = string = "Copyright (C) " + (String)author;
                    boolean bl10 = false;
                    String string3 = !StringsKt.contains((CharSequence)((CharSequence)author), (CharSequence)"Copyright", (boolean)true) ? string : null;
                    if (string3 == null) {
                        string3 = author;
                    }
                    String statement = string3;
                    iterable.add(new ResolvedCopyrightFinding(statement, LicenseInfoResolverKt.access$getUNDEFINED_TEXT_LOCATION$p(), CollectionsKt.emptyList()));
                }
                iterable = destination$iv2;
                Set set4 = (Set)iterable;
                List list = bl6;
                Map.Entry entry = object4;
                TextLocation textLocation2 = textLocation;
                Object object6 = object3;
                collection.add(new ResolvedLicenseLocation((Provenance)object6, textLocation2, (LicenseFindingCuration)((Object)entry), list, set4));
                set2 = $this$filterValues$iv;
                continue;
            }
            set2 = null;
        }
        Map copyrightGarbageFindings = new LinkedHashMap();
        DetectedLicenseInfo filteredDetectedLicenseInfo = this.filterCopyrightGarbage(licenseInfo.getDetectedLicenseInfo(), copyrightGarbageFindings);
        Map unmatchedCopyrights = new LinkedHashMap();
        Map<SpdxSingleLicenseExpression, Set<ResolvedLicenseLocation>> resolvedLocations = this.resolveLocations(filteredDetectedLicenseInfo, unmatchedCopyrights);
        Iterable bl2 = licenseInfo.getDetectedLicenseInfo().getFindings();
        object5 = new LinkedHashSet();
        boolean $i$f$flatMapTo232 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapNotNull$iv;
            Findings findings = (Findings)element$iv;
            boolean bl11 = false;
            iterable2 = new FindingCurationMatcher().applyAll((Collection<LicenseFinding>)findings.getLicenses(), (Collection<LicenseFindingCuration>)findings.getLicenseFindingCurations(), findings.getRelativeFindingsPath());
            boolean $i$f$mapNotNull = false;
            void var20_48 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = var20_48;
            boolean $i$f$forEach2 = false;
            object3 = $this$forEach$iv$iv$iv.iterator();
            while (object3.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl12 = false;
                LicenseFindingCurationResult curationResult = (LicenseFindingCurationResult)element$iv$iv;
                boolean bl13 = false;
                if (curationResult.getCuratedFinding() == null) {
                    pair = null;
                } else {
                    boolean bl3;
                    SpdxExpression spdxExpression5;
                    block30: {
                        void $this$any$iv;
                        LicenseFinding licenseFinding;
                        iterable = findings.getPathExcludes();
                        spdxExpression5 = licenseFinding.getLicense();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                PathExclude pathExclude = (PathExclude)element$iv2;
                                boolean bl15 = false;
                                if (!pathExclude.matches(org.ossreviewtoolkit.model.utils.ExtensionsKt.prependedPath(licenseFinding.getLocation(), findings.getRelativeFindingsPath()))) continue;
                                bl3 = true;
                                break block30;
                            }
                            bl3 = false;
                        }
                    }
                    boolean bl4 = bl3;
                    pair = TuplesKt.to((Object)spdxExpression5, (Object)bl4);
                }
                if (pair == null) continue;
                Pair it$iv$iv2 = pair;
                boolean bl17 = false;
                destination$iv$iv.add(it$iv$iv2);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$groupBy = false;
        void $i$f$flatMapTo232 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it5;
            Object object7;
            it = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-LicenseInfoResolver$createLicenseInfo$detectedLicenses$432 = false;
            SpdxExpression spdxExpression6 = (SpdxExpression)it.getFirst();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(spdxExpression6);
            if (value$iv$iv$iv == null) {
                boolean bl18 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(spdxExpression6, answer$iv$iv$iv);
                object7 = answer$iv$iv$iv;
            } else {
                object7 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object7;
            Pair $i$a$-groupBy-LicenseInfoResolver$createLicenseInfo$detectedLicenses$432 = (Pair)element$iv$iv;
            object2 = list$iv$iv;
            boolean bl19 = false;
            object2.add(Boolean.valueOf((Boolean)it5.getSecond()));
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            boolean bl5;
            Object k;
            block31: {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean bl21 = false;
                object4 = (Map.Entry)element$iv$iv$iv;
                k = entry.getKey();
                object2 = $this$getOrPut$iv$iv$iv;
                boolean bl22 = false;
                List excluded = (List)object4.getValue();
                Iterable $this$all$iv = excluded;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean it6 = (Boolean)element$iv;
                        boolean bl23 = false;
                        if (it6) continue;
                        bl5 = false;
                        break block31;
                    }
                    bl5 = true;
                }
            }
            comparable = bl5;
            object2.put(k, comparable);
        }
        Map detectedLicenses = destination$iv$iv;
        Iterable $this$forEach$iv2 = resolvedLocations.keySet();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$mapTo$iv$iv2;
            Map.Entry entry;
            Iterable $this$filterTo$iv$iv;
            Set<ResolvedLicenseLocation> set5;
            SpdxSingleLicenseExpression license2 = (SpdxSingleLicenseExpression)element$iv;
            boolean bl24 = false;
            $this$createLicenseInfo_u24lambda_u2425_u24lambda_u2424 = $i$f$associateByTo = LicenseInfoResolver.createLicenseInfo$builder(license2, resolvedLicenses);
            boolean bl25 = false;
            if (resolvedLocations.get(license2) != null) {
                Set<ResolvedLicenseLocation> set6;
                Set<ResolvedLicenseLocation> it7 = set6;
                boolean bl26 = false;
                CollectionsKt.addAll((Collection)$this$createLicenseInfo_u24lambda_u2425_u24lambda_u2424.getLocations(), (Iterable)it7);
                set5 = set6;
            } else {
                set5 = null;
            }
            object4 = $this$createLicenseInfo_u24lambda_u2425_u24lambda_u2424.getOriginalExpressions();
            Iterable iterable4 = detectedLicenses.entrySet();
            boolean $i$f$filter = false;
            Iterable bl26 = iterable4;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                entry = (Map.Entry)element$iv$iv;
                boolean bl27 = false;
                SpdxExpression expression = (SpdxExpression)entry.getKey();
                if (!expression.decompose().contains(license2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable iterable5 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = iterable5;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable5, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl28 = false;
                SpdxExpression expression = (SpdxExpression)entry.getKey();
                boolean isDetectedExcluded2 = (Boolean)entry.getValue();
                collection.add(new ResolvedOriginalExpression(expression, LicenseSource.DETECTED, isDetectedExcluded2));
            }
            Iterable iterable6 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)object4, (Iterable)iterable6);
        }
        $this$forEach$iv2 = resolvedLicenses.values();
        LicenseInfo licenseInfo2 = licenseInfo;
        comparable = id;
        boolean $i$f$map = false;
        $this$mapValuesTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            $this$createLicenseInfo_u24lambda_u2425_u24lambda_u2424 = (ResolvedLicenseBuilder)item$iv$iv;
            object = destination$iv$iv;
            boolean bl29 = false;
            object.add(it.build());
        }
        object = (List)destination$iv$iv;
        Map map = unmatchedCopyrights;
        Map map2 = copyrightGarbageFindings;
        List list = object;
        LicenseInfo licenseInfo3 = licenseInfo2;
        Comparable<Identifier> comparable2 = comparable;
        return new ResolvedLicenseInfo((Identifier)comparable2, licenseInfo3, list, map2, map);
    }

    /*
     * WARNING - void declaration
     */
    private final DetectedLicenseInfo filterCopyrightGarbage(DetectedLicenseInfo $this$filterCopyrightGarbage, Map<Provenance, Set<CopyrightFinding>> copyrightGarbageFindings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$filterCopyrightGarbage.getFindings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void finding;
            Findings findings = (Findings)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$partition$iv = finding.getCopyrights();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                CopyrightFinding copyrightFinding = (CopyrightFinding)element$iv;
                boolean bl2 = false;
                if (this.copyrightGarbage.contains(copyrightFinding.getStatement())) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List copyrightGarbage = (List)pair.component1();
            List copyrightFindings = (List)pair.component2();
            copyrightGarbageFindings.put(finding.getProvenance(), CollectionsKt.toSet((Iterable)copyrightGarbage));
            collection.add(Findings.copy$default((Findings)finding, null, null, CollectionsKt.toSet((Iterable)copyrightFindings), null, null, null, 59, null));
        }
        List filteredFindings = (List)destination$iv$iv;
        return new DetectedLicenseInfo(filteredFindings);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<SpdxSingleLicenseExpression, Set<ResolvedLicenseLocation>> resolveLocations(DetectedLicenseInfo detectedLicenseInfo, Map<Provenance, Set<ResolvedCopyrightFinding>> unmatchedCopyrights) {
        Map resolvedLocations = new LinkedHashMap();
        FindingCurationMatcher curationMatcher = new FindingCurationMatcher();
        Iterable $this$forEach$iv = detectedLicenseInfo.getFindings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Findings findings = (Findings)element$iv;
            boolean bl = false;
            Iterable iterable = curationMatcher.applyAll((Collection<LicenseFinding>)findings.getLicenses(), (Collection<LicenseFindingCuration>)findings.getLicenseFindingCurations(), findings.getRelativeFindingsPath());
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var14_16 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean bl2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                LicenseFindingCurationResult licenseFindingCurationResult = (LicenseFindingCurationResult)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl22 = false;
                map.put(it.getCuratedFinding(), element$iv$iv);
            }
            Map licenseCurationResults = destination$iv$iv;
            Set curatedLicenseFindings = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)licenseCurationResults.keySet()));
            FindingsMatcherResult matchResult = this.findingsMatcher.match(curatedLicenseFindings, findings.getCopyrights());
            Map<Object, Set<Object>> $this$forEach$iv2 = matchResult.getMatchedFindings();
            boolean $i$f$forEach2 = false;
            for (Map.Entry entry : $this$forEach$iv2.entrySet()) {
                void $this$filterTo$iv$iv;
                Map.Entry entry2 = entry;
                boolean bl3 = false;
                LicenseFinding licenseFinding = (LicenseFinding)entry2.getKey();
                Set copyrightFindings = (Set)entry2.getValue();
                Set<ResolvedCopyrightFinding> resolvedCopyrightFindings = this.resolveCopyrights(copyrightFindings, findings.getPathExcludes(), findings.getRelativeFindingsPath());
                Pair pair = (Pair)CollectionsKt.firstOrNull(((LicenseFindingCurationResult)MapsKt.getValue((Map)licenseCurationResults, (Object)licenseFinding)).getOriginalFindings());
                LicenseFindingCuration appliedCuration = pair != null ? (LicenseFindingCuration)pair.getSecond() : null;
                Iterable $this$filter$iv = findings.getPathExcludes();
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PathExclude it = (PathExclude)element$iv$iv;
                    boolean bl4 = false;
                    if (!it.matches(org.ossreviewtoolkit.model.utils.ExtensionsKt.prependedPath(licenseFinding.getLocation(), findings.getRelativeFindingsPath()))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List matchingPathExcludes = (List)destination$iv$iv2;
                Iterable $this$forEach$iv3 = licenseFinding.getLicense().decompose();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Object object2;
                    SpdxSingleLicenseExpression singleLicense = (SpdxSingleLicenseExpression)element$iv3;
                    boolean bl5 = false;
                    Map $this$getOrPut$iv2 = resolvedLocations;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv2.get(singleLicense);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv2.put(singleLicense, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    Collection collection = (Collection)object2;
                    collection.add(new ResolvedLicenseLocation(findings.getProvenance(), licenseFinding.getLocation(), appliedCuration, matchingPathExcludes, resolvedCopyrightFindings));
                }
            }
            $this$forEach$iv2 = unmatchedCopyrights;
            Provenance key$iv = findings.getProvenance();
            boolean $i$f$getOrPut = false;
            Object v = $this$getOrPut$iv.get(key$iv);
            if (v == null) {
                boolean bl7 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = v;
            }
            Collection collection = (Collection)object;
            CollectionsKt.addAll((Collection)collection, (Iterable)this.resolveCopyrights(matchResult.getUnmatchedCopyrights(), findings.getPathExcludes(), findings.getRelativeFindingsPath()));
        }
        return resolvedLocations;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ResolvedCopyrightFinding> resolveCopyrights(Set<CopyrightFinding> copyrightFindings, List<PathExclude> pathExcludes, String relativeFindingsPath) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = copyrightFindings;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void finding;
            void $this$filterTo$iv$iv;
            CopyrightFinding copyrightFinding = (CopyrightFinding)item$iv;
            void var21_21 = destination$iv;
            boolean bl = false;
            Iterable $this$filter$iv = pathExcludes;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PathExclude it = (PathExclude)element$iv$iv;
                boolean bl2 = false;
                if (!it.matches(org.ossreviewtoolkit.model.utils.ExtensionsKt.prependedPath(finding.getLocation(), relativeFindingsPath))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List matchingPathExcludes = (List)destination$iv$iv;
            var21_21.add(new ResolvedCopyrightFinding(finding.getStatement(), finding.getLocation(), matchingPathExcludes));
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolvedLicenseFileInfo createLicenseFileInfo(Identifier id) {
        void $this$forEach$iv;
        void destination$iv;
        Collection destination$iv$iv;
        Iterable $this$flatMapTo$iv;
        if (this.archiver == null) {
            return new ResolvedLicenseFileInfo(id, CollectionsKt.emptyList());
        }
        ResolvedLicenseInfo licenseInfo = this.resolveLicenseInfo(id);
        List licenseFiles = new ArrayList();
        Iterable iterable = licenseInfo;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            ResolvedLicense resolvedLicense = (ResolvedLicense)element$iv;
            boolean bl3 = false;
            Iterable $this$map$iv = resolvedLicense.getLocations();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolvedLicenseLocation resolvedLicenseLocation = (ResolvedLicenseLocation)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.getProvenance());
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void destination$iv2;
            void $this$mapTo$iv;
            String string;
            Object item$iv$iv;
            Provenance provenance = (Provenance)element$iv;
            boolean bl = false;
            Object bl3 = new String[]{"archive"};
            Object $this$createLicenseFileInfo_u24lambda_u2443_u24lambda_u2440 = bl3 = ExtensionsKt.createOrtTempDir((Object)this, (String[])bl3);
            boolean $i$a$-apply-LicenseInfoResolver$createLicenseFileInfo$2$archiveDir$22 = false;
            ((File)$this$createLicenseFileInfo_u24lambda_u2443_u24lambda_u2440).deleteOnExit();
            Object archiveDir = bl3;
            bl3 = provenance;
            if (bl3 instanceof UnknownProvenance || bl3 instanceof KnownProvenance && !this.archiver.unarchive((File)archiveDir, (KnownProvenance)provenance)) continue;
            Object object = provenance instanceof RepositoryProvenance ? (RepositoryProvenance)provenance : null;
            if ((object != null && (object = ((RepositoryProvenance)object).getVcsInfo()) != null ? ((VcsInfo)object).getPath() : (string = null)) == null) {
                string = "";
            }
            String directory = string;
            Sequence $i$a$-apply-LicenseInfoResolver$createLicenseFileInfo$2$archiveDir$22 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)archiveDir, null, (int)1, null)), (Function1)createLicenseFileInfo.2.rootLicenseFiles.1.INSTANCE);
            destination$iv$iv = new LinkedHashSet();
            Object object2 = this.rootLicenseMatcher;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                File file = (File)item$iv;
                void var20_32 = destination$iv2;
                boolean bl4 = false;
                var20_32.add(FilesKt.toRelativeString((File)it, (File)archiveDir));
            }
            Set rootLicenseFiles2 = (Set)MapsKt.getValue(((RootLicenseMatcher)object2).getApplicableLicenseFilesForDirectories((Collection<String>)destination$iv2, CollectionsKt.listOf((Object)directory)), (Object)directory);
            Collection collection3 = licenseFiles;
            Iterable $this$map$iv = rootLicenseFiles2;
            boolean $i$f$map = false;
            item$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void relativePath;
                String string2 = (String)item$iv$iv2;
                object2 = destination$iv$iv2;
                boolean bl5 = false;
                object2.add(new ResolvedLicenseFile(provenance, licenseInfo.filter(provenance, (String)relativePath), (String)relativePath, FilesKt.resolve((File)archiveDir, (String)relativePath)));
            }
            Iterable iterable3 = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)collection3, (Iterable)iterable3);
        }
        return new ResolvedLicenseFileInfo(id, licenseFiles);
    }

    private static final ResolvedLicenseBuilder createLicenseInfo$builder(SpdxSingleLicenseExpression $this$createLicenseInfo_u24builder, Map<SpdxSingleLicenseExpression, ResolvedLicenseBuilder> resolvedLicenses) {
        ResolvedLicenseBuilder resolvedLicenseBuilder;
        Map<SpdxSingleLicenseExpression, ResolvedLicenseBuilder> $this$getOrPut$iv = resolvedLicenses;
        boolean $i$f$getOrPut = false;
        ResolvedLicenseBuilder value$iv = $this$getOrPut$iv.get($this$createLicenseInfo_u24builder);
        if (value$iv == null) {
            boolean bl = false;
            ResolvedLicenseBuilder answer$iv = new ResolvedLicenseBuilder($this$createLicenseInfo_u24builder);
            $this$getOrPut$iv.put($this$createLicenseInfo_u24builder, answer$iv);
            resolvedLicenseBuilder = answer$iv;
        } else {
            resolvedLicenseBuilder = value$iv;
        }
        return resolvedLicenseBuilder;
    }
}

