/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.licenses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.LicenseSource;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.TextLocation;
import org.ossreviewtoolkit.model.config.LicenseFindingCuration;
import org.ossreviewtoolkit.model.licenses.ResolvedCopyright;
import org.ossreviewtoolkit.model.licenses.ResolvedCopyrightFinding;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseKt;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseLocation;
import org.ossreviewtoolkit.model.licenses.ResolvedOriginalExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003JC\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010!\u001a\u00020\u0000J\b\u0010\"\u001a\u0004\u0018\u00010\u0000J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010$\u001a\u00020\r2\b\b\u0002\u0010%\u001a\u00020\rH\u0007J \u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\b\u0002\u0010$\u001a\u00020\r2\b\b\u0002\u0010%\u001a\u00020\rJ\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0006H\u00d6\u0001R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006,"}, d2={"Lorg/ossreviewtoolkit/model/licenses/ResolvedLicense;", "", "license", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "originalDeclaredLicenses", "", "", "originalExpressions", "Lorg/ossreviewtoolkit/model/licenses/ResolvedOriginalExpression;", "locations", "Lorg/ossreviewtoolkit/model/licenses/ResolvedLicenseLocation;", "(Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "isDetectedExcluded", "", "()Z", "isDetectedExcluded$delegate", "Lkotlin/Lazy;", "getLicense", "()Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "getLocations", "()Ljava/util/Set;", "getOriginalDeclaredLicenses", "getOriginalExpressions", "sources", "Lorg/ossreviewtoolkit/model/LicenseSource;", "getSources", "component1", "component2", "component3", "component4", "copy", "equals", "other", "filterExcludedCopyrights", "filterExcludedOriginalExpressions", "getCopyrights", "process", "omitExcluded", "getResolvedCopyrights", "", "Lorg/ossreviewtoolkit/model/licenses/ResolvedCopyright;", "hashCode", "", "toString", "model"})
@SourceDebugExtension(value={"SMAP\nResolvedLicense.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolvedLicense.kt\norg/ossreviewtoolkit/model/licenses/ResolvedLicense\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1620#2,3:146\n1360#2:149\n1446#2,2:150\n766#2:152\n857#2,2:153\n1448#2,3:155\n1620#2,3:158\n1620#2,2:161\n857#2,2:163\n1622#2:165\n847#2,2:166\n*S KotlinDebug\n*F\n+ 1 ResolvedLicense.kt\norg/ossreviewtoolkit/model/licenses/ResolvedLicense\n*L\n57#1:146,3\n78#1:149\n78#1:150,2\n79#1:152\n79#1:153,2\n78#1:155,3\n94#1:158,3\n102#1:161,2\n104#1:163,2\n102#1:165\n117#1:166,2\n*E\n"})
public final class ResolvedLicense {
    @NotNull
    private final SpdxSingleLicenseExpression license;
    @NotNull
    private final Set<String> originalDeclaredLicenses;
    @NotNull
    private final Set<ResolvedOriginalExpression> originalExpressions;
    @NotNull
    private final Set<ResolvedLicenseLocation> locations;
    @NotNull
    private final Set<LicenseSource> sources;
    @NotNull
    private final Lazy isDetectedExcluded$delegate;

    /*
     * WARNING - void declaration
     */
    public ResolvedLicense(@NotNull SpdxSingleLicenseExpression license, @NotNull Set<String> originalDeclaredLicenses, @NotNull Set<ResolvedOriginalExpression> originalExpressions, @NotNull Set<ResolvedLicenseLocation> locations) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        Intrinsics.checkNotNullParameter(originalDeclaredLicenses, (String)"originalDeclaredLicenses");
        Intrinsics.checkNotNullParameter(originalExpressions, (String)"originalExpressions");
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        this.license = license;
        this.originalDeclaredLicenses = originalDeclaredLicenses;
        this.originalExpressions = originalExpressions;
        this.locations = locations;
        Iterable iterable = this.originalExpressions;
        Collection collection = new LinkedHashSet();
        ResolvedLicense resolvedLicense = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ResolvedOriginalExpression resolvedOriginalExpression = (ResolvedOriginalExpression)item$iv;
            void var13_15 = destination$iv;
            boolean bl = false;
            var13_15.add(it.getSource());
        }
        resolvedLicense.sources = (Set)destination$iv;
        this.isDetectedExcluded$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ResolvedLicense this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (this.this$0.getSources().contains((Object)((Object)LicenseSource.DETECTED))) {
                    boolean bl2;
                    block5: {
                        Iterable $this$all$iv = this.this$0.getLocations();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                ResolvedLicenseLocation it = (ResolvedLicenseLocation)element$iv;
                                boolean bl3 = false;
                                if (!((Collection)it.getMatchingPathExcludes()).isEmpty()) continue;
                                bl2 = false;
                                break block5;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        if (!(!((Collection)this.sources).isEmpty())) {
            boolean bl = false;
            String string = "A resolved license must have at least one license source.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final SpdxSingleLicenseExpression getLicense() {
        return this.license;
    }

    @NotNull
    public final Set<String> getOriginalDeclaredLicenses() {
        return this.originalDeclaredLicenses;
    }

    @NotNull
    public final Set<ResolvedOriginalExpression> getOriginalExpressions() {
        return this.originalExpressions;
    }

    @NotNull
    public final Set<ResolvedLicenseLocation> getLocations() {
        return this.locations;
    }

    @NotNull
    public final Set<LicenseSource> getSources() {
        return this.sources;
    }

    public final boolean isDetectedExcluded() {
        Lazy lazy = this.isDetectedExcluded$delegate;
        return (Boolean)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResolvedCopyright> getResolvedCopyrights(boolean process, boolean omitExcluded) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.locations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ResolvedLicenseLocation location = (ResolvedLicenseLocation)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = location.getCopyrights();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ResolvedCopyrightFinding copyright = (ResolvedCopyrightFinding)element$iv$iv2;
                boolean bl2 = false;
                if (!(!omitExcluded || copyright.getMatchingPathExcludes().isEmpty())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List resolvedCopyrightFindings = (List)destination$iv$iv;
        return ResolvedLicenseKt.toResolvedCopyrights(resolvedCopyrightFindings, process);
    }

    public static /* synthetic */ List getResolvedCopyrights$default(ResolvedLicense resolvedLicense, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return resolvedLicense.getResolvedCopyrights(bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Set<String> getCopyrights(boolean process, boolean omitExcluded) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = this.getResolvedCopyrights(process, omitExcluded);
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ResolvedCopyright resolvedCopyright = (ResolvedCopyright)item$iv;
            void var10_10 = destination$iv;
            boolean bl = false;
            var10_10.add(it.getStatement());
        }
        return (Set)destination$iv;
    }

    public static /* synthetic */ Set getCopyrights$default(ResolvedLicense resolvedLicense, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return resolvedLicense.getCopyrights(bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResolvedLicense filterExcludedCopyrights() {
        Collection collection;
        void $this$mapTo$iv;
        Iterable iterable = this.locations;
        Collection collection2 = new LinkedHashSet();
        Set set = null;
        Set set2 = null;
        SpdxSingleLicenseExpression spdxSingleLicenseExpression = null;
        ResolvedLicense resolvedLicense = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void destination$iv;
            void $this$filterTo$iv;
            void location;
            void destination$iv2;
            ResolvedLicenseLocation resolvedLicenseLocation = (ResolvedLicenseLocation)item$iv;
            collection = destination$iv2;
            boolean bl = false;
            Iterable iterable2 = location.getCopyrights();
            Collection collection3 = new LinkedHashSet();
            List list = null;
            LicenseFindingCuration licenseFindingCuration = null;
            TextLocation textLocation = null;
            Provenance provenance = null;
            void var14_18 = location;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                ResolvedCopyrightFinding it = (ResolvedCopyrightFinding)element$iv;
                boolean bl2 = false;
                if (!it.getMatchingPathExcludes().isEmpty()) continue;
                destination$iv.add(element$iv);
            }
            void var20_24 = destination$iv;
            collection.add(ResolvedLicenseLocation.copy$default((ResolvedLicenseLocation)var14_18, provenance, textLocation, licenseFindingCuration, list, (Set)var20_24, 15, null));
        }
        collection = collection2;
        return ResolvedLicense.copy$default(resolvedLicense, spdxSingleLicenseExpression, set2, set, (Set)collection, 7, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ResolvedLicense filterExcludedOriginalExpressions() {
        void var3_2;
        void $this$filterNotTo$iv;
        if (!this.sources.contains((Object)LicenseSource.DETECTED)) {
            return this;
        }
        Iterable iterable = this.originalExpressions;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            ResolvedOriginalExpression it = (ResolvedOriginalExpression)element$iv;
            boolean bl = false;
            if (it.isDetectedExcluded()) continue;
            destination$iv.add(element$iv);
        }
        Set filteredOriginalExpressions = (Set)var3_2;
        if (filteredOriginalExpressions.isEmpty()) {
            return null;
        }
        return ResolvedLicense.copy$default(this, null, null, filteredOriginalExpressions, null, 11, null);
    }

    @NotNull
    public final SpdxSingleLicenseExpression component1() {
        return this.license;
    }

    @NotNull
    public final Set<String> component2() {
        return this.originalDeclaredLicenses;
    }

    @NotNull
    public final Set<ResolvedOriginalExpression> component3() {
        return this.originalExpressions;
    }

    @NotNull
    public final Set<ResolvedLicenseLocation> component4() {
        return this.locations;
    }

    @NotNull
    public final ResolvedLicense copy(@NotNull SpdxSingleLicenseExpression license, @NotNull Set<String> originalDeclaredLicenses, @NotNull Set<ResolvedOriginalExpression> originalExpressions, @NotNull Set<ResolvedLicenseLocation> locations) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        Intrinsics.checkNotNullParameter(originalDeclaredLicenses, (String)"originalDeclaredLicenses");
        Intrinsics.checkNotNullParameter(originalExpressions, (String)"originalExpressions");
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        return new ResolvedLicense(license, originalDeclaredLicenses, originalExpressions, locations);
    }

    public static /* synthetic */ ResolvedLicense copy$default(ResolvedLicense resolvedLicense, SpdxSingleLicenseExpression spdxSingleLicenseExpression, Set set, Set set2, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            spdxSingleLicenseExpression = resolvedLicense.license;
        }
        if ((n & 2) != 0) {
            set = resolvedLicense.originalDeclaredLicenses;
        }
        if ((n & 4) != 0) {
            set2 = resolvedLicense.originalExpressions;
        }
        if ((n & 8) != 0) {
            set3 = resolvedLicense.locations;
        }
        return resolvedLicense.copy(spdxSingleLicenseExpression, set, set2, set3);
    }

    @NotNull
    public String toString() {
        return "ResolvedLicense(license=" + this.license + ", originalDeclaredLicenses=" + this.originalDeclaredLicenses + ", originalExpressions=" + this.originalExpressions + ", locations=" + this.locations + ")";
    }

    public int hashCode() {
        int result = this.license.hashCode();
        result = result * 31 + ((Object)this.originalDeclaredLicenses).hashCode();
        result = result * 31 + ((Object)this.originalExpressions).hashCode();
        result = result * 31 + ((Object)this.locations).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedLicense)) {
            return false;
        }
        ResolvedLicense resolvedLicense = (ResolvedLicense)other;
        if (!Intrinsics.areEqual((Object)this.license, (Object)resolvedLicense.license)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.originalDeclaredLicenses, resolvedLicense.originalDeclaredLicenses)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.originalExpressions, resolvedLicense.originalExpressions)) {
            return false;
        }
        return Intrinsics.areEqual(this.locations, resolvedLicense.locations);
    }

    @JvmOverloads
    @NotNull
    public final Set<String> getCopyrights(boolean process) {
        return ResolvedLicense.getCopyrights$default(this, process, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Set<String> getCopyrights() {
        return ResolvedLicense.getCopyrights$default(this, false, false, 3, null);
    }
}

