/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.licenses;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.licenses.ResolvedLicense;
import org.ossreviewtoolkit.model.licenses.ResolvedLicenseLocation;
import org.ossreviewtoolkit.model.licenses.ResolvedOriginalExpression;
import org.ossreviewtoolkit.utils.spdx.SpdxSingleLicenseExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/ossreviewtoolkit/model/licenses/ResolvedLicenseBuilder;", "", "license", "Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "(Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;)V", "getLicense", "()Lorg/ossreviewtoolkit/utils/spdx/SpdxSingleLicenseExpression;", "locations", "", "Lorg/ossreviewtoolkit/model/licenses/ResolvedLicenseLocation;", "getLocations", "()Ljava/util/Set;", "originalDeclaredLicenses", "", "getOriginalDeclaredLicenses", "originalExpressions", "Lorg/ossreviewtoolkit/model/licenses/ResolvedOriginalExpression;", "getOriginalExpressions", "build", "Lorg/ossreviewtoolkit/model/licenses/ResolvedLicense;", "model"})
final class ResolvedLicenseBuilder {
    @NotNull
    private final SpdxSingleLicenseExpression license;
    @NotNull
    private final Set<String> originalDeclaredLicenses;
    @NotNull
    private final Set<ResolvedOriginalExpression> originalExpressions;
    @NotNull
    private final Set<ResolvedLicenseLocation> locations;

    public ResolvedLicenseBuilder(@NotNull SpdxSingleLicenseExpression license) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        this.license = license;
        this.originalDeclaredLicenses = new LinkedHashSet();
        this.originalExpressions = new LinkedHashSet();
        this.locations = new LinkedHashSet();
    }

    @NotNull
    public final SpdxSingleLicenseExpression getLicense() {
        return this.license;
    }

    @NotNull
    public final Set<String> getOriginalDeclaredLicenses() {
        return this.originalDeclaredLicenses;
    }

    @NotNull
    public final Set<ResolvedOriginalExpression> getOriginalExpressions() {
        return this.originalExpressions;
    }

    @NotNull
    public final Set<ResolvedLicenseLocation> getLocations() {
        return this.locations;
    }

    @NotNull
    public final ResolvedLicense build() {
        return new ResolvedLicense(this.license, this.originalDeclaredLicenses, this.originalExpressions, this.locations);
    }
}

