/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageCuration;
import org.ossreviewtoolkit.model.ResolvedPackageCurations;
import org.ossreviewtoolkit.model.RuleViolation;
import org.ossreviewtoolkit.model.ScanResult;
import org.ossreviewtoolkit.model.config.PackageConfiguration;
import org.ossreviewtoolkit.model.config.Resolutions;
import org.ossreviewtoolkit.model.utils.PackageConfigurationProvider;
import org.ossreviewtoolkit.model.utils.PackageCurationProvider;
import org.ossreviewtoolkit.model.utils.ResolutionProvider;
import org.ossreviewtoolkit.model.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072'\u0010\t\u001a#\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00040\n2\u0006\u0010\u000f\u001a\u00020\u0010J4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u0004J8\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00042\u0006\u0010\"\u001a\u00020#\u00a8\u0006$"}, d2={"Lorg/ossreviewtoolkit/model/utils/ConfigurationResolver;", "", "()V", "resolvePackageConfigurations", "", "Lorg/ossreviewtoolkit/model/config/PackageConfiguration;", "identifiers", "", "Lorg/ossreviewtoolkit/model/Identifier;", "scanResultProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "id", "Lorg/ossreviewtoolkit/model/ScanResult;", "packageConfigurationProvider", "Lorg/ossreviewtoolkit/model/utils/PackageConfigurationProvider;", "resolvePackageCurations", "Lorg/ossreviewtoolkit/model/ResolvedPackageCurations;", "packages", "", "Lorg/ossreviewtoolkit/model/Package;", "curationProviders", "Lkotlin/Pair;", "", "Lorg/ossreviewtoolkit/model/utils/PackageCurationProvider;", "resolveResolutions", "Lorg/ossreviewtoolkit/model/config/Resolutions;", "issues", "Lorg/ossreviewtoolkit/model/Issue;", "ruleViolations", "Lorg/ossreviewtoolkit/model/RuleViolation;", "vulnerabilities", "Lorg/ossreviewtoolkit/model/vulnerabilities/Vulnerability;", "resolutionProvider", "Lorg/ossreviewtoolkit/model/utils/ResolutionProvider;", "model"})
@SourceDebugExtension(value={"SMAP\nConfigurationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationResolver.kt\norg/ossreviewtoolkit/model/utils/ConfigurationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,103:1\n1360#2:104\n1446#2,2:105\n1360#2:107\n1446#2,5:108\n1448#2,3:113\n1855#2:116\n3190#2,4:129\n1747#2,3:133\n3194#2,6:136\n1856#2:145\n1360#2:150\n1446#2,5:151\n1360#2:156\n1446#2,5:157\n1360#2:162\n1446#2,5:163\n79#3,5:117\n113#3,7:122\n1#4:142\n38#5:143\n38#5:144\n125#6:146\n152#6,3:147\n*S KotlinDebug\n*F\n+ 1 ConfigurationResolver.kt\norg/ossreviewtoolkit/model/utils/ConfigurationResolver\n*L\n47#1:104\n47#1:105,2\n48#1:107\n48#1:108,5\n47#1:113,3\n63#1:116\n68#1:129,4\n69#1:133,3\n68#1:136,6\n63#1:145\n98#1:150\n98#1:151,5\n99#1:156\n99#1:157,5\n100#1:162\n100#1:163,5\n64#1:117,5\n64#1:122,7\n73#1:143\n81#1:144\n84#1:146\n84#1:147,3\n*E\n"})
public final class ConfigurationResolver {
    @NotNull
    public static final ConfigurationResolver INSTANCE = new ConfigurationResolver();

    private ConfigurationResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageConfiguration> resolvePackageConfigurations(@NotNull Set<Identifier> identifiers, @NotNull Function1<? super Identifier, ? extends List<ScanResult>> scanResultProvider, @NotNull PackageConfigurationProvider packageConfigurationProvider) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        Intrinsics.checkNotNullParameter(scanResultProvider, (String)"scanResultProvider");
        Intrinsics.checkNotNullParameter((Object)packageConfigurationProvider, (String)"packageConfigurationProvider");
        Iterable $this$flatMap$iv = identifiers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Identifier id = (Identifier)element$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv2 = (Iterable)scanResultProvider.invoke((Object)id);
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                ScanResult scanResult = (ScanResult)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = packageConfigurationProvider.getPackageConfigurations(id, scanResult.getProvenance());
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResolvedPackageCurations> resolvePackageCurations(@NotNull Collection<Package> packages2, @NotNull List<? extends Pair<String, ? extends PackageCurationProvider>> curationProviders) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(curationProviders, (String)"curationProviders");
        Map packageCurations = new LinkedHashMap();
        Iterable $this$forEach$iv = curationProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String id = (String)pair.component1();
            PackageCurationProvider curationProvider = (PackageCurationProvider)pair.component2();
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            Set<PackageCuration> result$iv$iv = curationProvider.getCurationsFor(packages2);
            TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            Set curations = (Set)timedValue.component1();
            long duration = timedValue.component2-UwyO8pc();
            Iterable $this$partition$iv = curations;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                boolean bl3;
                block8: {
                    PackageCuration curation = (PackageCuration)element$iv2;
                    boolean bl4 = false;
                    Iterable $this$any$iv = packages2;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv) {
                            Package pkg = (Package)element$iv3;
                            boolean bl5 = false;
                            if (!curation.isApplicable(pkg.getId())) continue;
                            bl3 = true;
                            break block8;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair it = new Pair(first$iv, second$iv);
            boolean bl6 = false;
            Pair pair2 = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            List applicableCurations = (List)pair2.component1();
            List nonApplicableCurations = (List)pair2.component2();
            if (!((Collection)nonApplicableCurations).isEmpty()) {
                ConfigurationResolver $this$logger$iv = INSTANCE;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(ConfigurationResolver.class).warn((Function0)new Function0<Object>(id, (List<PackageCuration>)nonApplicableCurations){
                    final /* synthetic */ String $id;
                    final /* synthetic */ List<PackageCuration> $nonApplicableCurations;
                    {
                        this.$id = $id;
                        this.$nonApplicableCurations = $nonApplicableCurations;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "The provider '" + this.$id + "' returned the following non-applicable curations: " + CollectionsKt.joinToString$default((Iterable)this.$nonApplicableCurations, null, null, null, (int)0, null, null, (int)63, null) + ".";
                    }
                });
            }
            packageCurations.put(id, applicableCurations);
            ConfigurationResolver $this$logger$iv = INSTANCE;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(ConfigurationResolver.class).info((Function0)new Function0<Object>((Set<PackageCuration>)curations, id, duration){
                final /* synthetic */ Set<PackageCuration> $curations;
                final /* synthetic */ String $id;
                final /* synthetic */ long $duration;
                {
                    this.$curations = $curations;
                    this.$id = $id;
                    this.$duration = $duration;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Getting " + this.$curations.size() + " package curation(s) from provider '" + this.$id + "' took " + Duration.toString-impl((long)this.$duration) + ".";
                }
            });
        }
        Map $this$map$iv = packageCurations;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String providerId = (String)entry.getKey();
            List curations = (List)entry.getValue();
            collection.add(new ResolvedPackageCurations(new ResolvedPackageCurations.Provider(providerId), curations));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Resolutions resolveResolutions(@NotNull List<Issue> issues, @NotNull List<RuleViolation> ruleViolations, @NotNull List<Vulnerability> vulnerabilities, @NotNull ResolutionProvider resolutionProvider) {
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(ruleViolations, (String)"ruleViolations");
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        Intrinsics.checkNotNullParameter((Object)resolutionProvider, (String)"resolutionProvider");
        Iterable $this$flatMap$iv = issues;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Issue)element$iv$iv;
            boolean bl = false;
            list$iv$iv = resolutionProvider.getResolutionsFor((Issue)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = ruleViolations;
        List list = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (RuleViolation)element$iv$iv;
            boolean bl = false;
            list$iv$iv = resolutionProvider.getResolutionsFor((RuleViolation)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = vulnerabilities;
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Vulnerability)element$iv$iv;
            boolean bl = false;
            list$iv$iv = resolutionProvider.getResolutionsFor((Vulnerability)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List list4 = CollectionsKt.distinct((Iterable)list3);
        List list5 = list2;
        List list6 = list;
        return new Resolutions(list6, list5, list4);
    }
}

