/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Deferred;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.experimental.SuspendedKt;
import org.ossreviewtoolkit.model.config.PostgresConnection;
import org.ossreviewtoolkit.model.utils.ExposedUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u000f*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000bJ.\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b*\u00020\u001c2\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u001b0\u001e\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\u0010 JG\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001b0\"\"\u0004\b\u0000\u0010\u001b*\u00020\u001c2'\u0010\u001d\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0$\u0012\u0006\u0012\u0004\u0018\u00010\u00010#\u00a2\u0006\u0002\b\u001fH\u0086@\u00a2\u0006\u0002\u0010%R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/ossreviewtoolkit/model/utils/DatabaseUtils;", "", "()V", "dataSources", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/ossreviewtoolkit/model/config/PostgresConnection;", "Lkotlin/Lazy;", "Ljavax/sql/DataSource;", "createHikariDataSource", "config", "applicationNameSuffix", "", "maxPoolSize", "", "addDataSourcePropertyIfDefined", "", "Lcom/zaxxer/hikari/HikariConfig;", "key", "value", "checkDatabaseEncoding", "Lorg/jetbrains/exposed/sql/Transaction;", "expectedEncoding", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lkotlin/Unit;", "tableExists", "", "tableName", "transaction", "T", "Lorg/jetbrains/exposed/sql/Database;", "statement", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "transactionAsync", "Lkotlinx/coroutines/Deferred;", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "model"})
@SourceDebugExtension(value={"SMAP\nDatabaseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseUtils.kt\norg/ossreviewtoolkit/model/utils/DatabaseUtils\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n72#2,2:137\n1#3:139\n1#3:140\n1549#4:141\n1620#4,3:142\n*S KotlinDebug\n*F\n+ 1 DatabaseUtils.kt\norg/ossreviewtoolkit/model/utils/DatabaseUtils\n*L\n71#1:137,2\n71#1:140\n114#1:141\n114#1:142,3\n*E\n"})
public final class DatabaseUtils {
    @NotNull
    public static final DatabaseUtils INSTANCE = new DatabaseUtils();
    @NotNull
    private static final ConcurrentHashMap<PostgresConnection, Lazy<DataSource>> dataSources = new ConcurrentHashMap();

    private DatabaseUtils() {
    }

    @NotNull
    public final Lazy<DataSource> createHikariDataSource(@NotNull PostgresConnection config, @NotNull String applicationNameSuffix, int maxPoolSize) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)applicationNameSuffix, (String)"applicationNameSuffix");
        if (!(!StringsKt.isBlank((CharSequence)config.getUrl()))) {
            boolean $i$a$-require-DatabaseUtils$createHikariDataSource$52 = false;
            String $i$a$-require-DatabaseUtils$createHikariDataSource$52 = "URL for PostgreSQL storage is missing.";
            throw new IllegalArgumentException($i$a$-require-DatabaseUtils$createHikariDataSource$52.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)config.getSchema()))) {
            boolean $i$a$-require-DatabaseUtils$createHikariDataSource$62 = false;
            String $i$a$-require-DatabaseUtils$createHikariDataSource$62 = "Schema for PostgreSQL storage is missing.";
            throw new IllegalArgumentException($i$a$-require-DatabaseUtils$createHikariDataSource$62.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)config.getUsername()))) {
            boolean $i$a$-require-DatabaseUtils$createHikariDataSource$72 = false;
            String $i$a$-require-DatabaseUtils$createHikariDataSource$72 = "Username for PostgreSQL storage is missing.";
            throw new IllegalArgumentException($i$a$-require-DatabaseUtils$createHikariDataSource$72.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)config.getPassword()))) {
            boolean $i$a$-require-DatabaseUtils$createHikariDataSource$82 = false;
            String $i$a$-require-DatabaseUtils$createHikariDataSource$82 = "Password for PostgreSQL storage is missing.";
            throw new IllegalArgumentException($i$a$-require-DatabaseUtils$createHikariDataSource$82.toString());
        }
        ConcurrentMap $this$getOrPut$iv = dataSources;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(config);
        if (object == null) {
            String string;
            HikariConfig hikariConfig;
            boolean bl = false;
            HikariConfig $this$createHikariDataSource_u24lambda_u246_u24lambda_u245 = hikariConfig = new HikariConfig();
            boolean bl2 = false;
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.setJdbcUrl(config.getUrl());
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.setUsername(config.getUsername());
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.setPassword(config.getPassword());
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.setSchema(config.getSchema());
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.setMaximumPoolSize(maxPoolSize);
            String it = string = " - " + applicationNameSuffix;
            boolean bl3 = false;
            Object object2 = ((CharSequence)applicationNameSuffix).length() > 0 ? string : null;
            if (object2 == null) {
                object2 = "";
            }
            String suffix = object2;
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.addDataSourceProperty("ApplicationName", (Object)("OSS Review Toolkit" + suffix));
            $this$createHikariDataSource_u24lambda_u246_u24lambda_u245.addDataSourceProperty("sslmode", (Object)config.getSslmode());
            INSTANCE.addDataSourcePropertyIfDefined($this$createHikariDataSource_u24lambda_u246_u24lambda_u245, "sslcert", config.getSslcert());
            INSTANCE.addDataSourcePropertyIfDefined($this$createHikariDataSource_u24lambda_u246_u24lambda_u245, "sslkey", config.getSslkey());
            INSTANCE.addDataSourcePropertyIfDefined($this$createHikariDataSource_u24lambda_u246_u24lambda_u245, "sslrootcert", config.getSslrootcert());
            HikariConfig dataSourceConfig = hikariConfig;
            Lazy default$iv = LazyKt.lazy((Function0)((Function0)new Function0<HikariDataSource>(dataSourceConfig){
                final /* synthetic */ HikariConfig $dataSourceConfig;
                {
                    this.$dataSourceConfig = $dataSourceConfig;
                    super(0);
                }

                @NotNull
                public final HikariDataSource invoke() {
                    return new HikariDataSource(this.$dataSourceConfig);
                }
            }));
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(config, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (Lazy)object;
    }

    public static /* synthetic */ Lazy createHikariDataSource$default(DatabaseUtils databaseUtils, PostgresConnection postgresConnection, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        return databaseUtils.createHikariDataSource(postgresConnection, string, n);
    }

    @Nullable
    public final Unit checkDatabaseEncoding(@NotNull Transaction $this$checkDatabaseEncoding, @NotNull String expectedEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$checkDatabaseEncoding, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedEncoding, (String)"expectedEncoding");
        return (Unit)ExposedUtilsKt.execShow($this$checkDatabaseEncoding, "SHOW client_encoding", (Function1)new Function1<ResultSet, Unit>(expectedEncoding, $this$checkDatabaseEncoding){
            final /* synthetic */ String $expectedEncoding;
            final /* synthetic */ Transaction $this_checkDatabaseEncoding;
            {
                this.$expectedEncoding = $expectedEncoding;
                this.$this_checkDatabaseEncoding = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ResultSet resultSet) {
                String clientEncoding;
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                if (resultSet.next() && !Intrinsics.areEqual((Object)(clientEncoding = resultSet.getString(1)), (Object)this.$expectedEncoding)) {
                    Transaction $this$logger$iv = this.$this_checkDatabaseEncoding;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(Transaction.class).warn((Function0)new Function0<Object>(clientEncoding, this.$expectedEncoding){
                        final /* synthetic */ String $clientEncoding;
                        final /* synthetic */ String $expectedEncoding;
                        {
                            this.$clientEncoding = $clientEncoding;
                            this.$expectedEncoding = $expectedEncoding;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "The database's client_encoding is '" + this.$clientEncoding + "' but should be '" + this.$expectedEncoding + "'.";
                        }
                    });
                }
            }
        });
    }

    public static /* synthetic */ Unit checkDatabaseEncoding$default(DatabaseUtils databaseUtils, Transaction transaction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "UTF8";
        }
        return databaseUtils.checkDatabaseEncoding(transaction, string);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tableExists(@NotNull Transaction $this$tableExists, @NotNull String tableName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$tableExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Iterable $this$map$iv = $this$tableExists.getDb().getDialect().allTablesNames();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringAfterLast$default((String)it, (String)".", null, (int)2, null));
        }
        return ((List)destination$iv$iv).contains(tableName);
    }

    public final <T> T transaction(@NotNull Database $this$transaction, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"<this>");
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return (T)ThreadLocalTransactionManagerKt.transaction((Database)$this$transaction, statement);
    }

    @Nullable
    public final <T> Object transactionAsync(@NotNull Database $this$transactionAsync, @NotNull Function2<? super Transaction, ? super Continuation<? super T>, ? extends Object> statement, @NotNull Continuation<? super Deferred<? extends T>> $completion) {
        return SuspendedKt.suspendedTransactionAsync$default(null, (Database)$this$transactionAsync, null, statement, $completion, (int)5, null);
    }

    private final void addDataSourcePropertyIfDefined(HikariConfig $this$addDataSourcePropertyIfDefined, String key, String value2) {
        block0: {
            String string = value2;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$addDataSourcePropertyIfDefined.addDataSourceProperty(key, (Object)it);
        }
    }
}

