/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.AnalyzerResult;
import org.ossreviewtoolkit.model.DependencyGraph;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageLinkage;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.config.Excludes;
import org.ossreviewtoolkit.model.utils.DependencyGraphBuilder;
import org.ossreviewtoolkit.model.utils.DependencyHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000bJ*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0014\u0010\u0014\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/ossreviewtoolkit/model/utils/DependencyGraphConverter;", "", "()V", "buildDependencyGraphs", "", "", "Lorg/ossreviewtoolkit/model/DependencyGraph;", "projects", "", "Lorg/ossreviewtoolkit/model/Project;", "excludes", "Lorg/ossreviewtoolkit/model/config/Excludes;", "convert", "Lorg/ossreviewtoolkit/model/AnalyzerResult;", "result", "filterExcludedPackages", "Lorg/ossreviewtoolkit/model/Package;", "graphs", "", "packages", "convertToScopeNames", "projectsWithScopes", "ScopesDependencyHandler", "model"})
@SourceDebugExtension(value={"SMAP\nDependencyGraphConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyGraphConverter.kt\norg/ossreviewtoolkit/model/utils/DependencyGraphConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1620#2,3:149\n1477#2:152\n1502#2,3:153\n1505#2,3:163\n1855#2:167\n819#2:168\n847#2,2:169\n1855#2:171\n1855#2,2:172\n1856#2:174\n1856#2:175\n1446#2,5:177\n857#2,2:182\n857#2,2:184\n819#2:187\n847#2,2:188\n1620#2,3:190\n372#3,7:156\n215#4:166\n216#4:176\n1#5:186\n*S KotlinDebug\n*F\n+ 1 DependencyGraphConverter.kt\norg/ossreviewtoolkit/model/utils/DependencyGraphConverter\n*L\n66#1:149,3\n79#1:152\n79#1:153,3\n79#1:163,3\n82#1:167\n83#1:168\n83#1:169,2\n83#1:171\n85#1:172,2\n83#1:174\n82#1:175\n105#1:177,5\n106#1:182,2\n114#1:184,2\n123#1:187\n123#1:188,2\n123#1:190,3\n79#1:156,7\n79#1:166\n79#1:176\n*E\n"})
public final class DependencyGraphConverter {
    @NotNull
    public static final DependencyGraphConverter INSTANCE = new DependencyGraphConverter();

    private DependencyGraphConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalyzerResult convert(@NotNull AnalyzerResult result, @NotNull Excludes excludes) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)excludes, (String)"excludes");
        Set<Project> projectsToConvert = this.projectsWithScopes(result);
        if (projectsToConvert.isEmpty()) {
            return result;
        }
        Map<String, DependencyGraph> graphs = this.buildDependencyGraphs(projectsToConvert, excludes);
        Map allGraphs = MapsKt.plus(result.getDependencyGraphs(), graphs);
        Set<Package> filteredPackages = excludes.getScopes().isEmpty() ? result.getPackages() : this.filterExcludedPackages(allGraphs.values(), (Collection<Package>)result.getPackages());
        Iterable iterable = result.getProjects();
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Project project = (Project)item$iv;
            void var15_14 = destination$iv;
            boolean bl = false;
            var15_14.add(INSTANCE.convertToScopeNames((Project)it, excludes));
        }
        Set set = (Set)destination$iv;
        return AnalyzerResult.copy$default(result, set, filteredPackages, null, allGraphs, 4, null);
    }

    public static /* synthetic */ AnalyzerResult convert$default(DependencyGraphConverter dependencyGraphConverter, AnalyzerResult analyzerResult, Excludes excludes, int n, Object object) {
        if ((n & 2) != 0) {
            excludes = Excludes.EMPTY;
        }
        return dependencyGraphConverter.convert(analyzerResult, excludes);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DependencyGraph> buildDependencyGraphs(Set<Project> projects2, Excludes excludes) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map graphs = new LinkedHashMap();
        Object $this$groupBy$iv = projects2;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getId().getType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String type = (String)entry.getKey();
            List projectsForType = (List)entry.getValue();
            DependencyGraphBuilder<PackageReference> builder = new DependencyGraphBuilder<PackageReference>(ScopesDependencyHandler.INSTANCE);
            Iterable $this$forEach$iv2 = projectsForType;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$forEach$iv3;
                void $this$filterNotTo$iv$iv;
                Project project = (Project)element$iv2;
                boolean bl3 = false;
                Iterable $this$filterNot$iv = project.getScopes();
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Scope it = (Scope)element$iv$iv;
                    boolean bl4 = false;
                    if (excludes.isScopeExcluded(it.getName())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Scope scope = (Scope)element$iv3;
                    boolean bl5 = false;
                    String scopeName = DependencyGraph.Companion.qualifyScope(project, scope.getName());
                    Iterable $this$forEach$iv4 = scope.getDependencies();
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv4 : $this$forEach$iv4) {
                        PackageReference dependency = (PackageReference)element$iv4;
                        boolean bl6 = false;
                        builder.addDependency(scopeName, dependency);
                    }
                }
            }
            graphs.put(type, builder.build(false));
        }
        return graphs;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Package> filterExcludedPackages(Collection<DependencyGraph> graphs, Collection<Package> packages2) {
        void $this$filterTo$iv;
        Collection destination$iv;
        Object it;
        Iterable $this$flatMapTo$iv;
        Iterable iterable = graphs;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            it = (DependencyGraph)element$iv;
            boolean bl = false;
            Iterable list$iv = ((DependencyGraph)it).getPackages();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set includedPackages = (Set)destination$iv;
        $this$flatMapTo$iv = packages2;
        destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (Package)element$iv;
            boolean bl = false;
            if (!includedPackages.contains(((Package)it).getId())) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Project> projectsWithScopes(AnalyzerResult $this$projectsWithScopes) {
        void var3_3;
        void $this$filterTo$iv;
        Iterable iterable = $this$projectsWithScopes.getProjects();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Set<Scope> set = it.getScopeDependencies();
            boolean bl2 = set != null ? !((Collection)set).isEmpty() : false;
            if (!bl2) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final Project convertToScopeNames(Project $this$convertToScopeNames, Excludes excludes) {
        Object object = $this$convertToScopeNames;
        Project it = object;
        boolean bl = false;
        Object object2 = $this$convertToScopeNames.getScopeNames() != null ? object : null;
        if (object2 == null) {
            void destination$iv;
            void $this$mapTo$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$convertToScopeNames.getScopes();
            boolean $i$f$filterNot22 = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Scope it2 = (Scope)element$iv$iv;
                boolean bl2 = false;
                if (excludes.isScopeExcluded(it2.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            Collection $i$f$filterNot22 = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                Scope scope = (Scope)item$iv;
                void var13_17 = destination$iv;
                boolean bl3 = false;
                var13_17.add(it3.getName());
            }
            object = (Set)destination$iv;
            object2 = Project.copy$default($this$convertToScopeNames, null, null, null, null, null, null, null, null, null, null, (Set)object, 511, null);
        }
        return object2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/model/utils/DependencyGraphConverter$ScopesDependencyHandler;", "Lorg/ossreviewtoolkit/model/utils/DependencyHandler;", "Lorg/ossreviewtoolkit/model/PackageReference;", "()V", "createPackage", "Lorg/ossreviewtoolkit/model/Package;", "dependency", "issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "dependenciesFor", "", "identifierFor", "Lorg/ossreviewtoolkit/model/Identifier;", "issuesForDependency", "linkageFor", "Lorg/ossreviewtoolkit/model/PackageLinkage;", "model"})
    private static final class ScopesDependencyHandler
    implements DependencyHandler<PackageReference> {
        @NotNull
        public static final ScopesDependencyHandler INSTANCE = new ScopesDependencyHandler();

        private ScopesDependencyHandler() {
        }

        @Override
        @NotNull
        public Identifier identifierFor(@NotNull PackageReference dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            return dependency.getId();
        }

        @Override
        @NotNull
        public Collection<PackageReference> dependenciesFor(@NotNull PackageReference dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            return dependency.getDependencies();
        }

        @Override
        @NotNull
        public PackageLinkage linkageFor(@NotNull PackageReference dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            return dependency.getLinkage();
        }

        @Override
        @Nullable
        public Package createPackage(@NotNull PackageReference dependency, @NotNull List<Issue> issues) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter(issues, (String)"issues");
            return null;
        }

        @Override
        @NotNull
        public Collection<Issue> issuesForDependency(@NotNull PackageReference dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            return dependency.getIssues();
        }
    }
}

