/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.ArtifactProvenance;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.ProvenanceResolutionResult;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.SourceCodeOrigin;
import org.ossreviewtoolkit.model.TextLocation;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.utils.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0006\u001a\u0016\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"vcsPath", "", "Lorg/ossreviewtoolkit/model/Provenance;", "getVcsPath", "(Lorg/ossreviewtoolkit/model/Provenance;)Ljava/lang/String;", "alignRevisions", "Lorg/ossreviewtoolkit/model/RepositoryProvenance;", "clearVcsPath", "getKnownProvenancesWithoutVcsPath", "", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "Lorg/ossreviewtoolkit/model/ProvenanceResolutionResult;", "parseRepoManifestPath", "prependPath", "prefix", "Lorg/ossreviewtoolkit/model/TextLocation;", "prependedPath", "requireNotEmptyNoDuplicates", "", "", "Lorg/ossreviewtoolkit/model/SourceCodeOrigin;", "model"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/model/utils/ExtensionsKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n403#2:103\n1238#3,4:104\n1#4:108\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/model/utils/ExtensionsKt\n*L\n59#1:103\n59#1:104,4\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String prependPath(@NotNull String $this$prependPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prependPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.isBlank((CharSequence)prefix) ? $this$prependPath : StringsKt.removeSuffix((String)prefix, (CharSequence)"/") + "/" + $this$prependPath;
    }

    @NotNull
    public static final String prependedPath(@NotNull TextLocation $this$prependedPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prependedPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return ExtensionsKt.prependPath($this$prependedPath.getPath(), prefix);
    }

    @NotNull
    public static final TextLocation prependPath(@NotNull TextLocation $this$prependPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$prependPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return ((CharSequence)prefix).length() == 0 ? $this$prependPath : TextLocation.copy$default($this$prependPath, ExtensionsKt.prependPath($this$prependPath.getPath(), prefix), 0, 0, 6, null);
    }

    @NotNull
    public static final String getVcsPath(@NotNull Provenance $this$vcsPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$vcsPath, (String)"<this>");
        Object object = $this$vcsPath instanceof RepositoryProvenance ? (RepositoryProvenance)$this$vcsPath : null;
        if ((object != null && (object = ((RepositoryProvenance)object).getVcsInfo()) != null ? ((VcsInfo)object).getPath() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, KnownProvenance> getKnownProvenancesWithoutVcsPath(@NotNull ProvenanceResolutionResult $this$getKnownProvenancesWithoutVcsPath) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$getKnownProvenancesWithoutVcsPath, (String)"<this>");
        Map $this$getKnownProvenancesWithoutVcsPath_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        KnownProvenance knownProvenance = $this$getKnownProvenancesWithoutVcsPath.getPackageProvenance();
        if (knownProvenance instanceof RepositoryProvenance) {
            $this$getKnownProvenancesWithoutVcsPath_u24lambda_u241.put("", ExtensionsKt.alignRevisions(ExtensionsKt.clearVcsPath((RepositoryProvenance)$this$getKnownProvenancesWithoutVcsPath.getPackageProvenance())));
        } else if (knownProvenance instanceof ArtifactProvenance) {
            $this$getKnownProvenancesWithoutVcsPath_u24lambda_u241.put("", $this$getKnownProvenancesWithoutVcsPath.getPackageProvenance());
        }
        Map<String, VcsInfo> $this$mapValuesTo$iv = $this$getKnownProvenancesWithoutVcsPath.getSubRepositories();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = $this$getKnownProvenancesWithoutVcsPath_u24lambda_u241;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            VcsInfo vcsInfo = (VcsInfo)entry2.getValue();
            RepositoryProvenance repositoryProvenance = new RepositoryProvenance(vcsInfo, vcsInfo.getRevision());
            map3.put(k, repositoryProvenance);
        }
        return MapsKt.build((Map)map);
    }

    @NotNull
    public static final RepositoryProvenance clearVcsPath(@NotNull RepositoryProvenance $this$clearVcsPath) {
        Intrinsics.checkNotNullParameter((Object)$this$clearVcsPath, (String)"<this>");
        return RepositoryProvenance.copy$default($this$clearVcsPath, VcsInfo.copy$default($this$clearVcsPath.getVcsInfo(), null, null, null, "", 7, null), null, 2, null);
    }

    @NotNull
    public static final RepositoryProvenance alignRevisions(@NotNull RepositoryProvenance $this$alignRevisions) {
        Intrinsics.checkNotNullParameter((Object)$this$alignRevisions, (String)"<this>");
        return RepositoryProvenance.copy$default($this$alignRevisions, VcsInfo.copy$default($this$alignRevisions.getVcsInfo(), null, null, $this$alignRevisions.getResolvedRevision(), null, 11, null), null, 2, null);
    }

    @Nullable
    public static final String parseRepoManifestPath(@NotNull String $this$parseRepoManifestPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parseRepoManifestPath, (String)"<this>");
        Object object2 = $this$parseRepoManifestPath;
        try {
            Object object3;
            Object v1;
            Object object4;
            Object object5;
            block5: {
                String $this$parseRepoManifestPath_u24lambda_u244 = object2;
                boolean bl = false;
                String string = new URI($this$parseRepoManifestPath_u24lambda_u244).getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
                object5 = new String[]{"&"};
                object4 = SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)string, (String[])object5, (boolean)false, (int)0, (int)6, null), (Function1)parseRepoManifestPath.1.1.INSTANCE);
                for (Object e : object4) {
                    List it = (List)e;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)it), (Object)"manifest")) continue;
                    v1 = e;
                    break block5;
                }
                v1 = null;
            }
            List list = v1;
            if (list != null && (object5 = (String)list.get(1)) != null) {
                Object it = object4 = object5;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() == 0;
                object3 = !bl2 ? object4 : null;
            } else {
                object3 = null;
            }
            object = Result.constructor-impl(object3);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    public static final void requireNotEmptyNoDuplicates(@NotNull List<? extends SourceCodeOrigin> $this$requireNotEmptyNoDuplicates) {
        Intrinsics.checkNotNullParameter($this$requireNotEmptyNoDuplicates, (String)"<this>");
        if (!(!((Collection)$this$requireNotEmptyNoDuplicates).isEmpty())) {
            boolean bl = false;
            String string = "'sourceCodeOrigins' must not be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        Set duplicates = org.ossreviewtoolkit.utils.common.ExtensionsKt.getDuplicates((Collection)$this$requireNotEmptyNoDuplicates);
        if (!duplicates.isEmpty()) {
            boolean bl = false;
            String string = "'sourceCodeOrigins' must not contain duplicates. Duplicates: " + duplicates;
            throw new IllegalArgumentException(string.toString());
        }
    }
}

