/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.utils.FileArchiver;
import org.ossreviewtoolkit.model.utils.ProvenanceFileStorage;
import org.ossreviewtoolkit.utils.common.ArchiveUtilsKt;
import org.ossreviewtoolkit.utils.common.FileMatcher;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/ossreviewtoolkit/model/utils/FileArchiver;", "", "patterns", "", "", "storage", "Lorg/ossreviewtoolkit/model/utils/ProvenanceFileStorage;", "(Ljava/util/Collection;Lorg/ossreviewtoolkit/model/utils/ProvenanceFileStorage;)V", "matcher", "Lorg/ossreviewtoolkit/utils/common/FileMatcher;", "archive", "", "directory", "Ljava/io/File;", "provenance", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "hasArchive", "", "unarchive", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nFileArchiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileArchiver.kt\norg/ossreviewtoolkit/model/utils/FileArchiver\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,124:1\n38#2:125\n38#2:137\n38#2:149\n38#2:162\n38#2:174\n38#2:175\n18#3,4:126\n50#3,7:130\n18#3,4:138\n50#3,7:142\n79#3,5:150\n113#3,7:155\n18#3,4:163\n50#3,7:167\n*S KotlinDebug\n*F\n+ 1 FileArchiver.kt\norg/ossreviewtoolkit/model/utils/FileArchiver\n*L\n72#1:125\n92#1:137\n96#1:149\n107#1:162\n114#1:174\n120#1:175\n76#1:126,4\n76#1:130,7\n94#1:138,4\n94#1:142,7\n105#1:150,5\n105#1:155,7\n112#1:163,4\n112#1:167,7\n*E\n"})
public final class FileArchiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProvenanceFileStorage storage;
    @NotNull
    private final FileMatcher matcher;
    @NotNull
    private static final Lazy<File> DEFAULT_ARCHIVE_DIR$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_ARCHIVE_DIR.2.INSTANCE);

    public FileArchiver(@NotNull Collection<String> patterns, @NotNull ProvenanceFileStorage storage) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.matcher = new FileMatcher(patterns, true);
    }

    public final boolean hasArchive(@NotNull KnownProvenance provenance) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        return this.storage.hasData(provenance);
    }

    public final void archive(@NotNull File directory, @NotNull KnownProvenance provenance) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        FileArchiver $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).info((Function0)new Function0<Object>(this, directory){
            final /* synthetic */ FileArchiver this$0;
            final /* synthetic */ File $directory;
            {
                this.this$0 = $receiver;
                this.$directory = $directory;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Archiving files matching " + FileArchiver.access$getMatcher$p(this.this$0).getPatterns() + " from '" + this.$directory + "'...";
            }
        });
        File zipFile = ExtensionsKt.createOrtTempFile$default((Object)this, null, (String)".zip", (int)1, null);
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ArchiveUtilsKt.packZip$default((File)directory, (File)zipFile, null, (boolean)true, null, (Function1)((Function1)new Function1<File, Boolean>(directory, this){
            final /* synthetic */ File $directory;
            final /* synthetic */ FileArchiver this$0;
            {
                this.$directory = $directory;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String relativePath = FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file, (File)this.$directory));
                Boolean bl = FileArchiver.access$getMatcher$p(this.this$0).matches(relativePath);
                FileArchiver fileArchiver = this.this$0;
                boolean result = bl;
                boolean bl2 = false;
                FileArchiver $this$logger$iv = fileArchiver;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).debug((Function0)new Function0<Object>(result, relativePath){
                    final /* synthetic */ boolean $result;
                    final /* synthetic */ String $relativePath;
                    {
                        this.$result = $result;
                        this.$relativePath = $relativePath;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$result ? "Adding '" + this.$relativePath + "' to archive." : "Not adding '" + this.$relativePath + "' to archive.";
                    }
                });
                return bl;
            }
        }), (int)10, null);
        long zipDuration2 = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        FileArchiver $this$logger$iv2 = this;
        boolean $i$f$getLogger2 = false;
        LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).info((Function0)new Function0<Object>(directory, zipDuration2){
            final /* synthetic */ File $directory;
            final /* synthetic */ long $zipDuration;
            {
                this.$directory = $directory;
                this.$zipDuration = $zipDuration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Archived directory '" + this.$directory + "' in " + Duration.toString-impl((long)this.$zipDuration) + ".";
            }
        });
        $i$f$measureTime2 = false;
        TimeSource.Monotonic $this$measureTime$iv$iv2 = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime3 = false;
        long mark$iv$iv2 = $this$measureTime$iv$iv2.markNow-z9LOYto();
        boolean bl2 = false;
        this.storage.putData(provenance, new FileInputStream(zipFile), zipFile.length());
        long writeDuration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv2);
        FileArchiver $this$logger$iv3 = this;
        boolean $i$f$getLogger3 = false;
        LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).info((Function0)new Function0<Object>(directory, writeDuration){
            final /* synthetic */ File $directory;
            final /* synthetic */ long $writeDuration;
            {
                this.$directory = $directory;
                this.$writeDuration = $writeDuration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Wrote archive of directory '" + this.$directory + "' to storage in " + Duration.toString-impl((long)this.$writeDuration) + ".";
            }
        });
        File file = zipFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        org.ossreviewtoolkit.utils.common.ExtensionsKt.safeDeleteRecursively$default((File)file, (boolean)true, null, (int)2, null);
    }

    public final boolean unarchive(@NotNull File directory, @NotNull KnownProvenance provenance) {
        Object object;
        block3: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            InputStream result$iv$iv = this.storage.getData(provenance);
            TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            InputStream zipInputStream = (InputStream)timedValue.component1();
            long readDuration = timedValue.component2-UwyO8pc();
            FileArchiver $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).info((Function0)new Function0<Object>(directory, readDuration){
                final /* synthetic */ File $directory;
                final /* synthetic */ long $readDuration;
                {
                    this.$directory = $directory;
                    this.$readDuration = $readDuration;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Read archive of directory '" + this.$directory + "' from storage in " + Duration.toString-impl((long)this.$readDuration) + ".";
                }
            });
            if (zipInputStream == null) {
                return false;
            }
            object = this;
            try {
                FileArchiver $this$unarchive_u24lambda_u244 = object;
                boolean bl2 = false;
                boolean $i$f$measureTime = false;
                TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTime2 = false;
                long mark$iv$iv2 = $this$measureTime$iv$iv.markNow-z9LOYto();
                boolean bl3 = false;
                ArchiveUtilsKt.unpackZip((InputStream)zipInputStream, (File)directory);
                long unzipDuration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv2);
                FileArchiver $this$logger$iv2 = $this$unarchive_u24lambda_u244;
                boolean $i$f$getLogger2 = false;
                LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).info((Function0)new Function0<Object>(provenance, directory, unzipDuration){
                    final /* synthetic */ KnownProvenance $provenance;
                    final /* synthetic */ File $directory;
                    final /* synthetic */ long $unzipDuration;
                    {
                        this.$provenance = $provenance;
                        this.$directory = $directory;
                        this.$unzipDuration = $unzipDuration;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unarchived data for " + this.$provenance + " to '" + this.$directory + "' in " + Duration.toString-impl((long)this.$unzipDuration) + ".";
                    }
                });
                object2 = Result.constructor-impl((Object)true);
            }
            catch (Throwable bl2) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object it = object2 = throwable;
            boolean bl4 = false;
            ExtensionsKt.showStackTrace((Throwable)it);
            FileArchiver $this$logger$iv3 = this;
            boolean $i$f$getLogger3 = false;
            LoggingFactoryKt.cachedLoggerOf(FileArchiver.class).error((Function0)new Function0<Object>(provenance, (Throwable)it){
                final /* synthetic */ KnownProvenance $provenance;
                final /* synthetic */ Throwable $it;
                {
                    this.$provenance = $provenance;
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Failed to unarchive data for " + this.$provenance + ": " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)this.$it);
                }
            });
        }
        return Result.isSuccess-impl((Object)object);
    }

    public static final /* synthetic */ FileMatcher access$getMatcher$p(FileArchiver $this) {
        return $this.matcher;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/ossreviewtoolkit/model/utils/FileArchiver$Companion;", "", "()V", "DEFAULT_ARCHIVE_DIR", "Ljava/io/File;", "getDEFAULT_ARCHIVE_DIR", "()Ljava/io/File;", "DEFAULT_ARCHIVE_DIR$delegate", "Lkotlin/Lazy;", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getDEFAULT_ARCHIVE_DIR() {
            Lazy lazy = DEFAULT_ARCHIVE_DIR$delegate;
            return (File)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

