/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.utils.FileProvenanceFileStorageKt;
import org.ossreviewtoolkit.model.utils.ProvenanceFileStorage;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.ort.storage.FileStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/ossreviewtoolkit/model/utils/FileProvenanceFileStorage;", "Lorg/ossreviewtoolkit/model/utils/ProvenanceFileStorage;", "storage", "Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;", "filename", "", "(Lorg/ossreviewtoolkit/utils/ort/storage/FileStorage;Ljava/lang/String;)V", "getData", "Ljava/io/InputStream;", "provenance", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "getFilePath", "hasData", "", "putData", "", "data", "size", "", "model"})
@SourceDebugExtension(value={"SMAP\nFileProvenanceFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileProvenanceFileStorage.kt\norg/ossreviewtoolkit/model/utils/FileProvenanceFileStorage\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,88:1\n38#2:89\n*S KotlinDebug\n*F\n+ 1 FileProvenanceFileStorage.kt\norg/ossreviewtoolkit/model/utils/FileProvenanceFileStorage\n*L\n70#1:89\n*E\n"})
public final class FileProvenanceFileStorage
implements ProvenanceFileStorage {
    @NotNull
    private final FileStorage storage;
    @NotNull
    private final String filename;

    public FileProvenanceFileStorage(@NotNull FileStorage storage, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.storage = storage;
        this.filename = filename;
        if (!(((CharSequence)this.filename).length() > 0)) {
            boolean bl = false;
            String string = "The filename must not be empty.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean hasData(@NotNull KnownProvenance provenance) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        String filePath = this.getFilePath(provenance);
        return this.storage.exists(filePath);
    }

    @Override
    public void putData(@NotNull KnownProvenance provenance, @NotNull InputStream data, long size) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.storage.write(this.getFilePath(provenance), data);
    }

    @Override
    @Nullable
    public InputStream getData(@NotNull KnownProvenance provenance) {
        Object object;
        block2: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
            String filePath = this.getFilePath(provenance);
            object = this;
            try {
                FileProvenanceFileStorage $this$getData_u24lambda_u241 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)$this$getData_u24lambda_u241.storage.read(filePath));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            FileProvenanceFileStorage $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            LoggingFactoryKt.cachedLoggerOf(FileProvenanceFileStorage.class).error((Function0)new Function0<Object>(filePath, (Throwable)it){
                final /* synthetic */ String $filePath;
                final /* synthetic */ Throwable $it;
                {
                    this.$filePath = $filePath;
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Could not read from " + this.$filePath + ": " + ExtensionsKt.collectMessages((Throwable)this.$it);
                }
            });
        }
        return (InputStream)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final String getFilePath(KnownProvenance provenance) {
        return FileProvenanceFileStorageKt.access$hash(provenance) + "/" + this.filename;
    }
}

