/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.LicenseFinding;
import org.ossreviewtoolkit.model.config.LicenseFindingCuration;
import org.ossreviewtoolkit.model.licenses.LicenseFindingCurationResult;
import org.ossreviewtoolkit.model.utils.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.FileMatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u0017"}, d2={"Lorg/ossreviewtoolkit/model/utils/FindingCurationMatcher;", "", "()V", "apply", "Lorg/ossreviewtoolkit/model/LicenseFinding;", "finding", "curation", "Lorg/ossreviewtoolkit/model/config/LicenseFindingCuration;", "relativeFindingPath", "", "applyAll", "", "Lorg/ossreviewtoolkit/model/licenses/LicenseFindingCurationResult;", "findings", "", "curations", "relativeFindingsPath", "isDetectedLicenseMatching", "", "isLineCountMatching", "isPathMatching", "isStartLineMatching", "matches", "model"})
@SourceDebugExtension(value={"SMAP\nFindingCurationMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindingCurationMatcher.kt\norg/ossreviewtoolkit/model/utils/FindingCurationMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n1747#2,3:110\n1855#2:113\n766#2:114\n857#2,2:115\n1855#2:117\n1856#2:125\n1856#2:133\n372#3,7:118\n372#3,7:126\n125#4:134\n152#4,3:135\n*S KotlinDebug\n*F\n+ 1 FindingCurationMatcher.kt\norg/ossreviewtoolkit/model/utils/FindingCurationMatcher\n*L\n43#1:110,3\n92#1:113\n93#1:114\n93#1:115,2\n95#1:117\n95#1:125\n92#1:133\n97#1:118,7\n100#1:126,7\n104#1:134\n104#1:135,3\n*E\n"})
public final class FindingCurationMatcher {
    private final boolean isPathMatching(LicenseFinding finding, LicenseFindingCuration curation, String relativeFindingPath) {
        return FileMatcher.Companion.match$default((FileMatcher.Companion)FileMatcher.Companion, (String)curation.getPath(), (String)ExtensionsKt.prependedPath(finding.getLocation(), relativeFindingPath), (boolean)false, (int)4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStartLineMatching(LicenseFinding finding, LicenseFindingCuration curation) {
        boolean bl;
        if (curation.getStartLines().isEmpty()) return true;
        Iterable $this$any$iv = curation.getStartLines();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if (it == finding.getLocation().getStartLine()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLineCountMatching(LicenseFinding finding, LicenseFindingCuration curation) {
        if (curation.getLineCount() == null) return true;
        Integer n = curation.getLineCount();
        int n2 = finding.getLocation().getEndLine() - finding.getLocation().getStartLine() + 1;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    private final boolean isDetectedLicenseMatching(LicenseFinding finding, LicenseFindingCuration curation) {
        return curation.getDetectedLicense() == null || Intrinsics.areEqual((Object)curation.getDetectedLicense(), (Object)finding.getLicense());
    }

    public final boolean matches(@NotNull LicenseFinding finding, @NotNull LicenseFindingCuration curation, @NotNull String relativeFindingPath) {
        Intrinsics.checkNotNullParameter((Object)finding, (String)"finding");
        Intrinsics.checkNotNullParameter((Object)curation, (String)"curation");
        Intrinsics.checkNotNullParameter((Object)relativeFindingPath, (String)"relativeFindingPath");
        return this.isPathMatching(finding, curation, relativeFindingPath) && this.isStartLineMatching(finding, curation) && this.isLineCountMatching(finding, curation) && this.isDetectedLicenseMatching(finding, curation);
    }

    public static /* synthetic */ boolean matches$default(FindingCurationMatcher findingCurationMatcher, LicenseFinding licenseFinding, LicenseFindingCuration licenseFindingCuration, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return findingCurationMatcher.matches(licenseFinding, licenseFindingCuration, string);
    }

    @Nullable
    public final LicenseFinding apply(@NotNull LicenseFinding finding, @NotNull LicenseFindingCuration curation, @NotNull String relativeFindingPath) {
        Intrinsics.checkNotNullParameter((Object)finding, (String)"finding");
        Intrinsics.checkNotNullParameter((Object)curation, (String)"curation");
        Intrinsics.checkNotNullParameter((Object)relativeFindingPath, (String)"relativeFindingPath");
        return !this.matches(finding, curation, relativeFindingPath) ? finding : (Intrinsics.areEqual((Object)curation.getConcludedLicense().toString(), (Object)"NONE") ? null : LicenseFinding.copy$default(finding, curation.getConcludedLicense(), null, null, 6, null));
    }

    public static /* synthetic */ LicenseFinding apply$default(FindingCurationMatcher findingCurationMatcher, LicenseFinding licenseFinding, LicenseFindingCuration licenseFindingCuration, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return findingCurationMatcher.apply(licenseFinding, licenseFindingCuration, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LicenseFindingCurationResult> applyAll(@NotNull Collection<LicenseFinding> findings, @NotNull Collection<LicenseFindingCuration> curations, @NotNull String relativeFindingsPath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(findings, (String)"findings");
        Intrinsics.checkNotNullParameter(curations, (String)"curations");
        Intrinsics.checkNotNullParameter((Object)relativeFindingsPath, (String)"relativeFindingsPath");
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = findings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterator $this$filterTo$iv$iv;
            LicenseFinding finding = (LicenseFinding)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = curations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                LicenseFindingCuration it = (LicenseFindingCuration)element$iv$iv;
                boolean bl2 = false;
                if (!this.matches(finding, it, relativeFindingsPath)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List matchingCurations = (List)destination$iv$iv;
            if (!((Collection)matchingCurations).isEmpty()) {
                Iterable $this$forEach$iv2 = matchingCurations;
                boolean $i$f$forEach2 = false;
                $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object object;
                    Object element$iv2 = $this$filterTo$iv$iv.next();
                    LicenseFindingCuration curation = (LicenseFindingCuration)element$iv2;
                    boolean bl3 = false;
                    LicenseFinding curatedFinding = this.apply(finding, curation, relativeFindingsPath);
                    Map $this$getOrPut$iv = result;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(curatedFinding);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(curatedFinding, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Collection collection = (Collection)object;
                    collection.add(new Pair((Object)finding, (Object)curation));
                }
                continue;
            }
            Map $this$getOrPut$iv = result;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(finding);
            if (value$iv != null) continue;
            boolean bl5 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(finding, answer$iv);
        }
        Map $this$map$iv = result;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LicenseFinding curatedFinding = (LicenseFinding)entry.getKey();
            List originalFindings = (List)entry.getValue();
            collection.add(new LicenseFindingCurationResult(curatedFinding, originalFindings));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List applyAll$default(FindingCurationMatcher findingCurationMatcher, Collection collection, Collection collection2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return findingCurationMatcher.applyAll(collection, collection2, string);
    }
}

