/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.net.URLDecoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.ArtifactProvenance;
import org.ossreviewtoolkit.model.Hash;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Provenance;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.RepositoryProvenance;
import org.ossreviewtoolkit.model.UnknownProvenance;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.VcsType;
import org.ossreviewtoolkit.model.utils.PurlExtras;
import org.ossreviewtoolkit.model.utils.PurlType;
import org.ossreviewtoolkit.model.utils.PurlUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a,\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u0001H\u0007\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0004\u00a8\u0006\f"}, d2={"getPurlType", "", "Lorg/ossreviewtoolkit/model/Identifier;", "toProvenance", "Lorg/ossreviewtoolkit/model/Provenance;", "toPurl", "qualifiers", "", "subpath", "extras", "Lorg/ossreviewtoolkit/model/utils/PurlExtras;", "toPurlExtras", "model"})
@SourceDebugExtension(value={"SMAP\nPurlExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurlExtensions.kt\norg/ossreviewtoolkit/model/utils/PurlExtensionsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,146:1\n643#2,5:147\n*S KotlinDebug\n*F\n+ 1 PurlExtensions.kt\norg/ossreviewtoolkit/model/utils/PurlExtensionsKt\n*L\n111#1:147,5\n*E\n"})
public final class PurlExtensionsKt {
    @NotNull
    public static final String getPurlType(@NotNull Identifier $this$getPurlType) {
        PurlType purlType;
        Intrinsics.checkNotNullParameter((Object)$this$getPurlType, (String)"<this>");
        String string = $this$getPurlType.getType().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "bower": {
                purlType = PurlType.BOWER;
                break;
            }
            case "carthage": {
                purlType = PurlType.CARTHAGE;
                break;
            }
            case "composer": {
                purlType = PurlType.COMPOSER;
                break;
            }
            case "conan": {
                purlType = PurlType.CONAN;
                break;
            }
            case "crate": {
                purlType = PurlType.CARGO;
                break;
            }
            case "go": {
                purlType = PurlType.GOLANG;
                break;
            }
            case "gem": {
                purlType = PurlType.GEM;
                break;
            }
            case "hackage": {
                purlType = PurlType.HACKAGE;
                break;
            }
            case "maven": {
                purlType = PurlType.MAVEN;
                break;
            }
            case "npm": {
                purlType = PurlType.NPM;
                break;
            }
            case "nuget": {
                purlType = PurlType.NUGET;
                break;
            }
            case "pod": {
                purlType = PurlType.COCOAPODS;
                break;
            }
            case "pub": {
                purlType = PurlType.PUB;
                break;
            }
            case "pypi": {
                purlType = PurlType.PYPI;
                break;
            }
            case "swift": {
                purlType = PurlType.SWIFT;
                break;
            }
            default: {
                purlType = PurlType.GENERIC;
            }
        }
        return purlType.toString();
    }

    @JvmOverloads
    @NotNull
    public static final String toPurl(@NotNull Identifier $this$toPurl, @NotNull Map<String, String> qualifiers, @NotNull String subpath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPurl, (String)"<this>");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        Intrinsics.checkNotNullParameter((Object)subpath, (String)"subpath");
        return Intrinsics.areEqual((Object)$this$toPurl, (Object)Identifier.EMPTY) ? "" : PurlUtilsKt.createPurl(PurlExtensionsKt.getPurlType($this$toPurl), $this$toPurl.getNamespace(), $this$toPurl.getName(), $this$toPurl.getVersion(), qualifiers, subpath);
    }

    public static /* synthetic */ String toPurl$default(Identifier identifier, Map map, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return PurlExtensionsKt.toPurl(identifier, map, string);
    }

    @NotNull
    public static final String toPurl(@NotNull Identifier $this$toPurl, @NotNull PurlExtras extras) {
        Intrinsics.checkNotNullParameter((Object)$this$toPurl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        return PurlExtensionsKt.toPurl($this$toPurl, extras.getQualifiers(), extras.getSubpath());
    }

    @NotNull
    public static final PurlExtras toPurlExtras(@NotNull Provenance $this$toPurlExtras) {
        PurlExtras purlExtras;
        Intrinsics.checkNotNullParameter((Object)$this$toPurlExtras, (String)"<this>");
        Provenance provenance = $this$toPurlExtras;
        if (provenance instanceof ArtifactProvenance) {
            RemoteArtifact $this$toPurlExtras_u24lambda_u240 = ((ArtifactProvenance)$this$toPurlExtras).getSourceArtifact();
            boolean bl = false;
            String string = $this$toPurlExtras_u24lambda_u240.getHash().getAlgorithm().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String checksum = string + ":" + $this$toPurlExtras_u24lambda_u240.getHash().getValue();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"download_url", (Object)$this$toPurlExtras_u24lambda_u240.getUrl()), TuplesKt.to((Object)"checksum", (Object)checksum)};
            PurlExtras purlExtras2 = new PurlExtras(pairArray, null, 2, null);
            purlExtras = purlExtras2;
        } else if (provenance instanceof RepositoryProvenance) {
            VcsInfo $this$toPurlExtras_u24lambda_u241 = ((RepositoryProvenance)$this$toPurlExtras).getVcsInfo();
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"vcs_type", (Object)$this$toPurlExtras_u24lambda_u241.getType().toString()), TuplesKt.to((Object)"vcs_url", (Object)$this$toPurlExtras_u24lambda_u241.getUrl()), TuplesKt.to((Object)"vcs_revision", (Object)$this$toPurlExtras_u24lambda_u241.getRevision()), TuplesKt.to((Object)"resolved_revision", (Object)((RepositoryProvenance)$this$toPurlExtras).getResolvedRevision())};
            PurlExtras purlExtras3 = new PurlExtras(pairArray, ((RepositoryProvenance)$this$toPurlExtras).getVcsInfo().getPath());
            purlExtras = purlExtras3;
        } else if (provenance instanceof UnknownProvenance) {
            purlExtras = new PurlExtras(new Pair[0], null, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return purlExtras;
    }

    @NotNull
    public static final Provenance toProvenance(@NotNull String $this$toProvenance) {
        Provenance provenance;
        Intrinsics.checkNotNullParameter((Object)$this$toProvenance, (String)"<this>");
        String extras = StringsKt.substringAfter$default((String)$this$toProvenance, (char)'?', null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)extras, (CharSequence)"download_url=", (boolean)false, (int)2, null)) {
            String encodedUrl = PurlExtensionsKt.toProvenance$getQualifierValue(extras, "download_url");
            String percentEncodedColon = "%3A";
            String checksum = PurlExtensionsKt.toProvenance$getQualifierValue(extras, "checksum");
            String[] stringArray = new String[]{percentEncodedColon};
            List list = StringsKt.split$default((CharSequence)checksum, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            String algorithm = (String)list.get(0);
            String value2 = (String)list.get(1);
            String string = URLDecoder.decode(encodedUrl, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            provenance = new ArtifactProvenance(new RemoteArtifact(string, Hash.Companion.create(value2, algorithm)));
        } else if (StringsKt.contains$default((CharSequence)extras, (CharSequence)"vcs_url=", (boolean)false, (int)2, null)) {
            String encodedUrl = PurlExtensionsKt.toProvenance$getQualifierValue(extras, "vcs_url");
            VcsType vcsType = VcsType.Companion.forName(PurlExtensionsKt.toProvenance$getQualifierValue(extras, "vcs_type"));
            String string = URLDecoder.decode(encodedUrl, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            provenance = new RepositoryProvenance(new VcsInfo(vcsType, string, PurlExtensionsKt.toProvenance$getQualifierValue(extras, "vcs_revision"), StringsKt.substringAfterLast((String)extras, (char)'#', (String)"")), PurlExtensionsKt.toProvenance$getQualifierValue(extras, "resolved_revision"));
        } else {
            provenance = UnknownProvenance.INSTANCE;
        }
        return provenance;
    }

    @JvmOverloads
    @NotNull
    public static final String toPurl(@NotNull Identifier $this$toPurl, @NotNull Map<String, String> qualifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$toPurl, (String)"<this>");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        return PurlExtensionsKt.toPurl$default($this$toPurl, qualifiers, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String toPurl(@NotNull Identifier $this$toPurl) {
        Intrinsics.checkNotNullParameter((Object)$this$toPurl, (String)"<this>");
        return PurlExtensionsKt.toPurl$default($this$toPurl, null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String toProvenance$getQualifierValue(String extras, String name) {
        String string;
        block1: {
            void var2_2;
            String $this$takeWhile$iv = StringsKt.substringAfter$default((String)extras, (String)(name + "="), null, (int)2, null);
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '&' && it != '#') continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_2;
        }
        return string;
    }
}

