/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.LicenseFinding;
import org.ossreviewtoolkit.model.config.LicenseFilePatterns;
import org.ossreviewtoolkit.model.utils.RootLicenseMatcherKt;
import org.ossreviewtoolkit.utils.common.FileMatcher;
import org.ossreviewtoolkit.utils.common.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ4\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\f0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/ossreviewtoolkit/model/utils/RootLicenseMatcher;", "", "licenseFilePatterns", "Lorg/ossreviewtoolkit/model/config/LicenseFilePatterns;", "(Lorg/ossreviewtoolkit/model/config/LicenseFilePatterns;)V", "licenseFileMatcher", "Lorg/ossreviewtoolkit/utils/common/FileMatcher;", "patentFileMatcher", "rootLicenseFileMatcher", "getApplicableLicenseFilesForDirectories", "", "", "", "relativeFilePaths", "", "directories", "getApplicableRootLicenseFindingsForDirectories", "Lorg/ossreviewtoolkit/model/LicenseFinding;", "licenseFindings", "model"})
@SourceDebugExtension(value={"SMAP\nRootLicenseMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootLicenseMatcher.kt\norg/ossreviewtoolkit/model/utils/RootLicenseMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,119:1\n1477#2:120\n1502#2,3:121\n1505#2,3:131\n1238#2,2:136\n1446#2,5:138\n1241#2:143\n2624#2,3:144\n2624#2,3:147\n1549#2:150\n1620#2,3:151\n1855#2:154\n1856#2:162\n1238#2,4:165\n766#2:169\n857#2,2:170\n1477#2:172\n1502#2,3:173\n1505#2,3:183\n1238#2,4:188\n1855#2,2:192\n372#3,7:124\n453#3:134\n403#3:135\n372#3,7:155\n468#3:163\n414#3:164\n372#3,7:176\n453#3:186\n403#3:187\n*S KotlinDebug\n*F\n+ 1 RootLicenseMatcher.kt\norg/ossreviewtoolkit/model/utils/RootLicenseMatcher\n*L\n59#1:120\n59#1:121,3\n59#1:131,3\n63#1:136,2\n64#1:138,5\n63#1:143\n77#1:144,3\n78#1:147,3\n91#1:150\n91#1:151,3\n91#1:154\n91#1:162\n113#1:165,4\n81#1:169\n81#1:170,2\n81#1:172\n81#1:173,3\n81#1:183,3\n83#1:188,4\n96#1:192,2\n59#1:124,7\n63#1:134\n63#1:135\n93#1:155,7\n113#1:163\n113#1:164\n81#1:176,7\n83#1:186\n83#1:187\n*E\n"})
public final class RootLicenseMatcher {
    @NotNull
    private final FileMatcher licenseFileMatcher;
    @NotNull
    private final FileMatcher patentFileMatcher;
    @NotNull
    private final FileMatcher rootLicenseFileMatcher;

    public RootLicenseMatcher(@NotNull LicenseFilePatterns licenseFilePatterns) {
        Intrinsics.checkNotNullParameter((Object)licenseFilePatterns, (String)"licenseFilePatterns");
        this.licenseFileMatcher = RootLicenseMatcherKt.access$createFileMatcher(licenseFilePatterns.getLicenseFilenames());
        this.patentFileMatcher = RootLicenseMatcherKt.access$createFileMatcher(licenseFilePatterns.getPatentFilenames());
        this.rootLicenseFileMatcher = RootLicenseMatcherKt.access$createFileMatcher(licenseFilePatterns.getRootLicenseFilenames());
    }

    public /* synthetic */ RootLicenseMatcher(LicenseFilePatterns licenseFilePatterns, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            licenseFilePatterns = LicenseFilePatterns.Companion.getDEFAULT();
        }
        this(licenseFilePatterns);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Set<LicenseFinding>> getApplicableRootLicenseFindingsForDirectories(@NotNull Collection<LicenseFinding> licenseFindings, @NotNull Collection<String> directories) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(licenseFindings, (String)"licenseFindings");
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        Object $this$groupBy$iv = licenseFindings;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LicenseFinding it = (LicenseFinding)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getLocation().getPath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map licenseFindingsByPath = destination$iv$iv;
        $this$groupBy$iv = this.getApplicableLicenseFilesForDirectories(licenseFindingsByPath.keySet(), directories);
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void destination$iv;
            void $this$flatMapTo$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            Set rootLicenseFilePath = (Set)entry.getValue();
            Iterable iterable2 = rootLicenseFilePath;
            Collection collection = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                Iterable list$iv = (List)MapsKt.getValue((Map)licenseFindingsByPath, (Object)it);
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Set set = (Set)destination$iv;
            map2.put(k, set);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Set<String>> getApplicableLicenseFilesForDirectories(@NotNull Collection<String> relativeFilePaths, @NotNull Collection<String> directories) {
        void $this$mapKeysTo$iv$iv;
        Object licenseFilesForDirectory;
        Object value$iv;
        void $this$forEach$iv;
        Object object;
        Map $this$mapTo$iv$iv;
        boolean bl;
        block15: {
            String it;
            boolean bl2;
            boolean $i$f$none2;
            Iterable $this$none$iv;
            block14: {
                Intrinsics.checkNotNullParameter(relativeFilePaths, (String)"relativeFilePaths");
                Intrinsics.checkNotNullParameter(directories, (String)"directories");
                $this$none$iv = directories;
                $i$f$none2 = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                String $i$f$none2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$none2.toString());
            }
            $this$none$iv = relativeFilePaths;
            $i$f$none2 = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (String)element$iv;
                    boolean bl4 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (!bl) {
            String $i$f$none = "Failed requirement.";
            throw new IllegalArgumentException($i$f$none.toString());
        }
        Map<String, Set<String>> licenseFiles = RootLicenseMatcher.getApplicableLicenseFilesForDirectories$filePathsByDir(relativeFilePaths, this.licenseFileMatcher);
        Map<String, Set<String>> patentFiles = RootLicenseMatcher.getApplicableLicenseFilesForDirectories$filePathsByDir(relativeFilePaths, this.patentFileMatcher);
        Map<String, Set<String>> rootLicenseFiles2 = RootLicenseMatcher.getApplicableLicenseFilesForDirectories$filePathsByDir(relativeFilePaths, this.rootLicenseFileMatcher);
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = directories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            object.add("/" + (String)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object2;
            String directory = (String)element$iv;
            boolean bl6 = false;
            List directoriesOnPathToRoot = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)directory), (Iterable)UtilsKt.getAllAncestorDirectories((String)directory));
            Map $this$getOrPut$iv = result;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(directory);
            if (value$iv == null) {
                boolean bl7 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(directory, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            licenseFilesForDirectory = (Set)object2;
            RootLicenseMatcher.getApplicableLicenseFilesForDirectories$lambda$12$addApplicableLicenseFiles(directoriesOnPathToRoot, (Set<String>)licenseFilesForDirectory, licenseFiles);
            if (licenseFilesForDirectory.isEmpty()) {
                RootLicenseMatcher.getApplicableLicenseFilesForDirectories$lambda$12$addApplicableLicenseFiles(directoriesOnPathToRoot, (Set<String>)licenseFilesForDirectory, rootLicenseFiles2);
            }
            RootLicenseMatcher.getApplicableLicenseFilesForDirectories$lambda$12$addApplicableLicenseFiles(directoriesOnPathToRoot, (Set<String>)licenseFilesForDirectory, patentFiles);
        }
        Map $this$mapKeys$iv = result;
        boolean $i$f$mapKeys = false;
        $this$mapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            value$iv = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl8 = false;
            licenseFilesForDirectory = (Map.Entry)element$iv$iv$iv;
            String string = StringsKt.removePrefix((String)((String)it.getKey()), (CharSequence)"/");
            Object object3 = object;
            boolean bl9 = false;
            Object v = it$iv$iv.getValue();
            object3.put(string, v);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Set<String>> getApplicableLicenseFilesForDirectories$filePathsByDir(Collection<String> $relativeFilePaths, FileMatcher matcher2) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $relativeFilePaths;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!matcher2.matches("/" + it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            File file = new File("/" + it).getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            key$iv$iv = FilesKt.getInvariantSeparatorsPath((File)file);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            Set set = CollectionsKt.toSet((Iterable)((Iterable)it2.getValue()));
            object2.put(k, set);
        }
        return destination$iv$iv;
    }

    private static final void getApplicableLicenseFilesForDirectories$lambda$12$addApplicableLicenseFiles(List<String> directoriesOnPathToRoot, Set<String> licenseFilesForDirectory, Map<String, ? extends Collection<String>> licenseFilesByDir) {
        Iterable $this$forEach$iv = directoriesOnPathToRoot;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String currentDir = (String)element$iv;
            boolean bl = false;
            Collection<String> collection = licenseFilesByDir.get(currentDir);
            if (collection == null) continue;
            Collection<String> it = collection;
            boolean bl2 = false;
            CollectionsKt.addAll((Collection)licenseFilesForDirectory, (Iterable)it);
            return;
        }
    }

    public RootLicenseMatcher() {
        this(null, 1, null);
    }
}

