/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model.vulnerabilities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.vulnerabilities.Cvss2Rating;
import org.ossreviewtoolkit.model.vulnerabilities.Cvss3Rating;
import org.ossreviewtoolkit.model.vulnerabilities.Cvss4Rating;

@JsonIgnoreProperties(value={"severity_rating"}, allowGetters=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001b\u0010\u000b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/model/vulnerabilities/VulnerabilityReference;", "", "url", "Ljava/net/URI;", "scoringSystem", "", "severity", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;)V", "getScoringSystem", "()Ljava/lang/String;", "getSeverity", "severityRating", "getSeverityRating", "severityRating$delegate", "Lkotlin/Lazy;", "getUrl", "()Ljava/net/URI;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nVulnerabilityReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerabilityReference.kt\norg/ossreviewtoolkit/model/vulnerabilities/VulnerabilityReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 VulnerabilityReference.kt\norg/ossreviewtoolkit/model/vulnerabilities/VulnerabilityReference\n*L\n57#1:77\n57#1:78,3\n*E\n"})
public final class VulnerabilityReference {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final URI url;
    @Nullable
    private final String scoringSystem;
    @Nullable
    private final String severity;
    @NotNull
    private final Lazy severityRating$delegate;
    @NotNull
    private static final List<String> CVSS3_SEVERITIES;

    public VulnerabilityReference(@NotNull URI url, @Nullable String scoringSystem, @Nullable String severity) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.scoringSystem = scoringSystem;
        this.severity = severity;
        this.severityRating$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ VulnerabilityReference this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return VulnerabilityReference.Companion.getSeverityString(this.this$0.getScoringSystem(), this.this$0.getSeverity());
            }
        }));
    }

    @NotNull
    public final URI getUrl() {
        return this.url;
    }

    @Nullable
    public final String getScoringSystem() {
        return this.scoringSystem;
    }

    @Nullable
    public final String getSeverity() {
        return this.severity;
    }

    @NotNull
    public final String getSeverityRating() {
        Lazy lazy = this.severityRating$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final URI component1() {
        return this.url;
    }

    @Nullable
    public final String component2() {
        return this.scoringSystem;
    }

    @Nullable
    public final String component3() {
        return this.severity;
    }

    @NotNull
    public final VulnerabilityReference copy(@NotNull URI url, @Nullable String scoringSystem, @Nullable String severity) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new VulnerabilityReference(url, scoringSystem, severity);
    }

    public static /* synthetic */ VulnerabilityReference copy$default(VulnerabilityReference vulnerabilityReference, URI uRI, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            uRI = vulnerabilityReference.url;
        }
        if ((n & 2) != 0) {
            string = vulnerabilityReference.scoringSystem;
        }
        if ((n & 4) != 0) {
            string2 = vulnerabilityReference.severity;
        }
        return vulnerabilityReference.copy(uRI, string, string2);
    }

    @NotNull
    public String toString() {
        return "VulnerabilityReference(url=" + this.url + ", scoringSystem=" + this.scoringSystem + ", severity=" + this.severity + ")";
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + (this.scoringSystem == null ? 0 : this.scoringSystem.hashCode());
        result = result * 31 + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VulnerabilityReference)) {
            return false;
        }
        VulnerabilityReference vulnerabilityReference = (VulnerabilityReference)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)vulnerabilityReference.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scoringSystem, (Object)vulnerabilityReference.scoringSystem)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.severity, (Object)vulnerabilityReference.severity);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = (Iterable)Cvss3Rating.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cvss3Rating cvss3Rating = (Cvss3Rating)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        CVSS3_SEVERITIES = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/ossreviewtoolkit/model/vulnerabilities/VulnerabilityReference$Companion;", "", "()V", "CVSS3_SEVERITIES", "", "", "getSeverityString", "scoringSystem", "severity", "model"})
    @SourceDebugExtension(value={"SMAP\nVulnerabilityReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerabilityReference.kt\norg/ossreviewtoolkit/model/vulnerabilities/VulnerabilityReference$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final String getSeverityString(@Nullable String scoringSystem, @Nullable String severity) {
            String string;
            String string2;
            String string3;
            String string4 = scoringSystem;
            if (string4 != null) {
                String string5 = string4.toUpperCase(Locale.ROOT);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            } else {
                string3 = string2 = null;
            }
            if (CollectionsKt.contains((Iterable)Cvss2Rating.Companion.getNAMES(), (Object)string2)) {
                String string6 = severity;
                Object object = string6;
                if (string6 == null) return "UNKNOWN";
                Float f = StringsKt.toFloatOrNull((String)object);
                object = f;
                if (f == null) return "UNKNOWN";
                float it = ((Number)object).floatValue();
                boolean bl = false;
                Cvss2Rating cvss2Rating = Cvss2Rating.Companion.fromScore(it);
                object = cvss2Rating;
                if (cvss2Rating == null) return "UNKNOWN";
                string = ((Enum)object).toString();
            } else if (CollectionsKt.contains((Iterable)Cvss3Rating.Companion.getNAMES(), (Object)string2)) {
                String string7 = severity;
                Object object = string7;
                if (string7 == null) return "UNKNOWN";
                Float f = StringsKt.toFloatOrNull((String)object);
                object = f;
                if (f == null) return "UNKNOWN";
                float it = ((Number)object).floatValue();
                boolean bl = false;
                Cvss3Rating cvss3Rating = Cvss3Rating.Companion.fromScore(it);
                object = cvss3Rating;
                if (cvss3Rating == null) return "UNKNOWN";
                string = ((Enum)object).toString();
            } else if (CollectionsKt.contains((Iterable)Cvss4Rating.Companion.getNAMES(), (Object)string2)) {
                String string8 = severity;
                Object object = string8;
                if (string8 == null) return "UNKNOWN";
                Float f = StringsKt.toFloatOrNull((String)object);
                object = f;
                if (f == null) return "UNKNOWN";
                float it = ((Number)object).floatValue();
                boolean bl = false;
                Cvss4Rating cvss4Rating = Cvss4Rating.Companion.fromScore(it);
                object = cvss4Rating;
                if (cvss4Rating == null) return "UNKNOWN";
                string = ((Enum)object).toString();
            } else {
                String string9;
                String string10 = severity;
                String string11 = string10;
                if (string10 == null) return "UNKNOWN";
                String string12 = string11.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toUpperCase(...)");
                string11 = string12;
                if (string12 == null) return "UNKNOWN";
                String it = string9 = string11;
                boolean bl = false;
                if (!CVSS3_SEVERITIES.contains(it)) return "UNKNOWN";
                string = string9;
            }
            String string13 = string;
            if (string != null) return string13;
            return "UNKNOWN";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

