/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.commands.api.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ajalt.clikt.core.GroupableOption;
import com.github.ajalt.mordant.terminal.Terminal;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.FileFormatKt;
import org.ossreviewtoolkit.model.HashAlgorithm;
import org.ossreviewtoolkit.model.OrtResult;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0019\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u0002H\u000e\u00a2\u0006\u0002\u0010\u0010\u001a!\u0010\u0011\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u0002H\u000e2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u0019\u0010\u0015\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u0002H\u000e\u00a2\u0006\u0002\u0010\u0010\u001a\u0019\u0010\u0016\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u0002H\u000e\u00a2\u0006\u0002\u0010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"logger", "Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "readOrtResult", "Lorg/ossreviewtoolkit/model/OrtResult;", "ortFile", "Ljava/io/File;", "writeOrtResult", "", "ortResult", "outputFiles", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "configurationGroup", "T", "Lcom/github/ajalt/clikt/core/GroupableOption;", "(Lcom/github/ajalt/clikt/core/GroupableOption;)Lcom/github/ajalt/clikt/core/GroupableOption;", "group", "name", "", "(Lcom/github/ajalt/clikt/core/GroupableOption;Ljava/lang/String;)Lcom/github/ajalt/clikt/core/GroupableOption;", "inputGroup", "outputGroup", "command-api"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 FileFormat.kt\norg/ossreviewtoolkit/model/FileFormatKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1#2:78\n79#3,5:79\n113#3,6:84\n119#3:93\n18#3,4:95\n50#3,6:99\n56#3:114\n99#4:90\n120#4,9:105\n54#5:91\n49#5:92\n1855#6:94\n1856#6:115\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/ExtensionsKt\n*L\n55#1:79,5\n55#1:84,6\n55#1:93\n70#1:95,4\n70#1:99,6\n70#1:114\n55#1:90\n70#1:105,9\n55#1:91\n55#1:92\n66#1:94\n66#1:115\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    private static final KotlinLogger logger;

    @NotNull
    public static final <T extends GroupableOption> T group(@NotNull T $this$group, @NotNull String name) {
        T t;
        Intrinsics.checkNotNullParameter($this$group, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        T $this$group_u24lambda_u240 = t = $this$group;
        boolean bl = false;
        $this$group_u24lambda_u240.setGroupName(name);
        return t;
    }

    @NotNull
    public static final <T extends GroupableOption> T inputGroup(@NotNull T $this$inputGroup) {
        Intrinsics.checkNotNullParameter($this$inputGroup, (String)"<this>");
        return ExtensionsKt.group($this$inputGroup, "Input Options");
    }

    @NotNull
    public static final <T extends GroupableOption> T outputGroup(@NotNull T $this$outputGroup) {
        Intrinsics.checkNotNullParameter($this$outputGroup, (String)"<this>");
        return ExtensionsKt.group($this$outputGroup, "Output Options");
    }

    @NotNull
    public static final <T extends GroupableOption> T configurationGroup(@NotNull T $this$configurationGroup) {
        Intrinsics.checkNotNullParameter($this$configurationGroup, (String)"<this>");
        return ExtensionsKt.group($this$configurationGroup, "Configuration Options");
    }

    @NotNull
    public static final OrtResult readOrtResult(@NotNull File ortFile) {
        Intrinsics.checkNotNullParameter((Object)ortFile, (String)"ortFile");
        logger.debug((Function0)new Function0<Object>(ortFile){
            final /* synthetic */ File $ortFile;
            {
                this.$ortFile = $ortFile;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Input ORT result file has SHA-1 hash " + HashAlgorithm.SHA1.calculate(this.$ortFile) + ".";
            }
        });
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        File $this$readValue$iv = ortFile;
        boolean $i$f$readValue = false;
        ObjectMapper $this$readValue$iv$iv = FileFormatKt.mapper((File)$this$readValue$iv);
        boolean $i$f$readValue2 = false;
        boolean $i$f$jacksonTypeRef = false;
        OrtResult result$iv$iv = (OrtResult)$this$readValue$iv$iv.readValue($this$readValue$iv, (TypeReference)new TypeReference<OrtResult>(){});
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        OrtResult ortResult = (OrtResult)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        logger.info((Function0)new Function0<Object>(ortFile, duration){
            final /* synthetic */ File $ortFile;
            final /* synthetic */ long $duration;
            {
                this.$ortFile = $ortFile;
                this.$duration = $duration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Read ORT result from '" + this.$ortFile.getName() + "' (" + org.ossreviewtoolkit.utils.common.ExtensionsKt.getFormatSizeInMib((File)this.$ortFile) + ") in " + Duration.toString-impl((long)this.$duration) + ".";
            }
        });
        return ortResult;
    }

    public static final void writeOrtResult(@NotNull OrtResult ortResult, @NotNull Collection<? extends File> outputFiles, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)ortResult, (String)"ortResult");
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Iterable $this$forEach$iv = outputFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String resultName = StringsKt.substringBefore$default((String)string, (char)'-', null, (int)2, null);
            Terminal.println$default((Terminal)terminal, (Object)("Writing " + resultName + " result to '" + file + "'."), null, null, null, null, (boolean)false, (int)62, null);
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            File $this$writeValue_u24default$iv = file;
            boolean prettyPrint$iv = true;
            boolean $i$f$writeValue = false;
            File file2 = $this$writeValue_u24default$iv.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            org.ossreviewtoolkit.utils.common.ExtensionsKt.safeMkdirs((File)file2);
            FileFormatKt.mapper((File)$this$writeValue_u24default$iv).writerWithDefaultPrettyPrinter().writeValue($this$writeValue_u24default$iv, (Object)ortResult);
            long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            logger.info((Function0)new Function0<Object>(file, duration){
                final /* synthetic */ File $file;
                final /* synthetic */ long $duration;
                {
                    this.$file = $file;
                    this.$duration = $duration;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Wrote ORT result to '" + this.$file.getName() + "' (" + org.ossreviewtoolkit.utils.common.ExtensionsKt.getFormatSizeInMib((File)this.$file) + ") in " + Duration.toString-impl((long)this.$duration) + ".";
                }
            });
            logger.debug((Function0)new Function0<Object>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Output ORT result file has SHA-1 hash " + HashAlgorithm.SHA1.calculate(this.$file) + ".";
                }
            });
        }
    }

    static {
        Class<?> clazz = MethodHandles.lookup().lookupClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"lookupClass(...)");
        logger = LoggingFactoryKt.loggerOf(clazz);
    }
}

