/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.commands.api.utils;

import com.github.ajalt.clikt.core.ProgramResult;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.RuleViolation;
import org.ossreviewtoolkit.model.Severity;
import org.ossreviewtoolkit.model.utils.ResolutionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u00060\tR\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\b\rJ\u001f\u0010\b\u001a\u00060\tR\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0007\u00a2\u0006\u0002\b\u0010JS\u0010\b\u001a\u00060\tR\u00020\u0000\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u001e\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00160\u00152\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter;", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "resolutionProvider", "Lorg/ossreviewtoolkit/model/utils/ResolutionProvider;", "<init>", "(Lcom/github/ajalt/mordant/terminal/Terminal;Lorg/ossreviewtoolkit/model/utils/ResolutionProvider;)V", "stats", "Lorg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter$Entry;", "issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "statsForIssues", "ruleViolations", "Lorg/ossreviewtoolkit/model/RuleViolation;", "statsForRuleViolations", "T", "name", "", "thingsWithSeverities", "Lkotlin/Pair;", "", "selector", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/Severity;", "Lkotlin/ExtensionFunctionType;", "Entry", "command-api"})
@SourceDebugExtension(value={"SMAP\nSeverityStatsPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeverityStatsPrinter.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n3193#2,10:103\n3193#2,10:113\n1544#2:123\n1544#2:124\n*S KotlinDebug\n*F\n+ 1 SeverityStatsPrinter.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter\n*L\n89#1:103,10\n93#1:113,10\n98#1:123\n99#1:124\n*E\n"})
public final class SeverityStatsPrinter {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final ResolutionProvider resolutionProvider;

    public SeverityStatsPrinter(@NotNull Terminal terminal, @NotNull ResolutionProvider resolutionProvider) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)resolutionProvider, (String)"resolutionProvider");
        this.terminal = terminal;
        this.resolutionProvider = resolutionProvider;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="statsForIssues")
    @NotNull
    public final Entry statsForIssues(@NotNull Collection<Issue> issues) {
        void $this$partition$iv;
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Iterable iterable = issues;
        String string = "issue";
        SeverityStatsPrinter severityStatsPrinter = this;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Issue it = (Issue)element$iv;
            boolean bl = false;
            if (this.resolutionProvider.isResolved(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        return severityStatsPrinter.stats(string, pair, SeverityStatsPrinter::stats$lambda$1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="statsForRuleViolations")
    @NotNull
    public final Entry statsForRuleViolations(@NotNull Collection<RuleViolation> ruleViolations) {
        void $this$partition$iv;
        Intrinsics.checkNotNullParameter(ruleViolations, (String)"ruleViolations");
        Iterable iterable = ruleViolations;
        String string = "rule violation";
        SeverityStatsPrinter severityStatsPrinter = this;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            RuleViolation it = (RuleViolation)element$iv;
            boolean bl = false;
            if (this.resolutionProvider.isResolved(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        return severityStatsPrinter.stats(string, pair, SeverityStatsPrinter::stats$lambda$3);
    }

    private final <T> Entry stats(String name, Pair<? extends List<? extends T>, ? extends List<? extends T>> thingsWithSeverities, Function1<? super T, ? extends Severity> selector) {
        Iterable $this$groupingBy$iv = (Iterable)thingsWithSeverities.getFirst();
        boolean $i$f$groupingBy = false;
        Grouping grouping = new Grouping<T, Severity>($this$groupingBy$iv, selector){
            final /* synthetic */ Iterable $this_groupingBy;
            final /* synthetic */ Function1 $keySelector;
            {
                this.$this_groupingBy = $receiver;
                this.$keySelector = $keySelector;
            }

            public Iterator<T> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            public Severity keyOf(T element) {
                return this.$keySelector.invoke(element);
            }
        };
        $this$groupingBy$iv = (Iterable)thingsWithSeverities.getSecond();
        $i$f$groupingBy = false;
        return new Entry(name, GroupingKt.eachCount((Grouping)grouping), GroupingKt.eachCount((Grouping)new Grouping<T, Severity>($this$groupingBy$iv, selector){
            final /* synthetic */ Iterable $this_groupingBy;
            final /* synthetic */ Function1 $keySelector;
            {
                this.$this_groupingBy = $receiver;
                this.$keySelector = $keySelector;
            }

            public Iterator<T> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            public Severity keyOf(T element) {
                return this.$keySelector.invoke(element);
            }
        }));
    }

    private static final Severity stats$lambda$1(Issue $this$stats) {
        Intrinsics.checkNotNullParameter((Object)$this$stats, (String)"$this$stats");
        return $this$stats.getSeverity();
    }

    private static final Severity stats$lambda$3(RuleViolation $this$stats) {
        Intrinsics.checkNotNullParameter((Object)$this$stats, (String)"$this$stats");
        return $this$stats.getSeverity();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0010\u001a\u00060\u0000R\u00020\u0011J\u001a\u0010\u0012\u001a\u00060\u0000R\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter$Entry;", "", "name", "", "resolvedCounts", "", "Lorg/ossreviewtoolkit/model/Severity;", "", "unresolvedCounts", "<init>", "(Lorg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getName", "()Ljava/lang/String;", "getResolvedCounts", "()Ljava/util/Map;", "getUnresolvedCounts", "print", "Lorg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter;", "conclude", "threshold", "severeStatusCode", "command-api"})
    @SourceDebugExtension(value={"SMAP\nSeverityStatsPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeverityStatsPrinter.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter$Entry\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n37#2,2:103\n37#2,2:109\n11102#3:105\n11437#3,3:106\n11102#3:111\n11437#3,3:112\n1#4:115\n*S KotlinDebug\n*F\n+ 1 SeverityStatsPrinter.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/SeverityStatsPrinter$Entry\n*L\n47#1:103,2\n55#1:109,2\n47#1:105\n47#1:106,3\n55#1:111\n55#1:112,3\n*E\n"})
    public final class Entry {
        @NotNull
        private final String name;
        @NotNull
        private final Map<Severity, Integer> resolvedCounts;
        @NotNull
        private final Map<Severity, Integer> unresolvedCounts;

        public Entry(@NotNull String name, @NotNull Map<Severity, Integer> resolvedCounts, Map<Severity, Integer> unresolvedCounts) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(resolvedCounts, (String)"resolvedCounts");
            Intrinsics.checkNotNullParameter(unresolvedCounts, (String)"unresolvedCounts");
            this.name = name;
            this.resolvedCounts = resolvedCounts;
            this.unresolvedCounts = unresolvedCounts;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Map<Severity, Integer> getResolvedCounts() {
            return this.resolvedCounts;
        }

        @NotNull
        public final Map<Severity, Integer> getUnresolvedCounts() {
            return this.unresolvedCounts;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Entry print() {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Entry entry = this;
            SeverityStatsPrinter severityStatsPrinter = SeverityStatsPrinter.this;
            Entry $this$print_u24lambda_u242 = entry;
            boolean bl = false;
            Comparable[] $this$toTypedArray$iv = (Comparable[])Severity.getEntries();
            boolean $i$f$toTypedArray = false;
            Comparable[] thisCollection$iv = $this$toTypedArray$iv;
            Comparable[] $this$map$iv = ArraysKt.sortedArrayDescending((Comparable[])((Comparable[])thisCollection$iv.toArray(new Severity[0])));
            boolean $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv2).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv = $this$mapTo$iv$iv2[i];
                Severity severity = (Severity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                int count = ((Number)$this$print_u24lambda_u242.resolvedCounts.getOrDefault(it, 0)).intValue();
                String string = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String text = Entry.print$lambda$2$p(count, string);
                collection.add(Theme.Companion.getDefault().getSuccess().invoke(text));
            }
            List resolved = (List)destination$iv$iv;
            Terminal.println$default((Terminal)severityStatsPrinter.terminal, (Object)(Theme.Companion.getDefault().getInfo().invoke("Resolved " + $this$print_u24lambda_u242.name + "s:") + " " + CollectionsKt.joinToString$default((Iterable)resolved, null, null, null, (int)0, null, null, (int)63, null) + "."), null, null, null, null, (boolean)false, (int)62, null);
            Comparable[] $this$toTypedArray$iv2 = (Comparable[])Severity.getEntries();
            boolean $i$f$toTypedArray2 = false;
            Comparable[] thisCollection$iv2 = $this$toTypedArray$iv2;
            Comparable[] $this$map$iv2 = ArraysKt.sortedArrayDescending((Comparable[])((Comparable[])thisCollection$iv2.toArray(new Severity[0])));
            boolean $i$f$map2 = false;
            thisCollection$iv2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Severity bl2 = (Severity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                int count = ((Number)$this$print_u24lambda_u242.unresolvedCounts.getOrDefault(it, 0)).intValue();
                String string = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String text = Entry.print$lambda$2$p(count, string);
                collection.add(count == 0 ? Theme.Companion.getDefault().getSuccess().invoke(text) : Theme.Companion.getDefault().getDanger().invoke(text));
            }
            List unresolved = (List)destination$iv$iv2;
            Terminal.println$default((Terminal)severityStatsPrinter.terminal, (Object)(Theme.Companion.getDefault().getWarning().invoke("Unresolved " + $this$print_u24lambda_u242.name + "s:") + " " + CollectionsKt.joinToString$default((Iterable)unresolved, null, null, null, (int)0, null, null, (int)63, null) + "."), null, null, null, null, (boolean)false, (int)62, null);
            return entry;
        }

        @NotNull
        public final Entry conclude(@NotNull Severity threshold, int severeStatusCode) {
            Intrinsics.checkNotNullParameter((Object)threshold, (String)"threshold");
            Entry entry = this;
            SeverityStatsPrinter severityStatsPrinter = SeverityStatsPrinter.this;
            Entry $this$conclude_u24lambda_u244 = entry;
            boolean bl = false;
            Iterable iterable = $this$conclude_u24lambda_u244.unresolvedCounts.entrySet();
            int n = 0;
            for (Object t : iterable) {
                Map.Entry entry2 = (Map.Entry)t;
                int n2 = n;
                boolean bl2 = false;
                Severity severity = (Severity)entry2.getKey();
                int count = ((Number)entry2.getValue()).intValue();
                int n3 = severity.compareTo((Enum)threshold) >= 0 ? count : 0;
                n = n2 + n3;
            }
            int severeCount = n;
            if (severeCount > 0) {
                iterable = severeCount == 1 ? TuplesKt.to((Object)"is", (Object)"") : TuplesKt.to((Object)"are", (Object)"s");
                String be = (String)iterable.component1();
                String s = (String)iterable.component2();
                Terminal.println$default((Terminal)severityStatsPrinter.terminal, (Object)("There " + be + " " + severeCount + " unresolved " + $this$conclude_u24lambda_u244.name + s + " with a severity equal to or greater than the " + threshold + " threshold."), null, null, null, null, (boolean)false, (int)62, null);
                throw new ProgramResult(severeStatusCode);
            }
            return entry;
        }

        private static final String print$lambda$2$p(int count, String thing) {
            return count == 1 ? count + " " + thing : count + " " + thing + "s";
        }
    }
}

