/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.commands.api.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ajalt.clikt.core.GroupableOption;
import com.github.ajalt.mordant.terminal.Terminal;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.FileFormatKt;
import org.ossreviewtoolkit.model.HashAlgorithm;
import org.ossreviewtoolkit.model.OrtResult;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0002\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u0002H\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u0019\u0010\b\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u0002H\u0003\u00a2\u0006\u0002\u0010\t\u001a\u0019\u0010\n\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u0002H\u0003\u00a2\u0006\u0002\u0010\t\u001a\u0019\u0010\u000b\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u0002H\u0003\u00a2\u0006\u0002\u0010\t\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0015\u001a\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"logger", "Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "group", "T", "Lcom/github/ajalt/clikt/core/GroupableOption;", "name", "", "(Lcom/github/ajalt/clikt/core/GroupableOption;Ljava/lang/String;)Lcom/github/ajalt/clikt/core/GroupableOption;", "inputGroup", "(Lcom/github/ajalt/clikt/core/GroupableOption;)Lcom/github/ajalt/clikt/core/GroupableOption;", "outputGroup", "configurationGroup", "readOrtResult", "Lorg/ossreviewtoolkit/model/OrtResult;", "ortFile", "Ljava/io/File;", "writeOrtResult", "", "ortResult", "outputFiles", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "command-api"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 FileFormat.kt\norg/ossreviewtoolkit/model/FileFormatKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n79#3,5:77\n113#3,6:82\n119#3:107\n18#3,4:109\n50#3,6:113\n56#3:128\n96#4,12:88\n108#4,5:102\n125#4,9:119\n54#5:100\n51#5:101\n1863#6:108\n1864#6:129\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/ossreviewtoolkit/plugins/commands/api/utils/ExtensionsKt\n*L\n55#1:77,5\n55#1:82,6\n55#1:107\n68#1:109,4\n68#1:113,6\n68#1:128\n55#1:88,12\n55#1:102,5\n68#1:119,9\n55#1:100\n55#1:101\n66#1:108\n66#1:129\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    private static final KotlinLogger logger;

    @NotNull
    public static final <T extends GroupableOption> T group(@NotNull T $this$group, @NotNull String name) {
        T t;
        Intrinsics.checkNotNullParameter($this$group, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        T $this$group_u24lambda_u240 = t = $this$group;
        boolean bl = false;
        $this$group_u24lambda_u240.setGroupName(name);
        return t;
    }

    @NotNull
    public static final <T extends GroupableOption> T inputGroup(@NotNull T $this$inputGroup) {
        Intrinsics.checkNotNullParameter($this$inputGroup, (String)"<this>");
        return ExtensionsKt.group($this$inputGroup, "Input Options");
    }

    @NotNull
    public static final <T extends GroupableOption> T outputGroup(@NotNull T $this$outputGroup) {
        Intrinsics.checkNotNullParameter($this$outputGroup, (String)"<this>");
        return ExtensionsKt.group($this$outputGroup, "Output Options");
    }

    @NotNull
    public static final <T extends GroupableOption> T configurationGroup(@NotNull T $this$configurationGroup) {
        Intrinsics.checkNotNullParameter($this$configurationGroup, (String)"<this>");
        return ExtensionsKt.group($this$configurationGroup, "Configuration Options");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final OrtResult readOrtResult(@NotNull File ortFile) {
        Object object;
        void $this$readValues$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ortFile, (String)"ortFile");
        logger.debug(() -> ExtensionsKt.readOrtResult$lambda$1(ortFile));
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        File $this$readValue$iv = ortFile;
        boolean $i$f$readValue = false;
        File $this$readValueOrNull$iv$iv = $this$readValue$iv;
        boolean $i$f$readValueOrNull = false;
        ObjectMapper mapper$iv$iv = FileFormatKt.mapper((File)$this$readValueOrNull$iv$iv);
        JsonParser parser$iv$iv = mapper$iv$iv.getFactory().createParser($this$readValueOrNull$iv$iv);
        Object object2 = mapper$iv$iv;
        Intrinsics.checkNotNull((Object)parser$iv$iv);
        JsonParser jp$iv$iv$iv = parser$iv$iv;
        boolean $i$f$readValues = false;
        boolean $i$f$jacksonTypeRef = false;
        MappingIterator mappingIterator = $this$readValues$iv$iv$iv.readValues(jp$iv$iv$iv, (TypeReference)new TypeReference<OrtResult>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mappingIterator, (String)"readValues(jp, jacksonTypeRef<T>())");
        Object it$iv$iv = object2 = mappingIterator.readAll();
        boolean bl2 = false;
        if (it$iv$iv.isEmpty()) {
            object = null;
        } else {
            if (it$iv$iv.size() > 1) {
                throw new IOException("Multiple top-level objects found in file '" + $this$readValueOrNull$iv$iv + "'.");
            }
            Object values$iv$iv = object2;
            Intrinsics.checkNotNull((Object)values$iv$iv);
            object = CollectionsKt.first((List)values$iv$iv);
        }
        if (object == null) {
            throw new IOException("No object found in file '" + $this$readValue$iv + "'.");
        }
        OrtResult result$iv$iv = (OrtResult)object;
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        OrtResult ortResult = (OrtResult)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        logger.info(() -> ExtensionsKt.readOrtResult$lambda$3(ortFile, duration));
        return ortResult;
    }

    public static final void writeOrtResult(@NotNull OrtResult ortResult, @NotNull Collection<? extends File> outputFiles, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)ortResult, (String)"ortResult");
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Iterable $this$forEach$iv = outputFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String resultName = StringsKt.substringBefore$default((String)string, (char)'-', null, (int)2, null);
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            File $this$writeValue_u24default$iv = file;
            boolean prettyPrint$iv = true;
            boolean $i$f$writeValue = false;
            File file2 = $this$writeValue_u24default$iv.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            org.ossreviewtoolkit.utils.common.ExtensionsKt.safeMkdirs((File)file2);
            FileFormatKt.mapper((File)$this$writeValue_u24default$iv).writerWithDefaultPrettyPrinter().writeValue($this$writeValue_u24default$iv, (Object)ortResult);
            long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            Terminal.println$default((Terminal)terminal, (Object)("Wrote " + resultName + " result to '" + file + "' (" + org.ossreviewtoolkit.utils.common.ExtensionsKt.getFormatSizeInMib((File)file) + ") in " + Duration.toString-impl((long)duration) + "."), null, null, null, null, (boolean)false, (int)62, null);
            logger.debug(() -> ExtensionsKt.writeOrtResult$lambda$6$lambda$5(file));
        }
    }

    private static final Object readOrtResult$lambda$1(File $ortFile) {
        return "Input ORT result file has SHA-1 hash " + HashAlgorithm.SHA1.calculate($ortFile) + ".";
    }

    private static final Object readOrtResult$lambda$3(File $ortFile, long $duration) {
        return "Read ORT result from '" + $ortFile.getName() + "' (" + org.ossreviewtoolkit.utils.common.ExtensionsKt.getFormatSizeInMib((File)$ortFile) + ") in " + Duration.toString-impl((long)$duration) + ".";
    }

    private static final Object writeOrtResult$lambda$6$lambda$5(File $file) {
        return "Output ORT result file has SHA-1 hash " + HashAlgorithm.SHA1.calculate($file) + ".";
    }

    static {
        Class<?> clazz = MethodHandles.lookup().lookupClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"lookupClass(...)");
        logger = LoggingFactoryKt.loggerOf(clazz);
    }
}

