package org.ossreviewtoolkit.plugins.commands.compare

import org.ossreviewtoolkit.plugins.api.PluginConfig
import org.ossreviewtoolkit.plugins.api.PluginDescriptor
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory

public class CompareCommandFactory : OrtCommandFactory {
  override val descriptor: PluginDescriptor by Companion::descriptor

  override fun create(config: PluginConfig): CompareCommand = CompareCommand(descriptor)

  public companion object {
    public val descriptor: PluginDescriptor = PluginDescriptor(
            id = "compare",
            displayName = "compare command",
            description = "Compare two ORT results with various methods.",
            options = listOf(
            )
        )

    public fun create(): CompareCommand = CompareCommand(descriptor)
  }
}
