package org.ossreviewtoolkit.plugins.commands.config

import org.ossreviewtoolkit.plugins.api.PluginConfig
import org.ossreviewtoolkit.plugins.api.PluginDescriptor
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory

public class ConfigCommandFactory : OrtCommandFactory {
  override val descriptor: PluginDescriptor by Companion::descriptor

  override fun create(config: PluginConfig): ConfigCommand = ConfigCommand(descriptor)

  public companion object {
    public val descriptor: PluginDescriptor = PluginDescriptor(
            id = "config",
            displayName = "config command",
            description = "Show different ORT configurations.",
            options = listOf(
            )
        )

    public fun create(): ConfigCommand = ConfigCommand(descriptor)
  }
}
