/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.commands.migrate;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.options.Option;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.FileFormat;
import org.ossreviewtoolkit.model.FileFormatKt;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.PackageCuration;
import org.ossreviewtoolkit.model.config.PackageConfiguration;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.commands.api.OrtCommand;
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory;
import org.ossreviewtoolkit.plugins.commands.migrate.MigrateCommand$special$;
import org.ossreviewtoolkit.plugins.commands.migrate.MigrateCommandFactory;
import org.ossreviewtoolkit.plugins.commands.migrate.MigrateCommandKt;
import org.ossreviewtoolkit.plugins.packagecurationproviders.ortconfig.OrtConfigPackageCurationProviderKt;
import org.ossreviewtoolkit.plugins.packagemanagers.nuget.utils.NuGetUtilsKt;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.UtilsKt;

@OrtPlugin(id="migrate", displayName="migrate command", description="Assist with migrating ORT configuration to newer ORT versions.", factory=OrtCommandFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J$\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/ossreviewtoolkit/plugins/commands/migrate/MigrateCommand;", "Lorg/ossreviewtoolkit/plugins/commands/api/OrtCommand;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;)V", "hoconToYaml", "Ljava/io/File;", "getHoconToYaml", "()Ljava/io/File;", "hoconToYaml$delegate", "Lkotlin/properties/ReadOnlyProperty;", "nuGetIds", "getNuGetIds", "nuGetIds$delegate", "pubIds", "getPubIds", "pubIds$delegate", "run", "", "migrateNuGetIds", "configDir", "migratePubIds", "migrateIds", "transformId", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/Identifier;", "migrate-command"})
@SourceDebugExtension(value={"SMAP\nMigrateCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateCommand.kt\norg/ossreviewtoolkit/plugins/commands/migrate/MigrateCommand\n+ 2 Convert.kt\ncom/github/ajalt/clikt/parameters/options/OptionWithValuesKt__ConvertKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FileFormat.kt\norg/ossreviewtoolkit/model/FileFormatKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,211:1\n65#2,6:212\n82#2,4:218\n65#2,6:222\n82#2,4:228\n65#2,6:232\n82#2,4:238\n1611#3,9:242\n1863#3:251\n1864#3:272\n1620#3:273\n1611#3,9:274\n1863#3:283\n1864#3:304\n1620#3:305\n1557#3:307\n1628#3,3:308\n96#4,12:252\n108#4,5:266\n96#4,12:284\n108#4,5:298\n54#5:264\n51#5:265\n54#5:296\n51#5:297\n1#6:271\n1#6:303\n216#7:306\n217#7:311\n216#7,2:312\n*S KotlinDebug\n*F\n+ 1 MigrateCommand.kt\norg/ossreviewtoolkit/plugins/commands/migrate/MigrateCommand\n*L\n56#1:212,6\n56#1:218,4\n62#1:222,6\n62#1:228,4\n68#1:232,6\n68#1:238,4\n111#1:242,9\n111#1:251\n111#1:272\n111#1:273\n122#1:274,9\n122#1:283\n122#1:304\n122#1:305\n136#1:307\n136#1:308,3\n113#1:252,12\n113#1:266,5\n124#1:284,12\n124#1:298,5\n113#1:264\n113#1:265\n124#1:296\n124#1:297\n111#1:271\n122#1:303\n135#1:306\n135#1:311\n156#1:312,2\n*E\n"})
public final class MigrateCommand
extends OrtCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty hoconToYaml$delegate;
    @NotNull
    private final ReadOnlyProperty nuGetIds$delegate;
    @NotNull
    private final ReadOnlyProperty pubIds$delegate;

    public MigrateCommand(@NotNull PluginDescriptor descriptor) {
        CompletionCandidates completionCandidates;
        CompletionCandidates completionCandidates2;
        CompletionCandidates completionCandidates3;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(descriptor);
        String[] stringArray = new String[]{"--hocon-to-yaml"};
        String[] $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Perform a simple conversion of the given HOCON configuration file to YAML and print the result.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        Function1 metavar$iv = special$$inlined$convert$default$1.INSTANCE;
        Object completionCandidates$iv = null;
        boolean $i$f$convert = false;
        Function2 valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$hoconToYaml_delegate_u24lambda_u240 = optionCallTransformContext;
                    boolean bl = false;
                    string = ExtensionsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function2 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function22 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function23 = OptionWithValuesKt.defaultValidator();
        Function1 function1 = $this$convert_u24default$iv.getMetavarGetter();
        if (function1 == null) {
            function1 = metavar$iv;
        }
        if ((completionCandidates3 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates3 = completionCandidates$iv;
        }
        this.hoconToYaml$delegate = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function2, (Function2)function22, (Function2)function23, null, (Function1)function1, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates3, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)32, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        $this$convert_u24default$iv = new String[]{"--nuget-ids"};
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])$this$convert_u24default$iv, (String)"Convert NuGet package IDs in curations and configurations to the new format that includes a namespace.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        metavar$iv = special$$inlined$convert$default$3.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$nuGetIds_delegate_u24lambda_u241 = optionCallTransformContext;
                    boolean bl = false;
                    string = ExtensionsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function24 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function25 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function26 = OptionWithValuesKt.defaultValidator();
        Function1 function12 = $this$convert_u24default$iv.getMetavarGetter();
        if (function12 == null) {
            function12 = metavar$iv;
        }
        if ((completionCandidates2 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates2 = completionCandidates$iv;
        }
        this.nuGetIds$delegate = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function24, (Function2)function25, (Function2)function26, null, (Function1)function12, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates2, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (int)32, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        $this$convert_u24default$iv = new String[]{"--pub-ids"};
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])$this$convert_u24default$iv, (String)"Convert Pub package IDs in curations and configurations to the new format that has no namespace.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        metavar$iv = special$$inlined$convert$default$5.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$pubIds_delegate_u24lambda_u242 = optionCallTransformContext;
                    boolean bl = false;
                    string = ExtensionsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function27 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function28 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function29 = OptionWithValuesKt.defaultValidator();
        Function1 function13 = $this$convert_u24default$iv.getMetavarGetter();
        if (function13 == null) {
            function13 = metavar$iv;
        }
        if ((completionCandidates = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates = completionCandidates$iv;
        }
        this.pubIds$delegate = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function27, (Function2)function28, (Function2)function29, null, (Function1)function13, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (int)32, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
    }

    public /* synthetic */ MigrateCommand(PluginDescriptor pluginDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = MigrateCommandFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor);
    }

    private final File getHoconToYaml() {
        return (File)this.hoconToYaml$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final File getNuGetIds() {
        return (File)this.nuGetIds$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final File getPubIds() {
        return (File)this.pubIds$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public void run() {
        block2: {
            File file = this.getHoconToYaml();
            if (file != null) {
                File $this$run_u24lambda_u243 = file;
                boolean bl = false;
                BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)MigrateCommandKt.access$convertHoconToYaml(FilesKt.readText$default((File)$this$run_u24lambda_u243, null, (int)1, null)), (boolean)false, (boolean)false, (int)6, null);
            }
            File file2 = this.getNuGetIds();
            if (file2 != null) {
                File $this$run_u24lambda_u244 = file2;
                boolean bl = false;
                this.migrateNuGetIds($this$run_u24lambda_u244);
            }
            File file3 = this.getPubIds();
            if (file3 == null) break block2;
            File $this$run_u24lambda_u245 = file3;
            boolean bl = false;
            this.migratePubIds($this$run_u24lambda_u245);
        }
    }

    private final void migrateNuGetIds(File configDir) {
        this.migrateIds(configDir, (Function1<? super Identifier, Identifier>)((Function1)MigrateCommand::migrateNuGetIds$lambda$6));
    }

    private final void migratePubIds(File configDir) {
        this.migrateIds(configDir, (Function1<? super Identifier, Identifier>)((Function1)MigrateCommand::migratePubIds$lambda$7));
    }

    /*
     * WARNING - void declaration
     */
    private final void migrateIds(File configDir, Function1<? super Identifier, Identifier> transformId) {
        File file;
        Map.Entry entry;
        File $this$readValue$iv;
        Object file2;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        YAMLMapper configYamlMapper = MappersKt.getYamlMapper().copy().enable(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE).disable(YAMLGenerator.Feature.SPLIT_LINES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        List candidateFiles = CollectionsKt.toMutableList((Collection)FileFormat.Companion.findFilesWithKnownExtensions(configDir));
        Iterable $this$mapNotNull$iv = candidateFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            Pair pair;
            Object $this$migrateIds_u24lambda_u2410_u24lambda_u248;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            File file3 = (File)element$iv$iv;
            boolean bl2 = false;
            MigrateCommand migrateCommand = this;
            try {
                Object object;
                List $this$readValues$iv$iv$iv;
                $this$migrateIds_u24lambda_u2410_u24lambda_u248 = migrateCommand;
                boolean bl3 = false;
                File $this$readValue$iv2 = file3;
                boolean $i$f$readValue = false;
                File $this$readValueOrNull$iv$iv = $this$readValue$iv2;
                boolean $i$f$readValueOrNull = false;
                ObjectMapper mapper$iv$iv = FileFormatKt.mapper((File)$this$readValueOrNull$iv$iv);
                JsonParser parser$iv$iv = mapper$iv$iv.getFactory().createParser($this$readValueOrNull$iv$iv);
                ObjectMapper objectMapper = mapper$iv$iv;
                Intrinsics.checkNotNull((Object)parser$iv$iv);
                JsonParser jp$iv$iv$iv = parser$iv$iv;
                boolean $i$f$readValues = false;
                boolean $i$f$jacksonTypeRef = false;
                MappingIterator mappingIterator = $this$readValues$iv$iv$iv.readValues(jp$iv$iv$iv, (TypeReference)new TypeReference<List<? extends PackageCuration>>(){});
                Intrinsics.checkNotNullExpressionValue((Object)mappingIterator, (String)"readValues(jp, jacksonTypeRef<T>())");
                List it$iv$iv = $this$readValues$iv$iv$iv = mappingIterator.readAll();
                boolean bl4 = false;
                if (it$iv$iv.isEmpty()) {
                    object = null;
                } else {
                    if (it$iv$iv.size() > 1) {
                        throw new IOException("Multiple top-level objects found in file '" + $this$readValueOrNull$iv$iv + "'.");
                    }
                    List values$iv$iv = $this$readValues$iv$iv$iv;
                    Intrinsics.checkNotNull((Object)values$iv$iv);
                    object = CollectionsKt.first((List)values$iv$iv);
                }
                if (object == null) {
                    throw new IOException("No object found in file '" + $this$readValue$iv2 + "'.");
                }
                $this$migrateIds_u24lambda_u2410_u24lambda_u248 = Result.constructor-impl((Object)((List)object));
            }
            catch (Throwable bl3) {
                $this$migrateIds_u24lambda_u2410_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            migrateCommand = $this$migrateIds_u24lambda_u2410_u24lambda_u248;
            List list = (List)((Object)(Result.isFailure-impl((Object)((Object)migrateCommand)) ? null : migrateCommand));
            if (list != null) {
                List it = list;
                boolean bl5 = false;
                pair = TuplesKt.to((Object)file3, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map pkgCurationFiles = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        File curationsDir = UtilsKt.getCommonParentFile((Collection)pkgCurationFiles.keySet());
        CollectionsKt.removeAll((Collection)candidateFiles, (Iterable)pkgCurationFiles.keySet());
        Iterable $this$mapNotNull$iv2 = candidateFiles;
        boolean $i$f$mapNotNull2 = false;
        Iterable $i$f$mapNotNullTo22 = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv.hasNext()) {
            Pair pair;
            Object $this$migrateIds_u24lambda_u2413_u24lambda_u2411;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = element$iv$iv.next();
            boolean bl = false;
            file2 = (File)element$iv$iv2;
            boolean bl7 = false;
            MigrateCommand bl5 = this;
            try {
                Object object;
                List list;
                void $this$readValues$iv$iv$iv;
                $this$migrateIds_u24lambda_u2413_u24lambda_u2411 = bl5;
                boolean bl8 = false;
                $this$readValue$iv = file2;
                boolean $i$f$readValue = false;
                File $this$readValueOrNull$iv$iv = $this$readValue$iv;
                boolean $i$f$readValueOrNull = false;
                ObjectMapper mapper$iv$iv = FileFormatKt.mapper((File)$this$readValueOrNull$iv$iv);
                JsonParser parser$iv$iv = mapper$iv$iv.getFactory().createParser($this$readValueOrNull$iv$iv);
                ObjectMapper bl4 = mapper$iv$iv;
                Intrinsics.checkNotNull((Object)parser$iv$iv);
                JsonParser jp$iv$iv$iv = parser$iv$iv;
                boolean $i$f$readValues = false;
                boolean $i$f$jacksonTypeRef = false;
                MappingIterator mappingIterator = $this$readValues$iv$iv$iv.readValues(jp$iv$iv$iv, (TypeReference)new TypeReference<PackageConfiguration>(){});
                Intrinsics.checkNotNullExpressionValue((Object)mappingIterator, (String)"readValues(jp, jacksonTypeRef<T>())");
                List it$iv$iv = list = mappingIterator.readAll();
                boolean $i$a$-also-FileFormatKt$readValueOrNull$values$1$iv$iv2 = false;
                if (it$iv$iv.isEmpty()) {
                    object = null;
                } else {
                    if (it$iv$iv.size() > 1) {
                        throw new IOException("Multiple top-level objects found in file '" + $this$readValueOrNull$iv$iv + "'.");
                    }
                    List values$iv$iv = list;
                    Intrinsics.checkNotNull((Object)values$iv$iv);
                    object = CollectionsKt.first((List)values$iv$iv);
                }
                if (object == null) {
                    throw new IOException("No object found in file '" + $this$readValue$iv + "'.");
                }
                $this$migrateIds_u24lambda_u2413_u24lambda_u2411 = Result.constructor-impl((Object)((PackageConfiguration)object));
            }
            catch (Throwable bl8) {
                $this$migrateIds_u24lambda_u2413_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl8));
            }
            bl5 = $this$migrateIds_u24lambda_u2413_u24lambda_u2411;
            PackageConfiguration packageConfiguration = (PackageConfiguration)(Result.isFailure-impl((Object)((Object)bl5)) ? null : bl5);
            if (packageConfiguration != null) {
                PackageConfiguration it = packageConfiguration;
                boolean bl9 = false;
                pair = TuplesKt.to((Object)file2, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl10 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map pkgConfigFiles = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        File configsDir = UtilsKt.getCommonParentFile((Collection)pkgConfigFiles.keySet());
        CollectionsKt.removeAll((Collection)candidateFiles, (Iterable)pkgConfigFiles.keySet());
        BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)("Skipping " + candidateFiles.size() + " files of unknown format."), (boolean)false, (boolean)false, (int)6, null);
        BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)("Processing " + pkgCurationFiles.size() + " package curation files..."), (boolean)false, (boolean)false, (int)6, null);
        Map $this$forEach$iv = pkgCurationFiles;
        boolean $i$f$forEach3 = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            void $this$mapTo$iv$iv;
            entry = element$iv;
            boolean bl = false;
            file = (File)entry.getKey();
            List curations = (List)entry.getValue();
            Iterable $this$map$iv = curations;
            boolean $i$f$map = false;
            file2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                $this$readValue$iv = (PackageCuration)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl11 = false;
                collection.add(PackageCuration.copy$default((PackageCuration)it, (Identifier)((Identifier)transformId.invoke((Object)it.getId())), null, (int)2, null));
            }
            List curationsWithFixedIds = (List)destination$iv$iv3;
            if (Intrinsics.areEqual((Object)curationsWithFixedIds, (Object)curations)) continue;
            String oldPath = FilesKt.relativeTo((File)file, (File)curationsDir).getPath();
            String newPath = OrtConfigPackageCurationProviderKt.toCurationPath((Identifier)((PackageCuration)CollectionsKt.first((List)curationsWithFixedIds)).getId());
            File newFile = FilesKt.resolve((File)curationsDir, (String)newPath);
            if (!Intrinsics.areEqual((Object)newPath, (Object)oldPath)) {
                Intrinsics.checkNotNull((Object)oldPath);
                FilesKt.resolve((File)curationsDir, (String)oldPath).delete();
                File file4 = newFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getParentFile(...)");
                ExtensionsKt.safeMkdirs((File)file4);
            }
            configYamlMapper.writeValue(newFile, (Object)curationsWithFixedIds);
        }
        BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)("Processing " + pkgConfigFiles.size() + " package configuration files..."), (boolean)false, (boolean)false, (int)6, null);
        $this$forEach$iv = pkgConfigFiles;
        $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            entry = element$iv = iterator.next();
            boolean bl = false;
            file = (File)entry.getKey();
            PackageConfiguration config = (PackageConfiguration)entry.getValue();
            PackageConfiguration configWithFixedId = PackageConfiguration.copy$default((PackageConfiguration)config, (Identifier)((Identifier)transformId.invoke((Object)config.getId())), null, null, null, null, (int)30, null);
            if (Intrinsics.areEqual((Object)configWithFixedId, (Object)config)) continue;
            String oldPath = FilesKt.relativeTo((File)file, (File)configsDir).getPath();
            String newName = configWithFixedId.getSourceArtifactUrl() != null ? "source-artifact" : "vcs";
            String newPath = Identifier.toPath$default((Identifier)configWithFixedId.getId(), null, (String)"_", (int)1, null) + "/" + newName + ".yml";
            File newFile = FilesKt.resolve((File)configsDir, (String)newPath);
            if (!Intrinsics.areEqual((Object)newPath, (Object)oldPath)) {
                Intrinsics.checkNotNull((Object)oldPath);
                FilesKt.resolve((File)configsDir, (String)oldPath).delete();
                File file5 = newFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"getParentFile(...)");
                ExtensionsKt.safeMkdirs((File)file5);
            }
            configYamlMapper.writeValue(newFile, (Object)configWithFixedId);
        }
    }

    private static final Identifier migrateNuGetIds$lambda$6(Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id.getType(), (Object)"NuGet") ? NuGetUtilsKt.getIdentifierWithNamespace((String)id.getType(), (String)id.getName(), (String)id.getVersion()) : id;
    }

    private static final Identifier migratePubIds$lambda$7(Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id.getType(), (Object)"Pub") ? Identifier.copy$default((Identifier)id, null, (String)"", null, null, (int)13, null) : id;
    }

    public MigrateCommand() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MigrateCommand.class, "hoconToYaml", "getHoconToYaml()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MigrateCommand.class, "nuGetIds", "getNuGetIds()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MigrateCommand.class, "pubIds", "getPubIds()Ljava/io/File;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

