/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.commands.notifier;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.GroupableOption;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.options.Option;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import java.io.File;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.utils.DefaultResolutionProvider;
import org.ossreviewtoolkit.model.utils.OrtResultExtensionsKt;
import org.ossreviewtoolkit.model.utils.ResolutionProvider;
import org.ossreviewtoolkit.notifier.Notifier;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.commands.api.OrtCommand;
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory;
import org.ossreviewtoolkit.plugins.commands.api.utils.ExtensionsKt;
import org.ossreviewtoolkit.plugins.commands.notifier.NotifierCommand$special$;
import org.ossreviewtoolkit.plugins.commands.notifier.NotifierCommandFactory;
import org.ossreviewtoolkit.utils.ort.EnvironmentKt;

@OrtPlugin(id="notify", displayName="notify command", description="Create notifications based on an ORT result.", factory=OrtCommandFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\tR'\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000b\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/ossreviewtoolkit/plugins/commands/notifier/NotifierCommand;", "Lorg/ossreviewtoolkit/plugins/commands/api/OrtCommand;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;)V", "ortFile", "Ljava/io/File;", "getOrtFile", "()Ljava/io/File;", "ortFile$delegate", "Lkotlin/properties/ReadOnlyProperty;", "notificationsFile", "getNotificationsFile", "notificationsFile$delegate", "resolutionsFile", "getResolutionsFile", "resolutionsFile$delegate", "labels", "", "", "getLabels", "()Ljava/util/Map;", "labels$delegate", "run", "", "readDefaultNotificationsFile", "notifier-command"})
@SourceDebugExtension(value={"SMAP\nNotifierCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotifierCommand.kt\norg/ossreviewtoolkit/plugins/commands/notifier/NotifierCommand\n+ 2 Convert.kt\ncom/github/ajalt/clikt/parameters/options/OptionWithValuesKt__ConvertKt\n*L\n1#1,112:1\n65#2,6:113\n82#2,4:119\n65#2,6:123\n82#2,4:129\n65#2,6:133\n82#2,4:139\n65#2,6:143\n82#2,4:149\n65#2,6:153\n82#2,4:159\n65#2,6:163\n82#2,4:169\n*S KotlinDebug\n*F\n+ 1 NotifierCommand.kt\norg/ossreviewtoolkit/plugins/commands/notifier/NotifierCommand\n*L\n55#1:113,6\n55#1:119,4\n57#1:123,6\n57#1:129,4\n64#1:133,6\n64#1:139,4\n66#1:143,6\n66#1:149,4\n72#1:153,6\n72#1:159,4\n74#1:163,6\n74#1:169,4\n*E\n"})
public final class NotifierCommand
extends OrtCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty ortFile$delegate;
    @NotNull
    private final ReadOnlyProperty notificationsFile$delegate;
    @NotNull
    private final ReadOnlyProperty resolutionsFile$delegate;
    @NotNull
    private final ReadOnlyProperty labels$delegate;

    public NotifierCommand(@NotNull PluginDescriptor descriptor) {
        CompletionCandidates completionCandidates;
        CompletionCandidates completionCandidates2;
        CompletionCandidates completionCandidates3;
        CompletionCandidates completionCandidates4;
        CompletionCandidates completionCandidates5;
        CompletionCandidates completionCandidates6;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(descriptor);
        String[] stringArray = new String[]{"--ort-file", "-i"};
        String[] $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"The ORT result file to read as input.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        Function1 metavar$iv = special$$inlined$convert$default$1.INSTANCE;
        Object completionCandidates$iv = null;
        boolean $i$f$convert = false;
        Function2 valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$ortFile_delegate_u24lambda_u240 = optionCallTransformContext;
                    boolean bl = false;
                    string = org.ossreviewtoolkit.utils.common.ExtensionsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function2 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function22 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function23 = OptionWithValuesKt.defaultValidator();
        Function1 function1 = $this$convert_u24default$iv.getMetavarGetter();
        if (function1 == null) {
            function1 = metavar$iv;
        }
        if ((completionCandidates6 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates6 = completionCandidates$iv;
        }
        $this$convert_u24default$iv = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function2, (Function2)function22, (Function2)function23, null, (Function1)function1, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates6, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)32, null);
        metavar$iv = special$$inlined$convert$default$3.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, File>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final File invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                File file;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    File file2 = (File)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$ortFile_delegate_u24lambda_u241 = optionCallTransformContext;
                    boolean bl = false;
                    File file3 = it2.getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
                    file = FilesKt.normalize((File)file3);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string = err.getParamName();
                    if (string == null) {
                        void n;
                        String string2;
                        String string3 = string2 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string = !bl2 ? string2 : null;
                        if (string == null) {
                            string = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string);
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    optionCallTransformContext.fail(string);
                    throw new KotlinNothingValueException();
                }
                return file;
            }
        };
        Function2 function24 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function25 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function26 = OptionWithValuesKt.defaultValidator();
        Function1 function12 = $this$convert_u24default$iv.getMetavarGetter();
        if (function12 == null) {
            function12 = metavar$iv;
        }
        if ((completionCandidates5 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates5 = completionCandidates$iv;
        }
        this.ortFile$delegate = ((OptionWithValues)ExtensionsKt.inputGroup((GroupableOption)((GroupableOption)OptionWithValuesKt.required((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function24, (Function2)function25, (Function2)function26, null, (Function1)function12, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates5, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null))))).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        $this$convert_u24default$iv = new String[]{"--notifications-file", "-n"};
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])$this$convert_u24default$iv, (String)"The name of a Kotlin script file containing notification rules.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        metavar$iv = special$$inlined$convert$default$5.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$notificationsFile_delegate_u24lambda_u242 = optionCallTransformContext;
                    boolean bl = false;
                    string = org.ossreviewtoolkit.utils.common.ExtensionsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function27 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function28 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function29 = OptionWithValuesKt.defaultValidator();
        Function1 function13 = $this$convert_u24default$iv.getMetavarGetter();
        if (function13 == null) {
            function13 = metavar$iv;
        }
        if ((completionCandidates4 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates4 = completionCandidates$iv;
        }
        $this$convert_u24default$iv = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function27, (Function2)function28, (Function2)function29, null, (Function1)function13, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates4, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)32, null);
        metavar$iv = special$$inlined$convert$default$7.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, File>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final File invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                File file;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    File file2 = (File)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$notificationsFile_delegate_u24lambda_u243 = optionCallTransformContext;
                    boolean bl = false;
                    File file3 = it2.getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
                    file = FilesKt.normalize((File)file3);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string = err.getParamName();
                    if (string == null) {
                        void n;
                        String string2;
                        String string3 = string2 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string = !bl2 ? string2 : null;
                        if (string == null) {
                            string = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string);
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    optionCallTransformContext.fail(string);
                    throw new KotlinNothingValueException();
                }
                return file;
            }
        };
        Function2 function210 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function211 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function212 = OptionWithValuesKt.defaultValidator();
        Function1 function14 = $this$convert_u24default$iv.getMetavarGetter();
        if (function14 == null) {
            function14 = metavar$iv;
        }
        if ((completionCandidates3 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates3 = completionCandidates$iv;
        }
        this.notificationsFile$delegate = ((OptionWithValues)ExtensionsKt.inputGroup((GroupableOption)((GroupableOption)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function210, (Function2)function211, (Function2)function212, null, (Function1)function14, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates3, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null)))).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        $this$convert_u24default$iv = new String[]{"--resolutions-file"};
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])$this$convert_u24default$iv, (String)"A file containing issue and rule violation resolutions.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        metavar$iv = special$$inlined$convert$default$9.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$resolutionsFile_delegate_u24lambda_u244 = optionCallTransformContext;
                    boolean bl = false;
                    string = org.ossreviewtoolkit.utils.common.ExtensionsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function213 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function214 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function215 = OptionWithValuesKt.defaultValidator();
        Function1 function15 = $this$convert_u24default$iv.getMetavarGetter();
        if (function15 == null) {
            function15 = metavar$iv;
        }
        if ((completionCandidates2 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates2 = completionCandidates$iv;
        }
        $this$convert_u24default$iv = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function213, (Function2)function214, (Function2)function215, null, (Function1)function15, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates2, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)32, null);
        metavar$iv = special$$inlined$convert$default$11.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, File>((OptionWithValues)$this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final File invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                File file;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    File file2 = (File)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$resolutionsFile_delegate_u24lambda_u245 = optionCallTransformContext;
                    boolean bl = false;
                    File file3 = it2.getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
                    file = FilesKt.normalize((File)file3);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string = err.getParamName();
                    if (string == null) {
                        void n;
                        String string2;
                        String string3 = string2 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string = !bl2 ? string2 : null;
                        if (string == null) {
                            string = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string);
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    optionCallTransformContext.fail(string);
                    throw new KotlinNothingValueException();
                }
                return file;
            }
        };
        Function2 function216 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function217 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function218 = OptionWithValuesKt.defaultValidator();
        Function1 function16 = $this$convert_u24default$iv.getMetavarGetter();
        if (function16 == null) {
            function16 = metavar$iv;
        }
        if ((completionCandidates = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates = completionCandidates$iv;
        }
        this.resolutionsFile$delegate = ((OptionWithValues)ExtensionsKt.configurationGroup((GroupableOption)((GroupableOption)OptionWithValuesKt.default$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function216, (Function2)function217, (Function2)function218, null, (Function1)function16, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (Object)FilesKt.resolve((File)EnvironmentKt.getOrtConfigDirectory(), (String)"resolutions.yml"), null, (int)2, null)))).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
        stringArray = new String[]{"--label", "-l"};
        this.labels$delegate = OptionWithValuesKt.associate$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Set a label in the ORT result passed to the notifier script, overwriting any existing label of the same name. Can be used multiple times. For example: --label distribution=external", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), null, (int)1, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
    }

    public /* synthetic */ NotifierCommand(PluginDescriptor pluginDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = NotifierCommandFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor);
    }

    private final File getOrtFile() {
        return (File)this.ortFile$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final File getNotificationsFile() {
        return (File)this.notificationsFile$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final File getResolutionsFile() {
        return (File)this.resolutionsFile$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final Map<String, String> getLabels() {
        return (Map)this.labels$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public void run() {
        OrtResult ortResult = OrtResultExtensionsKt.mergeLabels((OrtResult)ExtensionsKt.readOrtResult((File)this.getOrtFile()), this.getLabels());
        ResolutionProvider resolutionProvider = ortResult.getResolvedConfiguration().getResolutions() == null ? (ResolutionProvider)DefaultResolutionProvider.Companion.create(ortResult, this.getResolutionsFile()) : (ResolutionProvider)ortResult;
        Notifier notifier = new Notifier(ortResult, this.getOrtConfig().getNotifier(), resolutionProvider);
        Object object = this.getNotificationsFile();
        if (object == null || (object = FilesKt.readText$default((File)object, null, (int)1, null)) == null) {
            object = this.readDefaultNotificationsFile();
        }
        Object script = object;
        notifier.run((String)script);
    }

    private final String readDefaultNotificationsFile() {
        File notificationsFile = FilesKt.resolve((File)EnvironmentKt.getOrtConfigDirectory(), (String)"notifier.notifications.kts");
        if (!notificationsFile.isFile()) {
            throw new UsageError("No notifications file option specified and no default notifications file found at '" + notificationsFile + "'.", null, 0, 6, null);
        }
        return FilesKt.readText$default((File)notificationsFile, null, (int)1, null);
    }

    public NotifierCommand() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NotifierCommand.class, "ortFile", "getOrtFile()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NotifierCommand.class, "notificationsFile", "getNotificationsFile()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NotifierCommand.class, "resolutionsFile", "getResolutionsFile()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NotifierCommand.class, "labels", "getLabels()Ljava/util/Map;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

