package org.ossreviewtoolkit.plugins.commands.requirements

import org.ossreviewtoolkit.plugins.api.PluginConfig
import org.ossreviewtoolkit.plugins.api.PluginDescriptor
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory

public class RequirementsCommandFactory : OrtCommandFactory {
  override val descriptor: PluginDescriptor by Companion::descriptor

  override fun create(config: PluginConfig): RequirementsCommand = RequirementsCommand(descriptor)

  public companion object {
    public val descriptor: PluginDescriptor = PluginDescriptor(
            id = "requirements",
            displayName = "requirements command",
            description = "Check for the command line tools required by ORT.",
            options = listOf(
            )
        )

    public fun create(): RequirementsCommand = RequirementsCommand(descriptor)
  }
}
