package org.ossreviewtoolkit.plugins.commands.scanner

import org.ossreviewtoolkit.plugins.api.PluginConfig
import org.ossreviewtoolkit.plugins.api.PluginDescriptor
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory

public class ScannerCommandFactory : OrtCommandFactory {
  override val descriptor: PluginDescriptor by Companion::descriptor

  override fun create(config: PluginConfig): ScannerCommand = ScannerCommand(descriptor)

  public companion object {
    public val descriptor: PluginDescriptor = PluginDescriptor(
            id = "scan",
            displayName = "scan command",
            description = "Run external license / copyright scanners.",
            options = listOf(
            )
        )

    public fun create(): ScannerCommand = ScannerCommand(descriptor)
  }
}
