/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.commands.uploadresulttopostgres;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.GroupableOption;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.Option;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.config.PostgresConnection;
import org.ossreviewtoolkit.model.config.PostgresStorageConfiguration;
import org.ossreviewtoolkit.model.utils.DatabaseUtils;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.api.PluginDescriptor;
import org.ossreviewtoolkit.plugins.commands.api.OrtCommand;
import org.ossreviewtoolkit.plugins.commands.api.OrtCommandFactory;
import org.ossreviewtoolkit.plugins.commands.uploadresulttopostgres.OrtResults;
import org.ossreviewtoolkit.plugins.commands.uploadresulttopostgres.UploadResultToPostgresCommand$special$;
import org.ossreviewtoolkit.plugins.commands.uploadresulttopostgres.UploadResultToPostgresCommandFactory;
import org.ossreviewtoolkit.utils.common.FileUtilsKt;
import org.ossreviewtoolkit.utils.common.MiscUtilsKt;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;

@OrtPlugin(displayName="upload-result-to-postgres command", description="Upload an ORT result to a PostgreSQL database.", factory=OrtCommandFactory.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0012\u0010\u000fR\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/ossreviewtoolkit/plugins/commands/uploadresulttopostgres/UploadResultToPostgresCommand;", "Lorg/ossreviewtoolkit/plugins/commands/api/OrtCommand;", "descriptor", "Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;", "<init>", "(Lorg/ossreviewtoolkit/plugins/api/PluginDescriptor;)V", "ortFile", "Ljava/io/File;", "getOrtFile", "()Ljava/io/File;", "ortFile$delegate", "Lkotlin/properties/ReadOnlyProperty;", "tableName", "", "getTableName", "()Ljava/lang/String;", "tableName$delegate", "columnName", "getColumnName", "columnName$delegate", "createTable", "", "getCreateTable", "()Z", "createTable$delegate", "run", "", "upload-result-to-postgres-command"})
@SourceDebugExtension(value={"SMAP\nUploadResultToPostgresCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadResultToPostgresCommand.kt\norg/ossreviewtoolkit/plugins/commands/uploadresulttopostgres/UploadResultToPostgresCommand\n+ 2 Convert.kt\ncom/github/ajalt/clikt/parameters/options/OptionWithValuesKt__ConvertKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n*L\n1#1,153:1\n65#2,6:154\n82#2,4:160\n65#2,6:164\n82#2,4:170\n808#3,11:174\n296#4,4:185\n*S KotlinDebug\n*F\n+ 1 UploadResultToPostgresCommand.kt\norg/ossreviewtoolkit/plugins/commands/uploadresulttopostgres/UploadResultToPostgresCommand\n*L\n64#1:154,6\n64#1:160,4\n66#1:164,6\n66#1:170,4\n89#1:174,11\n136#1:185,4\n*E\n"})
public final class UploadResultToPostgresCommand
extends OrtCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty ortFile$delegate;
    @NotNull
    private final ReadOnlyProperty tableName$delegate;
    @NotNull
    private final ReadOnlyProperty columnName$delegate;
    @NotNull
    private final ReadOnlyProperty createTable$delegate;

    public UploadResultToPostgresCommand(@NotNull PluginDescriptor descriptor) {
        CompletionCandidates completionCandidates;
        CompletionCandidates completionCandidates2;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(descriptor);
        String[] stringArray = new String[]{"--ort-file", "-i"};
        OptionWithValues $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"The ORT result file to read as input.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null);
        Function1 metavar$iv = special$$inlined$convert$default$1.INSTANCE;
        Object completionCandidates$iv = null;
        boolean $i$f$convert = false;
        Function2 valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, String>($this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string2 = (String)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$ortFile_delegate_u24lambda_u240 = optionCallTransformContext;
                    boolean bl = false;
                    string = FileUtilsKt.expandTilde((String)it2);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string3 = err.getParamName();
                    if (string3 == null) {
                        void n;
                        String string4;
                        String string5 = string4 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string3 = !bl2 ? string4 : null;
                        if (string3 == null) {
                            string3 = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string3);
                    throw err;
                }
                catch (Exception err) {
                    String string6 = err.getMessage();
                    if (string6 == null) {
                        string6 = "";
                    }
                    optionCallTransformContext.fail(string6);
                    throw new KotlinNothingValueException();
                }
                return string;
            }
        };
        Function2 function2 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function22 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function23 = OptionWithValuesKt.defaultValidator();
        Function1 function1 = $this$convert_u24default$iv.getMetavarGetter();
        if (function1 == null) {
            function1 = metavar$iv;
        }
        if ((completionCandidates2 = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates2 = completionCandidates$iv;
        }
        $this$convert_u24default$iv = FileKt.file$default((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function2, (Function2)function22, (Function2)function23, null, (Function1)function1, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates2, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null), (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)32, null);
        metavar$iv = special$$inlined$convert$default$3.INSTANCE;
        completionCandidates$iv = null;
        $i$f$convert = false;
        valueTransform$iv = (Function2)new Function2<OptionCallTransformContext, String, File>($this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final File invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                File file;
                Intrinsics.checkNotNullParameter((Object)optionCallTransformContext, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    File file2 = (File)this.$this_convert.getTransformValue().invoke((Object)optionCallTransformContext, (Object)it);
                    OptionCallTransformContext $this$ortFile_delegate_u24lambda_u241 = optionCallTransformContext;
                    boolean bl = false;
                    File file3 = it2.getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
                    file = FilesKt.normalize((File)file3);
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string = err.getParamName();
                    if (string == null) {
                        void n;
                        String string2;
                        String string3 = string2 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string = !bl2 ? string2 : null;
                        if (string == null) {
                            string = OptionKt.longestName((Option)optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string);
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    optionCallTransformContext.fail(string);
                    throw new KotlinNothingValueException();
                }
                return file;
            }
        };
        Function2 function24 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function25 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function26 = OptionWithValuesKt.defaultValidator();
        Function1 function12 = $this$convert_u24default$iv.getMetavarGetter();
        if (function12 == null) {
            function12 = metavar$iv;
        }
        if ((completionCandidates = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates = completionCandidates$iv;
        }
        this.ortFile$delegate = ((OptionWithValues)org.ossreviewtoolkit.plugins.commands.api.utils.ExtensionsKt.inputGroup((GroupableOption)((GroupableOption)OptionWithValuesKt.required((OptionWithValues)OptionWithValues.DefaultImpls.copy$default((OptionWithValues)$this$convert_u24default$iv, (Function2)valueTransform$iv, (Function2)function24, (Function2)function25, (Function2)function26, null, (Function1)function12, null, null, (boolean)false, null, null, null, null, (CompletionCandidates)completionCandidates, null, (boolean)false, (boolean)false, (boolean)false, (int)253904, null))))).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        stringArray = new String[]{"--table-name"};
        this.tableName$delegate = OptionWithValuesKt.required((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"The name of the table to upload results to.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null)).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        stringArray = new String[]{"--column-name"};
        this.columnName$delegate = OptionWithValuesKt.required((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"The name of the JSONB column to store the ORT result.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null)).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
        stringArray = new String[]{"--create-table"};
        this.createTable$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Create the table if it does not exist.", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
    }

    public /* synthetic */ UploadResultToPostgresCommand(PluginDescriptor pluginDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginDescriptor = UploadResultToPostgresCommandFactory.Companion.getDescriptor();
        }
        this(pluginDescriptor);
    }

    private final File getOrtFile() {
        return (File)this.ortFile$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final String getTableName() {
        return (String)this.tableName$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final String getColumnName() {
        return (String)this.columnName$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final boolean getCreateTable() {
        return (Boolean)this.createTable$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        PostgresStorageConfiguration postgresConfig;
        PostgresStorageConfiguration postgresStorageConfiguration;
        Collection collection;
        OrtResult ortResult = org.ossreviewtoolkit.plugins.commands.api.utils.ExtensionsKt.readOrtResult((File)this.getOrtFile());
        Map map = this.getOrtConfig().getScanner().getStorages();
        if (map != null && (collection = map.values()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = collection;
            boolean $i$f$filterIsInstance = false;
            void var8_13 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PostgresStorageConfiguration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List configs = (List)destination$iv$iv;
            boolean bl = false;
            if (configs.size() > 1) {
                PostgresStorageConfiguration config = (PostgresStorageConfiguration)CollectionsKt.first((List)configs);
                BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)("Multiple PostgreSQL storages are configured, using the first one which points to schema " + config.getConnection().getSchema() + " at " + config.getConnection().getUrl() + "."), (boolean)false, (boolean)false, (int)6, null);
            }
            postgresStorageConfiguration = (PostgresStorageConfiguration)CollectionsKt.firstOrNull((List)configs);
        } else {
            postgresStorageConfiguration = null;
        }
        if ((postgresConfig = postgresStorageConfiguration) == null) {
            boolean $i$a$-requireNotNull-UploadResultToPostgresCommand$run$22 = false;
            String $i$a$-requireNotNull-UploadResultToPostgresCommand$run$22 = "No PostgreSQL storage is configured for the scanner.";
            throw new IllegalArgumentException($i$a$-requireNotNull-UploadResultToPostgresCommand$run$22.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.getTableName()))) {
            boolean $i$a$-require-UploadResultToPostgresCommand$run$42 = false;
            String $i$a$-require-UploadResultToPostgresCommand$run$42 = "The table name must not be blank.";
            throw new IllegalArgumentException($i$a$-require-UploadResultToPostgresCommand$run$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.getColumnName()))) {
            boolean $i$a$-require-UploadResultToPostgresCommand$run$52 = false;
            String $i$a$-require-UploadResultToPostgresCommand$run$52 = "The column name must not be blank.";
            throw new IllegalArgumentException($i$a$-require-UploadResultToPostgresCommand$run$52.toString());
        }
        Lazy dataSource = DatabaseUtils.createHikariDataSource$default((DatabaseUtils)DatabaseUtils.INSTANCE, (PostgresConnection)postgresConfig.getConnection(), (String)"upload-result-command", (int)0, (int)4, null);
        Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)((DataSource)dataSource.getValue()), null, null, null, null, (int)30, null);
        OrtResults table = new OrtResults(this.getTableName(), this.getColumnName());
        if (this.getCreateTable()) {
            ThreadLocalTransactionManagerKt.transaction$default(null, arg_0 -> UploadResultToPostgresCommand.run$lambda$7(this, table, arg_0), (int)1, null);
        }
        try {
            ThreadLocalTransactionManagerKt.transaction$default(null, arg_0 -> UploadResultToPostgresCommand.run$lambda$9(table, ortResult, arg_0), (int)1, null);
            BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)"Successfully stored ORT result.", (boolean)false, (boolean)false, (int)6, null);
        }
        catch (SQLException e) {
            ExtensionsKt.showStackTrace((Throwable)e);
            BaseCliktCommand.echo$default((BaseCliktCommand)((BaseCliktCommand)this), (Object)("Could not store ORT result: " + MiscUtilsKt.collectMessages((Throwable)e)), (boolean)false, (boolean)false, (int)6, null);
        }
    }

    private static final Unit run$lambda$7$lambda$6(Transaction $this_transaction, UploadResultToPostgresCommand this$0, OrtResults $table) {
        if (!DatabaseUtils.INSTANCE.tableExists($this_transaction, this$0.getTableName())) {
            DatabaseUtils.checkDatabaseEncoding$default((DatabaseUtils)DatabaseUtils.INSTANCE, (Transaction)$this_transaction, null, (int)1, null);
            Table[] tableArray = new Table[]{$table};
            SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$7(UploadResultToPostgresCommand this$0, OrtResults $table, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        SchemaUtils.INSTANCE.withDataBaseLock($this$transaction, () -> UploadResultToPostgresCommand.run$lambda$7$lambda$6($this$transaction, this$0, $table));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final InsertStatement run$lambda$9(OrtResults $table, OrtResult $ortResult, Transaction $this$transaction) {
        void it;
        InsertStatement insertStatement;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table $this$insert$iv = (Table)$table;
        boolean $i$f$insert = false;
        InsertStatement $this$insert_u24lambda_u243$iv = insertStatement = new InsertStatement($this$insert$iv, false, 2, null);
        boolean bl = false;
        InsertStatement insertStatement2 = $this$insert_u24lambda_u243$iv;
        OrtResults $this$run_u24lambda_u249_u24lambda_u248 = (OrtResults)$this$insert$iv;
        boolean bl2 = false;
        it.set($this$run_u24lambda_u249_u24lambda_u248.getResult(), (Object)$ortResult);
        $this$insert_u24lambda_u243$iv.execute(TransactionManager.Companion.current());
        return insertStatement;
    }

    public UploadResultToPostgresCommand() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UploadResultToPostgresCommand.class, "ortFile", "getOrtFile()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UploadResultToPostgresCommand.class, "tableName", "getTableName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UploadResultToPostgresCommand.class, "columnName", "getColumnName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UploadResultToPostgresCommand.class, "createTable", "getCreateTable()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

