/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.compiler;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.plugins.api.OrtPlugin;
import org.ossreviewtoolkit.plugins.compiler.JsonSpecGenerator;
import org.ossreviewtoolkit.plugins.compiler.PluginFactoryGenerator;
import org.ossreviewtoolkit.plugins.compiler.PluginSpec;
import org.ossreviewtoolkit.plugins.compiler.PluginSpecFactory;
import org.ossreviewtoolkit.plugins.compiler.ServiceLoaderGenerator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/ossreviewtoolkit/plugins/compiler/PluginProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "<init>", "(Lcom/google/devtools/ksp/processing/CodeGenerator;)V", "invoked", "", "specFactory", "Lorg/ossreviewtoolkit/plugins/compiler/PluginSpecFactory;", "factoryGenerator", "Lorg/ossreviewtoolkit/plugins/compiler/PluginFactoryGenerator;", "jsonGenerator", "Lorg/ossreviewtoolkit/plugins/compiler/JsonSpecGenerator;", "serviceLoaderGenerator", "Lorg/ossreviewtoolkit/plugins/compiler/ServiceLoaderGenerator;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "getPluginFactoryClass", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "annotation", "Lorg/ossreviewtoolkit/plugins/api/OrtPlugin;", "getPluginParentClass", "factoryClass", "checkExtendsPluginFactory", "", "checkExtendsPluginClass", "pluginClass", "pluginBaseClass", "compiler"})
@SourceDebugExtension(value={"SMAP\nPluginProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginProcessor.kt\norg/ossreviewtoolkit/plugins/compiler/PluginProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,145:1\n1317#2,2:146\n350#2,12:148\n1251#2,2:160\n1251#2,2:162\n*S KotlinDebug\n*F\n+ 1 PluginProcessor.kt\norg/ossreviewtoolkit/plugins/compiler/PluginProcessor\n*L\n60#1:146,2\n110#1:148,12\n129#1:160,2\n140#1:162,2\n*E\n"})
public final class PluginProcessor
implements SymbolProcessor {
    private boolean invoked;
    @NotNull
    private final PluginSpecFactory specFactory;
    @NotNull
    private final PluginFactoryGenerator factoryGenerator;
    @NotNull
    private final JsonSpecGenerator jsonGenerator;
    @NotNull
    private final ServiceLoaderGenerator serviceLoaderGenerator;

    public PluginProcessor(@NotNull CodeGenerator codeGenerator) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        this.specFactory = new PluginSpecFactory();
        this.factoryGenerator = new PluginFactoryGenerator(codeGenerator);
        this.jsonGenerator = new JsonSpecGenerator(codeGenerator);
        this.serviceLoaderGenerator = new ServiceLoaderGenerator(codeGenerator);
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (this.invoked) {
            return CollectionsKt.emptyList();
        }
        String ortPluginClassName = Reflection.getOrCreateKotlinClass(OrtPlugin.class).getQualifiedName();
        if (ortPluginClassName == null) {
            boolean $i$a$-requireNotNull-PluginProcessor$process$22 = false;
            String $i$a$-requireNotNull-PluginProcessor$process$22 = "Could not get qualified name of OrtPlugin annotation.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PluginProcessor$process$22.toString());
        }
        List serviceLoaderSpecs = new ArrayList();
        Sequence $this$forEach$iv = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)ortPluginClassName, (boolean)false, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSAnnotated pluginClass = (KSAnnotated)element$iv;
            boolean bl = false;
            if (!(pluginClass instanceof KSClassDeclaration)) {
                boolean $i$a$-require-PluginProcessor$process$2$22 = false;
                String $i$a$-require-PluginProcessor$process$2$22 = "Annotated element " + pluginClass + " is not a class.";
                throw new IllegalArgumentException($i$a$-require-PluginProcessor$process$2$22.toString());
            }
            OrtPlugin pluginAnnotation = (OrtPlugin)SequencesKt.single((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)pluginClass, (KClass)Reflection.getOrCreateKotlinClass(OrtPlugin.class)));
            KSClassDeclaration pluginFactoryClass = this.getPluginFactoryClass(resolver, pluginAnnotation);
            this.checkExtendsPluginFactory(pluginFactoryClass);
            KSClassDeclaration pluginParentClass = this.getPluginParentClass(pluginFactoryClass);
            this.checkExtendsPluginClass((KSClassDeclaration)pluginClass, pluginParentClass);
            PluginSpec pluginSpec = this.specFactory.create(pluginAnnotation, (KSClassDeclaration)pluginClass, pluginParentClass, pluginFactoryClass);
            ((Collection)serviceLoaderSpecs).add(this.factoryGenerator.generate(pluginSpec));
            this.jsonGenerator.generate(pluginSpec);
        }
        this.serviceLoaderGenerator.generate(serviceLoaderSpecs);
        this.invoked = true;
        return CollectionsKt.emptyList();
    }

    private final KSClassDeclaration getPluginFactoryClass(Resolver $this$getPluginFactoryClass, OrtPlugin annotation) {
        String pluginFactoryName = Reflection.getOrCreateKotlinClass((Class)annotation.factory()).getQualifiedName();
        if (pluginFactoryName == null) {
            boolean $i$a$-requireNotNull-PluginProcessor$getPluginFactoryClass$32 = false;
            String $i$a$-requireNotNull-PluginProcessor$getPluginFactoryClass$32 = "Could not get qualified name of plugin factory.";
            throw new IllegalArgumentException($i$a$-requireNotNull-PluginProcessor$getPluginFactoryClass$32.toString());
        }
        KSClassDeclaration pluginFactoryClass = UtilsKt.getClassDeclarationByName((Resolver)$this$getPluginFactoryClass, (String)pluginFactoryName);
        if (pluginFactoryClass == null) {
            boolean bl = false;
            String string = "Could not find class for plugin factory " + pluginFactoryName + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return pluginFactoryClass;
    }

    private final KSClassDeclaration getPluginParentClass(KSClassDeclaration factoryClass) {
        KSType $this$single$iv;
        Sequence sequence = factoryClass.getAllFunctions();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            KSFunctionDeclaration it = (KSFunctionDeclaration)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)"create")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object object = ((KSFunctionDeclaration)single$iv).getReturnType();
        KSDeclaration parentClass = object != null && ($this$single$iv = object.resolve()) != null ? $this$single$iv.getDeclaration() : null;
        if (parentClass == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        if (!(parentClass instanceof KSClassDeclaration)) {
            boolean bl = false;
            String string = "Plugin class " + parentClass + " is not a class.";
            throw new IllegalArgumentException(string.toString());
        }
        return (KSClassDeclaration)parentClass;
    }

    private final void checkExtendsPluginFactory(KSClassDeclaration factoryClass) {
        boolean bl;
        block2: {
            Sequence $this$any$iv = UtilsKt.getAllSuperTypes((KSClassDeclaration)factoryClass);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KSType it = (KSType)element$iv;
                boolean bl2 = false;
                KSName kSName = it.getDeclaration().getQualifiedName();
                if (!Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)"org.ossreviewtoolkit.plugins.api.PluginFactory")) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Plugin factory " + factoryClass + " does not extend the required super type PluginFactory.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void checkExtendsPluginClass(KSClassDeclaration pluginClass, KSClassDeclaration pluginBaseClass) {
        boolean bl;
        block2: {
            Sequence $this$any$iv = UtilsKt.getAllSuperTypes((KSClassDeclaration)pluginClass);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KSType it = (KSType)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getDeclaration(), (Object)pluginBaseClass)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Plugin class " + pluginClass + " does not extend the required super type " + pluginBaseClass + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

