/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.plugins.packagemanagers.composer;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.analyzer.AbstractPackageManagerFactory;
import org.ossreviewtoolkit.analyzer.PackageManager;
import org.ossreviewtoolkit.downloader.VersionControlSystem;
import org.ossreviewtoolkit.model.FileFormatKt;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.IssueKt;
import org.ossreviewtoolkit.model.MappersKt;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.ProjectAnalyzerResult;
import org.ossreviewtoolkit.model.RemoteArtifact;
import org.ossreviewtoolkit.model.Scope;
import org.ossreviewtoolkit.model.VcsInfo;
import org.ossreviewtoolkit.model.config.AnalyzerConfiguration;
import org.ossreviewtoolkit.model.config.RepositoryConfiguration;
import org.ossreviewtoolkit.plugins.packagemanagers.composer.ComposerKt;
import org.ossreviewtoolkit.utils.common.CommandLineTool;
import org.ossreviewtoolkit.utils.common.Os;
import org.ossreviewtoolkit.utils.common.ProcessCapture;
import org.ossreviewtoolkit.utils.ort.ExtensionsKt;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.Semver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u00011B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0014JV\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\u0012\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010#\u001a\u00020\u0016H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0011H\u0002JB\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002J*\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000f2\u0006\u0010&\u001a\u00020\u00062\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0016J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0016\u00a8\u00062"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer;", "Lorg/ossreviewtoolkit/analyzer/PackageManager;", "Lorg/ossreviewtoolkit/utils/common/CommandLineTool;", "name", "", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "(Ljava/lang/String;Ljava/io/File;Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;)V", "beforeResolution", "", "definitionFiles", "", "buildDependencyTree", "", "Lorg/ossreviewtoolkit/model/PackageReference;", "dependencies", "Lkotlin/sequences/Sequence;", "lockFile", "Lcom/fasterxml/jackson/databind/JsonNode;", "packages", "", "Lorg/ossreviewtoolkit/model/Package;", "virtualPackages", "dependencyBranch", "command", "workingDir", "ensureLockFile", "getVersionArguments", "getVersionRequirement", "Lorg/semver4j/RangesList;", "parseInstalledPackages", "json", "parseProject", "Lorg/ossreviewtoolkit/model/Project;", "definitionFile", "scopes", "Lorg/ossreviewtoolkit/model/Scope;", "parseScope", "scopeName", "manifest", "resolveDependencies", "Lorg/ossreviewtoolkit/model/ProjectAnalyzerResult;", "labels", "transformVersion", "output", "Factory", "composer-package-manager"})
@SourceDebugExtension(value={"SMAP\nComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,379:1\n1726#2,3:380\n1855#2:390\n1855#2:391\n1856#2:393\n1856#2:394\n1247#3,2:383\n1313#3:386\n1314#3:388\n38#4:385\n38#4:387\n38#4:389\n38#4:392\n1#5:395\n37#6,2:396\n*S KotlinDebug\n*F\n+ 1 Composer.kt\norg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer\n*L\n108#1:380,3\n245#1:390\n246#1:391\n246#1:393\n245#1:394\n119#1:383,2\n179#1:386\n179#1:388\n132#1:385\n184#1:387\n216#1:389\n255#1:392\n293#1:396,2\n*E\n"})
public final class Composer
extends PackageManager
implements CommandLineTool {
    public Composer(@NotNull String name, @NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
        Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        super(name, analysisRoot, analyzerConfig, repoConfig);
    }

    @NotNull
    public String command(@Nullable File workingDir) {
        File file = workingDir;
        return (file != null && (file = FilesKt.resolve((File)file, (String)"composer.phar")) != null ? file.isFile() : false) ? "php composer.phar" : (Os.INSTANCE.isWindows() ? "composer.bat" : "composer");
    }

    @NotNull
    public String getVersionArguments() {
        return "--no-ansi --version";
    }

    @NotNull
    public String transformVersion(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return StringsKt.removeSurrounding((String)((String)CollectionsKt.last((List)CollectionsKt.dropLast((List)org.ossreviewtoolkit.utils.common.ExtensionsKt.splitOnWhitespace((String)output), (int)2))), (CharSequence)"(", (CharSequence)")");
    }

    @NotNull
    public RangesList getVersionRequirement() {
        RangesList rangesList = RangesListFactory.create((String)">=1.5");
        Intrinsics.checkNotNullExpressionValue((Object)rangesList, (String)"create(...)");
        return rangesList;
    }

    protected void beforeResolution(@NotNull List<? extends File> definitionFiles) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(definitionFiles, (String)"definitionFiles");
            Iterable $this$all$iv = definitionFiles;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (new File(it.getParentFile(), "composer.phar").isFile()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        CommandLineTool.DefaultImpls.checkVersion$default((CommandLineTool)this, null, (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<ProjectAnalyzerResult> resolveDependencies(@NotNull File definitionFile, @NotNull Map<String, String> labels) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)definitionFile, (String)"definitionFile");
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            workingDir = definitionFile.getParentFile();
            manifest = FileFormatKt.readTree((File)definitionFile);
            v0 = manifest.fields();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"fields(...)");
            $this$any$iv = SequencesKt.asSequence((Iterator)v0);
            $i$f$any = false;
            for (E element$iv : $this$any$iv) {
                var10_13 = (Map.Entry)element$iv;
                $i$a$-any-Composer$resolveDependencies$hasDependencies$1 = false;
                Intrinsics.checkNotNull((Object)var10_13);
                key = (String)var10_13.getKey();
                value = (JsonNode)var10_13.getValue();
                Intrinsics.checkNotNull((Object)key);
                if (!StringsKt.startsWith$default((String)key, (String)"require", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)value);
                if (CollectionsKt.count((Iterable)((Iterable)value)) > 0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = true;
                break block4;
            }
            v2 = hasDependencies = false;
        }
        if (!hasDependencies) {
            project = this.parseProject(definitionFile, SetsKt.emptySet());
            result = new ProjectAnalyzerResult(project, SetsKt.emptySet(), null, 4, null);
            return CollectionsKt.listOf((Object)result);
        }
        Intrinsics.checkNotNull((Object)workingDir);
        lockFile = this.ensureLockFile(workingDir);
        $this$logger$iv = this;
        $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Composer.class).info((Function0)new Function0<Object>(lockFile){
            final /* synthetic */ File $lockFile;
            {
                this.$lockFile = $lockFile;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Parsing lock file at '" + this.$lockFile + "'...";
            }
        });
        json = MappersKt.getJsonMapper().readTree(lockFile);
        Intrinsics.checkNotNull((Object)json);
        packages = this.parseInstalledPackages(json);
        virtualPackages = ComposerKt.access$parseVirtualPackageNames(packages, manifest, json);
        $i$a$-any-Composer$resolveDependencies$hasDependencies$1 = new Scope[]{this.parseScope("require", manifest, json, packages, virtualPackages), this.parseScope("require-dev", manifest, json, packages, virtualPackages)};
        scopes = SetsKt.setOf((Object[])$i$a$-any-Composer$resolveDependencies$hasDependencies$1);
        project = this.parseProject(definitionFile, scopes);
        result = new ProjectAnalyzerResult(project, CollectionsKt.toSet((Iterable)packages.values()), null, 4, null);
        return CollectionsKt.listOf((Object)result);
    }

    private final Scope parseScope(String scopeName, JsonNode manifest, JsonNode lockFile, Map<String, Package> packages, Set<String> virtualPackages) {
        Sequence requiredPackages = SequencesKt.asSequence((Iterator)org.ossreviewtoolkit.utils.common.ExtensionsKt.fieldNamesOrEmpty((JsonNode)manifest.get(scopeName)));
        Set dependencies = Composer.buildDependencyTree$default(this, requiredPackages, lockFile, packages, virtualPackages, null, 16, null);
        return new Scope(scopeName, dependencies);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PackageReference> buildDependencyTree(Sequence<String> dependencies, JsonNode lockFile, Map<String, Package> packages, Set<String> virtualPackages, List<String> dependencyBranch) {
        void $this$forEach$iv;
        Set packageReferences = new LinkedHashSet();
        Sequence sequence = SequencesKt.filterNot(dependencies, (Function1)((Function1)new Function1<String, Boolean>(virtualPackages){
            final /* synthetic */ Set<String> $virtualPackages;
            {
                this.$virtualPackages = $virtualPackages;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String packageName) {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                return ComposerKt.access$isPlatformDependency(packageName) || this.$virtualPackages.contains(packageName);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Package packageInfo;
            String packageName = (String)element$iv;
            boolean bl = false;
            if (packages.get(packageName) == null) {
                throw new IOException("Could not find package info for " + packageName);
            }
            if (dependencyBranch.contains(packageName)) {
                Composer $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                LoggingFactoryKt.cachedLoggerOf(Composer.class).debug((Function0)new Function0<Object>(packageName, dependencyBranch){
                    final /* synthetic */ String $packageName;
                    final /* synthetic */ List<String> $dependencyBranch;
                    {
                        this.$packageName = $packageName;
                        this.$dependencyBranch = $dependencyBranch;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Not adding circular dependency '" + this.$packageName + "' to the tree, it is already on this branch of the dependency tree: " + CollectionsKt.joinToString$default((Iterable)this.$dependencyBranch, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null) + ".";
                    }
                });
                continue;
            }
            try {
                Sequence runtimeDependencies = ComposerKt.access$getRuntimeDependencies(packageName, lockFile);
                Set<PackageReference> transitiveDependencies = this.buildDependencyTree((Sequence<String>)runtimeDependencies, lockFile, packages, virtualPackages, CollectionsKt.plus((Collection)dependencyBranch, (Object)packageName));
                ((Collection)packageReferences).add(Package.toReference$default((Package)packageInfo, null, transitiveDependencies, null, (int)5, null));
            }
            catch (IOException e) {
                ExtensionsKt.showStackTrace((Throwable)e);
                Package.toReference$default((Package)packageInfo, null, null, (List)CollectionsKt.listOf((Object)IssueKt.createAndLogIssue$default((Object)((Object)this), (String)this.getManagerName(), (String)("Could not resolve dependencies of '" + packageName + "': " + org.ossreviewtoolkit.utils.common.ExtensionsKt.collectMessages((Throwable)e)), null, (int)4, null)), (int)3, null);
            }
        }
        return packageReferences;
    }

    static /* synthetic */ Set buildDependencyTree$default(Composer composer, Sequence sequence, JsonNode jsonNode, Map map, Set set, List list, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return composer.buildDependencyTree((Sequence<String>)sequence, jsonNode, map, set, list);
    }

    private final Project parseProject(File definitionFile, Set<Scope> scopes) {
        String string;
        String namespace;
        String rawName;
        Composer $this$logger$iv = this;
        boolean $i$f$getLogger = false;
        LoggingFactoryKt.cachedLoggerOf(Composer.class).info((Function0)new Function0<Object>(definitionFile){
            final /* synthetic */ File $definitionFile;
            {
                this.$definitionFile = $definitionFile;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Parsing project metadata from '" + this.$definitionFile + "'...";
            }
        });
        JsonNode json = FileFormatKt.readTree((File)definitionFile);
        String homepageUrl = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)json.get("homepage"));
        VcsInfo vcs = ComposerKt.access$parseVcsInfo(json);
        JsonNode jsonNode = json.get("name");
        String string2 = rawName = jsonNode != null ? jsonNode.textValue() : null;
        String string3 = string2 != null ? StringsKt.substringBefore((String)string2, (String)"/", (String)"") : null;
        if (string3 == null) {
            string3 = namespace = "";
        }
        if ((string = rawName) == null || (string = StringsKt.substringAfter$default((String)string, (String)"/", null, (int)2, null)) == null) {
            string = PackageManager.Companion.getFallbackProjectName(this.getAnalysisRoot(), definitionFile);
        }
        String name = string;
        Identifier identifier = new Identifier(this.getManagerName(), namespace, name, org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)json.get("version")));
        String string4 = VersionControlSystem.Companion.getPathInfo(definitionFile).getPath();
        Set set = ComposerKt.access$parseAuthors(json);
        Set set2 = ComposerKt.access$parseDeclaredLicenses(json);
        File file = definitionFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        String[] stringArray = new String[]{homepageUrl};
        return new Project(identifier, null, string4, set, set2, null, vcs, PackageManager.Companion.processProjectVcs(file, vcs, stringArray), homepageUrl, scopes, null, 1058, null);
    }

    private final Map<String, Package> parseInstalledPackages(JsonNode json) {
        Map packages = new LinkedHashMap();
        Object[] objectArray = new String[]{"packages", "packages-dev"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode jsonNode;
            String it = (String)element$iv;
            boolean bl = false;
            JsonNode jsonNode2 = jsonNode = json.get(it);
            if (jsonNode2 == null) continue;
            Intrinsics.checkNotNull((Object)jsonNode2);
            Iterable $this$forEach$iv2 = (Iterable)jsonNode;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JsonNode pkgInfo = (JsonNode)element$iv2;
                boolean bl2 = false;
                String rawName = pkgInfo.get("name").textValue();
                String version = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)pkgInfo.get("version"));
                String homepageUrl = org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)pkgInfo.get("homepage"));
                Intrinsics.checkNotNull((Object)pkgInfo);
                VcsInfo vcsFromPackage = ComposerKt.access$parseVcsInfo(pkgInfo);
                if (((CharSequence)version).length() == 0) {
                    Composer $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    LoggingFactoryKt.cachedLoggerOf(Composer.class).warn((Function0)new Function0<Object>(rawName){
                        final /* synthetic */ String $rawName;
                        {
                            this.$rawName = $rawName;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "No version information found for package " + this.$rawName + ".";
                        }
                    });
                }
                Map map = packages;
                Intrinsics.checkNotNull((Object)rawName);
                String string = rawName;
                String[] stringArray = new String[]{homepageUrl};
                stringArray = new Package(new Identifier(this.getManagerName(), StringsKt.substringBefore$default((String)rawName, (char)'/', null, (int)2, null), StringsKt.substringAfter$default((String)rawName, (char)'/', null, (int)2, null), version), null, null, ComposerKt.access$parseAuthors(pkgInfo), ComposerKt.access$parseDeclaredLicenses(pkgInfo), null, null, org.ossreviewtoolkit.utils.common.ExtensionsKt.textValueOrEmpty((JsonNode)pkgInfo.get("description")), homepageUrl, RemoteArtifact.EMPTY, ComposerKt.access$parseArtifact(pkgInfo), vcsFromPackage, PackageManager.Companion.processPackageVcs(vcsFromPackage, stringArray), false, false, 24678, null);
                map.put(string, stringArray);
            }
        }
        return packages;
    }

    private final File ensureLockFile(File workingDir) {
        String string;
        File lockFile = FilesKt.resolve((File)workingDir, (String)"composer.lock");
        boolean hasLockFile = lockFile.isFile();
        this.requireLockfile(workingDir, (Function0)new Function0<Boolean>(hasLockFile){
            final /* synthetic */ boolean $hasLockFile;
            {
                this.$hasLockFile = $hasLockFile;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$hasLockFile;
            }
        });
        if (hasLockFile) {
            return lockFile;
        }
        Semver composerVersion = new Semver(this.getVersion(workingDir));
        Object[] objectArray = new String[3];
        objectArray[0] = "update";
        objectArray[1] = "--ignore-platform-reqs";
        String string2 = string = "--no-install";
        int n = 2;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = composerVersion.getMajor() >= 2;
        objectArray2[n] = bl2 ? string : null;
        List args = CollectionsKt.listOfNotNull((Object[])objectArray);
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new String[0]);
        this.run(workingDir, (CharSequence[])Arrays.copyOf(objectArray, objectArray.length));
        return lockFile;
    }

    public void checkVersion(@Nullable File workingDir) {
        CommandLineTool.DefaultImpls.checkVersion((CommandLineTool)this, (File)workingDir);
    }

    @NotNull
    public String getVersion(@Nullable File workingDir) {
        return CommandLineTool.DefaultImpls.getVersion((CommandLineTool)this, (File)workingDir);
    }

    public boolean isInPath() {
        return CommandLineTool.DefaultImpls.isInPath((CommandLineTool)this);
    }

    @NotNull
    public ProcessCapture run(@Nullable File workingDir, CharSequence ... args) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (File)workingDir, (CharSequence[])args);
    }

    @NotNull
    public ProcessCapture run(@NotNull CharSequence[] args, @Nullable File workingDir, @NotNull Map<String, String> environment) {
        return CommandLineTool.DefaultImpls.run((CommandLineTool)this, (CharSequence[])args, (File)workingDir, environment);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer$Factory;", "Lorg/ossreviewtoolkit/analyzer/AbstractPackageManagerFactory;", "Lorg/ossreviewtoolkit/plugins/packagemanagers/composer/Composer;", "()V", "globsForDefinitionFiles", "", "", "getGlobsForDefinitionFiles", "()Ljava/util/List;", "create", "analysisRoot", "Ljava/io/File;", "analyzerConfig", "Lorg/ossreviewtoolkit/model/config/AnalyzerConfiguration;", "repoConfig", "Lorg/ossreviewtoolkit/model/config/RepositoryConfiguration;", "composer-package-manager"})
    public static final class Factory
    extends AbstractPackageManagerFactory<Composer> {
        @NotNull
        private final List<String> globsForDefinitionFiles = CollectionsKt.listOf((Object)"composer.json");

        public Factory() {
            super("Composer", false, 2, null);
        }

        @NotNull
        public List<String> getGlobsForDefinitionFiles() {
            return this.globsForDefinitionFiles;
        }

        @NotNull
        public Composer create(@NotNull File analysisRoot, @NotNull AnalyzerConfiguration analyzerConfig, @NotNull RepositoryConfiguration repoConfig) {
            Intrinsics.checkNotNullParameter((Object)analysisRoot, (String)"analysisRoot");
            Intrinsics.checkNotNullParameter((Object)analyzerConfig, (String)"analyzerConfig");
            Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
            return new Composer(this.getType(), analysisRoot, analyzerConfig, repoConfig);
        }
    }
}

